/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.FloatDoubleAttribute;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dose.CTAcquisitionParameters;
import com.pixelmed.dose.CTIrradiationEventDataFromImages;
import com.pixelmed.dose.CTScanType;
import java.io.File;
import java.io.Serializable;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCTIrradiationEventDataFromImages
extends TestCase {
    private static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;

    public TestCTIrradiationEventDataFromImages(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCTIrradiationEventDataFromImages");
        testSuite.addTest((Test)new TestCTIrradiationEventDataFromImages("TestCTIrradiationEventDataFromImages_SeriesNumber_OneAcquisitionTime"));
        testSuite.addTest((Test)new TestCTIrradiationEventDataFromImages("TestCTIrradiationEventDataFromImages_SeriesNumber_TwoAcquisitionTimes"));
        testSuite.addTest((Test)new TestCTIrradiationEventDataFromImages("TestCTIrradiationEventDataFromImages_AcquisitionNumber"));
        testSuite.addTest((Test)new TestCTIrradiationEventDataFromImages("TestCTIrradiationEventDataFromImages_Localizer"));
        testSuite.addTest((Test)new TestCTIrradiationEventDataFromImages("TestCTIrradiationEventDataFromImages_PitchFactorZero"));
        testSuite.addTest((Test)new TestCTIrradiationEventDataFromImages("TestCTIrradiationEventDataFromImages_Anatomy"));
        testSuite.addTest((Test)new TestCTIrradiationEventDataFromImages("TestCTIrradiationEventDataFromImages_AnatomyDifferent"));
        testSuite.addTest((Test)new TestCTIrradiationEventDataFromImages("TestCTIrradiationEventDataFromImages_AnatomyCombined"));
        return testSuite;
    }

    protected void setUp() {
        Locale.setDefault(Locale.FRENCH);
    }

    protected void tearDown() {
    }

    public void TestCTIrradiationEventDataFromImages_SeriesNumber_OneAcquisitionTime() throws Exception {
        double d = 1.0;
        String string = "1";
        String string2 = "140";
        String string3 = "1.2.3.4";
        String string4 = "1.2.3.4.5";
        String string5 = "56";
        String string6 = "100134";
        String string7 = "AXIAL";
        CTScanType cTScanType = CTScanType.UNKNOWN;
        String string8 = "1.2.3.4.5.6";
        String string9 = "100.000";
        String string10 = "S";
        String string11 = "1.2.3.4.5.7";
        String string12 = "150.000";
        String string13 = "S";
        File file = File.createTempFile("TestCTIrradiationEventDataFromImages", ".tmp");
        file.deleteOnExit();
        Serializable serializable = new AttributeList();
        Object object = new FloatDoubleAttribute(dictionary.getTagFromName("SpiralPitchFactor"));
        ((Attribute)object).addValue(d);
        ((AttributeList)serializable).put((Attribute)object);
        object = new DecimalStringAttribute(dictionary.getTagFromName("KVP"));
        ((Attribute)object).addValue(string2);
        ((AttributeList)serializable).put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue(string5);
        ((AttributeList)serializable).put((Attribute)object);
        object = new TimeAttribute(TagFromName.AcquisitionTime);
        ((Attribute)object).addValue(string6);
        ((AttributeList)serializable).put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object).addValue(string3);
        ((AttributeList)serializable).put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object).addValue(string4);
        ((AttributeList)serializable).put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.ImageType);
        ((Attribute)object).addValue("ORIGINAL");
        ((Attribute)object).addValue("PRIMARY");
        ((Attribute)object).addValue(string7);
        ((AttributeList)serializable).put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(string8);
        ((AttributeList)serializable).put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue("1.2.840.10008.5.1.4.1.1.2");
        ((AttributeList)serializable).put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.SliceLocation);
        ((Attribute)object).addValue(string9);
        ((AttributeList)serializable).put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.ImageOrientationPatient);
        ((Attribute)object).addValue(1.0);
        ((Attribute)object).addValue(0.0);
        ((Attribute)object).addValue(0.0);
        ((Attribute)object).addValue(0.0);
        ((Attribute)object).addValue(1.0);
        ((Attribute)object).addValue(0.0);
        ((AttributeList)serializable).put((Attribute)object);
        ((AttributeList)serializable).write(file, "1.2.840.10008.1.2.1", false, true);
        serializable = File.createTempFile("TestCTIrradiationEventDataFromImages", ".tmp");
        ((File)serializable).deleteOnExit();
        object = new AttributeList();
        Object object2 = new FloatDoubleAttribute(dictionary.getTagFromName("SpiralPitchFactor"));
        ((Attribute)object2).addValue(d);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(dictionary.getTagFromName("KVP"));
        ((Attribute)object2).addValue(string2);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object2).addValue(string5);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new TimeAttribute(TagFromName.AcquisitionTime);
        ((Attribute)object2).addValue(string6);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object2).addValue(string3);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object2).addValue(string4);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new CodeStringAttribute(TagFromName.ImageType);
        ((Attribute)object2).addValue("ORIGINAL");
        ((Attribute)object2).addValue("PRIMARY");
        ((Attribute)object2).addValue(string7);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object2).addValue(string11);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object2).addValue("1.2.840.10008.5.1.4.1.1.2");
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.SliceLocation);
        ((Attribute)object2).addValue(string12);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.ImageOrientationPatient);
        ((Attribute)object2).addValue(1.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(1.0);
        ((Attribute)object2).addValue(0.0);
        ((AttributeList)object).put((Attribute)object2);
        ((AttributeList)object).write((File)serializable, "1.2.840.10008.1.2.1", false, true);
        object = new CTIrradiationEventDataFromImages();
        ((CTIrradiationEventDataFromImages)object).add(file);
        ((CTIrradiationEventDataFromImages)object).add((File)serializable);
        object2 = string5 + "+" + string13 + string12 + "+" + string10 + string9 + "+" + string3;
        CTAcquisitionParameters cTAcquisitionParameters = ((CTIrradiationEventDataFromImages)object).getAcquisitionParametersBySeriesNumberScanRangeAndStudyInstanceUID((String)object2);
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters SpiralPitchFactor", (String)string, (String)cTAcquisitionParameters.getPitchFactor());
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters KVP", (String)string2, (String)cTAcquisitionParameters.getKVP());
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters ScanType", (Object)cTScanType, (Object)cTAcquisitionParameters.getScanType());
    }

    public void TestCTIrradiationEventDataFromImages_SeriesNumber_TwoAcquisitionTimes() throws Exception {
        String string = "100134";
        String string2 = "100248";
        double d = 1.0;
        String string3 = "1";
        String string4 = "140";
        CTScanType cTScanType = CTScanType.UNKNOWN;
        String string5 = "Protocol A";
        double d2 = 1.5;
        String string6 = "1.5";
        String string7 = "120";
        CTScanType cTScanType2 = CTScanType.UNKNOWN;
        String string8 = "Protocol B";
        String string9 = "1.2.3.4";
        String string10 = "1.2.3.4.5";
        String string11 = "56";
        String string12 = "AXIAL";
        String string13 = "1.2.3.4.5.6";
        String string14 = "100.000";
        String string15 = "S";
        String string16 = "1.2.3.4.5.7";
        String string17 = "150.000";
        String string18 = "S";
        String string19 = "1.2.3.4.5.8";
        String string20 = "95.000";
        String string21 = "S";
        String string22 = "1.2.3.4.5.9";
        String string23 = "155.000";
        String string24 = "S";
        File file = File.createTempFile("TestCTIrradiationEventDataFromImages", ".tmp");
        file.deleteOnExit();
        Serializable serializable = new AttributeList();
        Object object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue(string11);
        ((AttributeList)serializable).put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object).addValue(string9);
        ((AttributeList)serializable).put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object).addValue(string10);
        ((AttributeList)serializable).put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.ImageType);
        ((Attribute)object).addValue("ORIGINAL");
        ((Attribute)object).addValue("PRIMARY");
        ((Attribute)object).addValue(string12);
        ((AttributeList)serializable).put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(string13);
        ((AttributeList)serializable).put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue("1.2.840.10008.5.1.4.1.1.2");
        ((AttributeList)serializable).put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.SliceLocation);
        ((Attribute)object).addValue(string14);
        ((AttributeList)serializable).put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.ImageOrientationPatient);
        ((Attribute)object).addValue(1.0);
        ((Attribute)object).addValue(0.0);
        ((Attribute)object).addValue(0.0);
        ((Attribute)object).addValue(0.0);
        ((Attribute)object).addValue(1.0);
        ((Attribute)object).addValue(0.0);
        ((AttributeList)serializable).put((Attribute)object);
        object = new TimeAttribute(TagFromName.AcquisitionTime);
        ((Attribute)object).addValue(string);
        ((AttributeList)serializable).put((Attribute)object);
        object = new FloatDoubleAttribute(dictionary.getTagFromName("SpiralPitchFactor"));
        ((Attribute)object).addValue(d);
        ((AttributeList)serializable).put((Attribute)object);
        object = new DecimalStringAttribute(dictionary.getTagFromName("KVP"));
        ((Attribute)object).addValue(string4);
        ((AttributeList)serializable).put((Attribute)object);
        object = new LongStringAttribute(TagFromName.ProtocolName);
        ((Attribute)object).addValue(string5);
        ((AttributeList)serializable).put((Attribute)object);
        ((AttributeList)serializable).write(file, "1.2.840.10008.1.2.1", false, true);
        serializable = File.createTempFile("TestCTIrradiationEventDataFromImages", ".tmp");
        ((File)serializable).deleteOnExit();
        object = new AttributeList();
        Object object2 = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object2).addValue(string11);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object2).addValue(string9);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object2).addValue(string10);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new CodeStringAttribute(TagFromName.ImageType);
        ((Attribute)object2).addValue("ORIGINAL");
        ((Attribute)object2).addValue("PRIMARY");
        ((Attribute)object2).addValue(string12);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object2).addValue(string16);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object2).addValue("1.2.840.10008.5.1.4.1.1.2");
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.SliceLocation);
        ((Attribute)object2).addValue(string17);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.ImageOrientationPatient);
        ((Attribute)object2).addValue(1.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(1.0);
        ((Attribute)object2).addValue(0.0);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new TimeAttribute(TagFromName.AcquisitionTime);
        ((Attribute)object2).addValue(string);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new FloatDoubleAttribute(dictionary.getTagFromName("SpiralPitchFactor"));
        ((Attribute)object2).addValue(d);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(dictionary.getTagFromName("KVP"));
        ((Attribute)object2).addValue(string4);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new LongStringAttribute(TagFromName.ProtocolName);
        ((Attribute)object2).addValue(string5);
        ((AttributeList)object).put((Attribute)object2);
        ((AttributeList)object).write((File)serializable, "1.2.840.10008.1.2.1", false, true);
        object = File.createTempFile("TestCTIrradiationEventDataFromImages", ".tmp");
        ((File)object).deleteOnExit();
        object2 = new AttributeList();
        Object object3 = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object3).addValue(string11);
        ((AttributeList)object2).put((Attribute)object3);
        object3 = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object3).addValue(string9);
        ((AttributeList)object2).put((Attribute)object3);
        object3 = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object3).addValue(string10);
        ((AttributeList)object2).put((Attribute)object3);
        object3 = new CodeStringAttribute(TagFromName.ImageType);
        ((Attribute)object3).addValue("ORIGINAL");
        ((Attribute)object3).addValue("PRIMARY");
        ((Attribute)object3).addValue(string12);
        ((AttributeList)object2).put((Attribute)object3);
        object3 = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object3).addValue(string19);
        ((AttributeList)object2).put((Attribute)object3);
        object3 = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object3).addValue("1.2.840.10008.5.1.4.1.1.2");
        ((AttributeList)object2).put((Attribute)object3);
        object3 = new DecimalStringAttribute(TagFromName.SliceLocation);
        ((Attribute)object3).addValue(string20);
        ((AttributeList)object2).put((Attribute)object3);
        object3 = new DecimalStringAttribute(TagFromName.ImageOrientationPatient);
        ((Attribute)object3).addValue(1.0);
        ((Attribute)object3).addValue(0.0);
        ((Attribute)object3).addValue(0.0);
        ((Attribute)object3).addValue(0.0);
        ((Attribute)object3).addValue(1.0);
        ((Attribute)object3).addValue(0.0);
        ((AttributeList)object2).put((Attribute)object3);
        object3 = new TimeAttribute(TagFromName.AcquisitionTime);
        ((Attribute)object3).addValue(string2);
        ((AttributeList)object2).put((Attribute)object3);
        object3 = new FloatDoubleAttribute(dictionary.getTagFromName("SpiralPitchFactor"));
        ((Attribute)object3).addValue(d2);
        ((AttributeList)object2).put((Attribute)object3);
        object3 = new DecimalStringAttribute(dictionary.getTagFromName("KVP"));
        ((Attribute)object3).addValue(string7);
        ((AttributeList)object2).put((Attribute)object3);
        object3 = new LongStringAttribute(TagFromName.ProtocolName);
        ((Attribute)object3).addValue(string8);
        ((AttributeList)object2).put((Attribute)object3);
        ((AttributeList)object2).write((File)object, "1.2.840.10008.1.2.1", false, true);
        object2 = File.createTempFile("TestCTIrradiationEventDataFromImages", ".tmp");
        ((File)object2).deleteOnExit();
        object3 = new AttributeList();
        Object object4 = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object4).addValue(string11);
        ((AttributeList)object3).put((Attribute)object4);
        object4 = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object4).addValue(string9);
        ((AttributeList)object3).put((Attribute)object4);
        object4 = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object4).addValue(string10);
        ((AttributeList)object3).put((Attribute)object4);
        object4 = new CodeStringAttribute(TagFromName.ImageType);
        ((Attribute)object4).addValue("ORIGINAL");
        ((Attribute)object4).addValue("PRIMARY");
        ((Attribute)object4).addValue(string12);
        ((AttributeList)object3).put((Attribute)object4);
        object4 = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object4).addValue(string22);
        ((AttributeList)object3).put((Attribute)object4);
        object4 = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object4).addValue("1.2.840.10008.5.1.4.1.1.2");
        ((AttributeList)object3).put((Attribute)object4);
        object4 = new DecimalStringAttribute(TagFromName.SliceLocation);
        ((Attribute)object4).addValue(string23);
        ((AttributeList)object3).put((Attribute)object4);
        object4 = new DecimalStringAttribute(TagFromName.ImageOrientationPatient);
        ((Attribute)object4).addValue(1.0);
        ((Attribute)object4).addValue(0.0);
        ((Attribute)object4).addValue(0.0);
        ((Attribute)object4).addValue(0.0);
        ((Attribute)object4).addValue(1.0);
        ((Attribute)object4).addValue(0.0);
        ((AttributeList)object3).put((Attribute)object4);
        object4 = new TimeAttribute(TagFromName.AcquisitionTime);
        ((Attribute)object4).addValue(string2);
        ((AttributeList)object3).put((Attribute)object4);
        object4 = new FloatDoubleAttribute(dictionary.getTagFromName("SpiralPitchFactor"));
        ((Attribute)object4).addValue(d2);
        ((AttributeList)object3).put((Attribute)object4);
        object4 = new DecimalStringAttribute(dictionary.getTagFromName("KVP"));
        ((Attribute)object4).addValue(string7);
        ((AttributeList)object3).put((Attribute)object4);
        object4 = new LongStringAttribute(TagFromName.ProtocolName);
        ((Attribute)object4).addValue(string8);
        ((AttributeList)object3).put((Attribute)object4);
        ((AttributeList)object3).write((File)object2, "1.2.840.10008.1.2.1", false, true);
        object3 = new CTIrradiationEventDataFromImages();
        ((CTIrradiationEventDataFromImages)object3).add(file);
        ((CTIrradiationEventDataFromImages)object3).add((File)serializable);
        ((CTIrradiationEventDataFromImages)object3).add((File)object);
        ((CTIrradiationEventDataFromImages)object3).add((File)object2);
        object4 = string11 + "+" + string18 + string17 + "+" + string15 + string14 + "+" + string9;
        CTAcquisitionParameters cTAcquisitionParameters = ((CTIrradiationEventDataFromImages)object3).getAcquisitionParametersBySeriesNumberScanRangeAndStudyInstanceUID((String)object4);
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters SpiralPitchFactor", (String)string3, (String)cTAcquisitionParameters.getPitchFactor());
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters KVP", (String)string4, (String)cTAcquisitionParameters.getKVP());
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters ScanType", (Object)cTScanType, (Object)cTAcquisitionParameters.getScanType());
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters AcqusitionProtocol", (String)string5, (String)cTAcquisitionParameters.getAcquisitionProtocol());
        object4 = string11 + "+" + string24 + string23 + "+" + string21 + string20 + "+" + string9;
        cTAcquisitionParameters = ((CTIrradiationEventDataFromImages)object3).getAcquisitionParametersBySeriesNumberScanRangeAndStudyInstanceUID((String)object4);
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters SpiralPitchFactor", (String)string6, (String)cTAcquisitionParameters.getPitchFactor());
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters KVP", (String)string7, (String)cTAcquisitionParameters.getKVP());
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters ScanType", (Object)cTScanType2, (Object)cTAcquisitionParameters.getScanType());
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters AcqusitionProtocol", (String)string8, (String)cTAcquisitionParameters.getAcquisitionProtocol());
    }

    public void TestCTIrradiationEventDataFromImages_AcquisitionNumber() throws Exception {
        double d = 1.0;
        String string = "1";
        String string2 = "140";
        String string3 = "1.2.3.4";
        String string4 = "1.2.3.4.5";
        String string5 = "56";
        String string6 = "43";
        String string7 = "100134";
        String string8 = "AXIAL";
        CTScanType cTScanType = CTScanType.UNKNOWN;
        String string9 = "1.2.3.4.5.6";
        String string10 = "100.000";
        String string11 = "S";
        File file = File.createTempFile("TestCTIrradiationEventDataFromImages", ".tmp");
        file.deleteOnExit();
        Object object = new AttributeList();
        Object object2 = new FloatDoubleAttribute(dictionary.getTagFromName("SpiralPitchFactor"));
        ((Attribute)object2).addValue(d);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(dictionary.getTagFromName("KVP"));
        ((Attribute)object2).addValue(string2);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object2).addValue(string5);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new IntegerStringAttribute(TagFromName.AcquisitionNumber);
        ((Attribute)object2).addValue(string6);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new TimeAttribute(TagFromName.AcquisitionTime);
        ((Attribute)object2).addValue(string7);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object2).addValue(string3);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object2).addValue(string4);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object2).addValue(string9);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object2).addValue("1.2.840.10008.5.1.4.1.1.2");
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.SliceLocation);
        ((Attribute)object2).addValue(string10);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.ImageOrientationPatient);
        ((Attribute)object2).addValue(1.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(1.0);
        ((Attribute)object2).addValue(0.0);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new CodeStringAttribute(TagFromName.ImageType);
        ((Attribute)object2).addValue("ORIGINAL");
        ((Attribute)object2).addValue("PRIMARY");
        ((Attribute)object2).addValue(string8);
        ((AttributeList)object).put((Attribute)object2);
        ((AttributeList)object).write(file, "1.2.840.10008.1.2.1", false, true);
        object = new CTIrradiationEventDataFromImages();
        ((CTIrradiationEventDataFromImages)object).add(file);
        object2 = string6 + "+" + string3;
        CTAcquisitionParameters cTAcquisitionParameters = ((CTIrradiationEventDataFromImages)object).getAcquisitionParametersByAcquisitionNumberAndStudyInstanceUID((String)object2);
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters SpiralPitchFactor", (String)string, (String)cTAcquisitionParameters.getPitchFactor());
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters KVP", (String)string2, (String)cTAcquisitionParameters.getKVP());
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters ScanType", (Object)cTScanType, (Object)cTAcquisitionParameters.getScanType());
    }

    public void TestCTIrradiationEventDataFromImages_Localizer() throws Exception {
        String string = "1.2.3.4";
        String string2 = "1.2.3.4.5";
        String string3 = "LOCALIZER";
        CTScanType cTScanType = CTScanType.LOCALIZER;
        File file = File.createTempFile("TestCTIrradiationEventDataFromImages", ".tmp");
        file.deleteOnExit();
        Object object = new AttributeList();
        Object object2 = new UniqueIdentifierAttribute(TagFromName.IrradiationEventUID);
        ((Attribute)object2).addValue(string);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object2).addValue(string2);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object2).addValue("1.2.840.10008.5.1.4.1.1.2");
        ((AttributeList)object).put((Attribute)object2);
        object2 = new CodeStringAttribute(TagFromName.ImageType);
        ((Attribute)object2).addValue("ORIGINAL");
        ((Attribute)object2).addValue("PRIMARY");
        ((Attribute)object2).addValue(string3);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.ImageOrientationPatient);
        ((Attribute)object2).addValue(1.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(1.0);
        ((Attribute)object2).addValue(0.0);
        ((AttributeList)object).put((Attribute)object2);
        ((AttributeList)object).write(file, "1.2.840.10008.1.2.1", false, true);
        object = new CTIrradiationEventDataFromImages();
        ((CTIrradiationEventDataFromImages)object).add(file);
        object2 = ((CTIrradiationEventDataFromImages)object).getAcquisitionParametersForIrradiationEvent(string);
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters ScanType", (Object)cTScanType, (Object)((CTAcquisitionParameters)object2).getScanType());
    }

    public void TestCTIrradiationEventDataFromImages_PitchFactorZero() throws Exception {
        double d = 0.0;
        String string = "0";
        String string2 = "1.2.3.4";
        String string3 = "1.2.3.4.5";
        String string4 = "AXIAL";
        CTScanType cTScanType = CTScanType.STATIONARY;
        File file = File.createTempFile("TestCTIrradiationEventDataFromImages", ".tmp");
        file.deleteOnExit();
        Object object = new AttributeList();
        Object object2 = new FloatDoubleAttribute(dictionary.getTagFromName("SpiralPitchFactor"));
        ((Attribute)object2).addValue(d);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.IrradiationEventUID);
        ((Attribute)object2).addValue(string2);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object2).addValue(string3);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object2).addValue("1.2.840.10008.5.1.4.1.1.2");
        ((AttributeList)object).put((Attribute)object2);
        object2 = new CodeStringAttribute(TagFromName.ImageType);
        ((Attribute)object2).addValue("ORIGINAL");
        ((Attribute)object2).addValue("PRIMARY");
        ((Attribute)object2).addValue(string4);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.ImageOrientationPatient);
        ((Attribute)object2).addValue(1.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(1.0);
        ((Attribute)object2).addValue(0.0);
        ((AttributeList)object).put((Attribute)object2);
        ((AttributeList)object).write(file, "1.2.840.10008.1.2.1", false, true);
        object = new CTIrradiationEventDataFromImages();
        ((CTIrradiationEventDataFromImages)object).add(file);
        object2 = ((CTIrradiationEventDataFromImages)object).getAcquisitionParametersForIrradiationEvent(string2);
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters SpiralPitchFactor", (String)string, (String)((CTAcquisitionParameters)object2).getPitchFactor());
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters ScanType stationary because of zero pitch", (Object)cTScanType, (Object)((CTAcquisitionParameters)object2).getScanType());
    }

    public void TestCTIrradiationEventDataFromImages_Anatomy() throws Exception {
        String string = "1.2.3.4";
        String string2 = "1.2.3.4.5";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem("R-FAB56", "SRT", "Chest, Abdomen and Pelvis");
        File file = File.createTempFile("TestCTIrradiationEventDataFromImages", ".tmp");
        file.deleteOnExit();
        Object object = new AttributeList();
        Object object2 = new UniqueIdentifierAttribute(TagFromName.IrradiationEventUID);
        ((Attribute)object2).addValue(string);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object2).addValue(string2);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object2).addValue("1.2.840.10008.5.1.4.1.1.2");
        ((AttributeList)object).put((Attribute)object2);
        object2 = new SequenceAttribute(TagFromName.AnatomicRegionSequence);
        ((SequenceAttribute)object2).addItem(codedSequenceItem.getAttributeList());
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.ImageOrientationPatient);
        ((Attribute)object2).addValue(1.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(1.0);
        ((Attribute)object2).addValue(0.0);
        ((AttributeList)object).put((Attribute)object2);
        ((AttributeList)object).write(file, "1.2.840.10008.1.2.1", false, true);
        object = new CTIrradiationEventDataFromImages();
        ((CTIrradiationEventDataFromImages)object).add(file);
        object2 = ((CTIrradiationEventDataFromImages)object).getAcquisitionParametersForIrradiationEvent(string);
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters anatomy", (Object)codedSequenceItem, (Object)((CTAcquisitionParameters)object2).getAnatomy());
    }

    public void TestCTIrradiationEventDataFromImages_AnatomyDifferent() throws Exception {
        String string = "1.2.3.4";
        String string2 = "1.2.3.4.5.6";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem("R-FAB56", "SRT", "Chest, Abdomen and Pelvis");
        String string3 = "1.2.3.4.5.7";
        CodedSequenceItem codedSequenceItem2 = new CodedSequenceItem("T-D8810", "SRT", "Thumb");
        File file = File.createTempFile("TestCTIrradiationEventDataFromImages", ".tmp");
        file.deleteOnExit();
        Serializable serializable = new AttributeList();
        Object object = new UniqueIdentifierAttribute(TagFromName.IrradiationEventUID);
        ((Attribute)object).addValue(string);
        ((AttributeList)serializable).put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(string2);
        ((AttributeList)serializable).put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue("1.2.840.10008.5.1.4.1.1.2");
        ((AttributeList)serializable).put((Attribute)object);
        object = new SequenceAttribute(TagFromName.AnatomicRegionSequence);
        ((SequenceAttribute)object).addItem(codedSequenceItem.getAttributeList());
        ((AttributeList)serializable).put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.ImageOrientationPatient);
        ((Attribute)object).addValue(1.0);
        ((Attribute)object).addValue(0.0);
        ((Attribute)object).addValue(0.0);
        ((Attribute)object).addValue(0.0);
        ((Attribute)object).addValue(1.0);
        ((Attribute)object).addValue(0.0);
        ((AttributeList)serializable).put((Attribute)object);
        ((AttributeList)serializable).write(file, "1.2.840.10008.1.2.1", false, true);
        serializable = File.createTempFile("TestCTIrradiationEventDataFromImages", ".tmp");
        ((File)serializable).deleteOnExit();
        object = new AttributeList();
        Object object2 = new UniqueIdentifierAttribute(TagFromName.IrradiationEventUID);
        ((Attribute)object2).addValue(string);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object2).addValue(string3);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object2).addValue("1.2.840.10008.5.1.4.1.1.2");
        ((AttributeList)object).put((Attribute)object2);
        object2 = new SequenceAttribute(TagFromName.AnatomicRegionSequence);
        ((SequenceAttribute)object2).addItem(codedSequenceItem2.getAttributeList());
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.ImageOrientationPatient);
        ((Attribute)object2).addValue(1.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(1.0);
        ((Attribute)object2).addValue(0.0);
        ((AttributeList)object).put((Attribute)object2);
        ((AttributeList)object).write((File)serializable, "1.2.840.10008.1.2.1", false, true);
        object = new CTIrradiationEventDataFromImages();
        ((CTIrradiationEventDataFromImages)object).add(file);
        ((CTIrradiationEventDataFromImages)object).add((File)serializable);
        object2 = ((CTIrradiationEventDataFromImages)object).getAcquisitionParametersForIrradiationEvent(string);
        TestCTIrradiationEventDataFromImages.assertTrue((String)"Checking CTAcquisitionParameters anatomy empty", (((CTAcquisitionParameters)object2).getAnatomy() == null ? 1 : 0) != 0);
    }

    public void TestCTIrradiationEventDataFromImages_AnatomyCombined() throws Exception {
        String string = "1.2.3.4";
        String string2 = "1.2.3.4.5.6";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem("T-D3000", "SRT", "Chest");
        String string3 = "1.2.3.4.5.7";
        CodedSequenceItem codedSequenceItem2 = new CodedSequenceItem("T-D4000", "SRT", "Abdomen");
        CodedSequenceItem codedSequenceItem3 = new CodedSequenceItem("R-FAB55", "SRT", "Chest and Abdomen");
        File file = File.createTempFile("TestCTIrradiationEventDataFromImages", ".tmp");
        file.deleteOnExit();
        Serializable serializable = new AttributeList();
        Object object = new UniqueIdentifierAttribute(TagFromName.IrradiationEventUID);
        ((Attribute)object).addValue(string);
        ((AttributeList)serializable).put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(string2);
        ((AttributeList)serializable).put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue("1.2.840.10008.5.1.4.1.1.2");
        ((AttributeList)serializable).put((Attribute)object);
        object = new SequenceAttribute(TagFromName.AnatomicRegionSequence);
        ((SequenceAttribute)object).addItem(codedSequenceItem.getAttributeList());
        ((AttributeList)serializable).put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.ImageOrientationPatient);
        ((Attribute)object).addValue(1.0);
        ((Attribute)object).addValue(0.0);
        ((Attribute)object).addValue(0.0);
        ((Attribute)object).addValue(0.0);
        ((Attribute)object).addValue(1.0);
        ((Attribute)object).addValue(0.0);
        ((AttributeList)serializable).put((Attribute)object);
        ((AttributeList)serializable).write(file, "1.2.840.10008.1.2.1", false, true);
        serializable = File.createTempFile("TestCTIrradiationEventDataFromImages", ".tmp");
        ((File)serializable).deleteOnExit();
        object = new AttributeList();
        Object object2 = new UniqueIdentifierAttribute(TagFromName.IrradiationEventUID);
        ((Attribute)object2).addValue(string);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object2).addValue(string3);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object2).addValue("1.2.840.10008.5.1.4.1.1.2");
        ((AttributeList)object).put((Attribute)object2);
        object2 = new SequenceAttribute(TagFromName.AnatomicRegionSequence);
        ((SequenceAttribute)object2).addItem(codedSequenceItem2.getAttributeList());
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.ImageOrientationPatient);
        ((Attribute)object2).addValue(1.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(0.0);
        ((Attribute)object2).addValue(1.0);
        ((Attribute)object2).addValue(0.0);
        ((AttributeList)object).put((Attribute)object2);
        ((AttributeList)object).write((File)serializable, "1.2.840.10008.1.2.1", false, true);
        object = new CTIrradiationEventDataFromImages();
        ((CTIrradiationEventDataFromImages)object).add(file);
        ((CTIrradiationEventDataFromImages)object).add((File)serializable);
        object2 = ((CTIrradiationEventDataFromImages)object).getAcquisitionParametersForIrradiationEvent(string);
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters anatomy combined", (Object)codedSequenceItem3, (Object)((CTAcquisitionParameters)object2).getAnatomy());
    }
}

