/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDateTimeAttributeTimeSinceEpochExtraction
extends TestCase {
    public TestDateTimeAttributeTimeSinceEpochExtraction(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestDateTimeAttributeTimeSinceEpochExtraction");
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochNoFractionDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochIllegalZeroDigitFractionDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochSingleDigitFractionDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochThreeDigitFractionDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochSixDigitFractionDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochYearOnlyDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochYearMonthOnlyDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochYearMonthDayOnlyDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochYearMonthDayHourOnlyDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochYearMonthDayHourMinuteOnlyDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochMissingDateValueDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochNoFractionDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochIllegalZeroDigitFractionDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochSingleDigitFractionDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochThreeDigitFractionDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochSixDigitFractionDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearOnlyDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearMonthOnlyDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearMonthDayOnlyDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearMonthDayHourOnlyDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearMonthDayHourMinuteOnlyDefaultTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochNoFractionExplicitUTCTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochIllegalZeroDigitFractionExplicitUTCTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochSingleDigitFractionExplicitUTCTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochThreeDigitFractionExplicitUTCTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochSixDigitFractionExplicitUTCTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearOnlyExplicitUTCTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearMonthOnlyExplicitUTCTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearMonthDayOnlyExplicitUTCTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearMonthDayHourOnlyExplicitUTCTimezone"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeSinceEpochExtraction("TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearMonthDayHourMinuteOnlyExplicitUTCTimezone"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochNoFractionDefaultTimezone() throws Exception {
        String string = "19700101";
        String string2 = "000000";
        long l = 0L;
        String string3 = "19700101000000.000+0000";
        String string4 = "19691231170000.000-0700";
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(string + string2);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(string + string2);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochIllegalZeroDigitFractionDefaultTimezone() throws Exception {
        String string = "19700101";
        String string2 = "000000.";
        long l = 0L;
        String string3 = "19700101000000.000+0000";
        String string4 = "19691231170000.000-0700";
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(string + string2);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(string + string2);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochSingleDigitFractionDefaultTimezone() throws Exception {
        String string = "19700101";
        String string2 = "000000.1";
        long l = 100L;
        String string3 = "19700101000000.100+0000";
        String string4 = "19691231170000.100-0700";
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(string + string2);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(string + string2);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochThreeDigitFractionDefaultTimezone() throws Exception {
        String string = "19700101";
        String string2 = "000000.123";
        long l = 123L;
        String string3 = "19700101000000.123+0000";
        String string4 = "19691231170000.123-0700";
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(string + string2);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(string + string2);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochSixDigitFractionDefaultTimezone() throws Exception {
        String string = "19700101";
        String string2 = "000000.123999";
        long l = 123L;
        String string3 = "19700101000000.123+0000";
        String string4 = "19691231170000.123-0700";
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(string + string2);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(string + string2);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochYearOnlyDefaultTimezone() throws Exception {
        String string = "1970";
        String string2 = "";
        long l = 0L;
        String string3 = "19700101000000.000+0000";
        String string4 = "19691231170000.000-0700";
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(string + string2);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(string + string2);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochYearMonthOnlyDefaultTimezone() throws Exception {
        String string = "197001";
        String string2 = "";
        long l = 0L;
        String string3 = "19700101000000.000+0000";
        String string4 = "19691231170000.000-0700";
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(string + string2);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(string + string2);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochYearMonthDayOnlyDefaultTimezone() throws Exception {
        String string = "19700101";
        String string2 = "";
        long l = 0L;
        String string3 = "19700101000000.000+0000";
        String string4 = "19691231170000.000-0700";
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(string + string2);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(string + string2);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochYearMonthDayHourOnlyDefaultTimezone() throws Exception {
        String string = "19700101";
        String string2 = "00";
        long l = 0L;
        String string3 = "19700101000000.000+0000";
        String string4 = "19691231170000.000-0700";
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(string + string2);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(string + string2);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromSingleString_AtEpochYearMonthDayHourMinuteOnlyDefaultTimezone() throws Exception {
        String string = "19700101";
        String string2 = "0000";
        long l = 0L;
        String string3 = "19700101000000.000+0000";
        String string4 = "19691231170000.000-0700";
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(string + string2);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(string + string2);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochNoFractionDefaultTimezone() throws Exception {
        String string = "19700101";
        String string2 = "000000";
        long l = 0L;
        String string3 = "19700101000000.000+0000";
        String string4 = "19691231170000.000-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochMissingDateValueDefaultTimezone() throws Exception {
        String string = "";
        String string2 = "000000";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        try {
            long l = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
            TestDateTimeAttributeTimeSinceEpochExtraction.assertTrue((String)"Missing exception for getTimeInMilliSecondsSinceEpoch expected when date absent", (boolean)false);
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
        try {
            Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
            TestDateTimeAttributeTimeSinceEpochExtraction.assertTrue((String)"Missing exception for getDateFromFormattedString expected when date absent", (boolean)false);
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochIllegalZeroDigitFractionDefaultTimezone() throws Exception {
        String string = "19700101";
        String string2 = "000000.";
        long l = 0L;
        String string3 = "19700101000000.000+0000";
        String string4 = "19691231170000.000-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochSingleDigitFractionDefaultTimezone() throws Exception {
        String string = "19700101";
        String string2 = "000000.1";
        long l = 100L;
        String string3 = "19700101000000.100+0000";
        String string4 = "19691231170000.100-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochThreeDigitFractionDefaultTimezone() throws Exception {
        String string = "19700101";
        String string2 = "000000.123";
        long l = 123L;
        String string3 = "19700101000000.123+0000";
        String string4 = "19691231170000.123-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochSixDigitFractionDefaultTimezone() throws Exception {
        String string = "19700101";
        String string2 = "000000.123999";
        long l = 123L;
        String string3 = "19700101000000.123+0000";
        String string4 = "19691231170000.123-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearOnlyDefaultTimezone() throws Exception {
        String string = "1970";
        String string2 = "";
        long l = 0L;
        String string3 = "19700101000000.000+0000";
        String string4 = "19691231170000.000-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearMonthOnlyDefaultTimezone() throws Exception {
        String string = "197001";
        String string2 = "";
        long l = 0L;
        String string3 = "19700101000000.000+0000";
        String string4 = "19691231170000.000-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearMonthDayOnlyDefaultTimezone() throws Exception {
        String string = "19700101";
        String string2 = "";
        long l = 0L;
        String string3 = "19700101000000.000+0000";
        String string4 = "19691231170000.000-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearMonthDayHourOnlyDefaultTimezone() throws Exception {
        String string = "19700101";
        String string2 = "00";
        long l = 0L;
        String string3 = "19700101000000.000+0000";
        String string4 = "19691231170000.000-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearMonthDayHourMinuteOnlyDefaultTimezone() throws Exception {
        String string = "19700101";
        String string2 = "0000";
        long l = 0L;
        String string3 = "19700101000000.000+0000";
        String string4 = "19691231170000.000-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string5 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string3, (String)string5);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string5 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
        string5 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string5);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochNoFractionExplicitUTCTimezone() throws Exception {
        String string = "19700101";
        String string2 = "000000";
        String string3 = "+0000";
        long l = 0L;
        String string4 = "19700101000000.000+0000";
        String string5 = "19691231170000.000-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        stringAttribute = new ShortStringAttribute(TagFromName.TimezoneOffsetFromUTC);
        ((Attribute)stringAttribute).addValue(string3);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string6 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string6);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string6 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
        string6 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochIllegalZeroDigitFractionExplicitUTCTimezone() throws Exception {
        String string = "19700101";
        String string2 = "000000.";
        String string3 = "+0000";
        long l = 0L;
        String string4 = "19700101000000.000+0000";
        String string5 = "19691231170000.000-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        stringAttribute = new ShortStringAttribute(TagFromName.TimezoneOffsetFromUTC);
        ((Attribute)stringAttribute).addValue(string3);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string6 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string6);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string6 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
        string6 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochSingleDigitFractionExplicitUTCTimezone() throws Exception {
        String string = "19700101";
        String string2 = "000000.1";
        String string3 = "+0000";
        long l = 100L;
        String string4 = "19700101000000.100+0000";
        String string5 = "19691231170000.100-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        stringAttribute = new ShortStringAttribute(TagFromName.TimezoneOffsetFromUTC);
        ((Attribute)stringAttribute).addValue(string3);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string6 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string6);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string6 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
        string6 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochThreeDigitFractionExplicitUTCTimezone() throws Exception {
        String string = "19700101";
        String string2 = "000000.123";
        String string3 = "+0000";
        long l = 123L;
        String string4 = "19700101000000.123+0000";
        String string5 = "19691231170000.123-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        stringAttribute = new ShortStringAttribute(TagFromName.TimezoneOffsetFromUTC);
        ((Attribute)stringAttribute).addValue(string3);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string6 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string6);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string6 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
        string6 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochSixDigitFractionExplicitUTCTimezone() throws Exception {
        String string = "19700101";
        String string2 = "000000.123999";
        String string3 = "+0000";
        long l = 123L;
        String string4 = "19700101000000.123+0000";
        String string5 = "19691231170000.123-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        stringAttribute = new ShortStringAttribute(TagFromName.TimezoneOffsetFromUTC);
        ((Attribute)stringAttribute).addValue(string3);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string6 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string6);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string6 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
        string6 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearOnlyExplicitUTCTimezone() throws Exception {
        String string = "1970";
        String string2 = "";
        String string3 = "+0000";
        long l = 0L;
        String string4 = "19700101000000.000+0000";
        String string5 = "19691231170000.000-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        stringAttribute = new ShortStringAttribute(TagFromName.TimezoneOffsetFromUTC);
        ((Attribute)stringAttribute).addValue(string3);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string6 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string6);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string6 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
        string6 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearMonthOnlyExplicitUTCTimezone() throws Exception {
        String string = "197001";
        String string2 = "";
        String string3 = "+0000";
        long l = 0L;
        String string4 = "19700101000000.000+0000";
        String string5 = "19691231170000.000-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        stringAttribute = new ShortStringAttribute(TagFromName.TimezoneOffsetFromUTC);
        ((Attribute)stringAttribute).addValue(string3);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string6 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string6);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string6 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
        string6 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearMonthDayOnlyExplicitUTCTimezone() throws Exception {
        String string = "19700101";
        String string2 = "";
        String string3 = "+0000";
        long l = 0L;
        String string4 = "19700101000000.000+0000";
        String string5 = "19691231170000.000-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        stringAttribute = new ShortStringAttribute(TagFromName.TimezoneOffsetFromUTC);
        ((Attribute)stringAttribute).addValue(string3);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string6 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string6);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string6 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
        string6 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearMonthDayHourOnlyExplicitUTCTimezone() throws Exception {
        String string = "19700101";
        String string2 = "00";
        String string3 = "+0000";
        long l = 0L;
        String string4 = "19700101000000.000+0000";
        String string5 = "19691231170000.000-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        stringAttribute = new ShortStringAttribute(TagFromName.TimezoneOffsetFromUTC);
        ((Attribute)stringAttribute).addValue(string3);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string6 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string6);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string6 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
        string6 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
    }

    public void TestDateTimeAttributeTimeSinceEpochExtraction_FromAttributeList_AtEpochYearMonthDayHourMinuteOnlyExplicitUTCTimezone() throws Exception {
        String string = "19700101";
        String string2 = "0000";
        String string3 = "+0000";
        long l = 0L;
        String string4 = "19700101000000.000+0000";
        String string5 = "19691231170000.000-0700";
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string2);
        attributeList.put(stringAttribute);
        stringAttribute = new ShortStringAttribute(TagFromName.TimezoneOffsetFromUTC);
        ((Attribute)stringAttribute).addValue(string3);
        attributeList.put(stringAttribute);
        long l2 = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (long)l, (long)l2);
        Date date = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
        String string6 = DateTimeAttribute.getFormattedStringUTC(date);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string4, (String)string6);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-7"));
        string6 = DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
        TimeZone.setDefault(null);
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
        string6 = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT-7"));
        TestDateTimeAttributeTimeSinceEpochExtraction.assertEquals((String)(string + string2), (String)string5, (String)string6);
    }
}

