/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.DateTimeAttribute;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDateTimeAttributeTimeZone
extends TestCase {
    public TestDateTimeAttributeTimeZone(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestDateTimeAttributeTimeZone");
        testSuite.addTest((Test)new TestDateTimeAttributeTimeZone("TestDateTimeAttributeTimeZone_Compare"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeZone("TestDateTimeAttributeTimeZone_WinterNorthernHemisphere"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeZone("TestDateTimeAttributeTimeZone_SummerNorthernHemisphere"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeZone("TestDateTimeAttributeTimeZone_WinterSouthernHemisphere"));
        testSuite.addTest((Test)new TestDateTimeAttributeTimeZone("TestDateTimeAttributeTimeZone_SummerSouthernHemisphere"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestDateTimeAttributeTimeZone_Compare() {
        String[] stringArray = new String[]{"+0000", "+0000", "-0800", "+0100", "+1000"};
        TimeZone[] timeZoneArray = new TimeZone[]{TimeZone.getTimeZone("GMT"), TimeZone.getTimeZone("Europe/London"), TimeZone.getTimeZone("America/Los_Angeles"), TimeZone.getTimeZone("Europe/Berlin"), TimeZone.getTimeZone("Australia/Melbourne")};
        for (int i = 0; i < stringArray.length; ++i) {
            TestDateTimeAttributeTimeZone.assertEquals((String)stringArray[i], (int)timeZoneArray[i].getRawOffset(), (int)DateTimeAttribute.getTimeZone(stringArray[i]).getRawOffset());
        }
    }

    public void TestDateTimeAttributeTimeZone_WinterNorthernHemisphere() {
        String[] stringArray = new String[]{"+0000", "+0000", "-0800", "+0100"};
        TimeZone[] timeZoneArray = new TimeZone[]{TimeZone.getTimeZone("GMT"), TimeZone.getTimeZone("Europe/London"), TimeZone.getTimeZone("America/Los_Angeles"), TimeZone.getTimeZone("Europe/Berlin")};
        for (int i = 0; i < stringArray.length; ++i) {
            Calendar calendar = Calendar.getInstance(timeZoneArray[i], Locale.US);
            calendar.set(2000, 12, 31);
            Date date = calendar.getTime();
            TestDateTimeAttributeTimeZone.assertEquals((String)stringArray[i], (String)stringArray[i], (String)DateTimeAttribute.getTimeZone(timeZoneArray[i], date));
        }
    }

    public void TestDateTimeAttributeTimeZone_SummerNorthernHemisphere() {
        String[] stringArray = new String[]{"+0000", "+0100", "-0700", "+0200"};
        TimeZone[] timeZoneArray = new TimeZone[]{TimeZone.getTimeZone("GMT"), TimeZone.getTimeZone("Europe/London"), TimeZone.getTimeZone("America/Los_Angeles"), TimeZone.getTimeZone("Europe/Berlin")};
        for (int i = 0; i < stringArray.length; ++i) {
            Calendar calendar = Calendar.getInstance(timeZoneArray[i], Locale.US);
            calendar.set(2000, 6, 30);
            Date date = calendar.getTime();
            TestDateTimeAttributeTimeZone.assertEquals((String)stringArray[i], (String)stringArray[i], (String)DateTimeAttribute.getTimeZone(timeZoneArray[i], date));
        }
    }

    public void TestDateTimeAttributeTimeZone_WinterSouthernHemisphere() {
        String[] stringArray = new String[]{"+1000"};
        TimeZone[] timeZoneArray = new TimeZone[]{TimeZone.getTimeZone("Australia/Melbourne")};
        for (int i = 0; i < stringArray.length; ++i) {
            Calendar calendar = Calendar.getInstance(timeZoneArray[i], Locale.US);
            calendar.set(2000, 6, 30);
            Date date = calendar.getTime();
            TestDateTimeAttributeTimeZone.assertEquals((String)stringArray[i], (String)stringArray[i], (String)DateTimeAttribute.getTimeZone(timeZoneArray[i], date));
        }
    }

    public void TestDateTimeAttributeTimeZone_SummerSouthernHemisphere() {
        String[] stringArray = new String[]{"+1100"};
        TimeZone[] timeZoneArray = new TimeZone[]{TimeZone.getTimeZone("Australia/Melbourne")};
        for (int i = 0; i < stringArray.length; ++i) {
            Calendar calendar = Calendar.getInstance(timeZoneArray[i], Locale.US);
            calendar.set(2000, 12, 31);
            Date date = calendar.getTime();
            TestDateTimeAttributeTimeZone.assertEquals((String)stringArray[i], (String)stringArray[i], (String)DateTimeAttribute.getTimeZone(timeZoneArray[i], date));
        }
    }
}

