/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.ContentItemWithReference;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.XMLRepresentationOfStructuredReportObjectFactory;
import java.util.Iterator;
import javax.xml.xpath.XPathFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.w3c.dom.Document;

public class TestDeidentifyStructuredContent
extends TestCase {
    private static final String defaultDescriptionValue = "This is a potential identity leakage";
    private static final String defaultPersonNameValue = "Smith^RealPerson";
    private static final String defaultUIDValue = "1.2.3.4";

    public TestDeidentifyStructuredContent(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestDeidentifyStructuredContent");
        testSuite.addTest((Test)new TestDeidentifyStructuredContent("TestDeidentifyStructuredContent_KeepAll_FromSR"));
        testSuite.addTest((Test)new TestDeidentifyStructuredContent("TestDeidentifyStructuredContent_RemoveAll_FromSR"));
        testSuite.addTest((Test)new TestDeidentifyStructuredContent("TestDeidentifyStructuredContent_Modify_FromSR"));
        testSuite.addTest((Test)new TestDeidentifyStructuredContent("TestDeidentifyStructuredContent_Modify_FromSR_KeepDescriptors"));
        testSuite.addTest((Test)new TestDeidentifyStructuredContent("TestDeidentifyStructuredContent_Modify_FromSR_KeepDevice"));
        testSuite.addTest((Test)new TestDeidentifyStructuredContent("TestDeidentifyStructuredContent_Modify_FromSR_KeepInstitution"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private static boolean checkNoEmptyContentSequenceEtAl(AttributeList attributeList, boolean bl) {
        Object object;
        boolean bl2 = true;
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.ValueType);
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.ReferencedContentItemIdentifier);
        if (string.length() == 0 && string2.length() == 0) {
            System.err.println("No ValueType and no ReferencedContentItemIdentifier");
            bl2 = false;
        }
        if (bl) {
            if (!string.equals("CONTAINER")) {
                System.err.println("Root ValueType is not CONTAINER");
                bl2 = false;
            }
        } else {
            object = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.RelationshipType);
            if (((String)object).length() == 0) {
                System.err.println("No RelationshipType");
                bl2 = false;
            }
        }
        object = (SequenceAttribute)attributeList.get(TagFromName.ContentSequence);
        if (string.length() > 0) {
            if (string.equals("CONTAINER")) {
                if (object == null) {
                    System.err.println("Missing ContentSequence for CONTAINER");
                    bl2 = false;
                }
            } else if (attributeList.get(TagFromName.TextValue) == null && attributeList.get(TagFromName.DateTime) == null && attributeList.get(TagFromName.Date) == null && attributeList.get(TagFromName.Time) == null && attributeList.get(TagFromName.PersonName) == null && attributeList.get(TagFromName.UID) == null && attributeList.get(TagFromName.MeasuredValueSequence) == null && attributeList.get(TagFromName.NumericValueQualifierCodeSequence) == null && attributeList.get(TagFromName.ConceptCodeSequence) == null && attributeList.get(TagFromName.ReferencedSOPSequence) == null && attributeList.get(TagFromName.GraphicData) == null && attributeList.get(TagFromName.GraphicType) == null && attributeList.get(TagFromName.PixelOriginInterpretation) == null && attributeList.get(TagFromName.FiducialUID) == null && attributeList.get(TagFromName.ReferencedFrameOfReferenceUID) == null && attributeList.get(TagFromName.TemporalRangeType) == null && attributeList.get(TagFromName.ReferencedSamplePositions) == null && attributeList.get(TagFromName.ReferencedTimeOffsets) == null && attributeList.get(TagFromName.ReferencedDateTime) == null) {
                System.err.println("No value attributes for valueType " + string);
                bl2 = false;
            }
        }
        if (object != null) {
            Iterator<SequenceItem> iterator = ((SequenceAttribute)object).iterator();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    SequenceItem sequenceItem = iterator.next();
                    if (sequenceItem == null) continue;
                    AttributeList attributeList2 = sequenceItem.getAttributeList();
                    if (attributeList2 != null && !attributeList2.isEmpty()) {
                        bl2 = bl2 && TestDeidentifyStructuredContent.checkNoEmptyContentSequenceEtAl(attributeList2, false);
                        continue;
                    }
                    System.err.println("Missing or empty AttributeList in item of ContentSequence");
                    bl2 = false;
                }
            } else {
                System.err.println("ContentSequence without items");
                bl2 = false;
            }
        }
        return bl2;
    }

    private static boolean checkNoEmptyContentSequenceEtAl(AttributeList attributeList) {
        return TestDeidentifyStructuredContent.checkNoEmptyContentSequenceEtAl(attributeList, true);
    }

    private static AttributeList makeSR() throws DicomException {
        ContentItemFactory contentItemFactory;
        ContentItemFactory contentItemFactory2 = contentItemFactory = new ContentItemFactory();
        contentItemFactory2.getClass();
        ContentItemFactory.ContainerContentItem containerContentItem = contentItemFactory2.new ContentItemFactory.ContainerContentItem(null, null, new CodedSequenceItem("111036", "DCM", "Mammography CAD Report"), true, "DCMR", "5000");
        ContentItemFactory contentItemFactory3 = contentItemFactory;
        contentItemFactory3.getClass();
        contentItemFactory3.new ContentItemFactory.CodeContentItem(containerContentItem, "HAS OBS CONTEXT", new CodedSequenceItem("121005", "DCM", "Observer Type"), new CodedSequenceItem("121006", "DCM", "Person"));
        ContentItemFactory contentItemFactory4 = contentItemFactory;
        contentItemFactory4.getClass();
        contentItemFactory4.new ContentItemFactory.PersonNameContentItem(containerContentItem, "HAS OBS CONTEXT", new CodedSequenceItem("121008", "DCM", "Person Observer Name"), defaultPersonNameValue);
        ContentItemFactory contentItemFactory5 = contentItemFactory;
        contentItemFactory5.getClass();
        contentItemFactory5.new ContentItemFactory.PersonNameContentItem(containerContentItem, "HAS OBS CONTEXT", new CodedSequenceItem("121435", "DCM", "Service Performer"), defaultPersonNameValue);
        ContentItemFactory contentItemFactory6 = contentItemFactory;
        contentItemFactory6.getClass();
        contentItemFactory6.new ContentItemFactory.TextContentItem(containerContentItem, "HAS OBS CONTEXT", new CodedSequenceItem("121435", "DCM", "Service Performer"), defaultPersonNameValue);
        ContentItemFactory contentItemFactory7 = contentItemFactory;
        contentItemFactory7.getClass();
        contentItemFactory7.new ContentItemFactory.PersonNameContentItem(containerContentItem, "HAS OBS CONTEXT", new CodedSequenceItem("7235223", "99CRAZYMADEUP", "Silly Name"), defaultPersonNameValue);
        ContentItemFactory contentItemFactory8 = contentItemFactory;
        contentItemFactory8.getClass();
        contentItemFactory8.new ContentItemFactory.CodeContentItem(containerContentItem, "HAS OBS CONTEXT", new CodedSequenceItem("121005", "DCM", "Observer Type"), new CodedSequenceItem("121007", "DCM", "Device"));
        ContentItemFactory contentItemFactory9 = contentItemFactory;
        contentItemFactory9.getClass();
        contentItemFactory9.new ContentItemFactory.UIDContentItem(containerContentItem, "HAS OBS CONTEXT", new CodedSequenceItem("121012", "DCM", "Device Observer UID"), defaultUIDValue);
        ContentItemFactory contentItemFactory10 = contentItemFactory;
        contentItemFactory10.getClass();
        contentItemFactory10.new ContentItemFactory.TextContentItem(containerContentItem, "HAS OBS CONTEXT", new CodedSequenceItem("121013", "DCM", "Device Observer Name"), defaultDescriptionValue);
        ContentItemFactory contentItemFactory11 = contentItemFactory;
        contentItemFactory11.getClass();
        contentItemFactory11.new ContentItemFactory.TextContentItem(containerContentItem, "HAS OBS CONTEXT", new CodedSequenceItem("121017", "DCM", "Device Observer Physical Location During Observation"), defaultDescriptionValue);
        ContentItemFactory contentItemFactory12 = contentItemFactory;
        contentItemFactory12.getClass();
        Object object = contentItemFactory12.new ContentItemFactory.ContainerContentItem(containerContentItem, "CONTAINS", new CodedSequenceItem("111028", "DCM", "Image Library"), true);
        ContentItemFactory contentItemFactory13 = contentItemFactory;
        contentItemFactory13.getClass();
        Object object2 = contentItemFactory13.new ContentItemFactory.ImageContentItem((ContentItem)object, "CONTAINS", null, "1.2.840.10008.5.1.4.1.1.1.2", "1.3.6.1.4.1.5962.99.1.993064428.2122236180.1358202762732.2.0", 0, 0, null, null, null, null);
        ContentItemFactory contentItemFactory14 = contentItemFactory;
        contentItemFactory14.getClass();
        object = contentItemFactory14.new ContentItemFactory.CodeContentItem(containerContentItem, "CONTAINS", new CodedSequenceItem("111017", "DCM", "CAD Processing and Findings Summary"), new CodedSequenceItem("111242", "DCM", "All algorithms succeeded; with findings"));
        ContentItemFactory contentItemFactory15 = contentItemFactory;
        contentItemFactory15.getClass();
        object2 = contentItemFactory15.new ContentItemFactory.ContainerContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("111034", "DCM", "Individual Impression/Recommendation"), true);
        ContentItemFactory contentItemFactory16 = contentItemFactory;
        contentItemFactory16.getClass();
        contentItemFactory16.new ContentItemFactory.CodeContentItem((ContentItem)object2, "CONTAINS", new CodedSequenceItem("111056", "DCM", "Rendering Intent"), new CodedSequenceItem("111150", "DCM", "Presentation Required: Rendering device is expected to present"));
        ContentItemFactory contentItemFactory17 = contentItemFactory;
        contentItemFactory17.getClass();
        ContentItemFactory.CodeContentItem codeContentItem = contentItemFactory17.new ContentItemFactory.CodeContentItem((ContentItem)object2, "CONTAINS", new CodedSequenceItem("111059", "DCM", "Single Image Finding"), new CodedSequenceItem("F-01775", "SRT", "Calcification Cluster"));
        ContentItemFactory contentItemFactory18 = contentItemFactory;
        contentItemFactory18.getClass();
        contentItemFactory18.new ContentItemFactory.CodeContentItem(codeContentItem, "HAS CONCEPT MOD", new CodedSequenceItem("111056", "DCM", "Rendering Intent"), new CodedSequenceItem("111150", "DCM", "Presentation Required: Rendering device is expected to present"));
        ContentItemFactory contentItemFactory19 = contentItemFactory;
        contentItemFactory19.getClass();
        ContentItemFactory.SpatialCoordinatesContentItem spatialCoordinatesContentItem = contentItemFactory19.new ContentItemFactory.SpatialCoordinatesContentItem((ContentItem)object2, "CONTAINS", new CodedSequenceItem("111010", "DCM", "Center"), "POINT", new float[]{165.0f, 2433.0f});
        new ContentItemWithReference(spatialCoordinatesContentItem, "SELECTED FROM", "1.1.1");
        ContentItemFactory contentItemFactory20 = contentItemFactory;
        contentItemFactory20.getClass();
        contentItemFactory20.new ContentItemFactory.NumericContentItem((ContentItem)codeContentItem, "HAS PROPERTIES", new CodedSequenceItem("111038", "DCM", "Number of calcifications"), 10.0, new CodedSequenceItem("111150", "1", "no units"));
        ContentItemFactory contentItemFactory21 = contentItemFactory;
        contentItemFactory21.getClass();
        codeContentItem = contentItemFactory21.new ContentItemFactory.CodeContentItem((ContentItem)object2, "CONTAINS", new CodedSequenceItem("111059", "DCM", "Single Image Finding"), new CodedSequenceItem("F-01776", "SRT", "Individual Calcification"));
        ContentItemFactory contentItemFactory22 = contentItemFactory;
        contentItemFactory22.getClass();
        contentItemFactory22.new ContentItemFactory.CodeContentItem(codeContentItem, "HAS CONCEPT MOD", new CodedSequenceItem("111056", "DCM", "Rendering Intent"), new CodedSequenceItem("111150", "DCM", "Presentation Required: Rendering device is expected to present"));
        ContentItemFactory contentItemFactory23 = contentItemFactory;
        contentItemFactory23.getClass();
        spatialCoordinatesContentItem = contentItemFactory23.new ContentItemFactory.SpatialCoordinatesContentItem((ContentItem)object2, "CONTAINS", new CodedSequenceItem("111010", "DCM", "Center"), "POINT", new float[]{198.0f, 2389.0f});
        new ContentItemWithReference(spatialCoordinatesContentItem, "SELECTED FROM", "1.1.1");
        ContentItemFactory contentItemFactory24 = contentItemFactory;
        contentItemFactory24.getClass();
        ContentItemFactory.SpatialCoordinatesContentItem spatialCoordinatesContentItem2 = contentItemFactory24.new ContentItemFactory.SpatialCoordinatesContentItem((ContentItem)object2, "CONTAINS", new CodedSequenceItem("111041", "DCM", "Outline"), "POLYLINE", new float[]{199.0f, 2388.0f, 198.0f, 2388.0f, 197.0f, 2388.0f, 197.0f, 2389.0f, 197.0f, 2390.0f, 198.0f, 2390.0f, 199.0f, 2390.0f, 200.0f, 2390.0f, 200.0f, 2389.0f});
        new ContentItemWithReference(spatialCoordinatesContentItem2, "SELECTED FROM", "1.1.1");
        ContentItemFactory contentItemFactory25 = contentItemFactory;
        contentItemFactory25.getClass();
        codeContentItem = contentItemFactory25.new ContentItemFactory.CodeContentItem((ContentItem)object2, "CONTAINS", new CodedSequenceItem("111059", "DCM", "Single Image Finding"), new CodedSequenceItem("111099", "DCM", "Selected Region"));
        ContentItemFactory contentItemFactory26 = contentItemFactory;
        contentItemFactory26.getClass();
        contentItemFactory26.new ContentItemFactory.TextContentItem(codeContentItem, "HAS PROPERTIES", new CodedSequenceItem("111058", "DCM", "Selected Region Description"), defaultDescriptionValue);
        object = new StructuredReport(containerContentItem);
        object2 = ((StructuredReport)object).getAttributeList();
        return object2;
    }

    public void TestDeidentifyStructuredContent_KeepAll_FromSR() throws Exception {
        AttributeList attributeList = TestDeidentifyStructuredContent.makeSR();
        AttributeList attributeList2 = TestDeidentifyStructuredContent.makeSR();
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, false, false, false, false, false, false, 1, null, null, 0);
        attributeList.remove(TagFromName.PatientIdentityRemoved);
        attributeList.remove(TagFromName.DeidentificationMethod);
        attributeList.remove(TagFromName.DeidentificationMethodCodeSequence);
        TestDeidentifyStructuredContent.assertEquals((String)"Checking before and after AttributeList", (Object)attributeList2, (Object)attributeList);
    }

    public void TestDeidentifyStructuredContent_RemoveAll_FromSR() throws Exception {
        AttributeList attributeList = TestDeidentifyStructuredContent.makeSR();
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, false, false, false, false, false, false, 1, null, null, 1);
        TestDeidentifyStructuredContent.assertTrue((String)"Checking no ContentSequence ", (attributeList.get(TagFromName.ContentSequence) == null ? 1 : 0) != 0);
        TestDeidentifyStructuredContent.assertTrue((String)"Checking no ConceptNameCodeSequence ", (attributeList.get(TagFromName.ConceptNameCodeSequence) == null ? 1 : 0) != 0);
    }

    public void TestDeidentifyStructuredContent_Modify_FromSR() throws Exception {
        AttributeList attributeList = TestDeidentifyStructuredContent.makeSR();
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 2, false, false, false, false, false, false, 1, null, null, 2);
        TestDeidentifyStructuredContent.assertTrue((String)"Checking there is a top level ContentSequence ", (attributeList.get(TagFromName.ContentSequence) != null ? 1 : 0) != 0);
        TestDeidentifyStructuredContent.assertTrue((String)"Checking there is a top level ConceptNameCodeSequence ", (attributeList.get(TagFromName.ConceptNameCodeSequence) != null ? 1 : 0) != 0);
        StructuredReport structuredReport = new StructuredReport(attributeList);
        TestDeidentifyStructuredContent.assertFalse((String)"Checking SR is not null", (structuredReport == null ? 1 : 0) != 0);
        Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(structuredReport, attributeList);
        TestDeidentifyStructuredContent.assertFalse((String)"Checking SR document is not null", (document == null ? 1 : 0) != 0);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        TestDeidentifyStructuredContent.assertEquals((String)"Selected Region Description", (String)"REMOVED", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/code[concept/@cv='111017']/container[concept/@cv='111034']/code[concept/@cv='111059']/text[concept/@cv='111058']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Person Observer Name", (String)"Nobody^Noone", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/pname[concept/@cv='121008']/value", document));
        TestDeidentifyStructuredContent.assertTrue((String)"Device Observer UID", (!defaultUIDValue.equals(xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/uidref[concept/@cv='121012']/value", document)) ? 1 : 0) != 0);
        TestDeidentifyStructuredContent.assertEquals((String)"Service Performer as PNAME removed", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/pname[concept/@cv='121435']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Service Performer as TEXT removed", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/text[concept/@cv='121435']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Unrecognized PNAME removed", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/pname[concept/@cv='7235223']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Device Observer Name", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/text[concept/@cv='121013']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Device Observer Physical Location During Observation", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/text[concept/@cv='121017']/value", document));
    }

    public void TestDeidentifyStructuredContent_Modify_FromSR_KeepDescriptors() throws Exception {
        AttributeList attributeList = TestDeidentifyStructuredContent.makeSR();
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 2, true, false, false, false, false, false, 1, null, null, 2);
        TestDeidentifyStructuredContent.assertTrue((String)"Checking there is a top level ContentSequence ", (attributeList.get(TagFromName.ContentSequence) != null ? 1 : 0) != 0);
        TestDeidentifyStructuredContent.assertTrue((String)"Checking there is a top level ConceptNameCodeSequence ", (attributeList.get(TagFromName.ConceptNameCodeSequence) != null ? 1 : 0) != 0);
        StructuredReport structuredReport = new StructuredReport(attributeList);
        TestDeidentifyStructuredContent.assertFalse((String)"Checking SR is not null", (structuredReport == null ? 1 : 0) != 0);
        Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(structuredReport, attributeList);
        TestDeidentifyStructuredContent.assertFalse((String)"Checking SR document is not null", (document == null ? 1 : 0) != 0);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        TestDeidentifyStructuredContent.assertEquals((String)"Selected Region Description", (String)defaultDescriptionValue, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/code[concept/@cv='111017']/container[concept/@cv='111034']/code[concept/@cv='111059']/text[concept/@cv='111058']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Person Observer Name", (String)"Nobody^Noone", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/pname[concept/@cv='121008']/value", document));
        TestDeidentifyStructuredContent.assertTrue((String)"Device Observer UID", (!defaultUIDValue.equals(xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/uidref[concept/@cv='121012']/value", document)) ? 1 : 0) != 0);
        TestDeidentifyStructuredContent.assertEquals((String)"Service Performer as PNAME removed", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/pname[concept/@cv='121435']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Service Performer as TEXT removed", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/text[concept/@cv='121435']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Unrecognized PNAME removed", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/pname[concept/@cv='7235223']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Device Observer Name", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/text[concept/@cv='121013']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Device Observer Physical Location During Observation", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/text[concept/@cv='121017']/value", document));
    }

    public void TestDeidentifyStructuredContent_Modify_FromSR_KeepDevice() throws Exception {
        AttributeList attributeList = TestDeidentifyStructuredContent.makeSR();
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 2, false, false, false, false, true, false, 1, null, null, 2);
        TestDeidentifyStructuredContent.assertTrue((String)"Checking there is a top level ContentSequence ", (attributeList.get(TagFromName.ContentSequence) != null ? 1 : 0) != 0);
        TestDeidentifyStructuredContent.assertTrue((String)"Checking there is a top level ConceptNameCodeSequence ", (attributeList.get(TagFromName.ConceptNameCodeSequence) != null ? 1 : 0) != 0);
        StructuredReport structuredReport = new StructuredReport(attributeList);
        TestDeidentifyStructuredContent.assertFalse((String)"Checking SR is not null", (structuredReport == null ? 1 : 0) != 0);
        Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(structuredReport, attributeList);
        TestDeidentifyStructuredContent.assertFalse((String)"Checking SR document is not null", (document == null ? 1 : 0) != 0);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        TestDeidentifyStructuredContent.assertEquals((String)"Device Observer Name", (String)defaultDescriptionValue, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/text[concept/@cv='121013']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Selected Region Description", (String)"REMOVED", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/code[concept/@cv='111017']/container[concept/@cv='111034']/code[concept/@cv='111059']/text[concept/@cv='111058']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Person Observer Name", (String)"Nobody^Noone", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/pname[concept/@cv='121008']/value", document));
        TestDeidentifyStructuredContent.assertTrue((String)"Device Observer UID", (!defaultUIDValue.equals(xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/uidref[concept/@cv='121012']/value", document)) ? 1 : 0) != 0);
        TestDeidentifyStructuredContent.assertEquals((String)"Service Performer as PNAME removed", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/pname[concept/@cv='121435']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Service Performer as TEXT removed", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/text[concept/@cv='121435']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Unrecognized PNAME removed", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/pname[concept/@cv='7235223']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Device Observer Physical Location During Observation", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/text[concept/@cv='121017']/value", document));
    }

    public void TestDeidentifyStructuredContent_Modify_FromSR_KeepInstitution() throws Exception {
        AttributeList attributeList = TestDeidentifyStructuredContent.makeSR();
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 2, false, false, false, false, false, true, 1, null, null, 2);
        TestDeidentifyStructuredContent.assertTrue((String)"Checking there is a top level ContentSequence ", (attributeList.get(TagFromName.ContentSequence) != null ? 1 : 0) != 0);
        TestDeidentifyStructuredContent.assertTrue((String)"Checking there is a top level ConceptNameCodeSequence ", (attributeList.get(TagFromName.ConceptNameCodeSequence) != null ? 1 : 0) != 0);
        TestDeidentifyStructuredContent.assertTrue((String)"Checking no empty ContentSequence items after de-identification ", (boolean)TestDeidentifyStructuredContent.checkNoEmptyContentSequenceEtAl(attributeList));
        StructuredReport structuredReport = new StructuredReport(attributeList);
        TestDeidentifyStructuredContent.assertFalse((String)"Checking SR is not null", (structuredReport == null ? 1 : 0) != 0);
        Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(structuredReport, attributeList);
        TestDeidentifyStructuredContent.assertFalse((String)"Checking SR document is not null", (document == null ? 1 : 0) != 0);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        TestDeidentifyStructuredContent.assertEquals((String)"Observer is PERSON", (String)"121006", (String)CodedSequenceItem.getSingleCodedSequenceItemOrNull(((SequenceAttribute)attributeList.get(TagFromName.ContentSequence)).getItem(0).getAttributeList(), TagFromName.ConceptCodeSequence).getCodeValue());
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.ContentSequence);
        int n = CodedSequenceItem.getItemNumberContainingCodeSequence(sequenceAttribute, TagFromName.ConceptNameCodeSequence, new CodedSequenceItem("121005", "DCM", "Observer Type"));
        TestDeidentifyStructuredContent.assertEquals((String)"Observer is PERSON", (String)"121006", (String)CodedSequenceItem.getSingleCodedSequenceItemOrNull(sequenceAttribute.getItem(n).getAttributeList(), TagFromName.ConceptCodeSequence).getCodeValue());
        TestDeidentifyStructuredContent.assertEquals((String)"Observer is PERSON", (String)"121006", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/code[concept/@cv='121005']/value/@cv", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Device Observer Physical Location During Observation", (String)defaultDescriptionValue, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/text[concept/@cv='121017']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Selected Region Description", (String)"REMOVED", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/code[concept/@cv='111017']/container[concept/@cv='111034']/code[concept/@cv='111059']/text[concept/@cv='111058']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Person Observer Name", (String)"Nobody^Noone", (String)((SequenceAttribute)attributeList.get(TagFromName.ContentSequence)).getItem(1).getAttributeList().get(TagFromName.PersonName).getSingleStringValueOrEmptyString());
        TestDeidentifyStructuredContent.assertEquals((String)"Person Observer Name", (String)"Nobody^Noone", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/pname[concept/@cv='121008']/value", document));
        TestDeidentifyStructuredContent.assertTrue((String)"Device Observer UID", (!defaultUIDValue.equals(xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/uidref[concept/@cv='121012']/value", document)) ? 1 : 0) != 0);
        TestDeidentifyStructuredContent.assertTrue((String)"Service Performer as PNAME and TEXT removed", (CodedSequenceItem.getItemNumberContainingCodeSequence(attributeList, TagFromName.ContentSequence, TagFromName.ConceptNameCodeSequence, new CodedSequenceItem("121435", "DCM", "Service Performer")) == -1 ? 1 : 0) != 0);
        TestDeidentifyStructuredContent.assertEquals((String)"Service Performer as PNAME removed", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/pname[concept/@cv='121435']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Service Performer as TEXT removed", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/text[concept/@cv='121435']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Unrecognized PNAME removed", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/pname[concept/@cv='7235223']/value", document));
        TestDeidentifyStructuredContent.assertEquals((String)"Device Observer Name", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='111036']/text[concept/@cv='121013']/value", document));
    }
}

