/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.DicomStreamCopier;
import com.pixelmed.dicom.FloatDoubleAttribute;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.SignedShortAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.Serializable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDicomStreamCopier_ConvertTransferSyntaxes
extends TestCase {
    private static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;
    private String patientName = "Smith^Mary";
    private String patientID = "3764913624";
    private String patientBirthDate = "19600101";
    private String patientAge = "041Y";
    private String patientWeight = "68";
    private String patientSize = "1.55";
    private String patientSex = "F";
    private String studyID = "612386812";
    private String seriesNumber = "12";
    private String instanceNumber = "38";
    private String referringPhysicianName = "Jones^Harriet";
    private String studyDate = "20010203";
    private String studyTime = "043000";

    public TestDicomStreamCopier_ConvertTransferSyntaxes(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestDicomStreamCopier_ConvertTransferSyntaxes");
        testSuite.addTest((Test)new TestDicomStreamCopier_ConvertTransferSyntaxes("TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitLittle_Basic"));
        testSuite.addTest((Test)new TestDicomStreamCopier_ConvertTransferSyntaxes("TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitLittle_ValueTooLongForShortVR"));
        testSuite.addTest((Test)new TestDicomStreamCopier_ConvertTransferSyntaxes("TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitBig_ValueTooLongForShortVR"));
        testSuite.addTest((Test)new TestDicomStreamCopier_ConvertTransferSyntaxes("TestDicomStreamCopier_ConvertTransferSyntaxes_RoundTripThroughExplicitBig_ValueTooLongForShortVR"));
        testSuite.addTest((Test)new TestDicomStreamCopier_ConvertTransferSyntaxes("TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitLittle_UnspecifiedShortAttribute_SignedPixelRepresentation"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private AttributeList makeAttributeList() {
        AttributeList attributeList = new AttributeList();
        try {
            UIDGenerator uIDGenerator = new UIDGenerator("9999");
            String string = uIDGenerator.getNewSOPInstanceUID(this.studyID, this.seriesNumber, this.instanceNumber);
            String string2 = uIDGenerator.getNewSeriesInstanceUID(this.studyID, this.seriesNumber);
            String string3 = uIDGenerator.getNewStudyInstanceUID(this.studyID);
            StringAttribute stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
            ((Attribute)stringAttribute).addValue("1.2.840.10008.5.1.4.1.1.2");
            attributeList.put(stringAttribute);
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
            ((Attribute)stringAttribute).addValue(string);
            attributeList.put(stringAttribute);
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
            ((Attribute)stringAttribute).addValue(string2);
            attributeList.put(stringAttribute);
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
            ((Attribute)stringAttribute).addValue(string3);
            attributeList.put(stringAttribute);
            stringAttribute = new PersonNameAttribute(TagFromName.PatientName);
            ((Attribute)stringAttribute).addValue(this.patientName);
            attributeList.put(stringAttribute);
            stringAttribute = new LongStringAttribute(TagFromName.PatientID);
            ((Attribute)stringAttribute).addValue(this.patientID);
            attributeList.put(stringAttribute);
            stringAttribute = new DateAttribute(TagFromName.PatientBirthDate);
            ((Attribute)stringAttribute).addValue(this.patientBirthDate);
            attributeList.put(stringAttribute);
            stringAttribute = new AgeStringAttribute(TagFromName.PatientAge);
            ((Attribute)stringAttribute).addValue(this.patientAge);
            attributeList.put(stringAttribute);
            stringAttribute = new CodeStringAttribute(TagFromName.PatientSex);
            ((Attribute)stringAttribute).addValue(this.patientSex);
            attributeList.put(stringAttribute);
            stringAttribute = new DecimalStringAttribute(TagFromName.PatientWeight);
            ((Attribute)stringAttribute).addValue(this.patientWeight);
            attributeList.put(stringAttribute);
            stringAttribute = new DecimalStringAttribute(TagFromName.PatientSize);
            ((Attribute)stringAttribute).addValue(this.patientSize);
            attributeList.put(stringAttribute);
            stringAttribute = new ShortStringAttribute(TagFromName.StudyID);
            ((Attribute)stringAttribute).addValue(this.studyID);
            attributeList.put(stringAttribute);
            stringAttribute = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
            ((Attribute)stringAttribute).addValue(this.referringPhysicianName);
            attributeList.put(stringAttribute);
            stringAttribute = new IntegerStringAttribute(TagFromName.SeriesNumber);
            ((Attribute)stringAttribute).addValue(this.seriesNumber);
            attributeList.put(stringAttribute);
            stringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
            ((Attribute)stringAttribute).addValue(this.instanceNumber);
            attributeList.put(stringAttribute);
            stringAttribute = new LongStringAttribute(TagFromName.Manufacturer);
            attributeList.put(stringAttribute);
            stringAttribute = new DateAttribute(TagFromName.StudyDate);
            ((Attribute)stringAttribute).addValue(this.studyDate);
            attributeList.put(stringAttribute);
            stringAttribute = new TimeAttribute(TagFromName.StudyTime);
            ((Attribute)stringAttribute).addValue(this.studyTime);
            attributeList.put(stringAttribute);
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
        return attributeList;
    }

    public void TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitLittle_Basic() throws Exception {
        File file = File.createTempFile("TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitLittle_Basic", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        attributeList.write(file, "1.2.840.10008.1.2", false, true);
        Object object = new AttributeList();
        ((AttributeList)object).read(file.getCanonicalPath(), "1.2.840.10008.1.2", false, true);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"AttributeLists read OK", (boolean)attributeList.equals(object));
        object = new DicomInputStream(new FileInputStream(file), "1.2.840.10008.1.2", false);
        File file2 = File.createTempFile("TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitLittle_Basic", ".dcm");
        file2.deleteOnExit();
        Object object2 = new DicomOutputStream(new FileOutputStream(file2), null, "1.2.840.10008.1.2.1");
        ((DicomOutputStream)object2).setWritingDataSet();
        new DicomStreamCopier((DicomInputStream)object, (DicomOutputStream)object2);
        ((FilterOutputStream)object2).close();
        ((FilterInputStream)object).close();
        AttributeList attributeList2 = new AttributeList();
        attributeList2.read(file2.getCanonicalPath(), "1.2.840.10008.1.2.1", false, true);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"AttributeLists copied using DicomStreamCopier OK", (boolean)attributeList.equals(attributeList2));
        object = new DicomInputStream(new FileInputStream(file), "1.2.840.10008.1.2", false);
        file2 = File.createTempFile("TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitLittle_Basic", ".dcm");
        file2.deleteOnExit();
        object2 = new AttributeList();
        ((AttributeList)object2).read(file.getCanonicalPath(), "1.2.840.10008.1.2", false, true);
        ((AttributeList)object2).write(file2, "1.2.840.10008.1.2.1", false, true);
        object2 = new AttributeList();
        ((AttributeList)object2).read(file2.getCanonicalPath(), "1.2.840.10008.1.2.1", false, true);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"AttributeLists copied by writing AttributeList OK", (boolean)attributeList.equals(object2));
    }

    public void TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitLittle_ValueTooLongForShortVR() throws Exception {
        File file = File.createTempFile("TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitLittle_ValueTooLongForShortVR", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        Object object = new DecimalStringAttribute(TagFromName.DVHData);
        attributeList.put((Attribute)object);
        String string = "1.369547";
        for (int i = 0; i < 9000; ++i) {
            ((Attribute)object).addValue(string);
        }
        object = new FloatDoubleAttribute(TagFromName.TableOfYBreakPoints);
        attributeList.put((Attribute)object);
        for (int i = 0; i < 8193; ++i) {
            ((Attribute)object).addValue(i);
        }
        attributeList.write(file, "1.2.840.10008.1.2", false, true);
        object = new AttributeList();
        ((AttributeList)object).read(file.getCanonicalPath(), "1.2.840.10008.1.2", false, true);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"AttributeLists read OK", (boolean)attributeList.equals(object));
        object = new DicomInputStream(new FileInputStream(file), "1.2.840.10008.1.2", false);
        File file2 = File.createTempFile("TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitLittle_ValueTooLongForShortVR", ".dcm");
        file2.deleteOnExit();
        Object object2 = new DicomOutputStream(new FileOutputStream(file2), null, "1.2.840.10008.1.2.1");
        ((DicomOutputStream)object2).setWritingDataSet();
        new DicomStreamCopier((DicomInputStream)object, (DicomOutputStream)object2);
        ((FilterOutputStream)object2).close();
        ((FilterInputStream)object).close();
        AttributeList attributeList2 = new AttributeList();
        attributeList2.read(file2.getCanonicalPath(), "1.2.840.10008.1.2.1", false, true);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"AttributeLists copied using DicomStreamCopier OK", (boolean)attributeList.equals(attributeList2));
        object = new DicomInputStream(new FileInputStream(file), "1.2.840.10008.1.2", false);
        file2 = File.createTempFile("TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitLittle_ValueTooLongForShortVR", ".dcm");
        file2.deleteOnExit();
        object2 = new AttributeList();
        ((AttributeList)object2).read(file.getCanonicalPath(), "1.2.840.10008.1.2", false, true);
        ((AttributeList)object2).write(file2, "1.2.840.10008.1.2.1", false, true);
        object2 = new AttributeList();
        ((AttributeList)object2).read(file2.getCanonicalPath(), "1.2.840.10008.1.2.1", false, true);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"AttributeLists copied by writing AttributeList OK", (boolean)attributeList.equals(object2));
    }

    public void TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitBig_ValueTooLongForShortVR() throws Exception {
        File file = File.createTempFile("TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitBig_ValueTooLongForShortVR", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        Object object = new DecimalStringAttribute(TagFromName.DVHData);
        attributeList.put((Attribute)object);
        Object object2 = "1.369547";
        for (int i = 0; i < 9000; ++i) {
            ((Attribute)object).addValue((String)object2);
        }
        attributeList.write(file, "1.2.840.10008.1.2", false, true);
        object = new AttributeList();
        ((AttributeList)object).read(file.getCanonicalPath(), "1.2.840.10008.1.2", false, true);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"AttributeLists read OK", (boolean)attributeList.equals(object));
        object = new DicomInputStream(new FileInputStream(file), "1.2.840.10008.1.2", false);
        object2 = File.createTempFile("TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitBig_ValueTooLongForShortVR", ".dcm");
        ((File)object2).deleteOnExit();
        Object object3 = new DicomOutputStream(new FileOutputStream((File)object2), null, "1.2.840.10008.1.2.2");
        ((DicomOutputStream)object3).setWritingDataSet();
        new DicomStreamCopier((DicomInputStream)object, (DicomOutputStream)object3);
        ((FilterOutputStream)object3).close();
        ((FilterInputStream)object).close();
        AttributeList attributeList2 = new AttributeList();
        attributeList2.read(((File)object2).getCanonicalPath(), "1.2.840.10008.1.2.2", false, true);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"AttributeLists copied using DicomStreamCopier OK", (boolean)attributeList.equals(attributeList2));
        object = new DicomInputStream(new FileInputStream(file), "1.2.840.10008.1.2", false);
        object2 = File.createTempFile("TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitBig_ValueTooLongForShortVR", ".dcm");
        ((File)object2).deleteOnExit();
        object3 = new AttributeList();
        ((AttributeList)object3).read(file.getCanonicalPath(), "1.2.840.10008.1.2", false, true);
        ((AttributeList)object3).write((File)object2, "1.2.840.10008.1.2.2", false, true);
        object3 = new AttributeList();
        ((AttributeList)object3).read(((File)object2).getCanonicalPath(), "1.2.840.10008.1.2.2", false, true);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"AttributeLists copied by writing AttributeList OK", (boolean)attributeList.equals(object3));
    }

    public void TestDicomStreamCopier_ConvertTransferSyntaxes_RoundTripThroughExplicitBig_ValueTooLongForShortVR() throws Exception {
        File file = File.createTempFile("TestDicomStreamCopier_ConvertTransferSyntaxes_RoundTripThroughExplicitBig_ValueTooLongForShortVR", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        Object object = new DecimalStringAttribute(TagFromName.DVHData);
        attributeList.put((Attribute)object);
        String string = "1.369547";
        for (int i = 0; i < 9000; ++i) {
            ((Attribute)object).addValue(string);
        }
        object = new FloatDoubleAttribute(TagFromName.TableOfYBreakPoints);
        attributeList.put((Attribute)object);
        for (int i = 0; i < 8193; ++i) {
            ((Attribute)object).addValue(i);
        }
        attributeList.write(file, "1.2.840.10008.1.2", false, true);
        object = new AttributeList();
        ((AttributeList)object).read(file.getCanonicalPath(), "1.2.840.10008.1.2", false, true);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"AttributeLists read OK", (boolean)attributeList.equals(object));
        object = File.createTempFile("TestDicomStreamCopier_ConvertTransferSyntaxes_RoundTripThroughExplicitBig_ValueTooLongForShortVR", ".dcm");
        ((File)object).deleteOnExit();
        Object object2 = new DicomInputStream(new FileInputStream(file), "1.2.840.10008.1.2", false);
        Object object3 = new DicomOutputStream(new FileOutputStream((File)object), null, "1.2.840.10008.1.2.2");
        ((DicomOutputStream)object3).setWritingDataSet();
        new DicomStreamCopier((DicomInputStream)object2, (DicomOutputStream)object3);
        ((FilterOutputStream)object3).close();
        ((FilterInputStream)object2).close();
        object2 = File.createTempFile("TestDicomStreamCopier_ConvertTransferSyntaxes_RoundTripThroughExplicitBig_ValueTooLongForShortVR", ".dcm");
        ((File)object2).deleteOnExit();
        object3 = new DicomInputStream(new FileInputStream((File)object), "1.2.840.10008.1.2.2", false);
        DicomOutputStream dicomOutputStream = new DicomOutputStream(new FileOutputStream((File)object2), null, "1.2.840.10008.1.2.1");
        dicomOutputStream.setWritingDataSet();
        new DicomStreamCopier((DicomInputStream)object3, dicomOutputStream);
        dicomOutputStream.close();
        ((FilterInputStream)object3).close();
        object3 = new AttributeList();
        ((AttributeList)object3).read(((File)object2).getCanonicalPath(), "1.2.840.10008.1.2.1", false, true);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"AttributeLists copied using DicomStreamCopier from IVRLE to EVRBE to EVRLE OK", (boolean)attributeList.equals(object3));
    }

    public void TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitLittle_UnspecifiedShortAttribute_SignedPixelRepresentation() throws Exception {
        File file = File.createTempFile("TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitLittle_UnspecifiedShortAttribute_SignedPixelRepresentation", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        Object object = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
        ((Attribute)object).addValue(1);
        attributeList.put((Attribute)object);
        object = new SignedShortAttribute(TagFromName.PixelPaddingValue);
        ((Attribute)object).addValue(65535);
        attributeList.put((Attribute)object);
        object = new SequenceAttribute(TagFromName.RealWorldValueMappingSequence);
        attributeList.put((Attribute)object);
        Serializable serializable = new AttributeList();
        ((SequenceAttribute)object).addItem((AttributeList)serializable);
        Object object2 = new SignedShortAttribute(TagFromName.RealWorldValueLastValueMapped);
        ((Attribute)object2).addValue(65535);
        ((AttributeList)serializable).put((Attribute)object2);
        object = new SequenceAttribute(dictionary.getTagFromName("HistogramSequence"));
        attributeList.put((Attribute)object);
        serializable = new AttributeList();
        ((SequenceAttribute)object).addItem((AttributeList)serializable);
        object2 = new SignedShortAttribute(dictionary.getTagFromName("HistogramLastBinValue"));
        ((Attribute)object2).addValue(65535);
        ((AttributeList)serializable).put((Attribute)object2);
        attributeList.write(file, "1.2.840.10008.1.2", false, true);
        object = new AttributeList();
        ((AttributeList)object).read(file.getCanonicalPath(), "1.2.840.10008.1.2", false, true);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"AttributeLists read OK", (boolean)attributeList.equals(object));
        object = new DicomInputStream(new FileInputStream(file), "1.2.840.10008.1.2", false);
        serializable = File.createTempFile("TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitLittle_UnspecifiedShortAttribute_SignedPixelRepresentation", ".dcm");
        ((File)serializable).deleteOnExit();
        object2 = new DicomOutputStream(new FileOutputStream((File)serializable), null, "1.2.840.10008.1.2.1");
        ((DicomOutputStream)object2).setWritingDataSet();
        new DicomStreamCopier((DicomInputStream)object, (DicomOutputStream)object2);
        ((FilterOutputStream)object2).close();
        ((FilterInputStream)object).close();
        Object object3 = new AttributeList();
        ((AttributeList)object3).read(((File)serializable).getCanonicalPath(), "1.2.840.10008.1.2.1", false, true);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"AttributeLists copied using DicomStreamCopier OK", (boolean)attributeList.equals(object3));
        Object object4 = ((AttributeList)object3).get(TagFromName.PixelPaddingValue);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"Checking PixelPaddingValue is SS", (boolean)(object4 instanceof SignedShortAttribute));
        int[] nArray = ((Attribute)object4).getIntegerValues();
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertEquals((String)"Checking PixelPaddingValue value is -1", (int)-1, (int)nArray[0]);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"Checking PixelPaddingValue value is not 0xffff", (nArray[0] != 65535 ? 1 : 0) != 0);
        object4 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem((AttributeList)object3, TagFromName.RealWorldValueMappingSequence, TagFromName.RealWorldValueLastValueMapped);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"Checking RealWorldValueLastValueMapped is SS", (boolean)(object4 instanceof SignedShortAttribute));
        nArray = ((Attribute)object4).getIntegerValues();
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertEquals((String)"Checking RealWorldValueLastValueMapped value is -1", (int)-1, (int)nArray[0]);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"Checking RealWorldValueLastValueMapped value is not 0xffff", (nArray[0] != 65535 ? 1 : 0) != 0);
        object4 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem((AttributeList)object3, dictionary.getTagFromName("HistogramSequence"), dictionary.getTagFromName("HistogramLastBinValue"));
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"Checking HistogramLastBinValue is SS", (boolean)(object4 instanceof SignedShortAttribute));
        nArray = ((Attribute)object4).getIntegerValues();
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertEquals((String)"Checking HistogramLastBinValue value is -1", (int)-1, (int)nArray[0]);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"Checking HistogramLastBinValue value is not 0xffff", (nArray[0] != 65535 ? 1 : 0) != 0);
        object = new DicomInputStream(new FileInputStream(file), "1.2.840.10008.1.2", false);
        serializable = File.createTempFile("TestDicomStreamCopier_ConvertTransferSyntaxes_ImplicitToExplicitLittle_UnspecifiedShortAttribute_SignedPixelRepresentation", ".dcm");
        ((File)serializable).deleteOnExit();
        object2 = new AttributeList();
        ((AttributeList)object2).read(file.getCanonicalPath(), "1.2.840.10008.1.2", false, true);
        ((AttributeList)object2).write((File)serializable, "1.2.840.10008.1.2.1", false, true);
        object2 = new AttributeList();
        ((AttributeList)object2).read(((File)serializable).getCanonicalPath(), "1.2.840.10008.1.2.1", false, true);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"AttributeLists copied by writing AttributeList OK", (boolean)attributeList.equals(object2));
        object3 = ((AttributeList)object2).get(TagFromName.PixelPaddingValue);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"Checking PixelPaddingValue is SS", (boolean)(object3 instanceof SignedShortAttribute));
        object4 = ((Attribute)object3).getIntegerValues();
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertEquals((String)"Checking PixelPaddingValue value is -1", (int)-1, (int)object4[0]);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"Checking PixelPaddingValue value is not 0xffff", (object4[0] != 65535 ? 1 : 0) != 0);
        object3 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem((AttributeList)object2, TagFromName.RealWorldValueMappingSequence, TagFromName.RealWorldValueLastValueMapped);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"Checking RealWorldValueLastValueMapped is SS", (boolean)(object3 instanceof SignedShortAttribute));
        object4 = ((Attribute)object3).getIntegerValues();
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertEquals((String)"Checking RealWorldValueLastValueMapped value is -1", (int)-1, (int)object4[0]);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"Checking RealWorldValueLastValueMapped value is not 0xffff", (object4[0] != 65535 ? 1 : 0) != 0);
        object3 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem((AttributeList)object2, dictionary.getTagFromName("HistogramSequence"), dictionary.getTagFromName("HistogramLastBinValue"));
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"Checking HistogramLastBinValue is SS", (boolean)(object3 instanceof SignedShortAttribute));
        object4 = ((Attribute)object3).getIntegerValues();
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertEquals((String)"Checking HistogramLastBinValue value is -1", (int)-1, (int)object4[0]);
        TestDicomStreamCopier_ConvertTransferSyntaxes.assertTrue((String)"Checking HistogramLastBinValue value is not 0xffff", (object4[0] != 65535 ? 1 : 0) != 0);
    }
}

