/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.utils.FloatFormatter;
import java.text.NumberFormat;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestFloatFormatterLocaleEffect
extends TestCase {
    public TestFloatFormatterLocaleEffect(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestFloatFormatterLocaleEffect");
        testSuite.addTest((Test)new TestFloatFormatterLocaleEffect("TestFloatFormatterLocaleEffect_Double_DefaultLocale"));
        testSuite.addTest((Test)new TestFloatFormatterLocaleEffect("TestFloatFormatterLocaleEffect_Double_DefaultFrenchLocale"));
        testSuite.addTest((Test)new TestFloatFormatterLocaleEffect("TestFloatFormatterLocaleEffect_Double_WantFrenchLocaleUsingDefault"));
        testSuite.addTest((Test)new TestFloatFormatterLocaleEffect("TestFloatFormatterLocaleEffect_Double_WantFrenchLocaleUsingExplicitLocale"));
        testSuite.addTest((Test)new TestFloatFormatterLocaleEffect("TestFloatFormatterLocaleEffect_Double_DefaultAllAvailableLocales"));
        testSuite.addTest((Test)new TestFloatFormatterLocaleEffect("TestFloatFormatterLocaleEffect_Double_ExplicitAllAvailableLocales"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestFloatFormatterLocaleEffect_Double_DefaultLocale() throws Exception {
        double d = 39.76;
        double d2 = -56356.457457;
        double d3 = 0.0;
        double d4 = 7.45345345E-21;
        double d5 = 86.0;
        String string = "39.76";
        String string2 = "-56356.457457";
        String string3 = "0";
        String string4 = ".745345345E-20";
        String string5 = "86";
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (String)string, (String)FloatFormatter.toStringOfFixedMaximumLength(d, 16, false));
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (String)string2, (String)FloatFormatter.toStringOfFixedMaximumLength(d2, 16, false));
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (String)string3, (String)FloatFormatter.toStringOfFixedMaximumLength(d3, 16, false));
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (String)string4, (String)FloatFormatter.toStringOfFixedMaximumLength(d4, 16, false));
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (String)string5, (String)FloatFormatter.toStringOfFixedMaximumLength(d5, 16, false));
        TestFloatFormatterLocaleEffect.assertEquals((String)"Default", (Object)d, (Object)Double.valueOf(FloatFormatter.toStringOfFixedMaximumLength(d, 16, false, Locale.US)));
        TestFloatFormatterLocaleEffect.assertEquals((String)"Default", (Object)d2, (Object)Double.valueOf(FloatFormatter.toStringOfFixedMaximumLength(d2, 16, false, Locale.US)));
        TestFloatFormatterLocaleEffect.assertEquals((String)"Default", (Object)d3, (Object)Double.valueOf(FloatFormatter.toStringOfFixedMaximumLength(d3, 16, false, Locale.US)));
        TestFloatFormatterLocaleEffect.assertEquals((String)"Default", (Object)d4, (Object)Double.valueOf(FloatFormatter.toStringOfFixedMaximumLength(d4, 16, false, Locale.US)));
        TestFloatFormatterLocaleEffect.assertEquals((String)"Default", (Object)d5, (Object)Double.valueOf(FloatFormatter.toStringOfFixedMaximumLength(d5, 16, false, Locale.US)));
    }

    public void TestFloatFormatterLocaleEffect_Double_DefaultFrenchLocale() throws Exception {
        double d = 39.76;
        double d2 = -56356.457457;
        double d3 = 0.0;
        double d4 = 7.45345345E-21;
        Locale.setDefault(Locale.FRENCH);
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (Object)d, (Object)Double.valueOf(FloatFormatter.toStringOfFixedMaximumLength(d, 16, false, Locale.US)));
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (Object)d2, (Object)Double.valueOf(FloatFormatter.toStringOfFixedMaximumLength(d2, 16, false, Locale.US)));
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (Object)d3, (Object)Double.valueOf(FloatFormatter.toStringOfFixedMaximumLength(d3, 16, false, Locale.US)));
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (Object)d4, (Object)Double.valueOf(FloatFormatter.toStringOfFixedMaximumLength(d4, 16, false, Locale.US)));
    }

    public void TestFloatFormatterLocaleEffect_Double_WantFrenchLocaleUsingDefault() throws Exception {
        double d = 39.76;
        double d2 = -56356.457457;
        double d3 = 0.0;
        double d4 = 7.45345345E-21;
        String string = "39,76";
        String string2 = "-56356,457457";
        String string3 = "0";
        String string4 = ",745345345E-20";
        Locale.setDefault(Locale.FRENCH);
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (String)string, (String)FloatFormatter.toStringOfFixedMaximumLength(d, 16, false));
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (String)string2, (String)FloatFormatter.toStringOfFixedMaximumLength(d2, 16, false));
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (String)string3, (String)FloatFormatter.toStringOfFixedMaximumLength(d3, 16, false));
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (String)string4, (String)FloatFormatter.toStringOfFixedMaximumLength(d4, 16, false));
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (Object)d, (Object)NumberFormat.getInstance().parse(FloatFormatter.toStringOfFixedMaximumLength(d, 16, false)).doubleValue());
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (Object)d2, (Object)NumberFormat.getInstance().parse(FloatFormatter.toStringOfFixedMaximumLength(d2, 16, false)).doubleValue());
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (Object)d3, (Object)NumberFormat.getInstance().parse(FloatFormatter.toStringOfFixedMaximumLength(d3, 16, false)).doubleValue());
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (Object)d4, (Object)NumberFormat.getInstance().parse(FloatFormatter.toStringOfFixedMaximumLength(d4, 16, false)).doubleValue());
    }

    public void TestFloatFormatterLocaleEffect_Double_WantFrenchLocaleUsingExplicitLocale() throws Exception {
        double d = 39.76;
        double d2 = -56356.457457;
        double d3 = 0.0;
        double d4 = 7.45345345E-21;
        String string = "39,76";
        String string2 = "-56356,457457";
        String string3 = "0";
        String string4 = ",745345345E-20";
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (String)string, (String)FloatFormatter.toStringOfFixedMaximumLength(d, 16, false, Locale.FRENCH));
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (String)string2, (String)FloatFormatter.toStringOfFixedMaximumLength(d2, 16, false, Locale.FRENCH));
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (String)string3, (String)FloatFormatter.toStringOfFixedMaximumLength(d3, 16, false, Locale.FRENCH));
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (String)string4, (String)FloatFormatter.toStringOfFixedMaximumLength(d4, 16, false, Locale.FRENCH));
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (Object)d, (Object)NumberFormat.getInstance(Locale.FRENCH).parse(FloatFormatter.toStringOfFixedMaximumLength(d, 16, false, Locale.FRENCH)).doubleValue());
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (Object)d2, (Object)NumberFormat.getInstance(Locale.FRENCH).parse(FloatFormatter.toStringOfFixedMaximumLength(d2, 16, false, Locale.FRENCH)).doubleValue());
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (Object)d3, (Object)NumberFormat.getInstance(Locale.FRENCH).parse(FloatFormatter.toStringOfFixedMaximumLength(d3, 16, false, Locale.FRENCH)).doubleValue());
        TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (Object)d4, (Object)NumberFormat.getInstance(Locale.FRENCH).parse(FloatFormatter.toStringOfFixedMaximumLength(d4, 16, false, Locale.FRENCH)).doubleValue());
    }

    public void TestFloatFormatterLocaleEffect_Double_DefaultAllAvailableLocales() throws Exception {
        Locale[] localeArray;
        double d = 39.76;
        double d2 = -56356.457457;
        double d3 = 0.0;
        double d4 = 7.45345345E-21;
        for (Locale locale : localeArray = Locale.getAvailableLocales()) {
            Locale.setDefault(locale);
            TestFloatFormatterLocaleEffect.assertEquals((String)locale.toString(), (Object)d, (Object)Double.valueOf(FloatFormatter.toStringOfFixedMaximumLength(d, 16, false, Locale.US)));
            TestFloatFormatterLocaleEffect.assertEquals((String)locale.toString(), (Object)d2, (Object)Double.valueOf(FloatFormatter.toStringOfFixedMaximumLength(d2, 16, false, Locale.US)));
            TestFloatFormatterLocaleEffect.assertEquals((String)locale.toString(), (Object)d3, (Object)Double.valueOf(FloatFormatter.toStringOfFixedMaximumLength(d3, 16, false, Locale.US)));
            TestFloatFormatterLocaleEffect.assertEquals((String)locale.toString(), (Object)d4, (Object)Double.valueOf(FloatFormatter.toStringOfFixedMaximumLength(d4, 16, false, Locale.US)));
        }
    }

    public void TestFloatFormatterLocaleEffect_Double_ExplicitAllAvailableLocales() throws Exception {
        Locale[] localeArray;
        double d = 39.76;
        double d2 = -56356.457457;
        double d3 = 0.0;
        double d4 = 7.45345345E-21;
        for (Locale locale : localeArray = Locale.getAvailableLocales()) {
            TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (Object)d, (Object)NumberFormat.getInstance(locale).parse(FloatFormatter.toStringOfFixedMaximumLength(d, 16, false, locale)).doubleValue());
            TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (Object)d2, (Object)NumberFormat.getInstance(locale).parse(FloatFormatter.toStringOfFixedMaximumLength(d2, 16, false, locale)).doubleValue());
            TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (Object)d3, (Object)NumberFormat.getInstance(locale).parse(FloatFormatter.toStringOfFixedMaximumLength(d3, 16, false, locale)).doubleValue());
            TestFloatFormatterLocaleEffect.assertEquals((String)Locale.getDefault().toString(), (Object)d4, (Object)NumberFormat.getInstance(locale).parse(FloatFormatter.toStringOfFixedMaximumLength(d4, 16, false, locale)).doubleValue());
        }
    }
}

