/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomFileUtilities;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestIsDicomFile
extends TestCase {
    private String patientName = "Smith^Mary";
    private String patientID = "3764913624";
    private String patientBirthDate = "19600101";
    private String patientAge = "041Y";
    private String patientWeight = "68";
    private String patientSize = "1.55";
    private String patientSex = "F";
    private String studyID = "612386812";
    private String seriesNumber = "12";
    private String instanceNumber = "38";
    private String referringPhysicianName = "Jones^Harriet";
    private String studyDate = "20010203";
    private String studyTime = "043000";

    public TestIsDicomFile(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestIsDicomFile");
        testSuite.addTest((Test)new TestIsDicomFile("TestIsDicomFile_NormalPreambleAndMetaInformation"));
        testSuite.addTest((Test)new TestIsDicomFile("TestIsDicomFile_NoPreambleOrMetaInformation"));
        testSuite.addTest((Test)new TestIsDicomFile("TestIsDicomFile_NormalPreambleAndCommandElementsBeforeMetaInformation"));
        testSuite.addTest((Test)new TestIsDicomFile("TestIsDicomFile_NoPreambleOrMetaInformationButCommandElementsBeforeDataSet"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private AttributeList makeAttributeList() {
        AttributeList attributeList = new AttributeList();
        try {
            UIDGenerator uIDGenerator = new UIDGenerator("9999");
            String string = uIDGenerator.getNewSOPInstanceUID(this.studyID, this.seriesNumber, this.instanceNumber);
            String string2 = uIDGenerator.getNewSeriesInstanceUID(this.studyID, this.seriesNumber);
            String string3 = uIDGenerator.getNewStudyInstanceUID(this.studyID);
            StringAttribute stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
            ((Attribute)stringAttribute).addValue("1.2.840.10008.5.1.4.1.1.2");
            attributeList.put(stringAttribute);
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
            ((Attribute)stringAttribute).addValue(string);
            attributeList.put(stringAttribute);
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
            ((Attribute)stringAttribute).addValue(string2);
            attributeList.put(stringAttribute);
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
            ((Attribute)stringAttribute).addValue(string3);
            attributeList.put(stringAttribute);
            stringAttribute = new PersonNameAttribute(TagFromName.PatientName);
            ((Attribute)stringAttribute).addValue(this.patientName);
            attributeList.put(stringAttribute);
            stringAttribute = new LongStringAttribute(TagFromName.PatientID);
            ((Attribute)stringAttribute).addValue(this.patientID);
            attributeList.put(stringAttribute);
            stringAttribute = new DateAttribute(TagFromName.PatientBirthDate);
            ((Attribute)stringAttribute).addValue(this.patientBirthDate);
            attributeList.put(stringAttribute);
            stringAttribute = new AgeStringAttribute(TagFromName.PatientAge);
            ((Attribute)stringAttribute).addValue(this.patientAge);
            attributeList.put(stringAttribute);
            stringAttribute = new CodeStringAttribute(TagFromName.PatientSex);
            ((Attribute)stringAttribute).addValue(this.patientSex);
            attributeList.put(stringAttribute);
            stringAttribute = new DecimalStringAttribute(TagFromName.PatientWeight);
            ((Attribute)stringAttribute).addValue(this.patientWeight);
            attributeList.put(stringAttribute);
            stringAttribute = new DecimalStringAttribute(TagFromName.PatientSize);
            ((Attribute)stringAttribute).addValue(this.patientSize);
            attributeList.put(stringAttribute);
            stringAttribute = new ShortStringAttribute(TagFromName.StudyID);
            ((Attribute)stringAttribute).addValue(this.studyID);
            attributeList.put(stringAttribute);
            stringAttribute = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
            ((Attribute)stringAttribute).addValue(this.referringPhysicianName);
            attributeList.put(stringAttribute);
            stringAttribute = new IntegerStringAttribute(TagFromName.SeriesNumber);
            ((Attribute)stringAttribute).addValue(this.seriesNumber);
            attributeList.put(stringAttribute);
            stringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
            ((Attribute)stringAttribute).addValue(this.instanceNumber);
            attributeList.put(stringAttribute);
            stringAttribute = new LongStringAttribute(TagFromName.Manufacturer);
            attributeList.put(stringAttribute);
            stringAttribute = new DateAttribute(TagFromName.StudyDate);
            ((Attribute)stringAttribute).addValue(this.studyDate);
            attributeList.put(stringAttribute);
            stringAttribute = new TimeAttribute(TagFromName.StudyTime);
            ((Attribute)stringAttribute).addValue(this.studyTime);
            attributeList.put(stringAttribute);
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
        return attributeList;
    }

    private void addCommandGroup(AttributeList attributeList) {
        try {
            Attribute attribute = new UniqueIdentifierAttribute(TagFromName.AffectedSOPClassUID);
            attribute.addValue("1.2.840.10008.5.1.4.1.1.2");
            attributeList.put(attribute);
            attribute = new UnsignedShortAttribute(TagFromName.CommandField);
            attribute.addValue(1);
            attributeList.put(attribute);
            attribute = new UnsignedShortAttribute(TagFromName.MessageID);
            attribute.addValue(1234);
            attributeList.put(attribute);
            attribute = new UnsignedShortAttribute(TagFromName.Priority);
            attribute.addValue(1);
            attributeList.put(attribute);
            attribute = new UnsignedShortAttribute(TagFromName.CommandDataSetType);
            attribute.addValue(0);
            attributeList.put(attribute);
            attribute = new UniqueIdentifierAttribute(TagFromName.AffectedSOPInstanceUID);
            attribute.addValue(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID));
            attributeList.put(attribute);
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
    }

    public void TestIsDicomFile_NormalPreambleAndMetaInformation() throws Exception {
        File file = File.createTempFile("TestIsDicomFile_NormalPreambleAndMetaInformation", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
        TestIsDicomFile.assertTrue((String)"isDicomOrAcrNemaFile", (boolean)DicomFileUtilities.isDicomOrAcrNemaFile(file));
        attributeList.removeMetaInformationHeaderAttributes();
        AttributeList attributeList2 = new AttributeList();
        attributeList2.read(file);
        attributeList2.removeMetaInformationHeaderAttributes();
        TestIsDicomFile.assertTrue((String)"Comparing list read with written", (boolean)attributeList.equals(attributeList2));
    }

    public void TestIsDicomFile_NoPreambleOrMetaInformation() throws Exception {
        File file = File.createTempFile("TestIsDicomFile_NoPreambleOrMetaInformation", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(file, "1.2.840.10008.1.2.1", false, true);
        TestIsDicomFile.assertTrue((String)"isDicomOrAcrNemaFile", (boolean)DicomFileUtilities.isDicomOrAcrNemaFile(file));
        attributeList.removeMetaInformationHeaderAttributes();
        AttributeList attributeList2 = new AttributeList();
        attributeList2.read(file);
        attributeList2.removeMetaInformationHeaderAttributes();
        TestIsDicomFile.assertTrue((String)"Comparing list read with written", (boolean)attributeList.equals(attributeList2));
    }

    public void TestIsDicomFile_NormalPreambleAndCommandElementsBeforeMetaInformation() throws Exception {
        File file = File.createTempFile("TestIsDicomFile_NormalPreambleAndCommandElementsBeforeMetaInformation", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        this.addCommandGroup(attributeList);
        attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
        TestIsDicomFile.assertTrue((String)"isDicomOrAcrNemaFile", (boolean)DicomFileUtilities.isDicomOrAcrNemaFile(file));
        attributeList.removeMetaInformationHeaderAttributes();
        AttributeList attributeList2 = new AttributeList();
        attributeList2.read(file);
        attributeList2.removeMetaInformationHeaderAttributes();
        TestIsDicomFile.assertTrue((String)"Comparing list read with written", (boolean)attributeList.equals(attributeList2));
    }

    public void TestIsDicomFile_NoPreambleOrMetaInformationButCommandElementsBeforeDataSet() throws Exception {
        File file = File.createTempFile("TestIsDicomFile_NoPreambleOrMetaInformationButCommandElementsBeforeDataSet", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        this.addCommandGroup(attributeList);
        attributeList.write(file, "1.2.840.10008.1.2.1", false, true);
        TestIsDicomFile.assertTrue((String)"isDicomOrAcrNemaFile", (!DicomFileUtilities.isDicomOrAcrNemaFile(file) ? 1 : 0) != 0);
        attributeList.removeMetaInformationHeaderAttributes();
        AttributeList attributeList2 = new AttributeList();
        attributeList2.read(file);
        attributeList2.removeMetaInformationHeaderAttributes();
        TestIsDicomFile.assertTrue((String)"Comparing list read with written", (boolean)attributeList.equals(attributeList2));
    }
}

