/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeFactory;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.ContentItemWithReference;
import com.pixelmed.dicom.ContentItemWithValue;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.FloatDoubleAttribute;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.JSONRepresentationOfStructuredReportObjectFactory;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherDoubleAttribute;
import com.pixelmed.dicom.OtherFloatAttribute;
import com.pixelmed.dicom.OtherLongAttribute;
import com.pixelmed.dicom.OtherVeryLongAttribute;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnknownAttribute;
import com.pixelmed.dicom.UnsignedLongAttribute;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestJSONRepresentationOfStructuredReport
extends TestCase {
    private static String deviceUID = "1.2.3.4";
    private static String deviceName = "station1";
    private static String manufacturer = "Acme";
    private static String modelName = "Scanner";
    private static String serialNumber = "72349236741";
    private static String location = "Suite1";
    private static String operatorName = "Smith^John";
    private static String operatorID = "26354781234";
    private static String physicianName = "Jones^Mary";
    private static String physicianID = "23491234234";
    private static String idIssuer = "99BLA";
    private static String organization = "St. Elsewhere's";
    private static String patientName = "Yamada^Tarou=\u5c71\u7530^\u592a\u90ce=\u3084\u307e\u3060^\u305f\u308d\u3046";
    private static String patientID = "3764913624";
    private static String patientBirthDate = "19600101";
    private static String patientAge = "041Y";
    private static String patientWeight = "68";
    private static String patientSize = "1.55";
    private static String patientSex = "F";
    private static String studyID = "612386812";
    private static String seriesNumber = "12";
    private static String instanceNumber = "38";
    private static String referringPhysicianName = "Jones^Harriet";
    private static String consultingPhysicianName1 = "Jones^Harriet";
    private static String consultingPhysicianName2 = "Yamada^Tarou=\u5c71\u7530^\u592a\u90ce=\u3084\u307e\u3060^\u305f\u308d\u3046";
    private static String consultingPhysicianName3 = "";
    private static String consultingPhysicianName4 = "Wang^XiaoDong=\u738b^\u5c0f\u6771";
    private static String consultingPhysicianName5 = "";
    private static String studyDate = "20010203";
    private static String studyTime = "043000";
    private static String sopInstanceUID;
    private static String seriesInstanceUID;
    private static String studyInstanceUID;
    private static String sopClassUID;
    private static String modalitiesInStudy1;
    private static String modalitiesInStudy2;
    private static String modalitiesInStudy3;
    private static String modalitiesInStudy4;
    private static String referencedFrameNumber1;
    private static String referencedFrameNumber2;
    private static String referencedFrameNumber3;
    private static String referencedFrameNumber4;
    private static long simpleFrameList1;
    private static long simpleFrameList2;
    private static double timeRange1;
    private static double timeRange2;
    private static byte[] makerNote;
    private static short[] recommendedDisplayCIELabValueList;
    private static float[] floatingPointValues;
    private static double[] volumetricCurvePoints;
    private static int[] longPrimitivePointIndexList;
    private static long[] extendedOffsetTable;
    private static byte[] unknownPrivateValues;
    private static String observationUID;
    private static String observationDateTime;

    public TestJSONRepresentationOfStructuredReport(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestJSONRepresentationOfStructuredReport");
        testSuite.addTest((Test)new TestJSONRepresentationOfStructuredReport("testStructuredReport_JSONRepresentationOfStructuredReport_DicomFile"));
        return testSuite;
    }

    private static StructuredReport createSRContent() throws DicomException {
        ContentItemFactory contentItemFactory;
        ContentItemFactory contentItemFactory2 = contentItemFactory = new ContentItemFactory();
        contentItemFactory2.getClass();
        ContentItemFactory.ContainerContentItem containerContentItem = contentItemFactory2.new ContentItemFactory.ContainerContentItem(null, null, new CodedSequenceItem("111036", "DCM", "Mammography CAD Report"), true, "DCMR", "5000");
        ContentItemFactory contentItemFactory3 = contentItemFactory;
        contentItemFactory3.getClass();
        ContentItemFactory.ContainerContentItem containerContentItem2 = contentItemFactory3.new ContentItemFactory.ContainerContentItem(containerContentItem, "CONTAINS", new CodedSequenceItem("111028", "DCM", "Image Library"), true);
        ContentItemFactory contentItemFactory4 = contentItemFactory;
        contentItemFactory4.getClass();
        ContentItemFactory.ImageContentItem imageContentItem = contentItemFactory4.new ContentItemFactory.ImageContentItem(containerContentItem2, "CONTAINS", null, "1.2.840.10008.5.1.4.1.1.1.2", "1.3.6.1.4.1.5962.99.1.993064428.2122236180.1358202762732.2.0", 0, 0, null, null, null, null);
        ContentItemFactory contentItemFactory5 = contentItemFactory;
        contentItemFactory5.getClass();
        contentItemFactory5.new ContentItemFactory.PersonNameContentItem(containerContentItem, "HAS OBS CONTEXT", new CodedSequenceItem("121008", "DCM", "Person Observer Name"), consultingPhysicianName2);
        ContentItemFactory contentItemFactory6 = contentItemFactory;
        contentItemFactory6.getClass();
        ContentItemWithValue contentItemWithValue = contentItemFactory6.new ContentItemFactory.PersonNameContentItem(containerContentItem, "HAS OBS CONTEXT", new CodedSequenceItem("121008", "DCM", "Person Observer Name"), consultingPhysicianName4, observationDateTime, observationUID);
        ContentItemFactory contentItemFactory7 = contentItemFactory;
        contentItemFactory7.getClass();
        contentItemFactory7.new ContentItemFactory.TextContentItem(contentItemWithValue, "HAS CONCEPT MOD", new CodedSequenceItem("128775", "DCM", "Identifier within Person Observer's Role"), "not realistic");
        ContentItemFactory contentItemFactory8 = contentItemFactory;
        contentItemFactory8.getClass();
        contentItemWithValue = contentItemFactory8.new ContentItemFactory.CodeContentItem(containerContentItem, "CONTAINS", new CodedSequenceItem("111017", "DCM", "CAD Processing and Findings Summary"), new CodedSequenceItem("111242", "DCM", "All algorithms succeeded; with findings"));
        ContentItemFactory contentItemFactory9 = contentItemFactory;
        contentItemFactory9.getClass();
        Object object = contentItemFactory9.new ContentItemFactory.ContainerContentItem(contentItemWithValue, "CONTAINS", new CodedSequenceItem("111034", "DCM", "Individual Impression/Recommendation"), true);
        ContentItemFactory contentItemFactory10 = contentItemFactory;
        contentItemFactory10.getClass();
        contentItemFactory10.new ContentItemFactory.CodeContentItem((ContentItem)object, "HAS CONCEPT MOD", new CodedSequenceItem("111056", "DCM", "Rendering Intent"), new CodedSequenceItem("111150", "DCM", "Presentation Required: Rendering device is expected to present"));
        Object object2 = new CodedSequenceItem("12345", "99PMPTESTJSON", "20191230", "Value for extended attributes");
        Object object3 = AttributeFactory.newAttribute(DicomDictionary.StandardDictionary.getTagFromName("LongCodeValue"));
        ((Attribute)object3).addValue("LONGCODE");
        ((CodedSequenceItem)object2).getAttributeList().put((Attribute)object3);
        object3 = AttributeFactory.newAttribute(DicomDictionary.StandardDictionary.getTagFromName("URNCodeValue"));
        ((Attribute)object3).addValue("URNCODE");
        ((CodedSequenceItem)object2).getAttributeList().put((Attribute)object3);
        object3 = AttributeFactory.newAttribute(DicomDictionary.StandardDictionary.getTagFromName("ContextIdentifier"));
        ((Attribute)object3).addValue("CIDVALUE");
        ((CodedSequenceItem)object2).getAttributeList().put((Attribute)object3);
        object3 = AttributeFactory.newAttribute(DicomDictionary.StandardDictionary.getTagFromName("ContextUID"));
        ((Attribute)object3).addValue("CUIDVALUE");
        ((CodedSequenceItem)object2).getAttributeList().put((Attribute)object3);
        object3 = AttributeFactory.newAttribute(DicomDictionary.StandardDictionary.getTagFromName("MappingResource"));
        ((Attribute)object3).addValue("MRVALUE");
        ((CodedSequenceItem)object2).getAttributeList().put((Attribute)object3);
        object3 = AttributeFactory.newAttribute(DicomDictionary.StandardDictionary.getTagFromName("MappingResourceUID"));
        ((Attribute)object3).addValue("MRUIDALUE");
        ((CodedSequenceItem)object2).getAttributeList().put((Attribute)object3);
        object3 = AttributeFactory.newAttribute(DicomDictionary.StandardDictionary.getTagFromName("MappingResourceName"));
        ((Attribute)object3).addValue("MRNVALUE");
        ((CodedSequenceItem)object2).getAttributeList().put((Attribute)object3);
        object3 = AttributeFactory.newAttribute(DicomDictionary.StandardDictionary.getTagFromName("ContextGroupVersion"));
        ((Attribute)object3).addValue("CGVERSVALUE");
        ((CodedSequenceItem)object2).getAttributeList().put((Attribute)object3);
        object3 = AttributeFactory.newAttribute(DicomDictionary.StandardDictionary.getTagFromName("ContextGroupExtensionFlag"));
        ((Attribute)object3).addValue("CGEXTFLAGVALUE");
        ((CodedSequenceItem)object2).getAttributeList().put((Attribute)object3);
        object3 = AttributeFactory.newAttribute(DicomDictionary.StandardDictionary.getTagFromName("ContextGroupLocalVersion"));
        ((Attribute)object3).addValue("CGLVERSVALUE");
        ((CodedSequenceItem)object2).getAttributeList().put((Attribute)object3);
        object3 = AttributeFactory.newAttribute(DicomDictionary.StandardDictionary.getTagFromName("ContextGroupExtensionCreatorUID"));
        ((Attribute)object3).addValue("CGEXTCUIDVALUE");
        ((CodedSequenceItem)object2).getAttributeList().put((Attribute)object3);
        ContentItemFactory contentItemFactory11 = contentItemFactory;
        contentItemFactory11.getClass();
        contentItemFactory11.new ContentItemFactory.CodeContentItem((ContentItem)object, "HAS CONCEPT MOD", new CodedSequenceItem("12346", "99PMPTESTJSON", "Concept name for extended attributes"), (CodedSequenceItem)object2);
        ContentItemFactory contentItemFactory12 = contentItemFactory;
        contentItemFactory12.getClass();
        object2 = contentItemFactory12.new ContentItemFactory.CodeContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("111059", "DCM", "Single Image Finding"), new CodedSequenceItem("F-01775", "SRT", "Calcification Cluster"));
        ContentItemFactory contentItemFactory13 = contentItemFactory;
        contentItemFactory13.getClass();
        contentItemFactory13.new ContentItemFactory.CodeContentItem((ContentItem)object2, "HAS CONCEPT MOD", new CodedSequenceItem("111056", "DCM", "Rendering Intent"), new CodedSequenceItem("111150", "DCM", "Presentation Required: Rendering device is expected to present"));
        ContentItemFactory contentItemFactory14 = contentItemFactory;
        contentItemFactory14.getClass();
        object3 = contentItemFactory14.new ContentItemFactory.SpatialCoordinatesContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("111010", "DCM", "Center"), "POINT", new float[]{165.0f, 2433.0f});
        new ContentItemWithReference((ContentItem)object3, "SELECTED FROM", "1.1.1");
        ContentItemFactory contentItemFactory15 = contentItemFactory;
        contentItemFactory15.getClass();
        contentItemFactory15.new ContentItemFactory.NumericContentItem((ContentItem)object2, "HAS PROPERTIES", new CodedSequenceItem("111038", "DCM", "Number of calcifications"), "10", 10.0, new Integer(20), new Long(2L), new CodedSequenceItem("1", "UCUM", "no units"), new CodedSequenceItem("114006", "DCM", "Measurement failure"), observationDateTime, observationUID);
        ContentItemFactory contentItemFactory16 = contentItemFactory;
        contentItemFactory16.getClass();
        ContentItemFactory.CodeContentItem codeContentItem = contentItemFactory16.new ContentItemFactory.CodeContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("111059", "DCM", "Single Image Finding"), new CodedSequenceItem("F-01776", "SRT", "Individual Calcification"));
        ContentItemFactory contentItemFactory17 = contentItemFactory;
        contentItemFactory17.getClass();
        contentItemFactory17.new ContentItemFactory.CodeContentItem(codeContentItem, "HAS CONCEPT MOD", new CodedSequenceItem("111056", "DCM", "Rendering Intent"), new CodedSequenceItem("111150", "DCM", "Presentation Required: Rendering device is expected to present"));
        ContentItemFactory contentItemFactory18 = contentItemFactory;
        contentItemFactory18.getClass();
        ContentItemFactory.SpatialCoordinatesContentItem spatialCoordinatesContentItem = contentItemFactory18.new ContentItemFactory.SpatialCoordinatesContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("111010", "DCM", "Center"), "POINT", new float[]{198.0f, 2389.0f});
        new ContentItemWithReference(spatialCoordinatesContentItem, "SELECTED FROM", "1.1.1");
        ContentItemFactory contentItemFactory19 = contentItemFactory;
        contentItemFactory19.getClass();
        ContentItemFactory.SpatialCoordinatesContentItem spatialCoordinatesContentItem2 = contentItemFactory19.new ContentItemFactory.SpatialCoordinatesContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("111041", "DCM", "Outline"), "POLYLINE", new float[]{199.0f, 2388.0f, 198.0f, 2388.0f, 197.0f, 2388.0f, 197.0f, 2389.0f, 197.0f, 2390.0f, 198.0f, 2390.0f, 199.0f, 2390.0f, 200.0f, 2390.0f, 200.0f, 2389.0f});
        new ContentItemWithReference(spatialCoordinatesContentItem2, "SELECTED FROM", "1.1.1");
        object = new StructuredReport(containerContentItem);
        System.err.println(object);
        return object;
    }

    private static AttributeList createSRContentAttributeList() throws DicomException {
        StructuredReport structuredReport = TestJSONRepresentationOfStructuredReport.createSRContent();
        return structuredReport.getAttributeList();
    }

    private static AttributeList createHeaderAttributeList() throws DicomException {
        Locale.setDefault(Locale.FRENCH);
        AttributeList attributeList = new AttributeList();
        UIDGenerator uIDGenerator = new UIDGenerator("9999");
        sopInstanceUID = uIDGenerator.getNewSOPInstanceUID(studyID, seriesNumber, instanceNumber);
        seriesInstanceUID = uIDGenerator.getNewSeriesInstanceUID(studyID, seriesNumber);
        studyInstanceUID = uIDGenerator.getNewStudyInstanceUID(studyID);
        Attribute attribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        attribute.addValue(sopInstanceUID);
        attributeList.put(attribute);
        attribute = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        attribute.addValue(seriesInstanceUID);
        attributeList.put(attribute);
        attribute = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        attribute.addValue(studyInstanceUID);
        attributeList.put(attribute);
        attribute = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        attribute.addValue(sopClassUID);
        attributeList.put(attribute);
        attribute = new PersonNameAttribute(TagFromName.PatientName);
        attribute.addValue(patientName);
        attributeList.put(attribute);
        attribute = new LongStringAttribute(TagFromName.PatientID);
        attribute.addValue(patientID);
        attributeList.put(attribute);
        attribute = new DateAttribute(TagFromName.PatientBirthDate);
        attribute.addValue(patientBirthDate);
        attributeList.put(attribute);
        attribute = new AgeStringAttribute(TagFromName.PatientAge);
        attribute.addValue(patientAge);
        attributeList.put(attribute);
        attribute = new CodeStringAttribute(TagFromName.PatientSex);
        attribute.addValue(patientSex);
        attributeList.put(attribute);
        attribute = new DecimalStringAttribute(TagFromName.PatientWeight);
        attribute.addValue(patientWeight);
        attributeList.put(attribute);
        attribute = new DecimalStringAttribute(TagFromName.PatientSize);
        attribute.addValue(patientSize);
        attributeList.put(attribute);
        attribute = new ShortStringAttribute(TagFromName.StudyID);
        attribute.addValue(studyID);
        attributeList.put(attribute);
        attribute = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
        attribute.addValue(referringPhysicianName);
        attributeList.put(attribute);
        attribute = new PersonNameAttribute(TagFromName.ConsultingPhysicianName);
        attribute.addValue(consultingPhysicianName1);
        attribute.addValue(consultingPhysicianName2);
        attribute.addValue(consultingPhysicianName3);
        attribute.addValue(consultingPhysicianName4);
        attribute.addValue(consultingPhysicianName5);
        attributeList.put(attribute);
        attribute = new IntegerStringAttribute(TagFromName.SeriesNumber);
        attribute.addValue(seriesNumber);
        attributeList.put(attribute);
        attribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
        attribute.addValue(instanceNumber);
        attributeList.put(attribute);
        attribute = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put(attribute);
        attribute = new DateAttribute(TagFromName.StudyDate);
        attribute.addValue(studyDate);
        attributeList.put(attribute);
        attribute = new TimeAttribute(TagFromName.StudyTime);
        attribute.addValue(studyTime);
        attributeList.put(attribute);
        attribute = new CodeStringAttribute(TagFromName.ModalitiesInStudy);
        attribute.addValue(modalitiesInStudy1);
        attribute.addValue(modalitiesInStudy2);
        attribute.addValue(modalitiesInStudy3);
        attribute.addValue(modalitiesInStudy4);
        attributeList.put(attribute);
        attribute = new IntegerStringAttribute(TagFromName.ReferencedFrameNumber);
        attribute.addValue(referencedFrameNumber1);
        attribute.addValue(referencedFrameNumber2);
        attribute.addValue(referencedFrameNumber3);
        attribute.addValue(referencedFrameNumber4);
        attributeList.put(attribute);
        attribute = new UnsignedLongAttribute(DicomDictionary.StandardDictionary.getTagFromName("SimpleFrameList"));
        attribute.addValue(simpleFrameList1);
        attribute.addValue(simpleFrameList2);
        attributeList.put(attribute);
        attribute = new FloatDoubleAttribute(DicomDictionary.StandardDictionary.getTagFromName("TimeRange"));
        attribute.addValue(timeRange1);
        attribute.addValue(timeRange2);
        attributeList.put(attribute);
        attribute = new OtherByteAttribute(DicomDictionary.StandardDictionary.getTagFromName("MakerNote"));
        attribute.setValues(makerNote);
        attributeList.put(attribute);
        attribute = new OtherWordAttribute(DicomDictionary.StandardDictionary.getTagFromName("RecommendedDisplayCIELabValueList"));
        attribute.setValues(recommendedDisplayCIELabValueList);
        attributeList.put(attribute);
        attribute = new OtherFloatAttribute(DicomDictionary.StandardDictionary.getTagFromName("FloatingPointValues"));
        attribute.setValues(floatingPointValues);
        attributeList.put(attribute);
        attribute = new OtherDoubleAttribute(DicomDictionary.StandardDictionary.getTagFromName("VolumetricCurvePoints"));
        attribute.setValues(volumetricCurvePoints);
        attributeList.put(attribute);
        attribute = new OtherLongAttribute(DicomDictionary.StandardDictionary.getTagFromName("LongPrimitivePointIndexList"));
        attribute.setValues(longPrimitivePointIndexList);
        attributeList.put(attribute);
        attribute = new OtherVeryLongAttribute(DicomDictionary.StandardDictionary.getTagFromName("ExtendedOffsetTable"));
        attribute.setValues(extendedOffsetTable);
        attributeList.put(attribute);
        attribute = new UnknownAttribute(new AttributeTag(41, 4097));
        attribute.setValues(unknownPrivateValues);
        attributeList.put(attribute);
        return attributeList;
    }

    private static void checkEquivalenceOfAttributeLists(AttributeList attributeList, AttributeList attributeList2) throws DicomException {
        Object object = attributeList.get(DicomDictionary.StandardDictionary.getTagFromName("MakerNote"));
        Attribute attribute = attributeList2.get(DicomDictionary.StandardDictionary.getTagFromName("MakerNote"));
        Object object2 = ((Attribute)object).getByteValues();
        Object[] objectArray = attribute.getByteValues();
        TestJSONRepresentationOfStructuredReport.assertTrue((String)"Checking round trip OtherByteAttribute", (boolean)Arrays.equals((byte[])object2, objectArray));
        object = attributeList.get(DicomDictionary.StandardDictionary.getTagFromName("RecommendedDisplayCIELabValueList"));
        attribute = attributeList2.get(DicomDictionary.StandardDictionary.getTagFromName("RecommendedDisplayCIELabValueList"));
        object2 = ((Attribute)object).getShortValues();
        objectArray = attribute.getShortValues();
        TestJSONRepresentationOfStructuredReport.assertTrue((String)"Checking round trip OtherWordAttribute", (boolean)Arrays.equals((short[])object2, (short[])objectArray));
        object = attributeList.get(DicomDictionary.StandardDictionary.getTagFromName("FloatingPointValues"));
        attribute = attributeList2.get(DicomDictionary.StandardDictionary.getTagFromName("FloatingPointValues"));
        object2 = ((Attribute)object).getFloatValues();
        objectArray = attribute.getFloatValues();
        TestJSONRepresentationOfStructuredReport.assertTrue((String)"Checking round trip OtherFloatAttribute", (boolean)Arrays.equals((float[])object2, (float[])objectArray));
        object = attributeList.get(DicomDictionary.StandardDictionary.getTagFromName("VolumetricCurvePoints"));
        attribute = attributeList2.get(DicomDictionary.StandardDictionary.getTagFromName("VolumetricCurvePoints"));
        object2 = ((Attribute)object).getDoubleValues();
        objectArray = attribute.getDoubleValues();
        TestJSONRepresentationOfStructuredReport.assertTrue((String)"Checking round trip OtherDoubleAttribute", (boolean)Arrays.equals((double[])object2, (double[])objectArray));
        object = attributeList.get(DicomDictionary.StandardDictionary.getTagFromName("LongPrimitivePointIndexList"));
        attribute = attributeList2.get(DicomDictionary.StandardDictionary.getTagFromName("LongPrimitivePointIndexList"));
        object2 = ((Attribute)object).getIntegerValues();
        objectArray = attribute.getIntegerValues();
        TestJSONRepresentationOfStructuredReport.assertTrue((String)"Checking round trip OtherLongAttribute", (boolean)Arrays.equals((int[])object2, (int[])objectArray));
        object = attributeList.get(DicomDictionary.StandardDictionary.getTagFromName("ExtendedOffsetTable"));
        attribute = attributeList2.get(DicomDictionary.StandardDictionary.getTagFromName("ExtendedOffsetTable"));
        object2 = ((Attribute)object).getLongValues();
        objectArray = attribute.getLongValues();
        TestJSONRepresentationOfStructuredReport.assertTrue((String)"Checking round trip OtherVeryLongAttribute", (boolean)Arrays.equals((long[])object2, (long[])objectArray));
        object = new AttributeTag(41, 4097);
        attribute = attributeList.get((AttributeTag)object);
        object2 = attributeList2.get((AttributeTag)object);
        objectArray = attribute.getByteValues(false);
        byte[] byArray = ((Attribute)object2).getByteValues(false);
        TestJSONRepresentationOfStructuredReport.assertTrue((String)"Checking round trip UnknownAttribute", (boolean)Arrays.equals(objectArray, byArray));
    }

    private static void checkEquivalenceOfStructuredReports(StructuredReport structuredReport, StructuredReport structuredReport2) throws DicomException {
        TestJSONRepresentationOfStructuredReport.assertEquals((String)"Checking round trip StructuredReport", (String)structuredReport.toString(), (String)structuredReport2.toString());
    }

    protected void tearDown() {
    }

    public void testStructuredReport_JSONRepresentationOfStructuredReport_DicomFile() throws Exception {
        File file = File.createTempFile("testStructuredReport_JSONRepresentationOfStructuredReport_DicomFile", ".dcm");
        file.deleteOnExit();
        File file2 = File.createTempFile("testStructuredReport_JSONRepresentationOfStructuredReport_JsonFile", ".json");
        file2.deleteOnExit();
        File file3 = File.createTempFile("testStructuredReport_JSONRepresentationOfStructuredReport_BusinessNamesFile", ".json");
        file3.deleteOnExit();
        StructuredReport structuredReport = TestJSONRepresentationOfStructuredReport.createSRContent();
        AttributeList attributeList = structuredReport.getAttributeList();
        attributeList.putAll(TestJSONRepresentationOfStructuredReport.createHeaderAttributeList());
        attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
        JSONRepresentationOfStructuredReportObjectFactory jSONRepresentationOfStructuredReportObjectFactory = new JSONRepresentationOfStructuredReportObjectFactory();
        Object object = jSONRepresentationOfStructuredReportObjectFactory.getDocument(file);
        System.err.println(object + "\n\n\n");
        JSONRepresentationOfStructuredReportObjectFactory.write(file2, object);
        Object object2 = jSONRepresentationOfStructuredReportObjectFactory.getBusinessNamesDocument();
        JSONRepresentationOfStructuredReportObjectFactory.write(file3, object2);
        jSONRepresentationOfStructuredReportObjectFactory = new JSONRepresentationOfStructuredReportObjectFactory();
        jSONRepresentationOfStructuredReportObjectFactory.loadBusinessNamesDocument(file3);
        object = jSONRepresentationOfStructuredReportObjectFactory.getAttributeList(file2);
        TestJSONRepresentationOfStructuredReport.checkEquivalenceOfAttributeLists(attributeList, (AttributeList)object);
        object2 = new StructuredReport((AttributeList)object);
        TestJSONRepresentationOfStructuredReport.checkEquivalenceOfStructuredReports(structuredReport, (StructuredReport)object2);
    }

    static {
        sopClassUID = "1.2.840.10008.5.1.4.1.1.88.22";
        modalitiesInStudy1 = "CT";
        modalitiesInStudy2 = "";
        modalitiesInStudy3 = "MR";
        modalitiesInStudy4 = "";
        referencedFrameNumber1 = "1";
        referencedFrameNumber2 = "2";
        referencedFrameNumber3 = "3";
        referencedFrameNumber4 = "4";
        simpleFrameList1 = 5L;
        simpleFrameList2 = 6L;
        timeRange1 = 36.4;
        timeRange2 = 59.0;
        makerNote = new byte[]{27, 43, 59, 75};
        recommendedDisplayCIELabValueList = new short[]{-255, 28816, 24736};
        floatingPointValues = new float[]{36.27f, 6.3E-7f};
        volumetricCurvePoints = new double[]{36.27, 6.3E-7};
        longPrimitivePointIndexList = new int[]{0x112233, 857870592};
        extendedOffsetTable = new long[]{4822678189205111L, 8603657889541918976L};
        unknownPrivateValues = new byte[]{49, 50, 51, 52};
        observationUID = "2.25.121653014693151198548584403358069116971";
        observationDateTime = "20191230163732";
    }
}

