/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.FloatDoubleAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SignedLongAttribute;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnsignedLongAttribute;
import com.pixelmed.dicom.XMLRepresentationOfStructuredReportObjectFactory;
import javax.xml.xpath.XPathFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.w3c.dom.Document;

public class TestNumericContentItemFloatingAndRational
extends TestCase {
    ContentItemFactory cf;

    public TestNumericContentItemFloatingAndRational(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestNumericContentItemFloatingAndRational");
        testSuite.addTest((Test)new TestNumericContentItemFloatingAndRational("TestNumericContentItemFloatingAndRational_StringOnlyFromAttributeListConstructor_NonSR"));
        testSuite.addTest((Test)new TestNumericContentItemFloatingAndRational("TestNumericContentItemFloatingAndRational_FloatingFromAttributeListConstructor_nonSR"));
        testSuite.addTest((Test)new TestNumericContentItemFloatingAndRational("TestNumericContentItemFloatingAndRational_StringOnlyConstructor_nonSR"));
        testSuite.addTest((Test)new TestNumericContentItemFloatingAndRational("TestNumericContentItemFloatingAndRational_StringOnlyFromAttributeListConstructor"));
        testSuite.addTest((Test)new TestNumericContentItemFloatingAndRational("TestNumericContentItemFloatingAndRational_FloatingFromAttributeListConstructor"));
        testSuite.addTest((Test)new TestNumericContentItemFloatingAndRational("TestNumericContentItemFloatingAndRational_RationalFromAttributeListConstructor"));
        testSuite.addTest((Test)new TestNumericContentItemFloatingAndRational("TestNumericContentItemFloatingAndRational_StringOnlyConstructor"));
        testSuite.addTest((Test)new TestNumericContentItemFloatingAndRational("TestNumericContentItemFloatingAndRational_FloatingFromDoubleConstructor"));
        testSuite.addTest((Test)new TestNumericContentItemFloatingAndRational("TestNumericContentItemFloatingAndRational_RationalAndFloatingFromDoubleConstructor"));
        testSuite.addTest((Test)new TestNumericContentItemFloatingAndRational("TestNumericContentItemFloatingAndRational_RationalAndFloatingFromDoubleConstructorDivideByZero"));
        testSuite.addTest((Test)new TestNumericContentItemFloatingAndRational("TestNumericContentItemFloatingAndRational_DoubleConstructor_MinimalSubNormal"));
        testSuite.addTest((Test)new TestNumericContentItemFloatingAndRational("TestNumericContentItemFloatingAndRational_DoubleConstructor_SubNormalAllMantissaBitsSet"));
        return testSuite;
    }

    protected void setUp() {
        this.cf = new ContentItemFactory();
    }

    protected void tearDown() {
    }

    public void TestNumericContentItemFloatingAndRational_StringOnlyFromAttributeListConstructor_NonSR() throws Exception {
        String string = "1";
        AttributeList attributeList = new AttributeList();
        Object object = new CodeStringAttribute(TagFromName.ValueType);
        ((Attribute)object).addValue("NUMERIC");
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.NumericValue);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new ContentItemFactory();
        ContentItemFactory.NumericContentItem numericContentItem = (ContentItemFactory.NumericContentItem)((ContentItemFactory)object).getNewContentItem(null, attributeList);
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)numericContentItem.getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasFloatingPointValue", (!numericContentItem.hasFloatingPointValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasRationalValue", (!numericContentItem.hasRationalValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"getQualifier", (numericContentItem.getQualifier() == null ? 1 : 0) != 0);
    }

    public void TestNumericContentItemFloatingAndRational_StringOnlyFromAttributeListConstructor() throws Exception {
        String string = "1";
        AttributeList attributeList = new AttributeList();
        Attribute attribute = new CodeStringAttribute(TagFromName.ValueType);
        attribute.addValue("NUM");
        attributeList.put(attribute);
        attribute = new SequenceAttribute(TagFromName.MeasuredValueSequence);
        attributeList.put(attribute);
        Object object = new AttributeList();
        ((SequenceAttribute)attribute).addItem((AttributeList)object);
        Object object2 = new DecimalStringAttribute(TagFromName.NumericValue);
        ((Attribute)object2).addValue(string);
        ((AttributeList)object).put((Attribute)object2);
        object = new ContentItemFactory();
        object2 = (ContentItemFactory.NumericContentItem)((ContentItemFactory)object).getNewContentItem(null, attributeList);
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)((ContentItemFactory.NumericContentItem)object2).getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasFloatingPointValue", (!((ContentItemFactory.NumericContentItem)object2).hasFloatingPointValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasRationalValue", (!((ContentItemFactory.NumericContentItem)object2).hasRationalValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"getQualifier", (((ContentItemFactory.NumericContentItem)object2).getQualifier() == null ? 1 : 0) != 0);
        StructuredReport structuredReport = new StructuredReport((ContentItem)object2);
        XMLRepresentationOfStructuredReportObjectFactory xMLRepresentationOfStructuredReportObjectFactory = new XMLRepresentationOfStructuredReportObjectFactory();
        Document document = xMLRepresentationOfStructuredReportObjectFactory.getDocument(structuredReport, null);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"numeric value", (String)string, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/value", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"double", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/double", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"numerator", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/numerator", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"denominator", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/denominator", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"qualifier", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/qualifier/@cm", document));
        StructuredReport structuredReport2 = xMLRepresentationOfStructuredReportObjectFactory.getStructuredReport(document);
        ContentItemFactory.NumericContentItem numericContentItem = (ContentItemFactory.NumericContentItem)structuredReport2.getRoot();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)numericContentItem.getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasFloatingPointValue", (!numericContentItem.hasFloatingPointValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasRationalValue", (!numericContentItem.hasRationalValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"getQualifier", (numericContentItem.getQualifier() == null ? 1 : 0) != 0);
    }

    public void TestNumericContentItemFloatingAndRational_FloatingFromAttributeListConstructor() throws Exception {
        String string = "1";
        double d = 1.0;
        AttributeList attributeList = new AttributeList();
        Attribute attribute = new CodeStringAttribute(TagFromName.ValueType);
        attribute.addValue("NUM");
        attributeList.put(attribute);
        attribute = new SequenceAttribute(TagFromName.MeasuredValueSequence);
        attributeList.put(attribute);
        Object object = new AttributeList();
        ((SequenceAttribute)attribute).addItem((AttributeList)object);
        Object object2 = new DecimalStringAttribute(TagFromName.NumericValue);
        ((Attribute)object2).addValue(string);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new FloatDoubleAttribute(TagFromName.FloatingPointValue);
        ((Attribute)object2).addValue(d);
        ((AttributeList)object).put((Attribute)object2);
        object = new ContentItemFactory();
        object2 = (ContentItemFactory.NumericContentItem)((ContentItemFactory)object).getNewContentItem(null, attributeList);
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)((ContentItemFactory.NumericContentItem)object2).getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"hasFloatingPointValue", (boolean)((ContentItemFactory.NumericContentItem)object2).hasFloatingPointValue());
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getFloatingPointValue", (Object)d, (Object)((ContentItemFactory.NumericContentItem)object2).getFloatingPointValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasRationalValue", (!((ContentItemFactory.NumericContentItem)object2).hasRationalValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"getQualifier", (((ContentItemFactory.NumericContentItem)object2).getQualifier() == null ? 1 : 0) != 0);
        StructuredReport structuredReport = new StructuredReport((ContentItem)object2);
        XMLRepresentationOfStructuredReportObjectFactory xMLRepresentationOfStructuredReportObjectFactory = new XMLRepresentationOfStructuredReportObjectFactory();
        Document document = xMLRepresentationOfStructuredReportObjectFactory.getDocument(structuredReport, null);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"numeric value", (String)string, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/value", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"double", (Object)d, (Object)Double.parseDouble(xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/double", document)));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"numerator", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/numerator", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"denominator", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/denominator", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"qualifier", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/qualifier/@cm", document));
        StructuredReport structuredReport2 = xMLRepresentationOfStructuredReportObjectFactory.getStructuredReport(document);
        ContentItemFactory.NumericContentItem numericContentItem = (ContentItemFactory.NumericContentItem)structuredReport2.getRoot();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)numericContentItem.getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"hasFloatingPointValue", (boolean)numericContentItem.hasFloatingPointValue());
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getFloatingPointValue", (Object)d, (Object)numericContentItem.getFloatingPointValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasRationalValue", (!numericContentItem.hasRationalValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"getQualifier", (numericContentItem.getQualifier() == null ? 1 : 0) != 0);
    }

    public void TestNumericContentItemFloatingAndRational_FloatingFromAttributeListConstructor_nonSR() throws Exception {
        String string = "1";
        double d = 1.0;
        AttributeList attributeList = new AttributeList();
        Object object = new CodeStringAttribute(TagFromName.ValueType);
        ((Attribute)object).addValue("NUMERIC");
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.NumericValue);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new FloatDoubleAttribute(TagFromName.FloatingPointValue);
        ((Attribute)object).addValue(d);
        attributeList.put((Attribute)object);
        object = new ContentItemFactory();
        ContentItemFactory.NumericContentItem numericContentItem = (ContentItemFactory.NumericContentItem)((ContentItemFactory)object).getNewContentItem(null, attributeList);
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)numericContentItem.getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"hasFloatingPointValue", (boolean)numericContentItem.hasFloatingPointValue());
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getFloatingPointValue", (Object)d, (Object)numericContentItem.getFloatingPointValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasRationalValue", (!numericContentItem.hasRationalValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"getQualifier", (numericContentItem.getQualifier() == null ? 1 : 0) != 0);
    }

    public void TestNumericContentItemFloatingAndRational_RationalFromAttributeListConstructor() throws Exception {
        String string = ".333333333333333";
        int n = 1;
        long l = 3L;
        AttributeList attributeList = new AttributeList();
        Attribute attribute = new CodeStringAttribute(TagFromName.ValueType);
        attribute.addValue("NUM");
        attributeList.put(attribute);
        attribute = new SequenceAttribute(TagFromName.MeasuredValueSequence);
        attributeList.put(attribute);
        Object object = new AttributeList();
        ((SequenceAttribute)attribute).addItem((AttributeList)object);
        Object object2 = new DecimalStringAttribute(TagFromName.NumericValue);
        ((Attribute)object2).addValue(string);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new SignedLongAttribute(TagFromName.RationalNumeratorValue);
        ((Attribute)object2).addValue(n);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UnsignedLongAttribute(TagFromName.RationalDenominatorValue);
        ((Attribute)object2).addValue(l);
        ((AttributeList)object).put((Attribute)object2);
        object = new ContentItemFactory();
        object2 = (ContentItemFactory.NumericContentItem)((ContentItemFactory)object).getNewContentItem(null, attributeList);
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)((ContentItemFactory.NumericContentItem)object2).getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasFloatingPointValue", (!((ContentItemFactory.NumericContentItem)object2).hasFloatingPointValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"hasRationalValue", (boolean)((ContentItemFactory.NumericContentItem)object2).hasRationalValue());
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getRationalNumeratorValue", (int)n, (int)((ContentItemFactory.NumericContentItem)object2).getRationalNumeratorValue());
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getRationalDenominatorValue", (long)l, (long)((ContentItemFactory.NumericContentItem)object2).getRationalDenominatorValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"getQualifier", (((ContentItemFactory.NumericContentItem)object2).getQualifier() == null ? 1 : 0) != 0);
        StructuredReport structuredReport = new StructuredReport((ContentItem)object2);
        XMLRepresentationOfStructuredReportObjectFactory xMLRepresentationOfStructuredReportObjectFactory = new XMLRepresentationOfStructuredReportObjectFactory();
        Document document = xMLRepresentationOfStructuredReportObjectFactory.getDocument(structuredReport, null);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"numeric value", (String)string, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/value", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"double", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/double", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"numerator", (String)"1", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/numerator", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"denominator", (String)"3", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/denominator", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"qualifier", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/qualifier/@cm", document));
        StructuredReport structuredReport2 = xMLRepresentationOfStructuredReportObjectFactory.getStructuredReport(document);
        ContentItemFactory.NumericContentItem numericContentItem = (ContentItemFactory.NumericContentItem)structuredReport2.getRoot();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)numericContentItem.getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasFloatingPointValue", (!numericContentItem.hasFloatingPointValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"hasRationalValue", (boolean)numericContentItem.hasRationalValue());
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getRationalNumeratorValue", (int)n, (int)numericContentItem.getRationalNumeratorValue());
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getRationalDenominatorValue", (long)l, (long)numericContentItem.getRationalDenominatorValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"getQualifier", (numericContentItem.getQualifier() == null ? 1 : 0) != 0);
    }

    public void TestNumericContentItemFloatingAndRational_StringOnlyConstructor_nonSR() throws Exception {
        String string = "1";
        ContentItemFactory contentItemFactory = new ContentItemFactory();
        ContentItemFactory.NumericContentItem numericContentItem = contentItemFactory.makeNumericContentItem(null, true, null, null, string, null, null);
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)numericContentItem.getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasFloatingPointValue", (!numericContentItem.hasFloatingPointValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasRationalValue", (!numericContentItem.hasRationalValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"getQualifier", (numericContentItem.getQualifier() == null ? 1 : 0) != 0);
        AttributeList attributeList = numericContentItem.getAttributeList();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"get NumericValue from AttributeList", (String)string, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.NumericValue));
        TestNumericContentItemFloatingAndRational.assertTrue((String)"no RationalNumeratorValue from AttributeList", (attributeList.get(TagFromName.RationalNumeratorValue) == null ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"no RationalDenominatorValue from AttributeList", (attributeList.get(TagFromName.RationalDenominatorValue) == null ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"no NumericValueQualifierCodeSequence from AttributeList", (attributeList.get(TagFromName.NumericValueQualifierCodeSequence) == null ? 1 : 0) != 0);
    }

    public void TestNumericContentItemFloatingAndRational_StringOnlyConstructor() throws Exception {
        String string = "1";
        ContentItemFactory contentItemFactory = new ContentItemFactory();
        ContentItemFactory.NumericContentItem numericContentItem = contentItemFactory.makeNumericContentItem(null, null, null, string, null, null);
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)numericContentItem.getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasFloatingPointValue", (!numericContentItem.hasFloatingPointValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasRationalValue", (!numericContentItem.hasRationalValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"getQualifier", (numericContentItem.getQualifier() == null ? 1 : 0) != 0);
        Object object = numericContentItem.getAttributeList();
        Object object2 = (SequenceAttribute)((AttributeList)object).get(TagFromName.MeasuredValueSequence);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"MeasuredValueSequence present", (object2 != null ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"MeasuredValueSequence has exactly one item", (((SequenceAttribute)object2).getNumberOfItems() == 1 ? 1 : 0) != 0);
        Object object3 = ((SequenceAttribute)object2).getItem(0).getAttributeList();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"get NumericValue from AttributeList", (String)string, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object3, TagFromName.NumericValue));
        TestNumericContentItemFloatingAndRational.assertTrue((String)"no FloatingPointValue from AttributeList", (((AttributeList)object3).get(TagFromName.FloatingPointValue) == null ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"no RationalNumeratorValue from AttributeList", (((AttributeList)object3).get(TagFromName.RationalNumeratorValue) == null ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"no RationalDenominatorValue from AttributeList", (((AttributeList)object3).get(TagFromName.RationalDenominatorValue) == null ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"no NumericValueQualifierCodeSequence from AttributeList", (((AttributeList)object3).get(TagFromName.NumericValueQualifierCodeSequence) == null ? 1 : 0) != 0);
        object = new StructuredReport(numericContentItem);
        object2 = new XMLRepresentationOfStructuredReportObjectFactory();
        object3 = ((XMLRepresentationOfStructuredReportObjectFactory)object2).getDocument((StructuredReport)object, null);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"numeric value", (String)string, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/value", object3));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"double", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/double", object3));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"numerator", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/numerator", object3));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"denominator", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/denominator", object3));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"qualifier", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/qualifier/@cm", object3));
        StructuredReport structuredReport = ((XMLRepresentationOfStructuredReportObjectFactory)object2).getStructuredReport((Document)object3);
        ContentItemFactory.NumericContentItem numericContentItem2 = (ContentItemFactory.NumericContentItem)structuredReport.getRoot();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)numericContentItem2.getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasFloatingPointValue", (!numericContentItem2.hasFloatingPointValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasRationalValue", (!numericContentItem2.hasRationalValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"getQualifier", (numericContentItem2.getQualifier() == null ? 1 : 0) != 0);
    }

    public void TestNumericContentItemFloatingAndRational_FloatingFromDoubleConstructor() throws Exception {
        String string = ".333333333333333";
        double d = 0.3333333333333333;
        ContentItemFactory contentItemFactory = new ContentItemFactory();
        ContentItemFactory.NumericContentItem numericContentItem = contentItemFactory.makeNumericContentItem(null, null, null, d, null);
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)numericContentItem.getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"hasFloatingPointValue", (boolean)numericContentItem.hasFloatingPointValue());
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getFloatingPointValue", (Object)d, (Object)numericContentItem.getFloatingPointValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasRationalValue", (!numericContentItem.hasRationalValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"getQualifier", (numericContentItem.getQualifier() == null ? 1 : 0) != 0);
        Object object = numericContentItem.getAttributeList();
        Object object2 = (SequenceAttribute)((AttributeList)object).get(TagFromName.MeasuredValueSequence);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"MeasuredValueSequence present", (object2 != null ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"MeasuredValueSequence has exactly one item", (((SequenceAttribute)object2).getNumberOfItems() == 1 ? 1 : 0) != 0);
        Object object3 = ((SequenceAttribute)object2).getItem(0).getAttributeList();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"get NumericValue from AttributeList", (String)string, (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object3, TagFromName.NumericValue));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"get FloatingPointValue from AttributeList", (Object)d, (Object)((AttributeList)object3).get(TagFromName.FloatingPointValue).getDoubleValues()[0]);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"no RationalNumeratorValue from AttributeList", (((AttributeList)object3).get(TagFromName.RationalNumeratorValue) == null ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"no RationalDenominatorValue from AttributeList", (((AttributeList)object3).get(TagFromName.RationalDenominatorValue) == null ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"no NumericValueQualifierCodeSequence from AttributeList", (((AttributeList)object3).get(TagFromName.NumericValueQualifierCodeSequence) == null ? 1 : 0) != 0);
        object = new StructuredReport(numericContentItem);
        object2 = new XMLRepresentationOfStructuredReportObjectFactory();
        object3 = ((XMLRepresentationOfStructuredReportObjectFactory)object2).getDocument((StructuredReport)object, null);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"numeric value", (String)string, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/value", object3));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"double", (Object)d, (Object)Double.parseDouble(xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/double", object3)));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"numerator", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/numerator", object3));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"denominator", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/denominator", object3));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"qualifier", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/qualifier/@cm", object3));
        StructuredReport structuredReport = ((XMLRepresentationOfStructuredReportObjectFactory)object2).getStructuredReport((Document)object3);
        ContentItemFactory.NumericContentItem numericContentItem2 = (ContentItemFactory.NumericContentItem)structuredReport.getRoot();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)numericContentItem2.getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"hasFloatingPointValue", (boolean)numericContentItem2.hasFloatingPointValue());
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getFloatingPointValue", (Object)d, (Object)numericContentItem2.getFloatingPointValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasRationalValue", (!numericContentItem2.hasRationalValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"getQualifier", (numericContentItem2.getQualifier() == null ? 1 : 0) != 0);
    }

    public void TestNumericContentItemFloatingAndRational_RationalAndFloatingFromDoubleConstructor() throws Exception {
        String string = ".333333333333333";
        int n = 1;
        long l = 3L;
        double d = (double)n / (double)l;
        ContentItemFactory contentItemFactory = new ContentItemFactory();
        ContentItemFactory.NumericContentItem numericContentItem = contentItemFactory.makeNumericContentItem(null, null, null, n, l, null);
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)numericContentItem.getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"hasFloatingPointValue", (boolean)numericContentItem.hasFloatingPointValue());
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getFloatingPointValue", (Object)d, (Object)numericContentItem.getFloatingPointValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"hasRationalValue", (boolean)numericContentItem.hasRationalValue());
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getRationalNumeratorValue", (int)n, (int)numericContentItem.getRationalNumeratorValue());
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getRationalDenominatorValue", (long)l, (long)numericContentItem.getRationalDenominatorValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"getQualifier", (numericContentItem.getQualifier() == null ? 1 : 0) != 0);
        StructuredReport structuredReport = new StructuredReport(numericContentItem);
        XMLRepresentationOfStructuredReportObjectFactory xMLRepresentationOfStructuredReportObjectFactory = new XMLRepresentationOfStructuredReportObjectFactory();
        Document document = xMLRepresentationOfStructuredReportObjectFactory.getDocument(structuredReport, null);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"numeric value", (String)string, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/value", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"double", (Object)d, (Object)Double.parseDouble(xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/double", document)));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"numerator", (String)"1", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/numerator", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"denominator", (String)"3", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/denominator", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"qualifier", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/qualifier/@cm", document));
        StructuredReport structuredReport2 = xMLRepresentationOfStructuredReportObjectFactory.getStructuredReport(document);
        ContentItemFactory.NumericContentItem numericContentItem2 = (ContentItemFactory.NumericContentItem)structuredReport2.getRoot();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)numericContentItem2.getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"hasFloatingPointValue", (boolean)numericContentItem2.hasFloatingPointValue());
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getFloatingPointValue", (Object)d, (Object)numericContentItem2.getFloatingPointValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"hasRationalValue", (boolean)numericContentItem2.hasRationalValue());
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getRationalNumeratorValue", (int)n, (int)numericContentItem2.getRationalNumeratorValue());
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getRationalDenominatorValue", (long)l, (long)numericContentItem2.getRationalDenominatorValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"getQualifier", (numericContentItem2.getQualifier() == null ? 1 : 0) != 0);
    }

    public void TestNumericContentItemFloatingAndRational_RationalAndFloatingFromDoubleConstructorDivideByZero() throws Exception {
        String string = "";
        int n = 1;
        long l = 0L;
        ContentItemFactory contentItemFactory = new ContentItemFactory();
        ContentItemFactory.NumericContentItem numericContentItem = contentItemFactory.makeNumericContentItem(null, null, null, n, l, null);
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)numericContentItem.getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasFloatingPointValue", (!numericContentItem.hasFloatingPointValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasRationalValue", (!numericContentItem.hasRationalValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getQualifier", (Object)new CodedSequenceItem("114003", "DCM", "Divide by zero"), (Object)numericContentItem.getQualifier());
        StructuredReport structuredReport = new StructuredReport(numericContentItem);
        XMLRepresentationOfStructuredReportObjectFactory xMLRepresentationOfStructuredReportObjectFactory = new XMLRepresentationOfStructuredReportObjectFactory();
        Document document = xMLRepresentationOfStructuredReportObjectFactory.getDocument(structuredReport, null);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"numeric value", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/value", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"double", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/double", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"numerator", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/numerator", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"denominator", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/denominator", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"qualifier", (String)"Divide by zero", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/qualifier/@cm", document));
        StructuredReport structuredReport2 = xMLRepresentationOfStructuredReportObjectFactory.getStructuredReport(document);
        ContentItemFactory.NumericContentItem numericContentItem2 = (ContentItemFactory.NumericContentItem)structuredReport2.getRoot();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)numericContentItem2.getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasFloatingPointValue", (!numericContentItem2.hasFloatingPointValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasRationalValue", (!numericContentItem2.hasRationalValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getQualifier", (Object)new CodedSequenceItem("114003", "DCM", "Divide by zero"), (Object)numericContentItem2.getQualifier());
    }

    public void TestNumericContentItemFloatingAndRational_DoubleConstructor_MinimalSubNormal() throws Exception {
        String string = ".49E-323";
        double d = Double.longBitsToDouble(1L);
        ContentItemFactory contentItemFactory = new ContentItemFactory();
        ContentItemFactory.NumericContentItem numericContentItem = contentItemFactory.makeNumericContentItem(null, null, null, d, null);
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)numericContentItem.getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasFloatingPointValue", (!numericContentItem.hasFloatingPointValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasRationalValue", (!numericContentItem.hasRationalValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"getQualifier", (numericContentItem.getQualifier() == null ? 1 : 0) != 0);
        StructuredReport structuredReport = new StructuredReport(numericContentItem);
        XMLRepresentationOfStructuredReportObjectFactory xMLRepresentationOfStructuredReportObjectFactory = new XMLRepresentationOfStructuredReportObjectFactory();
        Document document = xMLRepresentationOfStructuredReportObjectFactory.getDocument(structuredReport, null);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"numeric value", (String)string, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/value", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"double", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/double", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"numerator", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/numerator", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"denominator", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/denominator", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"qualifier", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/qualifier/@cm", document));
        StructuredReport structuredReport2 = xMLRepresentationOfStructuredReportObjectFactory.getStructuredReport(document);
        ContentItemFactory.NumericContentItem numericContentItem2 = (ContentItemFactory.NumericContentItem)structuredReport2.getRoot();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)numericContentItem2.getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasFloatingPointValue", (!numericContentItem2.hasFloatingPointValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasRationalValue", (!numericContentItem2.hasRationalValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"getQualifier", (numericContentItem2.getQualifier() == null ? 1 : 0) != 0);
    }

    public void TestNumericContentItemFloatingAndRational_DoubleConstructor_SubNormalAllMantissaBitsSet() throws Exception {
        String string = ".2225073859E-307";
        double d = Double.longBitsToDouble(0xFFFFFFFFFFFFFL);
        ContentItemFactory contentItemFactory = new ContentItemFactory();
        ContentItemFactory.NumericContentItem numericContentItem = contentItemFactory.makeNumericContentItem(null, null, null, d, null);
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)numericContentItem.getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"hasFloatingPointValue", (boolean)numericContentItem.hasFloatingPointValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasRationalValue", (!numericContentItem.hasRationalValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"getQualifier", (numericContentItem.getQualifier() == null ? 1 : 0) != 0);
        StructuredReport structuredReport = new StructuredReport(numericContentItem);
        XMLRepresentationOfStructuredReportObjectFactory xMLRepresentationOfStructuredReportObjectFactory = new XMLRepresentationOfStructuredReportObjectFactory();
        Document document = xMLRepresentationOfStructuredReportObjectFactory.getDocument(structuredReport, null);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"numeric value", (String)string, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/value", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"double", (Object)d, (Object)Double.parseDouble(xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/double", document)));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"numerator", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/numerator", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"denominator", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/denominator", document));
        TestNumericContentItemFloatingAndRational.assertEquals((String)"qualifier", (String)"", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/num/qualifier/@cm", document));
        StructuredReport structuredReport2 = xMLRepresentationOfStructuredReportObjectFactory.getStructuredReport(document);
        ContentItemFactory.NumericContentItem numericContentItem2 = (ContentItemFactory.NumericContentItem)structuredReport2.getRoot();
        TestNumericContentItemFloatingAndRational.assertEquals((String)"getNumericValue", (String)string, (String)numericContentItem2.getNumericValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"hasFloatingPointValue", (boolean)numericContentItem2.hasFloatingPointValue());
        TestNumericContentItemFloatingAndRational.assertTrue((String)"!hasRationalValue", (!numericContentItem2.hasRationalValue() ? 1 : 0) != 0);
        TestNumericContentItemFloatingAndRational.assertTrue((String)"getQualifier", (numericContentItem2.getQualifier() == null ? 1 : 0) != 0);
    }
}

