/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.SUVTransform;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSUVTransformValues
extends TestCase {
    public TestSUVTransformValues(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestSUVTransformValues");
        testSuite.addTest((Test)new TestSUVTransformValues("TestSUVTransformValues_BQML"));
        testSuite.addTest((Test)new TestSUVTransformValues("TestSUVTransformValues_BQMLWithTimezoneOffset"));
        testSuite.addTest((Test)new TestSUVTransformValues("TestSUVTransformValues_BQMLStartDateTime"));
        testSuite.addTest((Test)new TestSUVTransformValues("TestSUVTransformValues_BQMLStartDateTimeWithTimezoneOffsetInStartDateTime"));
        testSuite.addTest((Test)new TestSUVTransformValues("TestSUVTransformValues_BQMLStartDateTimeWithTimezoneOffsetButNotInStartDateTime"));
        testSuite.addTest((Test)new TestSUVTransformValues("TestSUVTransformValues_PhilipsSUVScaleFactor"));
        testSuite.addTest((Test)new TestSUVTransformValues("TestSUVTransformValues_GMLUnitsWithoutSUVType"));
        testSuite.addTest((Test)new TestSUVTransformValues("TestSUVTransformValues_DeriveScanDateTimeFromHalfLifeAcquisitionDateTimeFrameReferenceTimeAndActualFrameDuration"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestSUVTransformValues_BQML() throws Exception {
        int n = 7972;
        double d = 1.0;
        double d2 = 0.3806;
        double d3 = 1.0;
        double d4 = 2.7726;
        double d5 = 1.0E-4;
        AttributeList attributeList = new AttributeList();
        Object object = new AttributeList();
        Object object2 = new TimeAttribute(TagFromName.RadiopharmaceuticalStartTime);
        ((Attribute)object2).addValue("130100");
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.RadionuclideTotalDose);
        ((Attribute)object2).addValue(3.7E8);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.RadionuclideHalfLife);
        ((Attribute)object2).addValue(6586.0);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new SequenceAttribute(TagFromName.RadiopharmaceuticalInformationSequence);
        SequenceItem sequenceItem = new SequenceItem((AttributeList)object);
        ((SequenceAttribute)object2).addItem(sequenceItem);
        attributeList.put((Attribute)object2);
        object = new CodeStringAttribute(TagFromName.PatientSex);
        ((Attribute)object).addValue("M");
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.PatientSize);
        ((Attribute)object).addValue(2.898275349237887);
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.PatientWeight);
        ((Attribute)object).addValue(70.0);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue("1.2.840.10008.5.1.4.1.1.128");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.CorrectedImage);
        ((Attribute)object).addValue("ATTN");
        ((Attribute)object).addValue("DECY");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Units);
        ((Attribute)object).addValue("BQML");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.DecayCorrection);
        ((Attribute)object).addValue("START");
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.RescaleIntercept);
        ((Attribute)object).addValue(0);
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.RescaleSlope);
        ((Attribute)object).addValue(0.453901487278775);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)object).addValue("20111031");
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.AcquisitionDate);
        ((Attribute)object).addValue("20111031");
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)object).addValue("140100");
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.AcquisitionTime);
        ((Attribute)object).addValue("140100");
        attributeList.put((Attribute)object);
        object = new SUVTransform(attributeList);
        object2 = ((SUVTransform)object).getSingleSUVTransform(1);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbw", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVbw());
        TestSUVTransformValues.assertTrue((String)"getSUVbwValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVbwValue(n) - d) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbsa", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVbsa());
        TestSUVTransformValues.assertTrue((String)"getSUVbsaValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVbsaValue(n) - d2) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbw", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVlbm());
        TestSUVTransformValues.assertTrue((String)"getSUVlbmValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVlbmValue(n) - d3) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVibw", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVibw());
        TestSUVTransformValues.assertTrue((String)"getSUVibwValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVibwValue(n) - d4) < d5 ? 1 : 0) != 0);
    }

    public void TestSUVTransformValues_BQMLWithTimezoneOffset() throws Exception {
        int n = 7972;
        double d = 1.0;
        double d2 = 0.3806;
        double d3 = 1.0;
        double d4 = 2.7726;
        double d5 = 1.0E-4;
        AttributeList attributeList = new AttributeList();
        Object object = new AttributeList();
        Object object2 = new TimeAttribute(TagFromName.RadiopharmaceuticalStartTime);
        ((Attribute)object2).addValue("130100");
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.RadionuclideTotalDose);
        ((Attribute)object2).addValue(3.7E8);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.RadionuclideHalfLife);
        ((Attribute)object2).addValue(6586.0);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new SequenceAttribute(TagFromName.RadiopharmaceuticalInformationSequence);
        SequenceItem sequenceItem = new SequenceItem((AttributeList)object);
        ((SequenceAttribute)object2).addItem(sequenceItem);
        attributeList.put((Attribute)object2);
        object = new CodeStringAttribute(TagFromName.PatientSex);
        ((Attribute)object).addValue("M");
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.PatientSize);
        ((Attribute)object).addValue(2.898275349237887);
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.PatientWeight);
        ((Attribute)object).addValue(70.0);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue("1.2.840.10008.5.1.4.1.1.128");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.CorrectedImage);
        ((Attribute)object).addValue("ATTN");
        ((Attribute)object).addValue("DECY");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Units);
        ((Attribute)object).addValue("BQML");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.DecayCorrection);
        ((Attribute)object).addValue("START");
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.RescaleIntercept);
        ((Attribute)object).addValue(0);
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.RescaleSlope);
        ((Attribute)object).addValue(0.453901487278775);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)object).addValue("20111031");
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.AcquisitionDate);
        ((Attribute)object).addValue("20111031");
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)object).addValue("140100");
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.AcquisitionTime);
        ((Attribute)object).addValue("140100");
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.TimezoneOffsetFromUTC);
        ((Attribute)object).addValue("-0700");
        attributeList.put((Attribute)object);
        object = new SUVTransform(attributeList);
        object2 = ((SUVTransform)object).getSingleSUVTransform(1);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbw", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVbw());
        TestSUVTransformValues.assertTrue((String)"getSUVbwValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVbwValue(n) - d) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbsa", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVbsa());
        TestSUVTransformValues.assertTrue((String)"getSUVbsaValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVbsaValue(n) - d2) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbw", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVlbm());
        TestSUVTransformValues.assertTrue((String)"getSUVlbmValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVlbmValue(n) - d3) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVibw", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVibw());
        TestSUVTransformValues.assertTrue((String)"getSUVibwValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVibwValue(n) - d4) < d5 ? 1 : 0) != 0);
    }

    public void TestSUVTransformValues_BQMLStartDateTime() throws Exception {
        int n = 7972;
        double d = 1.0;
        double d2 = 0.3806;
        double d3 = 1.0;
        double d4 = 2.7726;
        double d5 = 1.0E-4;
        AttributeList attributeList = new AttributeList();
        Object object = new AttributeList();
        Object object2 = new TimeAttribute(TagFromName.RadiopharmaceuticalStartDateTime);
        ((Attribute)object2).addValue("20111031130100");
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.RadionuclideTotalDose);
        ((Attribute)object2).addValue(3.7E8);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.RadionuclideHalfLife);
        ((Attribute)object2).addValue(6586.0);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new SequenceAttribute(TagFromName.RadiopharmaceuticalInformationSequence);
        SequenceItem sequenceItem = new SequenceItem((AttributeList)object);
        ((SequenceAttribute)object2).addItem(sequenceItem);
        attributeList.put((Attribute)object2);
        object = new CodeStringAttribute(TagFromName.PatientSex);
        ((Attribute)object).addValue("M");
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.PatientSize);
        ((Attribute)object).addValue(2.898275349237887);
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.PatientWeight);
        ((Attribute)object).addValue(70.0);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue("1.2.840.10008.5.1.4.1.1.128");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.CorrectedImage);
        ((Attribute)object).addValue("ATTN");
        ((Attribute)object).addValue("DECY");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Units);
        ((Attribute)object).addValue("BQML");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.DecayCorrection);
        ((Attribute)object).addValue("START");
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.RescaleIntercept);
        ((Attribute)object).addValue(0);
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.RescaleSlope);
        ((Attribute)object).addValue(0.453901487278775);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)object).addValue("20111031");
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.AcquisitionDate);
        ((Attribute)object).addValue("20111031");
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)object).addValue("140100");
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.AcquisitionTime);
        ((Attribute)object).addValue("140100");
        attributeList.put((Attribute)object);
        object = new SUVTransform(attributeList);
        object2 = ((SUVTransform)object).getSingleSUVTransform(1);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbw", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVbw());
        TestSUVTransformValues.assertTrue((String)"getSUVbwValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVbwValue(n) - d) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbsa", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVbsa());
        TestSUVTransformValues.assertTrue((String)"getSUVbsaValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVbsaValue(n) - d2) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbw", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVlbm());
        TestSUVTransformValues.assertTrue((String)"getSUVlbmValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVlbmValue(n) - d3) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVibw", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVibw());
        TestSUVTransformValues.assertTrue((String)"getSUVibwValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVibwValue(n) - d4) < d5 ? 1 : 0) != 0);
    }

    public void TestSUVTransformValues_BQMLStartDateTimeWithTimezoneOffsetInStartDateTime() throws Exception {
        int n = 7972;
        double d = 1.0;
        double d2 = 0.3806;
        double d3 = 1.0;
        double d4 = 2.7726;
        double d5 = 1.0E-4;
        AttributeList attributeList = new AttributeList();
        Object object = new AttributeList();
        Object object2 = new TimeAttribute(TagFromName.RadiopharmaceuticalStartDateTime);
        ((Attribute)object2).addValue("20111031130100-0700");
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.RadionuclideTotalDose);
        ((Attribute)object2).addValue(3.7E8);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.RadionuclideHalfLife);
        ((Attribute)object2).addValue(6586.0);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new SequenceAttribute(TagFromName.RadiopharmaceuticalInformationSequence);
        SequenceItem sequenceItem = new SequenceItem((AttributeList)object);
        ((SequenceAttribute)object2).addItem(sequenceItem);
        attributeList.put((Attribute)object2);
        object = new CodeStringAttribute(TagFromName.PatientSex);
        ((Attribute)object).addValue("M");
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.PatientSize);
        ((Attribute)object).addValue(2.898275349237887);
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.PatientWeight);
        ((Attribute)object).addValue(70.0);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue("1.2.840.10008.5.1.4.1.1.128");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.CorrectedImage);
        ((Attribute)object).addValue("ATTN");
        ((Attribute)object).addValue("DECY");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Units);
        ((Attribute)object).addValue("BQML");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.DecayCorrection);
        ((Attribute)object).addValue("START");
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.RescaleIntercept);
        ((Attribute)object).addValue(0);
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.RescaleSlope);
        ((Attribute)object).addValue(0.453901487278775);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)object).addValue("20111031");
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.AcquisitionDate);
        ((Attribute)object).addValue("20111031");
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)object).addValue("140100");
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.AcquisitionTime);
        ((Attribute)object).addValue("140100");
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.TimezoneOffsetFromUTC);
        ((Attribute)object).addValue("-0700");
        attributeList.put((Attribute)object);
        object = new SUVTransform(attributeList);
        object2 = ((SUVTransform)object).getSingleSUVTransform(1);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbw", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVbw());
        TestSUVTransformValues.assertTrue((String)"getSUVbwValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVbwValue(n) - d) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbsa", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVbsa());
        TestSUVTransformValues.assertTrue((String)"getSUVbsaValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVbsaValue(n) - d2) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbw", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVlbm());
        TestSUVTransformValues.assertTrue((String)"getSUVlbmValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVlbmValue(n) - d3) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVibw", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVibw());
        TestSUVTransformValues.assertTrue((String)"getSUVibwValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVibwValue(n) - d4) < d5 ? 1 : 0) != 0);
    }

    public void TestSUVTransformValues_BQMLStartDateTimeWithTimezoneOffsetButNotInStartDateTime() throws Exception {
        int n = 7972;
        double d = 1.0;
        double d2 = 0.3806;
        double d3 = 1.0;
        double d4 = 2.7726;
        double d5 = 1.0E-4;
        AttributeList attributeList = new AttributeList();
        Object object = new AttributeList();
        Object object2 = new TimeAttribute(TagFromName.RadiopharmaceuticalStartDateTime);
        ((Attribute)object2).addValue("20111031130100");
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.RadionuclideTotalDose);
        ((Attribute)object2).addValue(3.7E8);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.RadionuclideHalfLife);
        ((Attribute)object2).addValue(6586.0);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new SequenceAttribute(TagFromName.RadiopharmaceuticalInformationSequence);
        SequenceItem sequenceItem = new SequenceItem((AttributeList)object);
        ((SequenceAttribute)object2).addItem(sequenceItem);
        attributeList.put((Attribute)object2);
        object = new CodeStringAttribute(TagFromName.PatientSex);
        ((Attribute)object).addValue("M");
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.PatientSize);
        ((Attribute)object).addValue(2.898275349237887);
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.PatientWeight);
        ((Attribute)object).addValue(70.0);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue("1.2.840.10008.5.1.4.1.1.128");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.CorrectedImage);
        ((Attribute)object).addValue("ATTN");
        ((Attribute)object).addValue("DECY");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Units);
        ((Attribute)object).addValue("BQML");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.DecayCorrection);
        ((Attribute)object).addValue("START");
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.RescaleIntercept);
        ((Attribute)object).addValue(0);
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.RescaleSlope);
        ((Attribute)object).addValue(0.453901487278775);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)object).addValue("20111031");
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.AcquisitionDate);
        ((Attribute)object).addValue("20111031");
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)object).addValue("140100");
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.AcquisitionTime);
        ((Attribute)object).addValue("140100");
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.TimezoneOffsetFromUTC);
        ((Attribute)object).addValue("-0700");
        attributeList.put((Attribute)object);
        object = new SUVTransform(attributeList);
        object2 = ((SUVTransform)object).getSingleSUVTransform(1);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbw", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVbw());
        TestSUVTransformValues.assertTrue((String)"getSUVbwValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVbwValue(n) - d) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbsa", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVbsa());
        TestSUVTransformValues.assertTrue((String)"getSUVbsaValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVbsaValue(n) - d2) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbw", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVlbm());
        TestSUVTransformValues.assertTrue((String)"getSUVlbmValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVlbmValue(n) - d3) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVibw", (boolean)((SUVTransform.SingleSUVTransform)object2).isValidSUVibw());
        TestSUVTransformValues.assertTrue((String)"getSUVibwValue", (Math.abs(((SUVTransform.SingleSUVTransform)object2).getSUVibwValue(n) - d4) < d5 ? 1 : 0) != 0);
    }

    public void TestSUVTransformValues_PhilipsSUVScaleFactor() throws Exception {
        int n = 7972;
        double d = 1.0;
        double d2 = 0.3806;
        double d3 = 1.0;
        double d4 = 2.7726;
        double d5 = 1.0E-4;
        AttributeList attributeList = new AttributeList();
        Object object = new CodeStringAttribute(TagFromName.PatientSex);
        ((Attribute)object).addValue("M");
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.PatientSize);
        ((Attribute)object).addValue(2.898275349237887);
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.PatientWeight);
        ((Attribute)object).addValue(70.0);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue("1.2.840.10008.5.1.4.1.1.128");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.CorrectedImage);
        ((Attribute)object).addValue("ATTN");
        ((Attribute)object).addValue("DECY");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Units);
        ((Attribute)object).addValue("CNTS");
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.RescaleIntercept);
        ((Attribute)object).addValue(0);
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.RescaleSlope);
        ((Attribute)object).addValue(0.453901487278775);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(new AttributeTag(28755, 16));
        ((Attribute)object).addValue("Philips PET Private Group");
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(new AttributeTag(28755, 4096));
        ((Attribute)object).addValue(2.7634E-4);
        attributeList.put((Attribute)object);
        object = new SUVTransform(attributeList);
        SUVTransform.SingleSUVTransform singleSUVTransform = ((SUVTransform)object).getSingleSUVTransform(1);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbw", (boolean)singleSUVTransform.isValidSUVbw());
        TestSUVTransformValues.assertTrue((String)"getSUVbwValue", (Math.abs(singleSUVTransform.getSUVbwValue(n) - d) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbsa", (boolean)singleSUVTransform.isValidSUVbsa());
        TestSUVTransformValues.assertTrue((String)"getSUVbsaValue", (Math.abs(singleSUVTransform.getSUVbsaValue(n) - d2) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbw", (boolean)singleSUVTransform.isValidSUVlbm());
        TestSUVTransformValues.assertTrue((String)"getSUVlbmValue", (Math.abs(singleSUVTransform.getSUVlbmValue(n) - d3) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVibw", (boolean)singleSUVTransform.isValidSUVibw());
        TestSUVTransformValues.assertTrue((String)"getSUVibwValue", (Math.abs(singleSUVTransform.getSUVibwValue(n) - d4) < d5 ? 1 : 0) != 0);
    }

    public void TestSUVTransformValues_GMLUnitsWithoutSUVType() throws Exception {
        int n = 7972;
        double d = 1.0;
        double d2 = 0.3806;
        double d3 = 1.0;
        double d4 = 2.7726;
        double d5 = 1.0E-4;
        AttributeList attributeList = new AttributeList();
        Object object = new CodeStringAttribute(TagFromName.PatientSex);
        ((Attribute)object).addValue("M");
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.PatientSize);
        ((Attribute)object).addValue(2.898275349237887);
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.PatientWeight);
        ((Attribute)object).addValue(70.0);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue("1.2.840.10008.5.1.4.1.1.128");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.CorrectedImage);
        ((Attribute)object).addValue("ATTN");
        ((Attribute)object).addValue("DECY");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Units);
        ((Attribute)object).addValue("GML");
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.RescaleIntercept);
        ((Attribute)object).addValue(0);
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.RescaleSlope);
        ((Attribute)object).addValue(1.2543E-4);
        attributeList.put((Attribute)object);
        object = new SUVTransform(attributeList);
        SUVTransform.SingleSUVTransform singleSUVTransform = ((SUVTransform)object).getSingleSUVTransform(1);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbw", (boolean)singleSUVTransform.isValidSUVbw());
        TestSUVTransformValues.assertTrue((String)"getSUVbwValue", (Math.abs(singleSUVTransform.getSUVbwValue(n) - d) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbsa", (boolean)singleSUVTransform.isValidSUVbsa());
        TestSUVTransformValues.assertTrue((String)"getSUVbsaValue", (Math.abs(singleSUVTransform.getSUVbsaValue(n) - d2) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVbw", (boolean)singleSUVTransform.isValidSUVlbm());
        TestSUVTransformValues.assertTrue((String)"getSUVlbmValue", (Math.abs(singleSUVTransform.getSUVlbmValue(n) - d3) < d5 ? 1 : 0) != 0);
        TestSUVTransformValues.assertTrue((String)"isValidSUVibw", (boolean)singleSUVTransform.isValidSUVibw());
        TestSUVTransformValues.assertTrue((String)"getSUVibwValue", (Math.abs(singleSUVTransform.getSUVibwValue(n) - d4) < d5 ? 1 : 0) != 0);
    }

    public void TestSUVTransformValues_DeriveScanDateTimeFromHalfLifeAcquisitionDateTimeFrameReferenceTimeAndActualFrameDuration() throws Exception {
        long l = DateTimeAttribute.getTimeInMilliSecondsSinceEpoch("20120928121310.062000");
        AttributeList attributeList = new AttributeList();
        String[] stringArray = new AttributeList();
        Attribute attribute = new TimeAttribute(TagFromName.RadiopharmaceuticalStartTime);
        attribute.addValue("103600");
        stringArray.put(attribute);
        attribute = new DecimalStringAttribute(TagFromName.RadionuclideTotalDose);
        attribute.addValue(3.3854998779297E8);
        stringArray.put(attribute);
        attribute = new DecimalStringAttribute(TagFromName.RadionuclideHalfLife);
        attribute.addValue(6586.2);
        stringArray.put(attribute);
        attribute = new SequenceAttribute(TagFromName.RadiopharmaceuticalInformationSequence);
        SequenceItem sequenceItem = new SequenceItem((AttributeList)stringArray);
        ((SequenceAttribute)attribute).addItem(sequenceItem);
        attributeList.put(attribute);
        stringArray = new CodeStringAttribute(TagFromName.PatientSex);
        stringArray.addValue("M");
        attributeList.put((Attribute)stringArray);
        stringArray = new DecimalStringAttribute(TagFromName.PatientSize);
        stringArray.addValue(2.898275349237887);
        attributeList.put((Attribute)stringArray);
        stringArray = new DecimalStringAttribute(TagFromName.PatientWeight);
        stringArray.addValue(70.0);
        attributeList.put((Attribute)stringArray);
        stringArray = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        stringArray.addValue("1.2.840.10008.5.1.4.1.1.128");
        attributeList.put((Attribute)stringArray);
        stringArray = new CodeStringAttribute(TagFromName.CorrectedImage);
        stringArray.addValue("ATTN");
        stringArray.addValue("DECY");
        attributeList.put((Attribute)stringArray);
        stringArray = new CodeStringAttribute(TagFromName.Units);
        stringArray.addValue("BQML");
        attributeList.put((Attribute)stringArray);
        stringArray = new CodeStringAttribute(TagFromName.DecayCorrection);
        stringArray.addValue("START");
        attributeList.put((Attribute)stringArray);
        stringArray = new DecimalStringAttribute(TagFromName.RescaleIntercept);
        stringArray.addValue(0);
        attributeList.put((Attribute)stringArray);
        stringArray = new DecimalStringAttribute(TagFromName.RescaleSlope);
        stringArray.addValue(5.02139);
        attributeList.put((Attribute)stringArray);
        stringArray = new DateAttribute(TagFromName.SeriesDate);
        stringArray.addValue("20120928");
        attributeList.put((Attribute)stringArray);
        stringArray = new DateAttribute(TagFromName.AcquisitionDate);
        stringArray.addValue("20120928");
        attributeList.put((Attribute)stringArray);
        stringArray = new TimeAttribute(TagFromName.SeriesTime);
        stringArray.addValue("121310.062000");
        attributeList.put((Attribute)stringArray);
        stringArray = new IntegerStringAttribute(TagFromName.ActualFrameDuration);
        stringArray.addValue("120000");
        attributeList.put((Attribute)stringArray);
        stringArray = new String[]{"121310.062000", "121513.671000", "121717.468000", "121921.296000", "122125.281000", "122328.984000"};
        attribute = new String[]{"59936.854672596", "182936.8546726", "306936.8546726", "430936.8546726", "554936.8546726", "677936.8546726"};
        for (int i = 0; i < ((Attribute)attribute).length; ++i) {
            Object object = new TimeAttribute(TagFromName.AcquisitionTime);
            ((Attribute)object).addValue(stringArray[i]);
            attributeList.put((Attribute)object);
            object = new DecimalStringAttribute(TagFromName.FrameReferenceTime);
            ((Attribute)object).addValue((String)((Object)attribute[i]));
            attributeList.put((Attribute)object);
            object = new SUVTransform(attributeList);
            SUVTransform.SingleSUVTransform singleSUVTransform = ((SUVTransform)object).getSingleSUVTransform(1);
            long l2 = SUVTransform.deriveScanDateTimeFromHalfLifeAcquisitionDateTimeFrameReferenceTimeAndActualFrameDuration(attributeList);
            TestSUVTransformValues.assertTrue((String)"derivedScanDateTime == expectSeriesTime in seconds", ((l2 - l) / 1000L == 0L ? 1 : 0) != 0);
        }
    }
}

