/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSafePrivateSiemensUltrasoundRawDataRelated
extends TestCase {
    public TestSafePrivateSiemensUltrasoundRawDataRelated(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestSafePrivateSiemensUltrasoundRawDataRelated");
        testSuite.addTest((Test)new TestSafePrivateSiemensUltrasoundRawDataRelated("TestSafePrivateSiemensUltrasoundRawDataRelated_ScaleFactors_FromTag"));
        testSuite.addTest((Test)new TestSafePrivateSiemensUltrasoundRawDataRelated("TestSafePrivateSiemensUltrasoundRawDataRelated_ScaleFactors_FromList"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestSafePrivateSiemensUltrasoundRawDataRelated_ScaleFactors_FromTag() throws Exception {
        TestSafePrivateSiemensUltrasoundRawDataRelated.assertTrue((String)"Checking AcousticMetaInformationVersion is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("SIEMENS Ultrasound SC2000", new AttributeTag(281, 0)));
        TestSafePrivateSiemensUltrasoundRawDataRelated.assertTrue((String)"Checking VolumeVersionID is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("SIEMENS SYNGO ULTRA-SOUND TOYON DATA STREAMING", new AttributeTag(32721, 9)));
    }

    public void TestSafePrivateSiemensUltrasoundRawDataRelated_ScaleFactors_FromList() throws Exception {
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new LongStringAttribute(new AttributeTag(281, 16));
        ((Attribute)stringAttribute).addValue("SIEMENS Ultrasound SC2000");
        attributeList.put(stringAttribute);
        TestSafePrivateSiemensUltrasoundRawDataRelated.assertTrue((String)"Checking AcousticMetaInformationVersion is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(281, 4096), attributeList));
        stringAttribute = new LongStringAttribute(new AttributeTag(281, 4096));
        ((Attribute)stringAttribute).addValue("Bla");
        attributeList.put(stringAttribute);
        stringAttribute = new LongStringAttribute(new AttributeTag(32721, 16));
        ((Attribute)stringAttribute).addValue("SIEMENS SYNGO ULTRA-SOUND TOYON DATA STREAMING");
        attributeList.put(stringAttribute);
        TestSafePrivateSiemensUltrasoundRawDataRelated.assertTrue((String)"Checking VolumeVersionID is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(32721, 4105), attributeList));
        TestSafePrivateSiemensUltrasoundRawDataRelated.assertTrue((String)"Checking VolumeVersionID is non-transient so won't be removed/replaced", (!UniqueIdentifierAttribute.isTransient(new AttributeTag(32721, 4105), attributeList) ? 1 : 0) != 0);
        stringAttribute = new UniqueIdentifierAttribute(new AttributeTag(32721, 4105));
        ((Attribute)stringAttribute).addValue("1.2");
        attributeList.put(stringAttribute);
        stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)stringAttribute).addValue("1.2.840.10008.5.1.4.1.1.66");
        attributeList.put(stringAttribute);
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 2, false, false, false, false, false);
        TestSafePrivateSiemensUltrasoundRawDataRelated.assertTrue((String)"Checking AcousticMetaInformationVersion was not removed", (attributeList.get(new AttributeTag(281, 4096)) != null ? 1 : 0) != 0);
        TestSafePrivateSiemensUltrasoundRawDataRelated.assertTrue((String)"Checking VolumeVersionID was not changed", (boolean)Attribute.getSingleStringValueOrEmptyString(attributeList, new AttributeTag(32721, 4105)).equals("1.2"));
        TestSafePrivateSiemensUltrasoundRawDataRelated.assertTrue((String)"Checking SOPClassUID was not changed", (boolean)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID).equals("1.2.840.10008.5.1.4.1.1.66"));
    }
}

