/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dose.ScanRange;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestScanRange
extends TestCase {
    public TestScanRange(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestScanRange");
        testSuite.addTest((Test)new TestScanRange("testScanRangeConstructor_WithAllParameters"));
        testSuite.addTest((Test)new TestScanRange("testScanRangeConstructor_Equality"));
        testSuite.addTest((Test)new TestScanRange("testScanRangeConstructor_Inequality"));
        testSuite.addTest((Test)new TestScanRange("testScanRange_Range_ZeroI"));
        testSuite.addTest((Test)new TestScanRange("testScanRange_Range_ZeroS"));
        testSuite.addTest((Test)new TestScanRange("testScanRange_Range_IToS"));
        testSuite.addTest((Test)new TestScanRange("testScanRange_Range_SToI"));
        testSuite.addTest((Test)new TestScanRange("testScanRange_Range_SToI_NotPooled"));
        testSuite.addTest((Test)new TestScanRange("testScanRangeConstructor_SignedNegativeConstructor"));
        testSuite.addTest((Test)new TestScanRange("testScanRangeConstructor_SignedPositiveConstructor"));
        testSuite.addTest((Test)new TestScanRange("testScanRangeConstructor_SignedPostiveAndNegativeConstructor"));
        return testSuite;
    }

    protected void setUp() {
        Locale.setDefault(Locale.FRENCH);
    }

    protected void tearDown() {
    }

    public void testScanRangeConstructor_SignedNegativeConstructor() {
        String string = "I";
        String string2 = "12.750";
        String string3 = "-" + string2;
        String string4 = "I";
        String string5 = "602.750";
        String string6 = "-" + string5;
        String string7 = "I12.750-I602.750";
        ScanRange scanRange = new ScanRange(string3, string6);
        TestScanRange.assertEquals((String)"Checking startDirection", (String)string, (String)scanRange.getStartDirection());
        TestScanRange.assertEquals((String)"Checking startLocation", (String)string2, (String)scanRange.getStartLocation());
        TestScanRange.assertEquals((String)"Checking endDirection", (String)string4, (String)scanRange.getEndDirection());
        TestScanRange.assertEquals((String)"Checking endLocation", (String)string5, (String)scanRange.getEndLocation());
        TestScanRange.assertEquals((String)"Checking toString", (String)string7, (String)scanRange.toString());
    }

    public void testScanRangeConstructor_SignedPositiveConstructor() {
        String string = "S";
        String string2 = "12.750";
        String string3 = "+" + string2;
        String string4 = "S";
        String string5 = "602.750";
        String string6 = "+" + string5;
        String string7 = "S12.750-S602.750";
        ScanRange scanRange = new ScanRange(string3, string6);
        TestScanRange.assertEquals((String)"Checking startDirection", (String)string, (String)scanRange.getStartDirection());
        TestScanRange.assertEquals((String)"Checking startLocation", (String)string2, (String)scanRange.getStartLocation());
        TestScanRange.assertEquals((String)"Checking endDirection", (String)string4, (String)scanRange.getEndDirection());
        TestScanRange.assertEquals((String)"Checking endLocation", (String)string5, (String)scanRange.getEndLocation());
        TestScanRange.assertEquals((String)"Checking toString", (String)string7, (String)scanRange.toString());
    }

    public void testScanRangeConstructor_SignedPostiveAndNegativeConstructor() {
        String string = "I";
        String string2 = "12.750";
        String string3 = "-" + string2;
        String string4 = "S";
        String string5 = "602.750";
        String string6 = "+" + string5;
        String string7 = "I12.750-S602.750";
        ScanRange scanRange = new ScanRange(string3, string6);
        TestScanRange.assertEquals((String)"Checking startDirection", (String)string, (String)scanRange.getStartDirection());
        TestScanRange.assertEquals((String)"Checking startLocation", (String)string2, (String)scanRange.getStartLocation());
        TestScanRange.assertEquals((String)"Checking endDirection", (String)string4, (String)scanRange.getEndDirection());
        TestScanRange.assertEquals((String)"Checking endLocation", (String)string5, (String)scanRange.getEndLocation());
        TestScanRange.assertEquals((String)"Checking toString", (String)string7, (String)scanRange.toString());
    }

    public void testScanRangeConstructor_WithAllParameters() {
        String string = "I";
        String string2 = "12.750";
        String string3 = "I";
        String string4 = "602.750";
        String string5 = "I12.750-I602.750";
        ScanRange scanRange = new ScanRange(string, string2, string3, string4);
        TestScanRange.assertEquals((String)"Checking startDirection", (String)string, (String)scanRange.getStartDirection());
        TestScanRange.assertEquals((String)"Checking startLocation", (String)string2, (String)scanRange.getStartLocation());
        TestScanRange.assertEquals((String)"Checking endDirection", (String)string3, (String)scanRange.getEndDirection());
        TestScanRange.assertEquals((String)"Checking endLocation", (String)string4, (String)scanRange.getEndLocation());
        TestScanRange.assertEquals((String)"Checking toString", (String)string5, (String)scanRange.toString());
    }

    public void testScanRangeConstructor_Equality() {
        String string = "I";
        String string2 = "12.750";
        String string3 = "I";
        String string4 = "602.750";
        ScanRange scanRange = new ScanRange(string, string2, string3, string4);
        ScanRange scanRange2 = new ScanRange(string, string2, string3, string4);
        TestScanRange.assertTrue((String)"Checking equality", (boolean)scanRange.equals(scanRange2));
        TestScanRange.assertTrue((String)"Checking hashCode", (scanRange.hashCode() == scanRange2.hashCode() ? 1 : 0) != 0);
    }

    public void testScanRangeConstructor_Inequality() {
        String string = "I";
        String string2 = "12.750";
        String string3 = "I";
        String string4 = "602.750";
        String string5 = "S";
        String string6 = "13.750";
        String string7 = "S";
        ScanRange scanRange = new ScanRange(string, string2, string3, string4);
        String string8 = "603.750";
        TestScanRange.assertTrue((String)"Checking inequality endLocation", (!scanRange.equals(new ScanRange(string, string2, string3, string8)) ? 1 : 0) != 0);
        TestScanRange.assertTrue((String)"Checking inequality endDirection", (!scanRange.equals(new ScanRange(string, string2, string7, string4)) ? 1 : 0) != 0);
        TestScanRange.assertTrue((String)"Checking inequality startLocation", (!scanRange.equals(new ScanRange(string, string6, string3, string4)) ? 1 : 0) != 0);
        TestScanRange.assertTrue((String)"Checking inequality startDirection", (!scanRange.equals(new ScanRange(string5, string2, string3, string4)) ? 1 : 0) != 0);
    }

    public void testScanRange_Range_ZeroI() {
        String string = "I";
        String string2 = "603.750";
        String string3 = "I";
        String string4 = "603.750";
        String string5 = "0.000";
        ScanRange scanRange = new ScanRange(string, string2, string3, string4);
        TestScanRange.assertEquals((String)"Checking getRange Zero I", (String)string5, (String)scanRange.getAbsoluteRange());
    }

    public void testScanRange_Range_ZeroS() {
        String string = "S";
        String string2 = "603.750";
        String string3 = "S";
        String string4 = "603.750";
        String string5 = "0.000";
        ScanRange scanRange = new ScanRange(string, string2, string3, string4);
        TestScanRange.assertEquals((String)"Checking getRange Zero S", (String)string5, (String)scanRange.getAbsoluteRange());
    }

    public void testScanRange_Range_IToS() {
        String string = "I";
        String string2 = "12.750";
        String string3 = "S";
        String string4 = "603.750";
        String string5 = "616.500";
        ScanRange scanRange = new ScanRange(string, string2, string3, string4);
        TestScanRange.assertEquals((String)"Checking getRange I to S", (String)string5, (String)scanRange.getAbsoluteRange());
    }

    public void testScanRange_Range_SToI() {
        String string = "S";
        String string2 = "12.750";
        String string3 = "I";
        String string4 = "603.750";
        String string5 = "616.500";
        ScanRange scanRange = new ScanRange(string, string2, string3, string4);
        TestScanRange.assertEquals((String)"Checking getRange S to I", (String)string5, (String)scanRange.getAbsoluteRange());
    }

    public void testScanRange_Range_SToI_NotPooled() {
        String string = new String("S");
        String string2 = "188.000";
        String string3 = new String("I");
        String string4 = "105.000";
        String string5 = "293.000";
        ScanRange scanRange = new ScanRange(string, string2, string3, string4);
        TestScanRange.assertEquals((String)"Checking getRange S to I not using String literal pool", (String)string5, (String)scanRange.getAbsoluteRange());
    }
}

