/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSequenceAttributeDelimitedString
extends TestCase {
    private NumberFormat decimalFormat = new DecimalFormat("######.###");

    public TestSequenceAttributeDelimitedString(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestSequenceAttributeDelimitedString");
        testSuite.addTest((Test)new TestSequenceAttributeDelimitedString("TestSequenceAttributeDelimitedString_EmptySequence"));
        testSuite.addTest((Test)new TestSequenceAttributeDelimitedString("TestSequenceAttributeDelimitedString_MultipleEmptyItems"));
        testSuite.addTest((Test)new TestSequenceAttributeDelimitedString("TestSequenceAttributeDelimitedString_MultipleItemsWithDefaultValues"));
        testSuite.addTest((Test)new TestSequenceAttributeDelimitedString("TestSequenceAttributeDelimitedString_MultipleItemsWithSpecifiedValues"));
        testSuite.addTest((Test)new TestSequenceAttributeDelimitedString("TestSequenceAttributeDelimitedString_NestedEmptySequence"));
        testSuite.addTest((Test)new TestSequenceAttributeDelimitedString("TestSequenceAttributeDelimitedString_NestedEmptyItems"));
        testSuite.addTest((Test)new TestSequenceAttributeDelimitedString("TestSequenceAttributeDelimitedString_NestedNonEmptyItems"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestSequenceAttributeDelimitedString_EmptySequence() {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.ContributingEquipmentSequence);
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking getDelimitedStringValuesOrDefault()", (String)"<>", (String)sequenceAttribute.getDelimitedStringValuesOrDefault("DEFAULT"));
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking getDelimitedStringValuesOrDefault() with NumberFormat", (String)"<>", (String)((Attribute)sequenceAttribute).getDelimitedStringValuesOrDefault("DEFAULT", this.decimalFormat));
    }

    public void TestSequenceAttributeDelimitedString_MultipleEmptyItems() {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.ContributingEquipmentSequence);
        AttributeList attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking getDelimitedStringValuesOrDefault()", (String)"<{},{},{}>", (String)sequenceAttribute.getDelimitedStringValuesOrDefault("DEFAULT"));
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking getDelimitedStringValuesOrDefault() with NumberFormat", (String)"<{},{},{}>", (String)((Attribute)sequenceAttribute).getDelimitedStringValuesOrDefault("DEFAULT", this.decimalFormat));
    }

    public void TestSequenceAttributeDelimitedString_MultipleItemsWithDefaultValues() {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.ContributingEquipmentSequence);
        AttributeList attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        StringAttribute stringAttribute = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put(stringAttribute);
        stringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
        attributeList.put(stringAttribute);
        stringAttribute = new DecimalStringAttribute(TagFromName.PixelSpacing);
        attributeList.put(stringAttribute);
        attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        stringAttribute = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put(stringAttribute);
        attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        stringAttribute = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put(stringAttribute);
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking getDelimitedStringValuesOrDefault()", (String)"<{DEFAULT,DEFAULT,DEFAULT},{DEFAULT},{DEFAULT}>", (String)sequenceAttribute.getDelimitedStringValuesOrDefault("DEFAULT"));
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking getDelimitedStringValuesOrDefault() with NumberFormat", (String)"<{DEFAULT,DEFAULT,DEFAULT},{DEFAULT},{DEFAULT}>", (String)((Attribute)sequenceAttribute).getDelimitedStringValuesOrDefault("DEFAULT", this.decimalFormat));
    }

    public void TestSequenceAttributeDelimitedString_MultipleItemsWithSpecifiedValues() throws DicomException {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.ContributingEquipmentSequence);
        AttributeList attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        StringAttribute stringAttribute = new LongStringAttribute(TagFromName.Manufacturer);
        ((Attribute)stringAttribute).addValue("Acme Devices");
        attributeList.put(stringAttribute);
        stringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)stringAttribute).addValue("39");
        attributeList.put(stringAttribute);
        stringAttribute = new DecimalStringAttribute(TagFromName.PixelSpacing);
        ((Attribute)stringAttribute).addValue("0.793456789");
        ((Attribute)stringAttribute).addValue("0.793456789");
        attributeList.put(stringAttribute);
        attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        stringAttribute = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put(stringAttribute);
        attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        stringAttribute = new LongStringAttribute(TagFromName.Manufacturer);
        ((Attribute)stringAttribute).addValue("Acme Devices");
        attributeList.put(stringAttribute);
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking getDelimitedStringValuesOrDefault()", (String)"<{Acme Devices,39,0.793456789\\0.793456789},{DEFAULT},{Acme Devices}>", (String)sequenceAttribute.getDelimitedStringValuesOrDefault("DEFAULT"));
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking getDelimitedStringValuesOrDefault() with NumberFormat", (String)"<{Acme Devices,39,0.793\\0.793},{DEFAULT},{Acme Devices}>", (String)((Attribute)sequenceAttribute).getDelimitedStringValuesOrDefault("DEFAULT", this.decimalFormat));
    }

    public void TestSequenceAttributeDelimitedString_NestedEmptySequence() throws DicomException {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.ContributingEquipmentSequence);
        AttributeList attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        Attribute attribute = new LongStringAttribute(TagFromName.Manufacturer);
        attribute.addValue("Acme Devices");
        attributeList.put(attribute);
        attribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
        attribute.addValue("39");
        attributeList.put(attribute);
        attribute = new DecimalStringAttribute(TagFromName.PixelSpacing);
        attribute.addValue("0.793456789");
        attribute.addValue("0.793456789");
        attributeList.put(attribute);
        attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        attribute = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put(attribute);
        attribute = new SequenceAttribute(TagFromName.OriginalAttributesSequence);
        attributeList.put(attribute);
        attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        attribute = new LongStringAttribute(TagFromName.Manufacturer);
        attribute.addValue("Acme Devices");
        attributeList.put(attribute);
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking getDelimitedStringValuesOrDefault()", (String)"<{Acme Devices,39,0.793456789\\0.793456789},{DEFAULT,<>},{Acme Devices}>", (String)sequenceAttribute.getDelimitedStringValuesOrDefault("DEFAULT"));
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking getDelimitedStringValuesOrDefault() with NumberFormat", (String)"<{Acme Devices,39,0.793\\0.793},{DEFAULT,<>},{Acme Devices}>", (String)((Attribute)sequenceAttribute).getDelimitedStringValuesOrDefault("DEFAULT", this.decimalFormat));
    }

    public void TestSequenceAttributeDelimitedString_NestedEmptyItems() throws DicomException {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.ContributingEquipmentSequence);
        AttributeList attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        Attribute attribute = new LongStringAttribute(TagFromName.Manufacturer);
        attribute.addValue("Acme Devices");
        attributeList.put(attribute);
        attribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
        attribute.addValue("39");
        attributeList.put(attribute);
        attribute = new DecimalStringAttribute(TagFromName.PixelSpacing);
        attribute.addValue("0.793456789");
        attribute.addValue("0.793456789");
        attributeList.put(attribute);
        attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        attribute = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put(attribute);
        attribute = new SequenceAttribute(TagFromName.OriginalAttributesSequence);
        attributeList.put(attribute);
        AttributeList attributeList2 = new AttributeList();
        ((SequenceAttribute)attribute).addItem(attributeList2);
        attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        attribute = new LongStringAttribute(TagFromName.Manufacturer);
        attribute.addValue("Acme Devices");
        attributeList.put(attribute);
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking getDelimitedStringValuesOrDefault()", (String)"<{Acme Devices,39,0.793456789\\0.793456789},{DEFAULT,<{}>},{Acme Devices}>", (String)sequenceAttribute.getDelimitedStringValuesOrDefault("DEFAULT"));
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking getDelimitedStringValuesOrDefault() with NumberFormat", (String)"<{Acme Devices,39,0.793\\0.793},{DEFAULT,<{}>},{Acme Devices}>", (String)((Attribute)sequenceAttribute).getDelimitedStringValuesOrDefault("DEFAULT", this.decimalFormat));
    }

    public void TestSequenceAttributeDelimitedString_NestedNonEmptyItems() throws DicomException {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.ContributingEquipmentSequence);
        AttributeList attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        Attribute attribute = new LongStringAttribute(TagFromName.Manufacturer);
        attribute.addValue("Acme Devices");
        attributeList.put(attribute);
        attribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
        attribute.addValue("39");
        attributeList.put(attribute);
        attribute = new DecimalStringAttribute(TagFromName.PixelSpacing);
        attribute.addValue("0.793456789");
        attribute.addValue("0.793456789");
        attributeList.put(attribute);
        attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        attribute = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put(attribute);
        attribute = new SequenceAttribute(TagFromName.OriginalAttributesSequence);
        attributeList.put(attribute);
        AttributeList attributeList2 = new AttributeList();
        ((SequenceAttribute)attribute).addItem(attributeList2);
        PersonNameAttribute personNameAttribute = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)personNameAttribute).addValue("Smith^Jane");
        attributeList2.put(personNameAttribute);
        attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        attribute = new LongStringAttribute(TagFromName.Manufacturer);
        attribute.addValue("Acme Devices");
        attributeList.put(attribute);
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking getDelimitedStringValuesOrDefault()", (String)"<{Acme Devices,39,0.793456789\\0.793456789},{DEFAULT,<{Smith^Jane}>},{Acme Devices}>", (String)sequenceAttribute.getDelimitedStringValuesOrDefault("DEFAULT"));
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking getDelimitedStringValuesOrDefault() with NumberFormat", (String)"<{Acme Devices,39,0.793\\0.793},{DEFAULT,<{Smith^Jane}>},{Acme Devices}>", (String)((Attribute)sequenceAttribute).getDelimitedStringValuesOrDefault("DEFAULT", this.decimalFormat));
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking static getDelimitedStringValuesOrDefault()", (String)"<{Acme Devices,39,0.793456789\\0.793456789},{DEFAULT,<{Smith^Jane}>},{Acme Devices}>", (String)Attribute.getDelimitedStringValuesOrDefault(sequenceAttribute, "DEFAULT"));
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking static getDelimitedStringValuesOrDefault() with NumberFormat", (String)"<{Acme Devices,39,0.793\\0.793},{DEFAULT,<{Smith^Jane}>},{Acme Devices}>", (String)Attribute.getDelimitedStringValuesOrDefault(sequenceAttribute, "DEFAULT", this.decimalFormat));
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking getDelimitedStringValuesOrEmptyString()", (String)"<{Acme Devices,39,0.793456789\\0.793456789},{,<{Smith^Jane}>},{Acme Devices}>", (String)sequenceAttribute.getDelimitedStringValuesOrEmptyString());
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking getDelimitedStringValuesOrEmptyString() with NumberFormat", (String)"<{Acme Devices,39,0.793\\0.793},{,<{Smith^Jane}>},{Acme Devices}>", (String)sequenceAttribute.getDelimitedStringValuesOrEmptyString(this.decimalFormat));
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking static getDelimitedStringValuesOrEmptyString()", (String)"<{Acme Devices,39,0.793456789\\0.793456789},{,<{Smith^Jane}>},{Acme Devices}>", (String)Attribute.getDelimitedStringValuesOrEmptyString(sequenceAttribute));
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking static getDelimitedStringValuesOrEmptyString() with NumberFormat", (String)"<{Acme Devices,39,0.793\\0.793},{,<{Smith^Jane}>},{Acme Devices}>", (String)Attribute.getDelimitedStringValuesOrEmptyString(sequenceAttribute, this.decimalFormat));
        attributeList = new AttributeList();
        attributeList.put(sequenceAttribute);
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking static list getDelimitedStringValuesOrDefault()", (String)"<{Acme Devices,39,0.793456789\\0.793456789},{DEFAULT,<{Smith^Jane}>},{Acme Devices}>", (String)Attribute.getDelimitedStringValuesOrDefault(attributeList, TagFromName.ContributingEquipmentSequence, "DEFAULT"));
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking static list getDelimitedStringValuesOrDefault() with NumberFormat", (String)"<{Acme Devices,39,0.793\\0.793},{DEFAULT,<{Smith^Jane}>},{Acme Devices}>", (String)Attribute.getDelimitedStringValuesOrDefault(attributeList, TagFromName.ContributingEquipmentSequence, "DEFAULT", this.decimalFormat));
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking static list getDelimitedStringValuesOrDefault()", (String)"<{Acme Devices,39,0.793456789\\0.793456789},{DEFAULT,<{Smith^Jane}>},{Acme Devices}>", (String)Attribute.getDelimitedStringValuesOrDefault(attributeList, TagFromName.ContributingEquipmentSequence, "DEFAULT"));
        TestSequenceAttributeDelimitedString.assertEquals((String)"Checking static list getDelimitedStringValuesOrDefault() with NumberFormat", (String)"<{Acme Devices,39,0.793\\0.793},{DEFAULT,<{Smith^Jane}>},{Acme Devices}>", (String)Attribute.getDelimitedStringValuesOrDefault(attributeList, TagFromName.ContributingEquipmentSequence, "DEFAULT", this.decimalFormat));
    }
}

