/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.ContentItemWithReference;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.XMLRepresentationOfStructuredReportObjectFactory;
import java.util.Locale;
import java.util.TreeMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.w3c.dom.Document;

public class TestStructuredReport_XMLRepresentation
extends TestCase {
    private static String deviceUID = "1.2.3.4";
    private static String deviceName = "station1";
    private static String manufacturer = "Acme";
    private static String modelName = "Scanner";
    private static String serialNumber = "72349236741";
    private static String location = "Suite1";
    private static String operatorName = "Smith^John";
    private static String operatorID = "26354781234";
    private static String physicianName = "Jones^Mary";
    private static String physicianID = "23491234234";
    private static String idIssuer = "99BLA";
    private static String organization = "St. Elsewhere's";
    private static String patientName = "Smith^Mary";
    private static String patientID = "3764913624";
    private static String patientBirthDate = "19600101";
    private static String patientAge = "041Y";
    private static String patientWeight = "68";
    private static String patientSize = "1.55";
    private static String patientSex = "F";
    private static String studyID = "612386812";
    private static String seriesNumber = "12";
    private static String instanceNumber = "38";
    private static String referringPhysicianName = "Jones^Harriet";
    private static String studyDate = "20010203";
    private static String studyTime = "043000";
    private static String sopInstanceUID;
    private static String seriesInstanceUID;
    private static String studyInstanceUID;

    public TestStructuredReport_XMLRepresentation(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestStructuredReport_XMLRepresentation");
        testSuite.addTest((Test)new TestStructuredReport_XMLRepresentation("testStructuredReport_XMLRepresentation_WithReferences"));
        testSuite.addTest((Test)new TestStructuredReport_XMLRepresentation("testStructuredReport_XMLRepresentation_WithObservationDateTimeAndUID"));
        return testSuite;
    }

    protected static AttributeList getDefaultAttributeList() throws DicomException {
        Locale.setDefault(Locale.FRENCH);
        AttributeList attributeList = new AttributeList();
        UIDGenerator uIDGenerator = new UIDGenerator("9999");
        sopInstanceUID = uIDGenerator.getNewSOPInstanceUID(studyID, seriesNumber, instanceNumber);
        seriesInstanceUID = uIDGenerator.getNewSeriesInstanceUID(studyID, seriesNumber);
        studyInstanceUID = uIDGenerator.getNewStudyInstanceUID(studyID);
        StringAttribute stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)stringAttribute).addValue(sopInstanceUID);
        attributeList.put(stringAttribute);
        stringAttribute = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)stringAttribute).addValue(seriesInstanceUID);
        attributeList.put(stringAttribute);
        stringAttribute = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)stringAttribute).addValue(studyInstanceUID);
        attributeList.put(stringAttribute);
        stringAttribute = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)stringAttribute).addValue(patientName);
        attributeList.put(stringAttribute);
        stringAttribute = new LongStringAttribute(TagFromName.PatientID);
        ((Attribute)stringAttribute).addValue(patientID);
        attributeList.put(stringAttribute);
        stringAttribute = new DateAttribute(TagFromName.PatientBirthDate);
        ((Attribute)stringAttribute).addValue(patientBirthDate);
        attributeList.put(stringAttribute);
        stringAttribute = new AgeStringAttribute(TagFromName.PatientAge);
        ((Attribute)stringAttribute).addValue(patientAge);
        attributeList.put(stringAttribute);
        stringAttribute = new CodeStringAttribute(TagFromName.PatientSex);
        ((Attribute)stringAttribute).addValue(patientSex);
        attributeList.put(stringAttribute);
        stringAttribute = new DecimalStringAttribute(TagFromName.PatientWeight);
        ((Attribute)stringAttribute).addValue(patientWeight);
        attributeList.put(stringAttribute);
        stringAttribute = new DecimalStringAttribute(TagFromName.PatientSize);
        ((Attribute)stringAttribute).addValue(patientSize);
        attributeList.put(stringAttribute);
        stringAttribute = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)stringAttribute).addValue(studyID);
        attributeList.put(stringAttribute);
        stringAttribute = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
        ((Attribute)stringAttribute).addValue(referringPhysicianName);
        attributeList.put(stringAttribute);
        stringAttribute = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)stringAttribute).addValue(seriesNumber);
        attributeList.put(stringAttribute);
        stringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)stringAttribute).addValue(instanceNumber);
        attributeList.put(stringAttribute);
        stringAttribute = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put(stringAttribute);
        stringAttribute = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)stringAttribute).addValue(studyDate);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.StudyTime);
        ((Attribute)stringAttribute).addValue(studyTime);
        attributeList.put(stringAttribute);
        return attributeList;
    }

    protected void tearDown() {
    }

    public void testStructuredReport_XMLRepresentation_WithReferences() throws Exception {
        ContentItemFactory contentItemFactory;
        ContentItemFactory contentItemFactory2 = contentItemFactory = new ContentItemFactory();
        contentItemFactory2.getClass();
        ContentItemFactory.ContainerContentItem containerContentItem = contentItemFactory2.new ContentItemFactory.ContainerContentItem(null, null, new CodedSequenceItem("111036", "DCM", "Mammography CAD Report"), true, "DCMR", "5000");
        ContentItemFactory contentItemFactory3 = contentItemFactory;
        contentItemFactory3.getClass();
        ContentItemFactory.ContainerContentItem containerContentItem2 = contentItemFactory3.new ContentItemFactory.ContainerContentItem(containerContentItem, "CONTAINS", new CodedSequenceItem("111028", "DCM", "Image Library"), true);
        ContentItemFactory contentItemFactory4 = contentItemFactory;
        contentItemFactory4.getClass();
        ContentItemFactory.ImageContentItem imageContentItem = contentItemFactory4.new ContentItemFactory.ImageContentItem(containerContentItem2, "CONTAINS", null, "1.2.840.10008.5.1.4.1.1.1.2", "1.3.6.1.4.1.5962.99.1.993064428.2122236180.1358202762732.2.0", 0, 0, null, null, null, null);
        ContentItemFactory contentItemFactory5 = contentItemFactory;
        contentItemFactory5.getClass();
        ContentItemFactory.CodeContentItem codeContentItem = contentItemFactory5.new ContentItemFactory.CodeContentItem(containerContentItem, "CONTAINS", new CodedSequenceItem("111017", "DCM", "CAD Processing and Findings Summary"), new CodedSequenceItem("111242", "DCM", "All algorithms succeeded; with findings"));
        ContentItemFactory contentItemFactory6 = contentItemFactory;
        contentItemFactory6.getClass();
        Object object = contentItemFactory6.new ContentItemFactory.ContainerContentItem(codeContentItem, "CONTAINS", new CodedSequenceItem("111034", "DCM", "Individual Impression/Recommendation"), true);
        ContentItemFactory contentItemFactory7 = contentItemFactory;
        contentItemFactory7.getClass();
        contentItemFactory7.new ContentItemFactory.CodeContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("111056", "DCM", "Rendering Intent"), new CodedSequenceItem("111150", "DCM", "Presentation Required: Rendering device is expected to present"));
        ContentItemFactory contentItemFactory8 = contentItemFactory;
        contentItemFactory8.getClass();
        Object object2 = contentItemFactory8.new ContentItemFactory.CodeContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("111059", "DCM", "Single Image Finding"), new CodedSequenceItem("F-01775", "SRT", "Calcification Cluster"));
        ContentItemFactory contentItemFactory9 = contentItemFactory;
        contentItemFactory9.getClass();
        contentItemFactory9.new ContentItemFactory.CodeContentItem((ContentItem)object2, "HAS CONCEPT MOD", new CodedSequenceItem("111056", "DCM", "Rendering Intent"), new CodedSequenceItem("111150", "DCM", "Presentation Required: Rendering device is expected to present"));
        ContentItemFactory contentItemFactory10 = contentItemFactory;
        contentItemFactory10.getClass();
        Object object3 = contentItemFactory10.new ContentItemFactory.SpatialCoordinatesContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("111010", "DCM", "Center"), "POINT", new float[]{165.0f, 2433.0f});
        new ContentItemWithReference((ContentItem)object3, "SELECTED FROM", "1.1.1");
        ContentItemFactory contentItemFactory11 = contentItemFactory;
        contentItemFactory11.getClass();
        contentItemFactory11.new ContentItemFactory.NumericContentItem((ContentItem)object2, "HAS PROPERTIES", new CodedSequenceItem("111038", "DCM", "Number of calcifications"), 10.0, new CodedSequenceItem("111150", "1", "no units"));
        ContentItemFactory contentItemFactory12 = contentItemFactory;
        contentItemFactory12.getClass();
        Object object4 = contentItemFactory12.new ContentItemFactory.CodeContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("111059", "DCM", "Single Image Finding"), new CodedSequenceItem("F-01776", "SRT", "Individual Calcification"));
        ContentItemFactory contentItemFactory13 = contentItemFactory;
        contentItemFactory13.getClass();
        contentItemFactory13.new ContentItemFactory.CodeContentItem((ContentItem)object4, "HAS CONCEPT MOD", new CodedSequenceItem("111056", "DCM", "Rendering Intent"), new CodedSequenceItem("111150", "DCM", "Presentation Required: Rendering device is expected to present"));
        ContentItemFactory contentItemFactory14 = contentItemFactory;
        contentItemFactory14.getClass();
        ContentItemFactory.SpatialCoordinatesContentItem spatialCoordinatesContentItem = contentItemFactory14.new ContentItemFactory.SpatialCoordinatesContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("111010", "DCM", "Center"), "POINT", new float[]{198.0f, 2389.0f});
        new ContentItemWithReference(spatialCoordinatesContentItem, "SELECTED FROM", "1.1.1");
        ContentItemFactory contentItemFactory15 = contentItemFactory;
        contentItemFactory15.getClass();
        ContentItemFactory.SpatialCoordinatesContentItem spatialCoordinatesContentItem2 = contentItemFactory15.new ContentItemFactory.SpatialCoordinatesContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("111041", "DCM", "Outline"), "POLYLINE", new float[]{199.0f, 2388.0f, 198.0f, 2388.0f, 197.0f, 2388.0f, 197.0f, 2389.0f, 197.0f, 2390.0f, 198.0f, 2390.0f, 199.0f, 2390.0f, 200.0f, 2390.0f, 200.0f, 2389.0f});
        new ContentItemWithReference(spatialCoordinatesContentItem2, "SELECTED FROM", "1.1.1");
        object = new StructuredReport(containerContentItem);
        object2 = ((StructuredReport)object).getAttributeList();
        ((TreeMap)object2).putAll(TestStructuredReport_XMLRepresentation.getDefaultAttributeList());
        object3 = new XMLRepresentationOfStructuredReportObjectFactory().getDocument((AttributeList)object2);
        object4 = new XMLRepresentationOfStructuredReportObjectFactory().getAttributeList((Document)object3);
        TestStructuredReport_XMLRepresentation.assertEquals((String)"Checking round trip AttributeList", (Object)object2, (Object)object4);
    }

    public void testStructuredReport_XMLRepresentation_WithObservationDateTimeAndUID() throws Exception {
        ContentItemFactory contentItemFactory;
        String string = "20181021030405";
        String string2 = "1.2.3.4";
        String string3 = "20181021050607";
        String string4 = "2.3.4.5";
        ContentItemFactory contentItemFactory2 = contentItemFactory = new ContentItemFactory();
        contentItemFactory2.getClass();
        ContentItemFactory.ContainerContentItem containerContentItem = contentItemFactory2.new ContentItemFactory.ContainerContentItem(null, null, new CodedSequenceItem("111036", "DCM", "Mammography CAD Report"), true, "DCMR", "5000", string, string2);
        ContentItemFactory contentItemFactory3 = contentItemFactory;
        contentItemFactory3.getClass();
        ContentItemFactory.CodeContentItem codeContentItem = contentItemFactory3.new ContentItemFactory.CodeContentItem(containerContentItem, "CONTAINS", new CodedSequenceItem("111017", "DCM", "CAD Processing and Findings Summary"), new CodedSequenceItem("111242", "DCM", "All algorithms succeeded; with findings"));
        ContentItemFactory contentItemFactory4 = contentItemFactory;
        contentItemFactory4.getClass();
        Object object = contentItemFactory4.new ContentItemFactory.ContainerContentItem(codeContentItem, "CONTAINS", new CodedSequenceItem("111034", "DCM", "Individual Impression/Recommendation"), true);
        ContentItemFactory contentItemFactory5 = contentItemFactory;
        contentItemFactory5.getClass();
        contentItemFactory5.new ContentItemFactory.CodeContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("111056", "DCM", "Rendering Intent"), new CodedSequenceItem("111150", "DCM", "Presentation Required: Rendering device is expected to present"), string3, string4);
        object = new StructuredReport(containerContentItem);
        AttributeList attributeList = ((StructuredReport)object).getAttributeList();
        attributeList.putAll(TestStructuredReport_XMLRepresentation.getDefaultAttributeList());
        Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(attributeList);
        AttributeList attributeList2 = new XMLRepresentationOfStructuredReportObjectFactory().getAttributeList(document);
        TestStructuredReport_XMLRepresentation.assertEquals((String)"Checking round trip AttributeList", (Object)attributeList, (Object)attributeList2);
    }
}

