/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.TagFromName;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSuitableCharacterSet
extends TestCase {
    public TestSuitableCharacterSet(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestSuitableCharacterSet");
        testSuite.addTest((Test)new TestSuitableCharacterSet("TestSuitableCharacterSet_PersonName_ASCII"));
        testSuite.addTest((Test)new TestSuitableCharacterSet("TestSuitableCharacterSet_PersonName_IR100"));
        testSuite.addTest((Test)new TestSuitableCharacterSet("TestSuitableCharacterSet_PersonName_IR192_TriggeredByHebrew"));
        testSuite.addTest((Test)new TestSuitableCharacterSet("TestSuitableCharacterSet_PersonName_IR192_TriggeredByJapanese"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testPersonNameValues(String string, String string2, String string3) throws Exception {
        SpecificCharacterSet specificCharacterSet = new SpecificCharacterSet(new String[]{string});
        TestSuitableCharacterSet.assertEquals((String)"Checking supplied getValueToUseInSpecificCharacterSetAttribute()", (String)string, (String)specificCharacterSet.getValueToUseInSpecificCharacterSetAttribute());
        PersonNameAttribute personNameAttribute = new PersonNameAttribute(TagFromName.PersonName, specificCharacterSet);
        personNameAttribute.addValue(string2);
        personNameAttribute.addValue(string3);
        AttributeList attributeList = new AttributeList();
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.ContentSequence);
        attributeList.put(sequenceAttribute);
        Object object = new AttributeList();
        sequenceAttribute.addItem((AttributeList)object);
        AttributeList attributeList2 = new AttributeList();
        sequenceAttribute.addItem(attributeList2);
        attributeList2.put(personNameAttribute);
        object = new SpecificCharacterSet(attributeList);
        TestSuitableCharacterSet.assertEquals((String)"Checking needed getValueToUseInSpecificCharacterSetAttribute()", (String)string, (String)((SpecificCharacterSet)object).getValueToUseInSpecificCharacterSetAttribute());
    }

    public void TestSuitableCharacterSet_PersonName_ASCII() throws Exception {
        this.testPersonNameValues("", "Aneas^Rudiger", "Buc^Jerome");
    }

    public void TestSuitableCharacterSet_PersonName_IR100() throws Exception {
        this.testPersonNameValues("ISO_IR 100", "\u00c4neas^R\u00fcdiger", "Buc^J\u00e9r\u00f4me");
    }

    public void TestSuitableCharacterSet_PersonName_IR192_TriggeredByHebrew() throws Exception {
        this.testPersonNameValues("ISO_IR 192", "\u05e9\u05c1\u05b8\u05e8\u05d5\u05b9\u05df^\u05d3\u05bc\u05b0\u05d1\u05d5\u05b9\u05e8\u05b8\u05d4", "Sharon^Deborah");
    }

    public void TestSuitableCharacterSet_PersonName_IR192_TriggeredByJapanese() throws Exception {
        this.testPersonNameValues("ISO_IR 192", "\u9ed2\u6fa4^\u660e", "Kurosawa^Akira");
    }
}

