/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.utils.UUIDBasedOID;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestUUIDBasedOID
extends TestCase {
    public TestUUIDBasedOID(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestUUIDBasedOID");
        testSuite.addTest((Test)new TestUUIDBasedOID("TestUUIDBasedOID_parseUUIDFromOID"));
        testSuite.addTest((Test)new TestUUIDBasedOID("TestUUIDBasedOID_OIDConstructor"));
        testSuite.addTest((Test)new TestUUIDBasedOID("TestUUIDBasedOID_createOIDFromUUIDCanonicalHexString"));
        testSuite.addTest((Test)new TestUUIDBasedOID("TestUUIDBasedOID_roundTripFromUUID_Test1"));
        testSuite.addTest((Test)new TestUUIDBasedOID("TestUUIDBasedOID_roundTripFromUUID_Test2"));
        testSuite.addTest((Test)new TestUUIDBasedOID("TestUUIDBasedOID_getByteArrayInNetworkByteOrderFromUUID"));
        testSuite.addTest((Test)new TestUUIDBasedOID("TestUUIDBasedOID_Deterministic"));
        testSuite.addTest((Test)new TestUUIDBasedOID("TestUUIDBasedOID_Uniqueness"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestUUIDBasedOID_parseUUIDFromOID() throws Exception {
        String string = "2.25.329800735698586629295641978511506172918";
        String string2 = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6";
        UUID uUID = UUIDBasedOID.parseUUIDFromOID(string);
        UUID uUID2 = UUID.fromString(string2);
        TestUUIDBasedOID.assertEquals((String)"Checking parsing UUID from OID via static method", (Object)uUID2, (Object)uUID);
    }

    public void TestUUIDBasedOID_OIDConstructor() throws Exception {
        String string = "2.25.329800735698586629295641978511506172918";
        String string2 = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6";
        UUIDBasedOID uUIDBasedOID = new UUIDBasedOID(string);
        UUID uUID = uUIDBasedOID.getUUID();
        UUID uUID2 = UUID.fromString(string2);
        TestUUIDBasedOID.assertEquals((String)"Checking parsing UUID from OID via constructor", (Object)uUID2, (Object)uUID);
        String string3 = uUIDBasedOID.getOID();
        TestUUIDBasedOID.assertEquals((String)"Checking round trip from string constructor of OID", (String)string, (String)string3);
    }

    public void TestUUIDBasedOID_createOIDFromUUIDCanonicalHexString() throws Exception {
        String string = "2.25.329800735698586629295641978511506172918";
        String string2 = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6";
        String string3 = UUIDBasedOID.createOIDFromUUIDCanonicalHexString(string2);
        TestUUIDBasedOID.assertEquals((String)"Checking creating OID given UUID via static method", (String)string, (String)string3);
    }

    public void TestUUIDBasedOID_roundTripFromUUID_Test1() throws Exception {
        String string = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6";
        String string2 = UUIDBasedOID.createOIDFromUUIDCanonicalHexString(string);
        String string3 = UUIDBasedOID.parseUUIDFromOID(string2).toString();
        TestUUIDBasedOID.assertEquals((String)"Checking round trip given UUID", (String)string, (String)string3);
    }

    public void TestUUIDBasedOID_roundTripFromUUID_Test2() throws Exception {
        String string = "0b7827e3-35f0-46c0-a2e9-eaf4dadc899b";
        String string2 = UUIDBasedOID.createOIDFromUUIDCanonicalHexString(string);
        String string3 = UUIDBasedOID.parseUUIDFromOID(string2).toString();
        TestUUIDBasedOID.assertEquals((String)"Checking round trip given UUID", (String)string, (String)string3);
    }

    public void TestUUIDBasedOID_getByteArrayInNetworkByteOrderFromUUID() throws Exception {
        UUID uUID = new UUID(-4822678189205112L, 8603657889541918976L);
        byte[] byArray = new byte[]{-1, -18, -35, -52, -69, -86, -103, -120, 119, 102, 85, 68, 51, 34, 17, 0};
        byte[] byArray2 = UUIDBasedOID.getByteArrayInNetworkByteOrderFromUUID(uUID);
        TestUUIDBasedOID.assertTrue((String)"Checking getByteArrayInNetworkByteOrderFromUUID() ", (boolean)Arrays.equals(byArray, byArray2));
    }

    public void TestUUIDBasedOID_Deterministic() throws Exception {
        String string = "Hello World";
        byte[] byArray = string.getBytes("UTF8");
        UUID uUID = UUID.randomUUID();
        UUIDBasedOID uUIDBasedOID = new UUIDBasedOID(uUID, byArray);
        UUIDBasedOID uUIDBasedOID2 = new UUIDBasedOID(uUID, byArray);
        TestUUIDBasedOID.assertEquals((String)"Checking Type 3 UUID hash based OID is deterministic ", (String)uUIDBasedOID.getOID(), (String)uUIDBasedOID2.getOID());
    }

    public void TestUUIDBasedOID_Uniqueness() throws Exception {
        int n = 1000;
        boolean bl = true;
        boolean bl2 = true;
        HashSet hashSet = new HashSet();
        for (int i = 0; i < n; ++i) {
            UUIDBasedOID uUIDBasedOID = new UUIDBasedOID();
            String string = uUIDBasedOID.getOID();
            int n2 = string.length();
            if (hashSet.contains(string)) {
                System.err.println("Error - not unique - \"" + string + "\"");
                bl = false;
            }
            if (n2 <= 64) continue;
            System.err.println("Error - too long - \"" + string + "\" (length = " + n2 + ")");
            bl2 = false;
        }
        TestUUIDBasedOID.assertTrue((String)"Were all unique", (boolean)bl);
        TestUUIDBasedOID.assertTrue((String)"Were all within length limit", (boolean)bl2);
    }
}

