/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.transfermonitor;

import com.pixelmed.transfermonitor.TransferMonitor;
import com.pixelmed.transfermonitor.TransferMonitoringContext;
import java.io.IOException;
import java.io.InputStream;

public class MonitoredInputStream
extends InputStream {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/transfermonitor/MonitoredInputStream.java,v 1.11 2025/01/29 10:58:09 dclunie Exp $";
    private InputStream in;
    private TransferMonitor monitor;

    public MonitoredInputStream(InputStream inputStream, TransferMonitoringContext transferMonitoringContext) {
        this.in = inputStream;
        this.monitor = TransferMonitor.newTransferMonitor(transferMonitoringContext);
    }

    @Override
    public final int read() throws IOException {
        int n = this.in.read();
        if (n >= 0) {
            this.monitor.countUp(1);
        }
        return n;
    }

    @Override
    public final int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        if (n > 0) {
            this.monitor.countUp(n);
        }
        return n;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 > 0) {
            this.monitor.countUp(n3);
        }
        return n3;
    }

    @Override
    public final long skip(long l) throws IOException {
        long l2 = this.in.skip(l);
        if (l2 > 0L) {
            this.monitor.countUp(l2);
        }
        return l2;
    }

    @Override
    public final int available() throws IOException {
        return this.in.available();
    }

    @Override
    public final void close() throws IOException {
        this.in.close();
    }

    @Override
    public final void mark(int n) {
        this.in.mark(n);
    }

    @Override
    public final boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public final void reset() throws IOException {
        this.in.reset();
    }
}

