/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.transfermonitor;

import com.pixelmed.transfermonitor.TransferMonitor;
import com.pixelmed.transfermonitor.TransferMonitoringContext;
import java.io.IOException;
import java.io.OutputStream;

public class MonitoredOutputStream
extends OutputStream {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/transfermonitor/MonitoredOutputStream.java,v 1.12 2025/01/29 10:58:09 dclunie Exp $";
    private OutputStream out;
    private TransferMonitor monitor;

    public MonitoredOutputStream(OutputStream outputStream, TransferMonitoringContext transferMonitoringContext) {
        this.out = outputStream;
        this.monitor = TransferMonitor.newTransferMonitor(transferMonitoringContext);
    }

    @Override
    public final void close() throws IOException {
        this.out.close();
    }

    @Override
    public final void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public final void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
        this.monitor.countUp(byArray.length);
    }

    @Override
    public final void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.monitor.countUp(n2);
    }

    @Override
    public final void write(int n) throws IOException {
        this.out.write(n);
        this.monitor.countUp(1);
    }
}

