/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.utils;

import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.CopyStream;
import com.pixelmed.utils.HexDump;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.rmi.server.UID;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class FileUtilities {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/utils/FileUtilities.java,v 1.33 2025/01/29 10:58:09 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(FileUtilities.class);

    private FileUtilities() {
    }

    public static final void renameElseCopyTo(File file, File file2) throws IOException {
        if (!file.renameTo(file2)) {
            CopyStream.copy(file, file2);
        }
    }

    public static final ArrayList<File> listFilesRecursively(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file != null && file.exists()) {
            if (file.isFile()) {
                arrayList.add(file);
            } else if (file.isDirectory()) {
                try {
                    File[] fileArray = file.listFiles((FilenameFilter)null);
                    if (fileArray != null && fileArray.length > 0) {
                        for (int i = 0; i < fileArray.length; ++i) {
                            if (fileArray[i].isDirectory()) {
                                ArrayList<File> arrayList2 = FileUtilities.listFilesRecursively(fileArray[i]);
                                if (arrayList2 == null || arrayList2.isEmpty()) continue;
                                arrayList.addAll(arrayList2);
                                continue;
                            }
                            if (!fileArray[i].isFile()) continue;
                            arrayList.add(fileArray[i]);
                        }
                    }
                }
                catch (SecurityException securityException) {
                    slf4jlogger.error("", securityException);
                }
            }
        }
        return arrayList;
    }

    public static final ArrayList<String> getCanonicalFileNames(ArrayList<File> arrayList) throws IOException {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (File file : arrayList) {
            arrayList2.add(file.getCanonicalPath());
        }
        return arrayList2;
    }

    public static final String readFile(Reader reader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        while ((n = reader.read(cArray)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    public static final String readFile(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return FileUtilities.readFile(bufferedReader);
    }

    public static final String readFile(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        return FileUtilities.readFile(fileReader);
    }

    public static final String readFile(String string) throws IOException {
        return FileUtilities.readFile(new File(string));
    }

    public static byte[] readAllBytes(InputStream inputStream) throws IOException {
        byte[] byArray = null;
        int n = 32768;
        byte[] byArray2 = new byte[n];
        try {
            int n2;
            boolean bl = true;
            while ((n2 = inputStream.read(byArray2, 0, n)) > 0) {
                if (byArray == null) {
                    byArray = new byte[n2];
                    System.arraycopy(byArray2, 0, byArray, 0, n2);
                    continue;
                }
                byte[] byArray3 = new byte[byArray.length + n2];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(byArray2, 0, byArray3, byArray.length, n2);
                byArray = byArray3;
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            inputStream.close();
        }
        return byArray;
    }

    public static final File getFileFromNameInsensitiveToCaseIfNecessary(String string) throws FileNotFoundException {
        File file = new File(string);
        if (!(file.exists() || (file = new File(string.toLowerCase(Locale.US))).exists() || (file = new File(string.toUpperCase(Locale.US))).exists())) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = null;
            for (file = new File(string).getAbsoluteFile(); file != null && (string2 = file.getName()) != null && string2.length() > 0; file = file.getParentFile()) {
                arrayList.add(string2);
            }
            File[] fileArray = File.listRoots();
            if (fileArray != null) {
                file = null;
                for (int i = 0; file == null && i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    for (int j = arrayList.size() - 1; j >= 0; --j) {
                        string2 = (String)arrayList.get(j);
                        file = new File(file2, string2);
                        if (!(file.exists() || (file = new File(file2, string2.toLowerCase(Locale.US))).exists() || (file = new File(file2, string2.toUpperCase(Locale.US))).exists())) {
                            file = null;
                        }
                        file2 = file;
                    }
                }
                if (file == null) {
                    throw new FileNotFoundException(string + "(No such file or lower or upper case variants)");
                }
            }
        }
        return file;
    }

    public static final String makeTemporaryFileName() {
        String string = new UID().toString().replaceAll("[^A-Za-z0-9 ]", "_").toUpperCase(Locale.US) + ".tmp";
        return string;
    }

    public static final String makePathToFileInUsersHomeDirectory(String string) {
        return System.getProperty("user.home") + System.getProperty("file.separator") + string;
    }

    public static final String digest(String string, String string2) throws IOException, NoSuchAlgorithmException {
        return FileUtilities.digest(new FileInputStream(string), string2);
    }

    public static final String digest(InputStream inputStream, String string) throws IOException, NoSuchAlgorithmException {
        int n = 32768;
        byte[] byArray = new byte[n];
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        try {
            inputStream = new DigestInputStream(inputStream, messageDigest);
            while (inputStream.read(byArray, 0, n) > 0) {
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            inputStream.close();
        }
        byte[] byArray2 = messageDigest.digest();
        String string2 = HexDump.byteArrayToHexString(byArray2);
        return string2;
    }

    public static final String md5(String string) throws IOException, NoSuchAlgorithmException {
        return FileUtilities.digest(string, "MD5");
    }

    public static final String md5(InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        return FileUtilities.digest(inputStream, "MD5");
    }

    public static List<String> getFilePathComponents(File file) throws IOException {
        return FileUtilities.getFilePathComponents(file.getCanonicalFile(), new ArrayList<String>());
    }

    private static List<String> getFilePathComponents(File file, List<String> list) {
        File file2;
        String string = file.getName();
        if (string != null && string.length() > 0) {
            list.add(0, string);
        }
        if ((file2 = file.getParentFile()) != null) {
            FileUtilities.getFilePathComponents(file2, list);
        }
        return list;
    }

    public static File makeSameRelativePathNameInDifferentFolder(String string, String string2, String string3) throws IOException {
        return FileUtilities.makeSameRelativePathNameInDifferentFolder(new File(string), new File(string2), new File(string3));
    }

    public static File makeSameRelativePathNameInDifferentFolder(File file, File file2, File file3) throws IOException {
        int n;
        List<String> list = FileUtilities.getFilePathComponents(file);
        List<String> list2 = FileUtilities.getFilePathComponents(file3);
        for (n = 0; n < list.size() && n < list2.size() && list.get(n).equals(list2.get(n)); ++n) {
        }
        File file4 = file2;
        while (n < list2.size()) {
            file4 = new File(file4, list2.get(n++));
        }
        return file4;
    }
}

