/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.utils;

import java.math.BigInteger;
import java.util.UUID;

public class UUIDBasedOID {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/utils/UUIDBasedOID.java,v 1.18 2025/01/29 10:58:09 dclunie Exp $";
    protected static final String OID_PREFIX = "2.25";
    protected static final String OID_PREFIX_REMOVAL_REGEX = "^2.25.";
    protected UUID uuid;
    protected String oid;

    public static byte[] getByteArrayInNetworkByteOrderFromUUID(UUID uUID) {
        int n;
        byte[] byArray = new byte[16];
        long l = uUID.getLeastSignificantBits();
        for (n = 15; n >= 8; --n) {
            byArray[n] = (byte)(l & 0xFFL);
            l >>>= 8;
        }
        l = uUID.getMostSignificantBits();
        for (n = 7; n >= 0; --n) {
            byArray[n] = (byte)(l & 0xFFL);
            l >>>= 8;
        }
        return byArray;
    }

    public UUIDBasedOID(UUID uUID, byte[] byArray) {
        byte[] byArray2 = UUIDBasedOID.getByteArrayInNetworkByteOrderFromUUID(uUID);
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        this.uuid = UUID.nameUUIDFromBytes(byArray3);
        this.oid = UUIDBasedOID.createOIDFromUUIDCanonicalHexString(this.uuid.toString());
    }

    public UUIDBasedOID() {
        this.uuid = UUID.randomUUID();
        this.oid = UUIDBasedOID.createOIDFromUUIDCanonicalHexString(this.uuid.toString());
    }

    public UUIDBasedOID(String string) throws IllegalArgumentException, NumberFormatException {
        this.oid = string;
        this.uuid = UUIDBasedOID.parseUUIDFromOID(string);
    }

    public String getOID() {
        return this.oid;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static UUID parseUUIDFromOID(String string) throws IllegalArgumentException, NumberFormatException {
        if (string == null || !string.startsWith(OID_PREFIX)) {
            throw new IllegalArgumentException("OID " + string + " does not start with " + OID_PREFIX);
        }
        String string2 = string.replaceFirst(OID_PREFIX_REMOVAL_REGEX, "");
        return UUIDBasedOID.parseUUIDFromDecimalString(string2);
    }

    public static UUID parseUUIDFromDecimalString(String string) throws NumberFormatException {
        BigInteger bigInteger = new BigInteger(string);
        long l = bigInteger.longValue();
        long l2 = bigInteger.shiftRight(64).longValue();
        return new UUID(l2, l);
    }

    public static BigInteger makeBigIntegerFromUnsignedLong(long l) {
        BigInteger bigInteger;
        if (l < 0L) {
            bigInteger = BigInteger.valueOf(l &= Long.MAX_VALUE);
            bigInteger = bigInteger.setBit(63);
        } else {
            bigInteger = BigInteger.valueOf(l);
        }
        return bigInteger;
    }

    public static String createOIDFromUUIDCanonicalHexString(String string) throws IllegalArgumentException {
        UUID uUID = UUID.fromString(string);
        long l = uUID.getLeastSignificantBits();
        long l2 = uUID.getMostSignificantBits();
        BigInteger bigInteger = UUIDBasedOID.makeBigIntegerFromUnsignedLong(l2);
        bigInteger = bigInteger.shiftLeft(64);
        BigInteger bigInteger2 = UUIDBasedOID.makeBigIntegerFromUnsignedLong(l);
        bigInteger = bigInteger.or(bigInteger2);
        return "2.25." + bigInteger.toString();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println(new UUIDBasedOID().getOID());
        } else {
            for (String string : stringArray) {
                if (string.startsWith(OID_PREFIX)) {
                    System.err.println(string + " = " + new UUIDBasedOID(string).getUUID());
                    continue;
                }
                System.err.println(UUIDBasedOID.createOIDFromUUIDCanonicalHexString(string) + " = " + string);
            }
        }
    }
}

