/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class HttpServer
implements Runnable {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/HttpServer.java,v 1.19 2025/01/29 10:58:09 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(HttpServer.class);
    private int port;
    private int numberOfWorkers;
    private Vector threadPool;
    protected static int defaultNumberOfWorkers = 20;

    public HttpServer() {
    }

    public HttpServer(int n) {
        this.initializeThreadPool(n, defaultNumberOfWorkers);
    }

    public HttpServer(int n, int n2) {
        this.initializeThreadPool(n, n2);
    }

    public void initializeThreadPool(int n, int n2) {
        slf4jlogger.trace("initializeThreadPool(): start on port {} with {} workers", n, n2);
        this.port = n;
        this.numberOfWorkers = n2;
        this.threadPool = new Vector();
        for (int i = 0; i < n2; ++i) {
            Worker worker = this.createWorker();
            new Thread((Runnable)worker, "worker #" + i).start();
            this.threadPool.addElement(worker);
        }
        slf4jlogger.trace("initializeThreadPool(): end");
    }

    public void initializeThreadPool(int n) {
        this.initializeThreadPool(n, defaultNumberOfWorkers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void run() {
        slf4jlogger.trace("run(): start");
        try {
            ServerSocket serverSocket = new ServerSocket(this.port);
            while (true) {
                Socket socket = serverSocket.accept();
                Worker worker = null;
                Vector vector = this.threadPool;
                synchronized (vector) {
                    if (this.threadPool.isEmpty()) {
                        slf4jlogger.trace("run(): additional worker");
                        Worker worker2 = this.createWorker();
                        worker2.setSocket(socket);
                        new Thread((Runnable)worker2, "additional worker").start();
                    } else {
                        worker = (Worker)this.threadPool.elementAt(0);
                        this.threadPool.removeElementAt(0);
                        worker.setSocket(socket);
                    }
                }
            }
        }
        catch (IOException iOException) {
            slf4jlogger.error("", iOException);
            return;
        }
    }

    protected abstract Worker createWorker();

    protected abstract class Worker
    implements Runnable {
        private Socket socket;

        protected Worker() {
        }

        private synchronized void setSocket(Socket socket) {
            this.socket = socket;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            slf4jlogger.trace("Worker.run(): start");
            while (true) {
                if (this.socket == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                }
                try {
                    this.handleConnection();
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
                slf4jlogger.trace("Worker.run(): done");
                this.socket = null;
                Vector vector = HttpServer.this.threadPool;
                synchronized (vector) {
                    if (HttpServer.this.threadPool.size() >= HttpServer.this.numberOfWorkers) {
                        slf4jlogger.trace("Worker.run(): not needed");
                        return;
                    }
                    slf4jlogger.trace("Worker.run(): going back into pool");
                    HttpServer.this.threadPool.addElement(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleConnection() {
            slf4jlogger.trace("Worker.handleConnection():");
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
                Vector<String> vector = new Vector<String>();
                while ((string = bufferedReader.readLine()) != null && string.length() > 0) {
                    slf4jlogger.trace("Worker.handleConnection(): read line=\"{}\"", string);
                    vector.add(string);
                }
                if (vector.size() > 0) {
                    String string2 = (String)vector.get(0);
                    slf4jlogger.trace("Worker.handleConnection(): requestLine=\"{}\"", string2);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                    if (stringTokenizer.countTokens() != 3) {
                        printWriter.print("HTTP/1.1 400 Bad Request\r\n");
                        printWriter.flush();
                    } else {
                        String string3 = stringTokenizer.nextToken();
                        String string4 = stringTokenizer.nextToken();
                        String string5 = stringTokenizer.nextToken();
                        if (string5 == null || !string5.equals("HTTP/1.0") && !string5.equals("HTTP/1.1")) {
                            printWriter.print("HTTP/1.1 505 HTTP Version Not Supported\r\n");
                            printWriter.flush();
                        } else if (string3 != null) {
                            if (string3.equals("GET")) {
                                this.generateResponseToGetRequest(string4, this.socket.getOutputStream());
                            } else {
                                slf4jlogger.trace("Worker.handleConnection(): Not Implemented method=\"{}\"", string3);
                                printWriter.print("HTTP/1.1 501 Not Implemented\r\n");
                                printWriter.flush();
                            }
                        }
                    }
                }
            }
            catch (IOException iOException) {
                slf4jlogger.error("", iOException);
            }
            finally {
                try {
                    slf4jlogger.trace("Worker.handleConnection(): closing socket");
                    this.socket.close();
                }
                catch (IOException iOException) {
                    slf4jlogger.error("", iOException);
                }
            }
        }

        protected abstract void generateResponseToGetRequest(String var1, OutputStream var2) throws IOException;
    }
}

