/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.anatproc;

import com.pixelmed.anatproc.DictionaryOfConcepts;
import com.pixelmed.anatproc.DisplayableAnatomicConcept;
import com.pixelmed.anatproc.DisplayableConcept;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.StringUtilities;

public class CTAnatomy {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/anatproc/CTAnatomy.java,v 1.27 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(CTAnatomy.class);
    protected static String[] badLateralityOrViewOrAnatomyPhraseTriggers = new String[]{"History", "Hx of"};
    protected static String[] badAnatomyWords = new String[]{"research", "and", "head first", "feet first", "entra di piedi", "axials", "sagittals", "coronals", "locator", "tracker"};
    protected static DisplayableAnatomicConcept[] anatomicConceptEntries = new DisplayableAnatomicConcept[]{new DisplayableAnatomicConcept("C1508499", "416949008", false, "SRT", "SNM3", null, "R-FAB57", "Abdomen and Pelvis", "ABDOMENPELVIS", CTAnatomy.newStringArray("Abdomen Pelvis", "Abdo Pelvis", "Abd Pelvis", "Abd Pelv", "Abd Pel", "AbdoPelv", "brzuch miednica"), CTAnatomy.newStringArray("Abdomen and Pelvis"), CTAnatomy.newStringArray("Abdomen and Pelvis")), new DisplayableAnatomicConcept("C1442171", "416550000", false, "SRT", "SNM3", null, "R-FAB55", "Chest and Abdomen", "CHESTABDOMEN", CTAnatomy.newStringArray("Chest Abdomen", "Chest Abdo", "Chest Abd", "Thorax Abdomen", "Thorax Abdo", "Thorax Abd", "Chest Liver", "Thorax Liver", "torace addome", "Klatka brzuch"), CTAnatomy.newStringArray("Chest and Abdomen"), CTAnatomy.newStringArray("Chest and Abdomen")), new DisplayableAnatomicConcept("C1562547", "416775004", false, "SRT", "SNM3", null, "R-FAB56", "Chest, Abdomen and Pelvis", "CHESTABDPELVIS", CTAnatomy.newStringArray("Chest Abdomen Pelvis", "Chest Abdo Pelvis", "Chest Abdo Pelv", "Chest Abdo Pel", "Chest Abd Pelvis", "Chest Abd Pelv", "Chest Abd Pel", "Chest AbdoPelv", "Chest Abdomen Pelv", "Chest Abdomen Pel", "Thorax Abdomen Pelvis", "Thorax Abdo Pelvis", "Thorax Abdo Pelv", "Thorax Abdo Pel", "Thorax Abd Pelvis", "Thorax Abd Pelv", "Thorax Abd Pel", "Thorax AbdoPelv", "Thorax Abdomen Pelv", "Thorax Abdomen Pel", "Thoraco Abdomino Pelvien", "Torax Abdomen Pelvis", "Th Abd Pel", "C A P", "CAP", "T A P", "TAP", "Klatka brzuch miednica", ""), CTAnatomy.newStringArray("Chest, Abdomen and Pelvis"), CTAnatomy.newStringArray("Chest, Abdomen and Pelvis")), new DisplayableAnatomicConcept("C0460004", "774007", false, "SRT", "SNM3", null, "T-D1000", "Head and Neck", "HEADNECK", CTAnatomy.newStringArray("Head Neck"), CTAnatomy.newStringArray("Head and Neck"), CTAnatomy.newStringArray("Head and Neck")), new DisplayableAnatomicConcept("C1562459", "417437006", false, "SRT", "SNM3", null, "R-FAB52", "Neck and Chest", "NECKCHEST", CTAnatomy.newStringArray("Neck Chest", "Neck Thorax", "Collo Tor"), CTAnatomy.newStringArray("Neck and Chest"), CTAnatomy.newStringArray("Neck and Chest")), new DisplayableAnatomicConcept("C1562378", "416152001", false, "SRT", "SNM3", null, "R-FAB53", "Neck, Chest and Abdomen", "NECKCHESTABDOMEN", CTAnatomy.newStringArray("Neck Chest Abdomen", "Neck Chest Abdo", "Neck Chest Abd", "Neck Thorax Abdomen", "Neck Thorax Abdo", "Neck Thorax Abd", "Collo Tor Addo"), CTAnatomy.newStringArray("Neck, Chest and Abdomen"), CTAnatomy.newStringArray("Neck, Chest and Abdomen")), new DisplayableAnatomicConcept("C1562776", "416319003", false, "SRT", "SNM3", null, "R-FAB54", "Neck, Chest, Abdomen and Pelvis", "NECKCHESTABDPELV", CTAnatomy.newStringArray("Neck Chest Abdomen Pelvis", "Neck Chest Abdo Pelvis", "Neck Chest Abd Pelvis", "Neck Chest Abdo Pelv", "Neck Chest Abdo Pel", "Neck Chest Abd Pelv", "Neck Chest Abd Pel", "Neck Thorax Abdomen Pelvis", "Neck Thorax Abdo Pelvis", "Neck Thorax Abd Pelvis", "Neck Thorax Abdo Pelv", "Neck Thorax Abdo Pel", "Neck Thorax Abd Pelv", "Neck Thorax Abd Pel"), CTAnatomy.newStringArray("Neck, Chest, Abdomen and Pelvis"), CTAnatomy.newStringArray("Neck, Chest, Abdomen and Pelvis")), new DisplayableAnatomicConcept("C1508520", "LP33902-5", false, "LN", null, null, "LP33902-5", "Aortic Arch and Carotid Artery", null, CTAnatomy.newStringArray("Aortic Arch Carotid Artery", "Aortic Arch and Carotid Arteries", "Aortic Arch Carotid Arteries"), CTAnatomy.newStringArray("Aortic Arch and Carotid Artery"), CTAnatomy.newStringArray("Aortic Arch and Carotid Artery")), new DisplayableAnatomicConcept("C0000726", "113345001", false, "SRT", "SNM3", null, "T-D4000", "Abdomen", "ABDOMEN", CTAnatomy.newStringArray("Abdominal", "B\u00d8ICHO", "bruco", "Buik", "Vatsa", "Ventre", "Addome", "Abdome", "\u306f\u3089", "\u5fc3\u7aa9\u90e8", "\u80f4", "\u8179", "\u8179\u90e8", "\u0416\u0418\u0412\u041e\u0422", "Buk", "Pilvo", "Addo", "brzuch"), CTAnatomy.newStringArray("Abdomen"), CTAnatomy.newStringArray("Abdomen")), new DisplayableAnatomicConcept("C0001625", "23451007", true, "SRT", "SNM3", null, "T-B3000", "Adrenal gland", "ADRENAL", CTAnatomy.newStringArray("Adrenal"), CTAnatomy.newStringArray("Adrenal gland"), CTAnatomy.newStringArray("Adrenal gland")), new DisplayableAnatomicConcept("C0042425", "67109009", false, "SRT", "SNM3", null, "T-64700", "Ampulla of Vater", null, null, CTAnatomy.newStringArray("Ampulla of Vater"), CTAnatomy.newStringArray("Ampulla of Vater")), new DisplayableAnatomicConcept("C0003087", "70258002", true, "SRT", "SNM3", null, "T-15750", "Ankle joint", "ANKLE", CTAnatomy.newStringArray("Ankle", "Tobillo", "Kn\u00f6chel", "Enkel", "Cheville", "Tornozelo", "\u03b1\u03c3\u03c4\u03c1\u03ac\u03b3\u03b1\u03bb\u03bf\u03c2", "\u8db3\u9996", "\ubc1c\ubaa9", "\u043b\u043e\u0434\u044b\u0436\u043a\u0430"), CTAnatomy.newStringArray("Ankle joint"), CTAnatomy.newStringArray("Ankle joint")), new DisplayableAnatomicConcept("C0003483", "15825003", false, "SRT", "SNM3", null, "T-42000", "Aorta", "AORTA", null, CTAnatomy.newStringArray("Aorta"), CTAnatomy.newStringArray("Aorta")), new DisplayableAnatomicConcept("C0545736", "LP33868-8", false, "LN", null, null, "LP33868-8", "Aorta and femoral artery", null, null, CTAnatomy.newStringArray("Aorta and femoral artery"), CTAnatomy.newStringArray("Aorta and femoral artery")), new DisplayableAnatomicConcept("C0003489", "57034009", false, "SRT", "SNM3", null, "T-42300", "Aortic Arch", null, null, CTAnatomy.newStringArray("Aortic Arch"), CTAnatomy.newStringArray("Aortic Arch")), new DisplayableAnatomicConcept("C1508529", "LP33903-3", false, "LN", null, null, "LP33903-3", "Aortic arch and subclavian artery", null, null, CTAnatomy.newStringArray("Aortic arch and subclavian artery"), CTAnatomy.newStringArray("Aortic arch and subclavian artery")), new DisplayableAnatomicConcept("C0446516", "40983000", true, "SRT", "SNM3", null, "T-D8200", "Arm", "ARM", null, CTAnatomy.newStringArray("Arm"), CTAnatomy.newStringArray("Arm")), new DisplayableAnatomicConcept("C0003855", "439470001", false, "SRT", "SNM3", null, "D1-50666", "Arteriovenous fistula", null, null, CTAnatomy.newStringArray("Arteriovenous fistula"), CTAnatomy.newStringArray("Arteriovenous fistula")), new DisplayableAnatomicConcept("C0004454", "34797008", true, "SRT", "SNM3", null, "T-D8100", "Axilla", "AXILLA", null, CTAnatomy.newStringArray("Axilla"), CTAnatomy.newStringArray("Axilla")), new DisplayableAnatomicConcept("C1995000", "77568009", false, "SRT", "SNM3", null, "T-D2100", "Back", "BACK", null, CTAnatomy.newStringArray("Back"), CTAnatomy.newStringArray("Back")), new DisplayableAnatomicConcept("C0005400", "28273000", false, "SRT", "SNM3", null, "T-60610", "Bile duct", null, null, CTAnatomy.newStringArray("Bile duct"), CTAnatomy.newStringArray("Bile duct")), new DisplayableAnatomicConcept("C0005682", "89837001", false, "SRT", "SNM3", null, "T-74000", "Bladder", "BLADDER", null, CTAnatomy.newStringArray("Bladder"), CTAnatomy.newStringArray("Bladder")), new DisplayableAnatomicConcept("C0006087", "17137000", true, "SRT", "SNM3", null, "T-47160", "Brachial artery", null, null, CTAnatomy.newStringArray("Brachial artery"), CTAnatomy.newStringArray("Brachial artery")), new DisplayableAnatomicConcept("C0006104", "12738006", false, "SRT", "SNM3", null, "T-A0100", "Brain", "BRAIN", null, CTAnatomy.newStringArray("Brain"), CTAnatomy.newStringArray("Brain")), new DisplayableAnatomicConcept("C0006141", "76752008", true, "SRT", "SNM3", null, "T-04000", "Breast", "BREAST", null, CTAnatomy.newStringArray("Breast"), CTAnatomy.newStringArray("Breast")), new DisplayableAnatomicConcept("C0006255", "955009", true, "SRT", "SNM3", null, "T-26000", "Bronchus", "BRONCHUS", null, CTAnatomy.newStringArray("Bronchus"), CTAnatomy.newStringArray("Bronchus")), new DisplayableAnatomicConcept("C0006497", "46862004", true, "SRT", "SNM3", null, "T-D2600", "Buttock", "BUTTOCK", null, CTAnatomy.newStringArray("Buttock"), CTAnatomy.newStringArray("Buttock")), new DisplayableAnatomicConcept("C0006655", "80144004", true, "SRT", "SNM3", null, "T-12770", "Calcaneus", "CALCANEUS", null, CTAnatomy.newStringArray("Calcaneus"), CTAnatomy.newStringArray("Calcaneus")), new DisplayableAnatomicConcept("C0230445", "53840002", true, "SRT", "SNM3", null, "T-D9440", "Calf of leg", "CALF", CTAnatomy.newStringArray("Calf"), CTAnatomy.newStringArray("Calf of leg"), CTAnatomy.newStringArray("Calf of leg")), new DisplayableAnatomicConcept("C0007272", "69105007", true, "SRT", "SNM3", null, "T-45010", "Carotid Artery", "CAROTID", CTAnatomy.newStringArray("Carotid"), CTAnatomy.newStringArray("Carotid Artery"), CTAnatomy.newStringArray("Carotid Artery")), new DisplayableAnatomicConcept("C1268981", "180924008", false, "SRT", "SNM3", null, "T-A600A", "Cerebellum", "CEREBELLUM", null, CTAnatomy.newStringArray("Cerebellum"), CTAnatomy.newStringArray("Cerebellum")), new DisplayableAnatomicConcept("C0728985", "122494005", false, "SRT", "SNM3", null, "T-11501", "Cervical spine", "CSPINE", CTAnatomy.newStringArray("CS", "CWK", "CWZ", "HWS", "H Rygg", "Cspine", "C spine", "Spine Cervical", "Cervical", "Cervic", "Kaelal\u00fclid", "KR\u00c8N\u00cd OBRATLE", "Halswervels", "Vertebrae cervicalis", "Wervel hals", "Kaulanikamat", "Rachis cervical", "Vert\u00e8bre cervicale", "Vert\u00e8bres cervicales", "COLONNE CERVICALE", "CERVICALE", "Halswirbel", "Vertebrae cervicales", "Vertebre cervicali", "\u981a\u690e", "\u9838\u690e", "V\u00e9rtebras Cervicais", "\u0428\u0415\u0419\u041d\u042b\u0415 \u041f\u041e\u0417\u0412\u041e\u041d\u041a\u0418", "columna cervical", "columna cerv", "columna espinal cervical", "columna vertebral cervical", "v\u00e9rtebras cervicales", "Cervikalkotor", "Halskotor", "Halsrygg", "Cervicale wervelzuil", "C chrbtica"), CTAnatomy.newStringArray("Cervical spine"), CTAnatomy.newStringArray("Cervical spine")), new DisplayableAnatomicConcept("C0729373", "297171002", false, "SRT", "SRT", null, "T-D00F7", "Cervico-thoracic spine", "CTSPINE", CTAnatomy.newStringArray("CTSPINE", "Cervico-thoracic", "Cervicothoracic"), CTAnatomy.newStringArray("Cervico-thoracic spine"), CTAnatomy.newStringArray("Cervico-thoracic spine")), new DisplayableAnatomicConcept("C0007874", "71252005", false, "SRT", "SNM3", null, "T-83200", "Cervix", "CERVIX", null, CTAnatomy.newStringArray("Cervix"), CTAnatomy.newStringArray("Cervix")), new DisplayableAnatomicConcept("C0007966", "60819002", true, "SRT", "SNM3", null, "T-D1206", "Cheek", "CHEEK", null, CTAnatomy.newStringArray("Cheek"), CTAnatomy.newStringArray("Cheek")), new DisplayableAnatomicConcept("C0817096", "51185008", false, "SRT", "SNM3", null, "T-D3000", "Chest", "CHEST", CTAnatomy.newStringArray("Thorax", "Rindkere", "HRUDN\u00cdK", "hrudn\u00edk", "Borst", "Rintakeh\u00e4", "Poitrine", "Potter", "Torse", "Brustkorb", "Torace", "Peito", "\u0413\u0420\u0423\u0414\u041d\u0410\u042f \u041a\u041b\u0415\u0422\u041a\u0410", "\u0413\u0420\u0423\u0414\u042c", "pecho", "tor\u00e1cico", "Br\u00f6stkorg", "Torax", "hrudn\u043dk", "hrudn", "mellkas", "Kr\u016btin\u0117s l\u0105sta", "Tor", "Klatka"), CTAnatomy.newStringArray("Chest"), CTAnatomy.newStringArray("Chest")), new DisplayableAnatomicConcept("C1284333", "362047009", false, "SRT", "SNM3", null, "T-45526", "Circle of Willis", "CIRCLEOFWILLIS", null, CTAnatomy.newStringArray("Circle of Willis"), CTAnatomy.newStringArray("Circle of Willis")), new DisplayableAnatomicConcept("C0008913", "51299004", true, "SRT", "SNM3", null, "T-12310", "Clavicle", "CLAVICLE", null, CTAnatomy.newStringArray("Clavicle"), CTAnatomy.newStringArray("Clavicle")), new DisplayableAnatomicConcept("C0009194", "64688005", false, "SRT", "SNM3", null, "T-11BF0", "Coccyx", "COCCYX", null, CTAnatomy.newStringArray("Coccyx"), CTAnatomy.newStringArray("Coccyx")), new DisplayableAnatomicConcept("C0009368", "71854001", false, "SRT", "SNM3", null, "T-59300", "Colon", "COLON", null, CTAnatomy.newStringArray("Colon"), CTAnatomy.newStringArray("Colon")), new DisplayableAnatomicConcept("C1268346", "110797007", false, "SRT", "SNM3", null, "T-DD080", "Colon and rectum", null, null, CTAnatomy.newStringArray("Colon and rectum"), CTAnatomy.newStringArray("Colon and rectum")), new DisplayableAnatomicConcept("C0010031", "28726007", true, "SRT", "SNM3", null, "T-AA200", "Cornea", "CORNEA", null, CTAnatomy.newStringArray("Cornea"), CTAnatomy.newStringArray("Cornea")), new DisplayableAnatomicConcept("C0205042", "41801008", false, "SRT", "SNM3", null, "T-43000", "Coronary artery", "CORONARYARTERY", CTAnatomy.newStringArray("Coronary"), CTAnatomy.newStringArray("Coronary artery"), CTAnatomy.newStringArray("Coronary artery")), new DisplayableAnatomicConcept("C0011980", "5798000", false, "SRT", "SNM3", null, "T-D3400", "Diaphragm", null, null, CTAnatomy.newStringArray("Diaphragm"), CTAnatomy.newStringArray("Diaphragm")), new DisplayableAnatomicConcept("C0013303", "38848004", false, "SRT", "SNM3", null, "T-58200", "Duodenum", "DUODENUM", null, CTAnatomy.newStringArray("Duodenum"), CTAnatomy.newStringArray("Duodenum")), new DisplayableAnatomicConcept("C0521421", "1910005", true, "SRT", "SNM3", null, "T-AB000", "Ear", "EAR", null, CTAnatomy.newStringArray("Ear"), CTAnatomy.newStringArray("Ear")), new DisplayableAnatomicConcept("C1305417", "76248009", true, "SRT", "SNM3", null, "T-D8300", "Elbow", "ELBOW", CTAnatomy.newStringArray("Ellbogen", "Coude", "K\u00fc\u00fcnar", "Armb\u00e5ge", "Codo", "Cotovelo"), CTAnatomy.newStringArray("Elbow"), CTAnatomy.newStringArray("Elbow")), new DisplayableAnatomicConcept("C0229960", "38266002", false, "SRT", "SNM3", null, "T-D0010", "Entire body", "WHOLEBODY", CTAnatomy.newStringArray("Entire body", "Whole body", "Mid body"), CTAnatomy.newStringArray("Entire body"), CTAnatomy.newStringArray("Entire body")), new DisplayableAnatomicConcept("C0014876", "32849002", false, "SRT", "SNM3", null, "T-56000", "Esophagus", "ESOPHAGUS", null, CTAnatomy.newStringArray("Esophagus"), CTAnatomy.newStringArray("Esophagus")), new DisplayableAnatomicConcept("C0015385", "66019005", true, "SRT", "SNM3", null, "T-D0300", "Extremity", "EXTREMITY", CTAnatomy.newStringArray("Extremety", "Extremidad"), CTAnatomy.newStringArray("Extremity"), CTAnatomy.newStringArray("Extremity")), new DisplayableAnatomicConcept("C0015392", "81745001", true, "SRT", "SNM3", null, "T-AA000", "Eye", "EYE", null, CTAnatomy.newStringArray("Eye"), CTAnatomy.newStringArray("Eye")), new DisplayableAnatomicConcept("C0015426", "80243003", true, "SRT", "SNM3", null, "T-AA810", "Eyelid", "EYELID", null, CTAnatomy.newStringArray("Eyelid"), CTAnatomy.newStringArray("Eyelid")), new DisplayableAnatomicConcept("C0015801", "7657000", true, "SRT", "SNM3", null, "T-47400", "Femoral artery", null, null, CTAnatomy.newStringArray("Femoral artery"), CTAnatomy.newStringArray("Femoral artery")), new DisplayableAnatomicConcept("C0015811", "71341001", true, "SRT", "SNM3", null, "T-12710", "Femur", "FEMUR", null, CTAnatomy.newStringArray("Femur"), CTAnatomy.newStringArray("Femur")), new DisplayableAnatomicConcept("C0524584", "55460000", true, "SRT", "SNM3", null, "T-F5201", "Fetus", null, null, CTAnatomy.newStringArray("Fetus"), CTAnatomy.newStringArray("Fetus")), new DisplayableAnatomicConcept("C0016129", "7569003", true, "SRT", "SNM3", null, "T-D8800", "Finger", "FINGER", null, CTAnatomy.newStringArray("Finger"), CTAnatomy.newStringArray("Finger")), new DisplayableAnatomicConcept("C0016504", "56459004", true, "SRT", "SNM3", null, "T-D9700", "Foot", "FOOT", CTAnatomy.newStringArray("Pied", "Pie", "Voet", "Fu\u00df", "\u03c0\u03cc\u03b4\u03b9", "Piede", "\u043d\u043e\u0433\u0430"), CTAnatomy.newStringArray("Foot"), CTAnatomy.newStringArray("Foot")), new DisplayableAnatomicConcept("C0223680", "55797009", true, "SRT", "SNM3", null, "T-12402", "Forearm bone", "FOREARM", CTAnatomy.newStringArray("Forearm", "U ARM", "Unterarm", "Avambraccio", "P\u00d8EDLOKT\u00cd", "Onderarm", "Kyyn\u00e4rvarsi", "Avant-bras", "\u307e\u3048\u3046\u3067", "\u524d\u8155", "Antebra\u00e7o", "\u041f\u0420\u0415\u0414\u041f\u041b\u0415\u0427\u042c\u0415", "antebrazo", "Underarm", "predlaktie"), CTAnatomy.newStringArray("Forearm"), CTAnatomy.newStringArray("Forearm")), new DisplayableAnatomicConcept("C0016976", "28231008", false, "SRT", "SNM3", null, "T-63000", "Gallbladder", "GALLBLADDER", null, CTAnatomy.newStringArray("Gallbladder"), CTAnatomy.newStringArray("Gallbladder")), new DisplayableAnatomicConcept("C0018563", "85562004", true, "SRT", "SNM3", null, "T-D8700", "Hand", "HAND", null, CTAnatomy.newStringArray("Hand"), CTAnatomy.newStringArray("Hand")), new DisplayableAnatomicConcept("C0018670", "69536005", false, "SRT", "SNM3", null, "T-D1100", "Head", "HEAD", CTAnatomy.newStringArray("Kopf", "Schaedel", "Sch\u00e6del", "Sch?del", "Tete"), CTAnatomy.newStringArray("Head"), CTAnatomy.newStringArray("Head")), new DisplayableAnatomicConcept("C0460004", "774007", false, "SRT", "SNM3", null, "T-D1000", "Head and Neck", "HEADNECK", CTAnatomy.newStringArray("Head Neck"), CTAnatomy.newStringArray("Head and Neck"), CTAnatomy.newStringArray("Head and Neck")), new DisplayableAnatomicConcept("C0018787", "80891009", false, "SRT", "SNM3", null, "T-32000", "Heart", "HEART", null, CTAnatomy.newStringArray("Heart"), CTAnatomy.newStringArray("Heart")), new DisplayableAnatomicConcept("C0019552", "24136001", true, "SRT", "SNM3", null, "T-15710", "Hip joint", "HIP", CTAnatomy.newStringArray("Hip", "Heup", "Hanche", "H\u00fcfte", "Puus", "H\u00d6FT", "Cadera", "\u03b9\u03c3\u03c7\u03af\u03bf", "anca", "\u30d2\u30c3\u30d7", "\uc5c9\ub369\uc774", "\u0432\u0430\u043b\u044c\u043c\u0430"), CTAnatomy.newStringArray("Hip"), CTAnatomy.newStringArray("Hip")), new DisplayableAnatomicConcept("C0020164", "85050009", true, "SRT", "SNM3", null, "T-12410", "Humerus", "HUMERUS", CTAnatomy.newStringArray("UP_EXM", "O ARM", "Oberarm", "\u00d5lavars", "Bovenarm", "h\u00famero"), CTAnatomy.newStringArray("Humerus"), CTAnatomy.newStringArray("Humerus")), new DisplayableAnatomicConcept("C0020885", "34516001", false, "SRT", "SNM3", null, "T-58600", "Ileum", "ILEUM", null, CTAnatomy.newStringArray("Ileum"), CTAnatomy.newStringArray("Ileum")), new DisplayableAnatomicConcept("C0576469", "299716001", true, "SRT", "SNM3", null, "T-41068", "Iliac and femoral artery", null, null, CTAnatomy.newStringArray("Iliac and femoral artery"), CTAnatomy.newStringArray("Iliac and femoral artery")), new DisplayableAnatomicConcept("C0020889", "22356005", true, "SRT", "SNM3", null, "T-12340", "Ilium", "ILIUM", null, CTAnatomy.newStringArray("Ilium"), CTAnatomy.newStringArray("Ilium")), new DisplayableAnatomicConcept("C0018246", "26893007", true, "SRT", "SNM3", null, "T-D7000", "Inguinal region", null, null, CTAnatomy.newStringArray("Inguinal region"), CTAnatomy.newStringArray("Inguinal region")), new DisplayableAnatomicConcept("C1283773", "361078006", true, "SRT", "SNM3", null, "T-AB959", "Internal Auditory Canal", "IAC", CTAnatomy.newStringArray("IAC"), CTAnatomy.newStringArray("Internal Auditory Canal"), CTAnatomy.newStringArray("Internal Auditory Canal")), new DisplayableAnatomicConcept("C0226364", "90024005", true, "SRT", "SNM3", null, "T-46740", "Internal iliac artery", null, null, CTAnatomy.newStringArray("Internal iliac artery"), CTAnatomy.newStringArray("Internal iliac artery")), new DisplayableAnatomicConcept("C0022359", "661005", true, "SRT", "SNM3", null, "T-D1213", "Jaw region", "JAW", null, CTAnatomy.newStringArray("Jaw region"), CTAnatomy.newStringArray("Jaw region")), new DisplayableAnatomicConcept("C0022378", "21306003", false, "SRT", "SNM3", null, "T-58400", "Jejunum", "JEJUNUM", null, CTAnatomy.newStringArray("Jejunum"), CTAnatomy.newStringArray("Jejunum")), new DisplayableAnatomicConcept("C0022646", "64033007", true, "SRT", "SNM3", null, "T-71000", "Kidney", "KIDNEY", null, CTAnatomy.newStringArray("Kidney"), CTAnatomy.newStringArray("Kidney")), new DisplayableAnatomicConcept("C1456798", "72696002", true, "SRT", "SNM3", null, "T-D9200", "Knee", "KNEE", CTAnatomy.newStringArray("Knie", "Genou", "P\u00f5lv", "P\u00f6lv", "Kn\u00e4", "Rodilla"), CTAnatomy.newStringArray("Knee"), CTAnatomy.newStringArray("Knee")), new DisplayableAnatomicConcept("C0023078", "4596009", false, "SRT", "SNM3", null, "T-24100", "Larynx", "LARYNX", CTAnatomy.newStringArray("Laringe", "Kehlkopf", "Strottenhoofd"), CTAnatomy.newStringArray("Larynx"), CTAnatomy.newStringArray("Larynx")), new DisplayableAnatomicConcept("C1140621", "30021000", true, "SRT", "SNM3", null, "T-D9400", "Leg", "LEG", CTAnatomy.newStringArray("LOW_EXM", "LOWEXM", "TIB FIB ANKLE", "Jambe"), CTAnatomy.newStringArray("Leg"), CTAnatomy.newStringArray("Leg")), new DisplayableAnatomicConcept("C0023884", "10200004", false, "SRT", "SNM3", null, "T-62000", "Liver", "LIVER", CTAnatomy.newStringArray("foie", "Kepenys"), CTAnatomy.newStringArray("Liver"), CTAnatomy.newStringArray("Liver")), new DisplayableAnatomicConcept("C0024091", "122496007", false, "SRT", "SNM3", null, "T-11503", "Lumbar spine", "LSPINE", CTAnatomy.newStringArray("LS", "LWK", "LWZ", "LWS", "L Rygg", "Lspine", "L spine", "Spine Lumbar", "Lumbar", "Rachis lombaire", "COLONNE LOMBAIRE", "Rach.Lomb", "lombaire", "Nimmel\u00fclid", "Columna lumbar", "L\u00c4NDRYGG", "L chrbtica", "COL LOMBARE"), CTAnatomy.newStringArray("Lumbar spine"), CTAnatomy.newStringArray("Lumbar spine")), new DisplayableAnatomicConcept("C0223603", "297173004", false, "SRT", "SRT", null, "T-D00F9", "Lumbo-sacral spine", "LSSPINE", CTAnatomy.newStringArray("LSSPINE", "Lumbosacral spine", "Lumbo-sacrale wervelzuil", "columna vertebral lumbosacra", "v\u00e9rtebras lumbosacras", "Colonna Lombosacrale"), CTAnatomy.newStringArray("Lumbo-sacral spine"), CTAnatomy.newStringArray("Lumbo-sacral spine")), new DisplayableAnatomicConcept("C0024109", "39607008", true, "SRT", "SNM3", null, "T-28000", "Lung", "LUNG", CTAnatomy.newStringArray("pluco", "pluca"), CTAnatomy.newStringArray("Lung"), CTAnatomy.newStringArray("Lung")), new DisplayableAnatomicConcept("C0024687", "91609006", true, "SRT", "SNM3", null, "T-11180", "Mandible", "JAW", null, CTAnatomy.newStringArray("Mandible"), CTAnatomy.newStringArray("Mandible")), new DisplayableAnatomicConcept("C0024947", "70925003", true, "SRT", "SNM3", null, "T-11170", "Maxilla", "MAXILLA", null, CTAnatomy.newStringArray("Maxilla"), CTAnatomy.newStringArray("Maxilla")), new DisplayableAnatomicConcept("C0178738", "LP30124-9", true, "LN", null, null, "LP30124-9", "Maxilla and Mandible", null, null, CTAnatomy.newStringArray("Maxilla and Mandible"), CTAnatomy.newStringArray("Maxilla and Mandible")), new DisplayableAnatomicConcept("C0025066", "72410000", false, "SRT", "SNM3", null, "T-D3300", "Mediastinum", "MEDIASTINUM", null, CTAnatomy.newStringArray("Mediastinum"), CTAnatomy.newStringArray("Mediastinum")), new DisplayableAnatomicConcept("C1267547", "21082005", false, "SRT", "SNM3", null, "T-51000", "Mouth", "MOUTH", null, CTAnatomy.newStringArray("Mouth"), CTAnatomy.newStringArray("Mouth")), new DisplayableAnatomicConcept("C0027530", "45048000", false, "SRT", "SNM3", null, "T-D1600", "Neck", "NECK", CTAnatomy.newStringArray("Kael", "Collo", "Cuello", "Hals", "Nek", "Nacke"), CTAnatomy.newStringArray("Neck"), CTAnatomy.newStringArray("Neck")), new DisplayableAnatomicConcept("C0028429", "45206002", false, "SRT", "SNM3", null, "T-21000", "Nose", "NOSE", null, CTAnatomy.newStringArray("Nose"), CTAnatomy.newStringArray("Nose")), new DisplayableAnatomicConcept("C0015392", "371398005", true, "SRT", "SNM3", null, "T-D0801", "Orbital region", "ORBIT", CTAnatomy.newStringArray("Orbit"), CTAnatomy.newStringArray("Orbital region"), CTAnatomy.newStringArray("Orbital region")), new DisplayableAnatomicConcept("C0029939", "15497006", true, "SRT", "SNM3", null, "T-87000", "Ovary", "OVARY", null, CTAnatomy.newStringArray("Ovary"), CTAnatomy.newStringArray("Ovary")), new DisplayableAnatomicConcept("C0030274", "15776009", false, "SRT", "SNM3", null, "T-65000", "Pancreas", "PANCREAS", null, CTAnatomy.newStringArray("Pancreas"), CTAnatomy.newStringArray("Pancreas")), new DisplayableAnatomicConcept("C0030288", "69930009", false, "SRT", "SNM3", null, "T-65010", "Pancreatic duct", null, null, CTAnatomy.newStringArray("Pancreatic duct"), CTAnatomy.newStringArray("Pancreatic duct")), new DisplayableAnatomicConcept("C1267614", "110621006", false, "SRT", "SNM3", null, "T-65600", "Pancreatic duct and bile duct systems", null, CTAnatomy.newStringArray("Pancreatic duct and bile duct systems", "Pancreatic duct and bile ducts", "Pancreatic duct and bile duct", "Pancreatic and bile ducts"), CTAnatomy.newStringArray("Pancreatic duct and bile duct systems"), CTAnatomy.newStringArray("Pancreatic duct and bile duct systems")), new DisplayableAnatomicConcept("C0030580", "45289007", true, "SRT", "SNM3", null, "T-61100", "Parotid gland", "PAROTID", CTAnatomy.newStringArray("Parotid"), CTAnatomy.newStringArray("Parotid gland"), CTAnatomy.newStringArray("Parotid gland")), new DisplayableAnatomicConcept("C0030647", "64234005", true, "SRT", "SNM3", null, "T-12730", "Patella", "PATELLA", null, CTAnatomy.newStringArray("Patella"), CTAnatomy.newStringArray("Patella")), new DisplayableAnatomicConcept("C0030797", "12921003", false, "SRT", "SNM3", null, "T-D6000", "Pelvis", "PELVIS", CTAnatomy.newStringArray("PV", "Pelv", "Pel", "Bekken", "Becken", "Bassin", "Vaagen", "B\u00c4CKEN", "\u03bb\u03b5\u03ba\u03ac\u03bd\u03b7", "Bacino", "\u9aa8\u76e4", "\uace8\ubc18", "miednica"), CTAnatomy.newStringArray("Pelvis"), CTAnatomy.newStringArray("Pelvis")), new DisplayableAnatomicConcept("C0030851", "18911002", false, "SRT", "SNM3", null, "T-91000", "Penis", "PENIS", null, CTAnatomy.newStringArray("Penis"), CTAnatomy.newStringArray("Penis")), new DisplayableAnatomicConcept("C0225972", "25489000", false, "SRT", "SNM3", null, "T-39050", "Pericardial cavity", null, null, CTAnatomy.newStringArray("Pericardial cavity"), CTAnatomy.newStringArray("Pericardial cavity")), new DisplayableAnatomicConcept("C1278903", "181211006", false, "SRT", "SNM3", null, "T-55002", "Pharynx", "PHARYNX", null, CTAnatomy.newStringArray("Pharynx"), CTAnatomy.newStringArray("Pharynx")), new DisplayableAnatomicConcept("C0033572", "41216001", false, "SRT", "SNM3", null, "T-92000", "Prostate", "PROSTATE", null, CTAnatomy.newStringArray("Prostate"), CTAnatomy.newStringArray("Prostate")), new DisplayableAnatomicConcept("C0034896", "34402009", false, "SRT", "SNM3", null, "T-59600", "Rectum", "RECTUM", null, CTAnatomy.newStringArray("Rectum"), CTAnatomy.newStringArray("Rectum")), new DisplayableAnatomicConcept("C0035561", "113197003", true, "SRT", "SNM3", null, "T-11300", "Rib", "RIB", CTAnatomy.newStringArray("Gril costal", "Gril cost"), CTAnatomy.newStringArray("Rib"), CTAnatomy.newStringArray("Rib")), new DisplayableAnatomicConcept("C0036037", "54735007", false, "SRT", "SNM3", null, "T-11AD0", "Sacrum", "SSPINE", CTAnatomy.newStringArray("SSPINE"), CTAnatomy.newStringArray("Sacrum"), CTAnatomy.newStringArray("Sacrum")), new DisplayableAnatomicConcept("C0036270", "41695006", false, "SRT", "SNM3", null, "T-D1160", "Scalp", "SCALP", null, CTAnatomy.newStringArray("Scalp"), CTAnatomy.newStringArray("Scalp")), new DisplayableAnatomicConcept("C0036277", "79601000", true, "SRT", "SNM3", null, "T-12280", "Scapula", "SCAPULA", null, CTAnatomy.newStringArray("Scapula"), CTAnatomy.newStringArray("Scapula")), new DisplayableAnatomicConcept("C0036410", "18619003", true, "SRT", "SNM3", null, "T-AA110", "Sclera", "SCLERA", null, CTAnatomy.newStringArray("Sclera"), CTAnatomy.newStringArray("Sclera")), new DisplayableAnatomicConcept("C0036471", "20233005", true, "SRT", "SNM3", null, "T-98000", "Scrotum", "SCROTUM", null, CTAnatomy.newStringArray("Scrotum"), CTAnatomy.newStringArray("Scrotum")), new DisplayableAnatomicConcept("C0037004", "16982005", true, "SRT", "SNM3", null, "T-D2220", "Shoulder", "SHOULDER", CTAnatomy.newStringArray("Schouder", "Schulter", "Epaule", "\u00e9paule", "\u00f5lg", "\u00d6lg", "Hombro", "Ombro", "Rameno", "Rippe"), CTAnatomy.newStringArray("Shoulder"), CTAnatomy.newStringArray("Shoulder")), new DisplayableAnatomicConcept("C0021852", "30315005", false, "SRT", "SNM3", null, "T-58000", "Small intestine", null, null, CTAnatomy.newStringArray("Small intestine"), CTAnatomy.newStringArray("Small intestine")), new DisplayableAnatomicConcept("C0037303", "89546000", false, "SRT", "SNM3", null, "T-11100", "Skull", "SKULL", CTAnatomy.newStringArray("Kolju", "LEBKA", "Schedel", "Kallo", "Cr\u00e2ne", "Cranium", "Sch\u00e4del", "Cranio", "Calota Craniana", "Cr\u00e2nio", "\u0427\u0415\u0420\u0415\u041f", "Calota Craneal", "Cr\u00e1neo", "Kalvarium", "Kranium", "Skalle", "Lebka"), CTAnatomy.newStringArray("Skull"), CTAnatomy.newStringArray("Skull")), new DisplayableAnatomicConcept("C0037949", "280717001", false, "SRT", "SNM3", null, "T-D0146", "Spine", "SPINE", CTAnatomy.newStringArray("Rachis", "Rygg", "chrbtica"), CTAnatomy.newStringArray("Spine"), CTAnatomy.newStringArray("Spine")), new DisplayableAnatomicConcept("C0028872", "51807001", false, "SRT", "SNM3", null, "T-64710", "Sphincter of Oddi", null, null, CTAnatomy.newStringArray("Sphincter of Oddi"), CTAnatomy.newStringArray("Sphincter of Oddi")), new DisplayableAnatomicConcept("C0278443", "56101001", false, "SRT", "SNM3", null, "T-65016", "Sphincter pancreaticus", null, null, CTAnatomy.newStringArray("Sphincter pancreaticus"), CTAnatomy.newStringArray("Sphincter pancreaticus")), new DisplayableAnatomicConcept("C0037993", "78961009", false, "SRT", "SNM3", null, "T-C3000", "Spleen", "SPLEEN", null, CTAnatomy.newStringArray("Spleen"), CTAnatomy.newStringArray("Spleen")), new DisplayableAnatomicConcept("C0038293", "56873002", false, "SRT", "SNM3", null, "T-11210", "Sternum", "STERNUM", null, CTAnatomy.newStringArray("Sternum"), CTAnatomy.newStringArray("Sternum")), new DisplayableAnatomicConcept("C0038351", "69695003", false, "SRT", "SNM3", null, "T-57000", "Stomach", "STOMACH", null, CTAnatomy.newStringArray("Stomach"), CTAnatomy.newStringArray("Stomach")), new DisplayableAnatomicConcept("C0038530", "36765005", false, "SRT", "SNM3", null, "T-46100", "Subclavian artery", null, null, CTAnatomy.newStringArray("Subclavian artery"), CTAnatomy.newStringArray("Subclavian artery")), new DisplayableAnatomicConcept("C0038556", "54019009", true, "SRT", "SNM3", null, "T-61300", "Submandibular gland", "SUBMANDIBULAR", CTAnatomy.newStringArray("Submandibular"), CTAnatomy.newStringArray("Submandibular gland"), CTAnatomy.newStringArray("Submandibular gland")), new DisplayableAnatomicConcept("C0039493", "53620006", true, "SRT", "SNM3", null, "T-15290", "Temporomandibular joint", "TMJ", CTAnatomy.newStringArray("Temporomandibular", "TMJ"), CTAnatomy.newStringArray("Temporomandibular joint"), CTAnatomy.newStringArray("Temporomandibular joint")), new DisplayableAnatomicConcept("C0039597", "40689003", true, "SRT", "SNM3", null, "T-94000", "Testis", "TESTIS", null, CTAnatomy.newStringArray("Testis"), CTAnatomy.newStringArray("Testis")), new DisplayableAnatomicConcept("C0039866", "68367000", true, "SRT", "SNM3", null, "T-D9100", "Thigh", "THIGH", CTAnatomy.newStringArray("Oberschenkel", "Bovenbeen", "Reis"), CTAnatomy.newStringArray("Thigh"), CTAnatomy.newStringArray("Thigh")), new DisplayableAnatomicConcept("C0581269", "122495006", false, "SRT", "SNM3", null, "T-11502", "Thoracic spine", "TSPINE", CTAnatomy.newStringArray("TSPINE", "TS", "THWK", "DWZ", "BWS", "B Rygg", "T spine", "Spine Thoracic", "Thoracic", "Dorsal", "Dorsal spine", "Spine Dorsal", "Rachis dorsal", "COLONNE THORACIQUE", "THORACIQUE", "Rinnaosa", "Rinnal\u00fclid", "Columna dorsal", "Columna vertebral dorsal", "Thoracale wervelzuil", "BR\u00d6STRYGG", "Th chrbtica"), CTAnatomy.newStringArray("Thoracic spine"), CTAnatomy.newStringArray("Thoracic spine")), new DisplayableAnatomicConcept("C0729374", "297172009", false, "SRT", "SRT", null, "T-D00F8", "Thoraco-lumbar spine", "TLSPINE", CTAnatomy.newStringArray("TLSPINE", "Thoraco-lumbar", "Thoracolumbar", "Col.Dors.Lomb", "THORACOLUMBALE"), CTAnatomy.newStringArray("Thoraco-lumbar spine"), CTAnatomy.newStringArray("Thoraco-lumbar spine")), new DisplayableAnatomicConcept("C0040067", "76505004", true, "SRT", "SNM3", null, "T-D8810", "Thumb", "THUMB", null, CTAnatomy.newStringArray("Thumb"), CTAnatomy.newStringArray("Thumb")), new DisplayableAnatomicConcept("C1306748", "118507000", false, "SRT", "SNM3", null, "T-C8001", "Thymus", "THYMUS", null, CTAnatomy.newStringArray("Thymus"), CTAnatomy.newStringArray("Thymus")), new DisplayableAnatomicConcept("C0040132", "69748006", false, "SRT", "SNM3", null, "T-B6000", "Thyroid", "THYROID", null, CTAnatomy.newStringArray("Thyroid"), CTAnatomy.newStringArray("Thyroid")), new DisplayableAnatomicConcept("C0040357", "29707007", true, "SRT", "SNM3", null, "T-D9800", "Toe", "TOE", null, CTAnatomy.newStringArray("Toe"), CTAnatomy.newStringArray("Toe")), new DisplayableAnatomicConcept("C0040408", "21974007", false, "SRT", "SNM3", null, "T-53000", "Tongue", "TONGUE", null, CTAnatomy.newStringArray("Tongue"), CTAnatomy.newStringArray("Tongue")), new DisplayableAnatomicConcept("C0040578", "44567001", false, "SRT", "SNM3", null, "T-25000", "Trachea", "TRACHEA", null, CTAnatomy.newStringArray("Trachea"), CTAnatomy.newStringArray("Trachea")), new DisplayableAnatomicConcept("C0227690", "65364008", true, "SRT", "SNM3", null, "T-73800", "Ureter", "URETER", null, CTAnatomy.newStringArray("Ureter"), CTAnatomy.newStringArray("Ureter")), new DisplayableAnatomicConcept("C0041967", "13648007", false, "SRT", "SNM3", null, "T-75000", "Urethra", "URETHRA", null, CTAnatomy.newStringArray("Urethra"), CTAnatomy.newStringArray("Urethra")), new DisplayableAnatomicConcept("C0042149", "35039007", false, "SRT", "SNM3", null, "T-83000", "Uterus", "UTERUS", null, CTAnatomy.newStringArray("Uterus"), CTAnatomy.newStringArray("Uterus")), new DisplayableAnatomicConcept("C0042232", "76784001", false, "SRT", "SNM3", null, "T-82000", "Vagina", "VAGINA", null, CTAnatomy.newStringArray("Vagina"), CTAnatomy.newStringArray("Vagina")), new DisplayableAnatomicConcept("C0729900", "312548007", false, "SRT", "SNM3", null, "T-46006", "Ventral branch of abdominal aorta", null, null, CTAnatomy.newStringArray("Ventral branch of abdominal aorta"), CTAnatomy.newStringArray("Ventral branch of abdominal aorta")), new DisplayableAnatomicConcept("C0042993", "45292006", false, "SRT", "SNM3", null, "T-81000", "Vulva", "VULVA", null, CTAnatomy.newStringArray("Vulva"), CTAnatomy.newStringArray("Vulva")), new DisplayableAnatomicConcept("C1262468", "74670003", true, "SRT", "SNM3", null, "T-15460", "Wrist joint", "WRIST", CTAnatomy.newStringArray("Wrist", "mu\u00f1eca", "MU\u00d2ECA", "pols", "poignet", "Handgelenk", "\u03ba\u03b1\u03c1\u03c0\u03cc\u03c2", "polso", "\u624b\u9996", "\uc190\ubaa9", "\u0437\u0430\u043f\u044f\u0441\u0442\u044c\u0435 \u0440\u0443\u043a\u0438", "ranne", "k\u00e4e"), CTAnatomy.newStringArray("Wrist joint"), CTAnatomy.newStringArray("Wrist joint")), new DisplayableAnatomicConcept("C0162485", "51204001", true, "SRT", "SNM3", null, "T-11167", "Zygomatic arch", "ZYGOMA", CTAnatomy.newStringArray("Zygoma"), CTAnatomy.newStringArray("Zygomatic arch"), CTAnatomy.newStringArray("Zygomatic arch"))};
    protected static DictionaryOfConcepts anatomyConcepts = new DictionaryOfConcepts(anatomicConceptEntries, badAnatomyWords, "Anatomy");

    protected static String[] newStringArray(String ... stringArray) {
        return stringArray;
    }

    public static DictionaryOfConcepts getAnatomyConcepts() {
        return anatomyConcepts;
    }

    public static DisplayableAnatomicConcept findAnatomicConcept(AttributeList attributeList) {
        DisplayableConcept displayableConcept = null;
        Object object = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList, TagFromName.AnatomicRegionSequence);
        if (object != null) {
            slf4jlogger.debug("findAnatomicConcept(): anatomicRegionSequence = {}", object);
            displayableConcept = anatomyConcepts.findCodeInEntriesFirstThenTryCodeMeaningInEntriesThenTryLongestIndividualEntryContainedWithinCodeMeaning((CodedSequenceItem)object);
            if (displayableConcept != null) {
                slf4jlogger.debug("findAnatomicConcept(): found Anatomy in AnatomicRegionSequence = {}", displayableConcept.toStringBrief());
            }
        }
        if (displayableConcept == null && (object = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.BodyPartExamined)) != null) {
            slf4jlogger.debug("findAnatomicConcept(): bodyPartExamined = {}", object);
            displayableConcept = anatomyConcepts.findInEntriesFirstThenTryLongestIndividualEntryContainedWithin((String)object);
            if (displayableConcept != null) {
                slf4jlogger.debug("findAnatomicConcept(): found Anatomy in BodyPartExamined = {}", displayableConcept.toStringBrief());
            }
        }
        if (displayableConcept == null) {
            displayableConcept = CTAnatomy.findAmongstGeneralAttributes(attributeList, anatomyConcepts, badLateralityOrViewOrAnatomyPhraseTriggers);
        }
        return (DisplayableAnatomicConcept)displayableConcept;
    }

    public static DisplayableConcept findAmongstGeneralAttributes(AttributeList attributeList, DictionaryOfConcepts dictionaryOfConcepts, String[] stringArray) {
        DisplayableConcept displayableConcept = null;
        Object object = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ImageComments);
        if (object != null && !StringUtilities.containsRegardlessOfCase((String)object, stringArray)) {
            slf4jlogger.debug("findAmongstGeneralAttributes(): imageComments = {}", object);
            displayableConcept = dictionaryOfConcepts.findInEntriesFirstThenTryLongestIndividualEntryContainedWithin((String)object);
            if (displayableConcept != null) {
                slf4jlogger.debug("findAmongstGeneralAttributes(): found {} in ImageComments = {}", dictionaryOfConcepts.getDescriptionOfConcept(), displayableConcept.toStringBrief());
            }
        }
        if (displayableConcept == null && (object = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SeriesDescription)) != null && !StringUtilities.containsRegardlessOfCase((String)object, stringArray)) {
            slf4jlogger.debug("findAmongstGeneralAttributes(): seriesDescription = {}", object);
            displayableConcept = dictionaryOfConcepts.findInEntriesFirstThenTryLongestIndividualEntryContainedWithin((String)object);
            if (displayableConcept != null) {
                slf4jlogger.debug("findAmongstGeneralAttributes(): found {} in SeriesDescription = {}", dictionaryOfConcepts.getDescriptionOfConcept(), displayableConcept.toStringBrief());
            }
        }
        if (displayableConcept == null && (object = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ProtocolName)) != null && !StringUtilities.containsRegardlessOfCase((String)object, stringArray)) {
            slf4jlogger.debug("findAmongstGeneralAttributes(): protocolName = {}", object);
            displayableConcept = dictionaryOfConcepts.findInEntriesFirstThenTryLongestIndividualEntryContainedWithin((String)object);
            if (displayableConcept != null) {
                slf4jlogger.debug("findAmongstGeneralAttributes(): found {} in ProtocolName = {}", dictionaryOfConcepts.getDescriptionOfConcept(), displayableConcept.toStringBrief());
            }
        }
        if (displayableConcept == null && (object = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList, TagFromName.PerformedProtocolCodeSequence)) != null) {
            slf4jlogger.debug("findAmongstGeneralAttributes(): performedProtocolCodeSequence = {}", object);
            displayableConcept = dictionaryOfConcepts.findCodeInEntriesFirstThenTryCodeMeaningInEntriesThenTryLongestIndividualEntryContainedWithinCodeMeaning((CodedSequenceItem)object);
            if (displayableConcept != null) {
                slf4jlogger.debug("findAmongstGeneralAttributes(): found {} in PerformedProtocolCodeSequence = {}", dictionaryOfConcepts.getDescriptionOfConcept(), displayableConcept.toStringBrief());
            }
        }
        if (displayableConcept == null && (object = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PerformedProcedureStepDescription)) != null && !StringUtilities.containsRegardlessOfCase((String)object, stringArray)) {
            slf4jlogger.debug("findAmongstGeneralAttributes(): performedProcedureStepDescription = {}", object);
            displayableConcept = dictionaryOfConcepts.findInEntriesFirstThenTryLongestIndividualEntryContainedWithin((String)object);
            if (displayableConcept != null) {
                slf4jlogger.debug("findAmongstGeneralAttributes(): found {} in PerformedProcedureStepDescription = {}", dictionaryOfConcepts.getDescriptionOfConcept(), displayableConcept.toStringBrief());
            }
        }
        if (displayableConcept == null && (object = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList, TagFromName.ProcedureCodeSequence)) != null) {
            slf4jlogger.debug("findAmongstGeneralAttributes(): procedureCodeSequence = {}", object);
            displayableConcept = dictionaryOfConcepts.findCodeInEntriesFirstThenTryCodeMeaningInEntriesThenTryLongestIndividualEntryContainedWithinCodeMeaning((CodedSequenceItem)object);
            if (displayableConcept != null) {
                slf4jlogger.debug("findAmongstGeneralAttributes(): found {} in ProcedureCodeSequence = {}", dictionaryOfConcepts.getDescriptionOfConcept(), displayableConcept.toStringBrief());
            }
        }
        if (displayableConcept == null && (object = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.StudyDescription)) != null && !StringUtilities.containsRegardlessOfCase((String)object, stringArray)) {
            slf4jlogger.debug("findAmongstGeneralAttributes(): seriesDescription = {}", object);
            displayableConcept = dictionaryOfConcepts.findInEntriesFirstThenTryLongestIndividualEntryContainedWithin((String)object);
            if (displayableConcept != null) {
                slf4jlogger.debug("findAmongstGeneralAttributes(): found {} in StudyDescription = {}", dictionaryOfConcepts.getDescriptionOfConcept(), displayableConcept.toStringBrief());
            }
        }
        return displayableConcept;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1) {
            String string = stringArray[0];
            try {
                AttributeList attributeList = new AttributeList();
                attributeList.read(string, null, true, true, TagFromName.PixelData);
                DisplayableAnatomicConcept displayableAnatomicConcept = CTAnatomy.findAnatomicConcept(attributeList);
                if (displayableAnatomicConcept != null) {
                    slf4jlogger.info(displayableAnatomicConcept.toString());
                } else {
                    slf4jlogger.info("########################### - ANATOMY NOT FOUND - ###########################");
                }
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }
    }
}

