/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.display.SourceImage;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ConvertColorToGrayscale {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/ConvertColorToGrayscale.java,v 1.2 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ConvertColorToGrayscale.class);
    private static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;

    public ConvertColorToGrayscale(String string, String string2) throws DicomException, FileNotFoundException, IOException {
        AttributeList attributeList = new AttributeList();
        DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
        attributeList.read(dicomInputStream);
        dicomInputStream.close();
        String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
        if (!SOPClass.isImageStorage(string3)) {
            throw new DicomException("Input file is not an image");
        }
        String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PhotometricInterpretation);
        if (!string4.equals("RGB")) {
            throw new DicomException("Input image is not RGB");
        }
        SourceImage sourceImage = new SourceImage(attributeList);
        BufferedImage bufferedImage = sourceImage.getBufferedImage();
        if (bufferedImage.getColorModel().getNumComponents() != 3) {
            throw new DicomException("Input image is not three components");
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        SampleModel sampleModel = bufferedImage.getSampleModel();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n3 = writableRaster.getNumBands();
        int n4 = n2 * n;
        byte[] byArray = new byte[n4];
        int[] nArray = null;
        nArray = sampleModel.getPixels(0, 0, n, n2, nArray, dataBuffer);
        int n5 = nArray.length;
        if (n3 == 3 && n5 == n4 * 3) {
            int n6 = 0;
            for (int i = 0; i < n5; i += 3) {
                byArray[n6++] = (byte)((nArray[i] + nArray[i + 1] + nArray[i + 2]) / 3);
            }
        } else {
            throw new DicomException("Cannot copy source pixels to destination");
        }
        OtherByteAttribute otherByteAttribute = new OtherByteAttribute(TagFromName.PixelData);
        ((Attribute)otherByteAttribute).setValues(byArray);
        attributeList.put(otherByteAttribute);
        Attribute attribute = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
        attribute.addValue("MONOCHROME2");
        attributeList.put(attribute);
        attribute = new UnsignedShortAttribute(TagFromName.SamplesPerPixel);
        attribute.addValue(1);
        attributeList.put(attribute);
        attribute = new UnsignedShortAttribute(TagFromName.BitsStored);
        attribute.addValue(8);
        attributeList.put(attribute);
        attribute = new UnsignedShortAttribute(TagFromName.BitsAllocated);
        attribute.addValue(8);
        attributeList.put(attribute);
        attribute = new UnsignedShortAttribute(TagFromName.HighBit);
        attribute.addValue(7);
        attributeList.put(attribute);
        attributeList.remove(dictionary.getTagFromName("PlanarConfiguration"));
        attributeList.remove(dictionary.getTagFromName("UltrasoundColorDataPresent"));
        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.apps.ConvertColorPaletteToGrayscale.main()", null, VersionAndConstants.getBuildDate(), "Converted " + string4 + " color to 8-bit grayscale");
        attributeList.removeMetaInformationHeaderAttributes();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(string2, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 2) {
                new ConvertColorToGrayscale(stringArray[0], stringArray[1]);
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: ConvertColorToGrayscale inputFile outputFile");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

