/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.CompressedFrameDecoder;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.OtherByteAttributeCompressedSeparateFramesOnDisk;
import com.pixelmed.dicom.OtherByteAttributeMultipleCompressedFrames;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.display.ImageEditUtilities;
import com.pixelmed.display.SourceImage;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.CapabilitiesAvailable;
import com.pixelmed.utils.MessageLogger;
import com.pixelmed.utils.PrintStreamMessageLogger;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeidentifyAndRedact {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/DeidentifyAndRedact.java,v 1.30 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DeidentifyAndRedact.class);
    protected static String ourCalledAETitle = "OURAETITLE";
    protected Set<String> failedSet;

    protected String makeOutputFileName(String string, String string2, String string3) throws IOException {
        return new File(string, (string3 == null || string3.length() == 0 ? "NOSOPINSTANCEUID" : string3) + "_Anon.dcm").getCanonicalPath();
    }

    public Set<String> getFilePathNamesThatFailedToProcess() {
        return this.failedSet;
    }

    public DeidentifyAndRedact(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, AttributeList attributeList) throws DicomException, Exception, IOException {
        Object object = System.getProperty("os.name");
        if (object != null && ((String)object).toLowerCase().startsWith("windows")) {
            slf4jlogger.info("disabling memory mapping for SourceImage on Windows platform");
            SourceImage.setAllowMemoryMapping(false);
        }
        object = string3.trim().length() == 0 ? null : new RedactionRegions(string3);
        PrintStreamMessageLogger printStreamMessageLogger = new PrintStreamMessageLogger(System.err);
        this.failedSet = new HashSet<String>();
        OurMediaImporter ourMediaImporter = new OurMediaImporter(printStreamMessageLogger, string2, (RedactionRegions)object, bl, bl2, bl3, attributeList, this.failedSet);
        ourMediaImporter.importDicomFiles(string);
    }

    public DeidentifyAndRedact(String string, String string2, String string3, boolean bl, boolean bl2, AttributeList attributeList) throws DicomException, Exception, IOException {
        this(string, string2, string3, bl, bl2, true, attributeList);
    }

    public DeidentifyAndRedact(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) throws DicomException, Exception, IOException {
        this(string, string2, string3, bl, bl2, bl3, null);
    }

    public DeidentifyAndRedact(String string, String string2, String string3, boolean bl, boolean bl2) throws DicomException, Exception, IOException {
        this(string, string2, string3, bl, bl2, true, null);
    }

    public static void main(String[] stringArray) {
        try {
            boolean bl = false;
            if (stringArray.length >= 3) {
                String string;
                AttributeList attributeList = null;
                int n = 3;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = true;
                if (stringArray.length - n > 0) {
                    string = stringArray[n].trim().toUpperCase();
                    if (string.equals("DECOMPRESS")) {
                        bl2 = true;
                        ++n;
                    } else if (string.equals("BLOCK")) {
                        ++n;
                    }
                }
                if (stringArray.length - n > 0) {
                    string = stringArray[n].trim().toUpperCase();
                    if (string.equals("KEEPALLPRIVATE")) {
                        bl3 = true;
                        ++n;
                    } else if (string.equals("KEEPSAFEPRIVATE")) {
                        ++n;
                    }
                }
                if (stringArray.length - n > 0) {
                    string = stringArray[n].trim().toUpperCase();
                    if (string.equals("ADDCONTRIBUTINGEQUIPMENT")) {
                        bl4 = true;
                        ++n;
                    } else if (string.equals("DONOTADDCONTRIBUTINGEQUIPMENT")) {
                        bl4 = false;
                        ++n;
                    }
                }
                if (stringArray.length > n) {
                    if ((stringArray.length - n) % 2 == 0) {
                        attributeList = AttributeList.makeAttributeListFromKeywordAndValuePairs(stringArray, n, stringArray.length - n);
                    } else {
                        slf4jlogger.error("Replacement keyword/value pairs must be pairs");
                        bl = true;
                    }
                }
                if (!bl) {
                    long l = System.currentTimeMillis();
                    DeidentifyAndRedact deidentifyAndRedact = new DeidentifyAndRedact(stringArray[0], stringArray[1], stringArray[2], bl2, bl3, bl4, attributeList);
                    long l2 = System.currentTimeMillis();
                    slf4jlogger.info("DeidentifyAndRedact entire set took = {} ms", l2 - l);
                    Set<String> set = deidentifyAndRedact.getFilePathNamesThatFailedToProcess();
                    if (set.isEmpty()) {
                        slf4jlogger.info("successfully deidentified and redacted all files");
                    } else {
                        slf4jlogger.info("failed to deidentify and redact {} files", set.size());
                        for (String string2 : set) {
                            slf4jlogger.error("failed to deidentify and redact {}", string2);
                        }
                    }
                }
            } else {
                slf4jlogger.error("Incorrect number of arguments");
                bl = true;
            }
            if (bl) {
                slf4jlogger.error("Usage: DeidentifyAndRedact inputPath outputFile redactionControlFile [BLOCK|DECOMPRESS] [KEEPALLPRIVATE|KEEPSAFEPRIVATE] [ADDCONTRIBUTINGEQUIPMENT|DONOTADDCONTRIBUTINGEQUIPMENT] [keyword value]*");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    protected class RedactionRegions {
        private Map<String, Vector<Shape>> regionsByClassName = new HashMap<String, Vector<Shape>>();

        public RedactionRegions(String string) throws Exception {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).startsWith("#") || string2.length() <= 0) continue;
                String[] stringArray = (string2 = string2.replaceAll(" ", "")).split("=", 2);
                if (stringArray.length != 2) {
                    throw new Exception("Missing delimiter between class name and regions");
                }
                String[] stringArray2 = stringArray[1].split(";");
                Vector<Rectangle> vector = new Vector<Rectangle>();
                for (String string3 : stringArray2) {
                    Pattern pattern = Pattern.compile("[(]([0-9]+),([0-9]+),([0-9]+),([0-9]+)[)]");
                    Matcher matcher = pattern.matcher(string3);
                    if (!matcher.matches() || matcher.groupCount() != 4) {
                        throw new Exception("Malformed region \"" + string3 + "\" does not match expected (x,y,w,h)");
                    }
                    int n = Integer.parseInt(matcher.group(1));
                    int n2 = Integer.parseInt(matcher.group(2));
                    int n3 = Integer.parseInt(matcher.group(3));
                    int n4 = Integer.parseInt(matcher.group(4));
                    Rectangle rectangle = new Rectangle(n, n2, n3, n4);
                    vector.add(rectangle);
                }
                Vector<Shape> vector2 = this.regionsByClassName.get(stringArray[0]);
                if (vector2 != null) {
                    System.err.println("Warning: shapes already specified in previous line(s) for class = \"" + stringArray[0] + "\" -  appending the new regions to the previous list");
                    vector2.addAll(vector);
                    continue;
                }
                this.regionsByClassName.put(stringArray[0], vector);
            }
        }

        public Vector<Shape> getRedactionRegionShapes(String string) {
            return this.regionsByClassName.get(string);
        }
    }

    protected class OurMediaImporter
    extends MediaImporter {
        String outputFolderName;
        RedactionRegions redactionRegions;
        boolean decompress;
        boolean keepAllPrivate;
        boolean addContributingEquipmentSequence;
        AttributeList replacementAttributes;
        Set<String> failedSet;
        protected boolean canUseBzip;

        public Set<String> getFilePathNamesThatFailedToProcess() {
            return this.failedSet;
        }

        public OurMediaImporter(MessageLogger messageLogger, String string, RedactionRegions redactionRegions, boolean bl, boolean bl2, boolean bl3, AttributeList attributeList, Set<String> set) {
            super(messageLogger);
            this.canUseBzip = CapabilitiesAvailable.haveBzip2Support();
            this.outputFolderName = string;
            this.redactionRegions = redactionRegions;
            this.decompress = bl;
            this.keepAllPrivate = bl2;
            this.addContributingEquipmentSequence = bl3;
            this.replacementAttributes = attributeList;
            this.failedSet = set;
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string, String string2, String string3) {
            slf4jlogger.info("OurMediaImporter.doSomethingWithDicomFile(): Processing {} Transfer Syntax {}", string, string2);
            try {
                Object object;
                Object object2;
                Object object3;
                File file = new File(string);
                DicomInputStream dicomInputStream = new DicomInputStream(file);
                AttributeList attributeList = new AttributeList();
                boolean bl = !this.decompress && string2.equals("1.2.840.10008.1.2.4.50") && CapabilitiesAvailable.haveJPEGBaselineSelectiveBlockRedaction();
                slf4jlogger.info("OurMediaImporter.doSomethingWithDicomFile(): doitwithjpeg = {}", bl);
                boolean bl2 = !bl && CompressedFrameDecoder.canDecompress(file);
                slf4jlogger.info("OurMediaImporter.doSomethingWithDicomFile(): deferredDecompression = {}", bl2);
                attributeList.setDecompressPixelData(!bl && !bl2);
                String string4 = bl ? "1.2.840.10008.1.2.4.50" : "1.2.840.10008.1.2.1";
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                Attribute attribute = attributeList.getPixelData();
                if (attribute != null && this.redactionRegions != null) {
                    object3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0) + "x" + Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0);
                    slf4jlogger.debug("OurMediaImporter.doSomethingWithDicomFile(): redactionRegion selector classNameForThisImage = " + (String)object3);
                    object2 = this.redactionRegions.getRedactionRegionShapes((String)object3);
                    if (object2 != null && ((Vector)object2).size() > 0) {
                        if (slf4jlogger.isDebugEnabled()) {
                            slf4jlogger.debug("OurMediaImporter.doSomethingWithDicomFile(): aPixelData.getClass() = {}", attribute.getClass().toString());
                        }
                        if (bl && (attribute instanceof OtherByteAttributeMultipleCompressedFrames || attribute instanceof OtherByteAttributeCompressedSeparateFramesOnDisk)) {
                            slf4jlogger.info("OurMediaImporter.doSomethingWithDicomFile(): lossless redaction of JPEG pixels");
                            ImageEditUtilities.blackoutJPEGBlocks(attributeList, (Vector)object2);
                        } else {
                            slf4jlogger.info("OurMediaImporter.doSomethingWithDicomFile(): redaction of fully decompressed pixels");
                            object = new SourceImage(attributeList);
                            ImageEditUtilities.blackout((SourceImage)object, attributeList, (Vector)object2, true, false, true, 0);
                        }
                    }
                }
                attributeList.removeGroupLengthAttributes();
                attributeList.correctDecompressedImagePixelModule(bl2);
                attributeList.insertLossyImageCompressionHistoryIfDecompressed(bl2);
                attributeList.removeMetaInformationHeaderAttributes();
                ClinicalTrialsAttributes.removeClinicalTrialsAttributes(attributeList);
                ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, true, true, true, true, true, true, 0, null, null);
                object3 = attributeList.get(TagFromName.DeidentificationMethod);
                object2 = (SequenceAttribute)attributeList.get(TagFromName.DeidentificationMethodCodeSequence);
                ((Attribute)object3).addValue("Burned in text redacted");
                ((SequenceAttribute)object2).addItem(new CodedSequenceItem("113101", "DCM", "Clean Pixel Data Option").getAttributeList());
                object = new CodeStringAttribute(TagFromName.BurnedInAnnotation);
                ((Attribute)object).addValue("NO");
                attributeList.put((Attribute)object);
                if (this.keepAllPrivate) {
                    ((Attribute)object3).addValue("All private retained");
                    ((SequenceAttribute)object2).addItem(new CodedSequenceItem("210002", "99PMP", "Retain all private elements").getAttributeList());
                } else {
                    attributeList.removeUnsafePrivateAttributes();
                    ((Attribute)object3).addValue("Unsafe private removed");
                    ((SequenceAttribute)object2).addItem(new CodedSequenceItem("113111", "DCM", "Retain Safe Private Option").getAttributeList());
                }
                ClinicalTrialsAttributes.remapUIDAttributes(attributeList);
                ((Attribute)object3).addValue("UIDs remapped");
                object = ((SequenceAttribute)object2).iterator();
                while (object.hasNext()) {
                    CodedSequenceItem codedSequenceItem;
                    SequenceItem sequenceItem = object.next();
                    if (sequenceItem == null || (codedSequenceItem = new CodedSequenceItem(sequenceItem.getAttributeList())) == null) continue;
                    String string5 = codedSequenceItem.getCodeValue();
                    String string6 = codedSequenceItem.getCodingSchemeDesignator();
                    if (string5 == null || !string5.equals("113110") || string6 == null || !string6.equals("DCM")) continue;
                    object.remove();
                }
                ((SequenceAttribute)object2).addItem(new CodedSequenceItem("210001", "99PMP", "Remap UIDs").getAttributeList());
                if (this.addContributingEquipmentSequence) {
                    ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109104", "DCM", "De-identifying Equipment"), "PixelMed", null, null, null, ourCalledAETitle, "DeidentifyAndRedact.main()", null, VersionAndConstants.getBuildDate(), "Deidentified and Redacted");
                }
                if (this.replacementAttributes != null) {
                    attributeList.putAll(this.replacementAttributes);
                }
                FileMetaInformation.addFileMetaInformation(attributeList, string4, ourCalledAETitle);
                attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
                object = new File(DeidentifyAndRedact.this.makeOutputFileName(this.outputFolderName, string, Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID)));
                attributeList.write((File)object, string4, true, true);
                slf4jlogger.info("Deidentified and Redacted {} into {}", string, ((File)object).getCanonicalPath());
            }
            catch (Exception exception) {
                slf4jlogger.error("Failed to process " + string + " ", exception);
                this.failedSet.add(string);
            }
        }

        @Override
        protected boolean isOKToImport(String string, String string2) {
            return string != null && (SOPClass.isImageStorage(string) || SOPClass.isNonImageStorage(string) && !SOPClass.isDirectory(string)) && string2 != null && (string2.equals("1.2.840.10008.1.2") || string2.equals("1.2.840.10008.1.2.1") || string2.equals("1.2.840.10008.1.2.2") || string2.equals("1.2.840.10008.1.2.1.99") || string2.equals("1.2.840.10008.1.2.1.99") && this.canUseBzip || string2.equals("1.2.840.10008.1.2.5") || string2.equals("1.2.840.10008.1.2.4.50") || CapabilitiesAvailable.haveJPEGLosslessCodec() && (string2.equals("1.2.840.10008.1.2.4.57") || string2.equals("1.2.840.10008.1.2.4.70")) || CapabilitiesAvailable.haveJPEG2000Part1Codec() && (string2.equals("1.2.840.10008.1.2.4.91") || string2.equals("1.2.840.10008.1.2.4.90")) || CapabilitiesAvailable.haveJPEGLSCodec() && (string2.equals("1.2.840.10008.1.2.4.80") || string2.equals("1.2.840.10008.1.2.4.81")));
        }
    }
}

