/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.apps.DoseReporterWithLegacyOCRAndAutoSendToRegistry;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.CodingSchemeIdentification;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.ContentItemWithValue;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.FloatDoubleAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.SignedShortAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.MessageLogger;
import com.pixelmed.utils.PrintStreamMessageLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class InsertRealWorldValueMap {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/InsertRealWorldValueMap.java,v 1.15 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DoseReporterWithLegacyOCRAndAutoSendToRegistry.class);
    protected String ourAETitle = "OURAETITLE";
    protected String dstFolderName;
    protected String firstValueMapped;
    protected String lastValueMapped;
    protected String intercept;
    protected String slope;
    protected String explanation;
    protected String label;
    protected String unitsCodingSchemeDesignator;
    protected String unitsCodeValue;
    protected String unitsCodeMeaning;
    protected String unitsCodingSchemeVersion;
    protected List<ContentItem> quantityDefinitionContentItems;
    private static ContentItemFactory contentItemFactory = new ContentItemFactory();

    public InsertRealWorldValueMap(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, List<ContentItem> list, String string11, String string12, MessageLogger messageLogger) throws IOException, DicomException {
        this.dstFolderName = string12;
        this.firstValueMapped = string;
        this.lastValueMapped = string2;
        this.intercept = string3;
        this.slope = string4;
        this.explanation = string5;
        this.label = string6;
        this.unitsCodingSchemeDesignator = string8;
        this.unitsCodeValue = string7;
        this.unitsCodeMeaning = string10;
        this.unitsCodingSchemeVersion = string9;
        this.quantityDefinitionContentItems = list;
        OurMediaImporter ourMediaImporter = new OurMediaImporter(messageLogger);
        ourMediaImporter.importDicomFiles(string11);
    }

    private static List<ContentItem> extractContentItems(String[] stringArray, int n, int n2) throws DicomException {
        slf4jlogger.info("extractContentItems(): starting arg.length = {}, start = {}, end = {}", stringArray.length, n, n2);
        ArrayList<ContentItem> arrayList = new ArrayList<ContentItem>();
        while (n2 > n) {
            Object object;
            int n3 = n2 - n + 1;
            slf4jlogger.info("extractContentItems(): remaining = {}", n3);
            String string = stringArray[n];
            CodedSequenceItem codedSequenceItem = new CodedSequenceItem(stringArray[n + 1]);
            ContentItemWithValue contentItemWithValue = null;
            if (string.equals("CODE") && n3 >= 3) {
                object = new CodedSequenceItem(stringArray[n + 2]);
                contentItemWithValue = contentItemFactory.makeCodeContentItem(null, null, codedSequenceItem, (CodedSequenceItem)object);
                n += 3;
            } else if ((string.equals("NUM") || string.equals("NUMERIC")) && n3 >= 4) {
                object = stringArray[n + 2];
                CodedSequenceItem codedSequenceItem2 = new CodedSequenceItem(stringArray[n + 3]);
                contentItemWithValue = contentItemFactory.makeNumericContentItem(null, true, null, codedSequenceItem, (String)object, codedSequenceItem2, null);
                n += 4;
            } else if (string.equals("DATETIME")) {
                object = stringArray[n + 2];
                contentItemWithValue = contentItemFactory.makeDateTimeContentItem(null, null, codedSequenceItem, (String)object);
                n += 3;
            } else if (string.equals("DATE")) {
                object = stringArray[n + 2];
                contentItemWithValue = contentItemFactory.makeDateContentItem(null, null, codedSequenceItem, (String)object);
                n += 3;
            } else if (string.equals("TIME")) {
                object = stringArray[n + 2];
                contentItemWithValue = contentItemFactory.makeTimeContentItem(null, null, codedSequenceItem, (String)object);
                n += 3;
            } else if (string.equals("PNAME")) {
                object = stringArray[n + 2];
                contentItemWithValue = contentItemFactory.makePersonNameContentItem(null, null, codedSequenceItem, (String)object);
                n += 3;
            } else if (string.equals("UIDREF")) {
                object = stringArray[n + 2];
                contentItemWithValue = contentItemFactory.makeUIDContentItem(null, null, codedSequenceItem, (String)object);
                n += 3;
            } else if (string.equals("TEXT") && n3 >= 3) {
                object = stringArray[n + 2];
                contentItemWithValue = contentItemFactory.makeTextContentItem(null, null, codedSequenceItem, (String)object);
                n += 3;
            } else {
                throw new DicomException("Unrecognized value type in content item argument");
            }
            slf4jlogger.info("extractContentItems(): contentItem = {}", contentItemWithValue);
            if (contentItemWithValue == null) continue;
            arrayList.add(contentItemWithValue);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length >= 12) {
                PrintStreamMessageLogger printStreamMessageLogger = new PrintStreamMessageLogger(System.err);
                String string = stringArray[stringArray.length - 2];
                String string2 = stringArray[stringArray.length - 1];
                List<ContentItem> list = InsertRealWorldValueMap.extractContentItems(stringArray, 10, stringArray.length - 3);
                new InsertRealWorldValueMap(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6], stringArray[7], stringArray[8], stringArray[9], list, string, string2, printStreamMessageLogger);
            } else {
                System.err.println("Usage: java -cp ./pixelmed.jar com.pixelmed.apps.InsertRealWorldValueMap firstValueMapped lastValueMapped intercept slope explanation label unitsCodeValue unitsCodingSchemeDesignator unitsCodingSchemeVersion (or empty string if none) unitsCodeMeaning [CODE|NUMERIC|DATE|TIME|DATETIME|PNAME|UIDREF|TEXT (cv,csd,cm) = value|(cv,csd,cm)]* srcdir|DICOMDIR dstdir");
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class OurMediaImporter
    extends MediaImporter {
        public OurMediaImporter(MessageLogger messageLogger) {
            super(messageLogger);
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string) {
            try {
                Object object;
                boolean bl;
                SequenceItem sequenceItem;
                Object object2;
                Object object3;
                DicomInputStream dicomInputStream = new DicomInputStream(new File(string));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                AttributeList attributeList2 = attributeList;
                SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
                if (sequenceAttribute != null && (object3 = sequenceAttribute.iterator()).hasNext() && (object2 = (sequenceItem = object3.next()).getAttributeList()) != null) {
                    attributeList2 = object2;
                }
                if ((sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.RealWorldValueMappingSequence)) == null) {
                    sequenceAttribute = new SequenceAttribute(TagFromName.RealWorldValueMappingSequence);
                    attributeList2.put(sequenceAttribute);
                }
                object3 = new AttributeList();
                sequenceAttribute.addItem((AttributeList)object3);
                boolean bl2 = bl = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PixelRepresentation, 0) == 1;
                if (bl) {
                    object2 = new SignedShortAttribute(TagFromName.RealWorldValueFirstValueMapped);
                    ((Attribute)object2).addValue(InsertRealWorldValueMap.this.firstValueMapped);
                    ((AttributeList)object3).put((Attribute)object2);
                    object2 = new SignedShortAttribute(TagFromName.RealWorldValueLastValueMapped);
                    ((Attribute)object2).addValue(InsertRealWorldValueMap.this.lastValueMapped);
                    ((AttributeList)object3).put((Attribute)object2);
                } else {
                    object2 = new SignedShortAttribute(TagFromName.RealWorldValueFirstValueMapped);
                    ((Attribute)object2).addValue(InsertRealWorldValueMap.this.firstValueMapped);
                    ((AttributeList)object3).put((Attribute)object2);
                    object2 = new SignedShortAttribute(TagFromName.RealWorldValueLastValueMapped);
                    ((Attribute)object2).addValue(InsertRealWorldValueMap.this.lastValueMapped);
                    ((AttributeList)object3).put((Attribute)object2);
                }
                object2 = new FloatDoubleAttribute(TagFromName.RealWorldValueIntercept);
                ((Attribute)object2).addValue(InsertRealWorldValueMap.this.intercept);
                ((AttributeList)object3).put((Attribute)object2);
                object2 = new FloatDoubleAttribute(TagFromName.RealWorldValueSlope);
                ((Attribute)object2).addValue(InsertRealWorldValueMap.this.slope);
                ((AttributeList)object3).put((Attribute)object2);
                object2 = new LongStringAttribute(TagFromName.LUTExplanation);
                ((Attribute)object2).addValue(InsertRealWorldValueMap.this.explanation);
                ((AttributeList)object3).put((Attribute)object2);
                object2 = new ShortStringAttribute(TagFromName.LUTLabel);
                ((Attribute)object2).addValue(InsertRealWorldValueMap.this.label);
                ((AttributeList)object3).put((Attribute)object2);
                object2 = null;
                object2 = InsertRealWorldValueMap.this.unitsCodingSchemeVersion == null || InsertRealWorldValueMap.this.unitsCodingSchemeVersion.trim().length() == 0 ? new CodedSequenceItem(InsertRealWorldValueMap.this.unitsCodeValue, InsertRealWorldValueMap.this.unitsCodingSchemeDesignator, InsertRealWorldValueMap.this.unitsCodeMeaning) : new CodedSequenceItem(InsertRealWorldValueMap.this.unitsCodeValue, InsertRealWorldValueMap.this.unitsCodingSchemeDesignator, InsertRealWorldValueMap.this.unitsCodingSchemeVersion, InsertRealWorldValueMap.this.unitsCodeMeaning);
                if (object2 != null && (object = ((CodedSequenceItem)object2).getAttributeList()) != null) {
                    SequenceAttribute object4 = new SequenceAttribute(TagFromName.MeasurementUnitsCodeSequence);
                    object4.addItem((AttributeList)object);
                    ((AttributeList)object3).put(object4);
                }
                if (InsertRealWorldValueMap.this.quantityDefinitionContentItems != null && !InsertRealWorldValueMap.this.quantityDefinitionContentItems.isEmpty()) {
                    object2 = new SequenceAttribute(TagFromName.QuantityDefinitionSequence);
                    ((AttributeList)object3).put((Attribute)object2);
                    for (ContentItem contentItem : InsertRealWorldValueMap.this.quantityDefinitionContentItems) {
                        ((SequenceAttribute)object2).addItem(contentItem.getAttributeList());
                    }
                }
                CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(attributeList);
                attributeList.removeGroupLengthAttributes();
                attributeList.removeMetaInformationHeaderAttributes();
                attributeList.remove(TagFromName.DataSetTrailingPadding);
                FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", InsertRealWorldValueMap.this.ourAETitle);
                object2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
                object = new File(InsertRealWorldValueMap.this.dstFolderName, (String)object2 + ".dcm");
                attributeList.write((File)object, "1.2.840.10008.1.2.1", true, true);
            }
            catch (Exception exception) {
                slf4jlogger.error("File {}", string, exception);
            }
        }
    }
}

