/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.CodingSchemeIdentification;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.FunctionalGroupUtilities;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.MoveDicomFilesIntoHierarchy;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.MessageLogger;
import com.pixelmed.utils.PrintStreamMessageLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class MergeFunctionalGroups {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/MergeFunctionalGroups.java,v 1.16 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(MergeFunctionalGroups.class);
    protected String ourAETitle = "OURAETITLE";
    protected String dstFolderName;
    protected FunctionalGroupUtilities.Selector selector;
    AttributeList mergedDimensionsModuleList = null;
    AttributeList mergedList = null;

    protected void mergeDimensionsModule(AttributeList attributeList) throws DicomException {
        SequenceAttribute sequenceAttribute;
        if (this.mergedDimensionsModuleList == null && (sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.DimensionIndexSequence)) != null && sequenceAttribute.getNumberOfItems() > 0) {
            this.mergedDimensionsModuleList = new AttributeList();
            this.mergedDimensionsModuleList.put(sequenceAttribute);
            Attribute attribute = (SequenceAttribute)attributeList.get(TagFromName.DimensionOrganizationSequence);
            if (attribute != null) {
                this.mergedDimensionsModuleList.put(attribute);
            }
            if ((attribute = attributeList.get(TagFromName.DimensionOrganizationType)) != null) {
                this.mergedDimensionsModuleList.put(attribute);
            }
        }
    }

    protected void replaceDimensionsModuleWithMerged(AttributeList attributeList) {
        if (this.mergedDimensionsModuleList != null) {
            attributeList.putAll(this.mergedDimensionsModuleList);
        }
    }

    protected void mergeSelectedFunctionalGroup(SequenceAttribute sequenceAttribute, SequenceAttribute sequenceAttribute2) throws DicomException {
        if (sequenceAttribute2.getNumberOfItems() == sequenceAttribute.getNumberOfItems()) {
            for (int i = 0; i < sequenceAttribute2.getNumberOfItems(); ++i) {
                AttributeList attributeList = sequenceAttribute.getItem(i).getAttributeList();
                for (SequenceAttribute sequenceAttribute3 : sequenceAttribute2.getItem(i).getAttributeList().values()) {
                    AttributeTag attributeTag = sequenceAttribute3.getTag();
                    SequenceAttribute sequenceAttribute4 = (SequenceAttribute)attributeList.get(attributeTag);
                    if (sequenceAttribute4 == null || sequenceAttribute4.getNumberOfItems() == 0) {
                        attributeList.put(sequenceAttribute3);
                        continue;
                    }
                    AttributeList attributeList2 = sequenceAttribute4.getItem(0).getAttributeList();
                    attributeList2.putAll(sequenceAttribute4.getItem(0).getAttributeList());
                }
            }
        } else {
            throw new DicomException("Different number of Per-Frame Functional Groups Sequence items");
        }
    }

    protected void mergeSelectedFunctionalGroups(AttributeList attributeList) throws DicomException {
        if (this.mergedList == null) {
            this.mergedList = attributeList;
        } else {
            SequenceAttribute sequenceAttribute = (SequenceAttribute)this.mergedList.get(TagFromName.SharedFunctionalGroupsSequence);
            SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
            if (sequenceAttribute == null || sequenceAttribute.getNumberOfItems() == 0) {
                if (sequenceAttribute2 != null && sequenceAttribute2.getNumberOfItems() >= 1) {
                    this.mergedList.put(sequenceAttribute2);
                }
            } else if (sequenceAttribute2 != null && sequenceAttribute2.getNumberOfItems() >= 1) {
                this.mergeSelectedFunctionalGroup(sequenceAttribute, sequenceAttribute2);
            }
            sequenceAttribute = (SequenceAttribute)this.mergedList.get(TagFromName.PerFrameFunctionalGroupsSequence);
            sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
            if (sequenceAttribute == null || sequenceAttribute.getNumberOfItems() == 0) {
                if (sequenceAttribute2 != null && sequenceAttribute2.getNumberOfItems() >= 1) {
                    this.mergedList.put(sequenceAttribute2);
                }
            } else if (sequenceAttribute2 != null && sequenceAttribute2.getNumberOfItems() >= 1) {
                this.mergeSelectedFunctionalGroup(sequenceAttribute, sequenceAttribute2);
            }
        }
    }

    protected void replaceFunctionalGroupsWithMerged(AttributeList attributeList) {
        AttributeList attributeList2;
        int n;
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
        SequenceAttribute sequenceAttribute2 = (SequenceAttribute)this.mergedList.get(TagFromName.SharedFunctionalGroupsSequence);
        if (sequenceAttribute == null || sequenceAttribute.getNumberOfItems() == 0) {
            if (sequenceAttribute2 != null && sequenceAttribute2.getNumberOfItems() >= 1) {
                attributeList.put(sequenceAttribute2);
            }
        } else if (sequenceAttribute2 != null && sequenceAttribute2.getNumberOfItems() >= 1) {
            for (n = 0; n < sequenceAttribute2.getNumberOfItems(); ++n) {
                attributeList2 = sequenceAttribute.getItem(n).getAttributeList();
                attributeList2.putAll(sequenceAttribute2.getItem(n).getAttributeList());
            }
        }
        sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        sequenceAttribute2 = (SequenceAttribute)this.mergedList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        if (sequenceAttribute == null || sequenceAttribute.getNumberOfItems() == 0) {
            if (sequenceAttribute2 != null && sequenceAttribute2.getNumberOfItems() >= 1) {
                attributeList.put(sequenceAttribute2);
            }
        } else if (sequenceAttribute2 != null && sequenceAttribute2.getNumberOfItems() >= 1) {
            for (n = 0; n < sequenceAttribute2.getNumberOfItems(); ++n) {
                attributeList2 = sequenceAttribute.getItem(n).getAttributeList();
                attributeList2.putAll(sequenceAttribute2.getItem(n).getAttributeList());
            }
        }
    }

    public MergeFunctionalGroups(FunctionalGroupUtilities.Selector selector, String string, String string2, MessageLogger messageLogger) throws IOException, DicomException {
        this.selector = selector;
        this.dstFolderName = string2;
        OurFirstPassMediaImporter ourFirstPassMediaImporter = new OurFirstPassMediaImporter(messageLogger);
        ourFirstPassMediaImporter.importDicomFiles(string);
        OurSecondPassMediaImporter ourSecondPassMediaImporter = new OurSecondPassMediaImporter(messageLogger);
        ourSecondPassMediaImporter.importDicomFiles(string);
    }

    public MergeFunctionalGroups(FunctionalGroupUtilities.Selector selector, String[] stringArray, String string, MessageLogger messageLogger) throws IOException, DicomException {
        this.selector = selector;
        this.dstFolderName = string;
        OurFirstPassMediaImporter ourFirstPassMediaImporter = new OurFirstPassMediaImporter(messageLogger);
        for (String string2 : stringArray) {
            ourFirstPassMediaImporter.importDicomFiles(string2);
        }
        OurSecondPassMediaImporter ourSecondPassMediaImporter = new OurSecondPassMediaImporter(messageLogger);
        for (String string3 : stringArray) {
            ourSecondPassMediaImporter.importDicomFiles(string3);
        }
    }

    public static void main(String[] stringArray) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            FunctionalGroupUtilities.Selector selector = new FunctionalGroupUtilities.Selector(stringArray, arrayList);
            if (stringArray.length == arrayList.size()) {
                selector.setAll(true);
            }
            if (arrayList.size() == 2) {
                PrintStreamMessageLogger printStreamMessageLogger = new PrintStreamMessageLogger(System.err);
                new MergeFunctionalGroups(selector, arrayList.get(0), arrayList.get(1), (MessageLogger)printStreamMessageLogger);
            } else if (arrayList.size() > 2) {
                PrintStreamMessageLogger printStreamMessageLogger = new PrintStreamMessageLogger(System.err);
                int n = arrayList.size() - 1;
                String string = arrayList.get(n);
                arrayList.remove(n);
                String[] stringArray2 = new String[n];
                stringArray2 = arrayList.toArray(stringArray2);
                new MergeFunctionalGroups(selector, stringArray2, string, (MessageLogger)printStreamMessageLogger);
            } else {
                System.err.println("Usage: java -cp ./pixelmed.jar com.pixelmed.apps.MergeFunctionalGroups [-all|-spatial|-framecontent|-unclassified]* srcdir|DICOMDIR [srcdir|DICOMDIR]* dstdir");
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class OurSecondPassMediaImporter
    extends MediaImporter {
        public OurSecondPassMediaImporter(MessageLogger messageLogger) {
            super(messageLogger);
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string) {
            try {
                DicomInputStream dicomInputStream = new DicomInputStream(new File(string));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                if (MergeFunctionalGroups.this.selector.framecontent) {
                    MergeFunctionalGroups.this.replaceDimensionsModuleWithMerged(attributeList);
                }
                MergeFunctionalGroups.this.replaceFunctionalGroupsWithMerged(attributeList);
                ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.apps.MergeFunctionalGroups", null, "Vers. " + VersionAndConstants.getBuildDate(), "Merged functional groups");
                CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(attributeList);
                attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
                attributeList.removeGroupLengthAttributes();
                attributeList.removeMetaInformationHeaderAttributes();
                attributeList.remove(TagFromName.DataSetTrailingPadding);
                FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", MergeFunctionalGroups.this.ourAETitle);
                File file = new File(MergeFunctionalGroups.this.dstFolderName, MoveDicomFilesIntoHierarchy.makeHierarchicalPathFromAttributes(attributeList));
                if (file.exists()) {
                    throw new DicomException("\"" + string + "\": new file \"" + file + "\" already exists - not overwriting");
                }
                File file2 = file.getParentFile();
                if (!file2.exists() && !file2.mkdirs()) {
                    throw new DicomException("\"" + string + "\": parent directory creation failed for \"" + file + "\"");
                }
                slf4jlogger.info("Writing with new functional groups file {}", file);
                attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
            }
            catch (Exception exception) {
                slf4jlogger.error("File {}", string, exception);
            }
        }
    }

    protected class OurFirstPassMediaImporter
    extends MediaImporter {
        public OurFirstPassMediaImporter(MessageLogger messageLogger) {
            super(messageLogger);
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string) {
            try {
                DicomInputStream dicomInputStream = new DicomInputStream(new File(string));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                FunctionalGroupUtilities.removeAllButSelected(attributeList, MergeFunctionalGroups.this.selector);
                if (MergeFunctionalGroups.this.selector.framecontent) {
                    MergeFunctionalGroups.this.mergeDimensionsModule(attributeList);
                }
                MergeFunctionalGroups.this.mergeSelectedFunctionalGroups(attributeList);
            }
            catch (Exception exception) {
                slf4jlogger.error("File {}", string, exception);
            }
        }
    }
}

