/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RemapFrameOfReferenceUIDs {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/RemapFrameOfReferenceUIDs.java,v 1.12 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(RemapFrameOfReferenceUIDs.class);
    protected String ourAETitle = "OURAETITLE";
    private Map<String, String> frameOfReferenceUIDIndexedByCommonUID = new HashMap<String, String>();
    private UIDGenerator u = new UIDGenerator();
    private String scope;
    private String srcFolderName;
    private String dstFolderName;

    public RemapFrameOfReferenceUIDs(String string, String string2, String string3) throws FileNotFoundException, IOException, DicomException {
        this.scope = string.toUpperCase();
        this.srcFolderName = string2;
        this.dstFolderName = string3;
        OurMediaImporter ourMediaImporter = new OurMediaImporter();
        ourMediaImporter.importDicomFiles(string2);
    }

    public static void main(String[] stringArray) {
        try {
            new RemapFrameOfReferenceUIDs(stringArray[0], stringArray[1], stringArray[2]);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class OurMediaImporter
    extends MediaImporter {
        public OurMediaImporter() {
            super(null);
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string) {
            System.err.println("Doing " + string);
            try {
                Object object;
                DicomInputStream dicomInputStream = new DicomInputStream(new File(string));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                String string2 = null;
                if (RemapFrameOfReferenceUIDs.this.scope.equals("STUDY")) {
                    string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
                } else if (RemapFrameOfReferenceUIDs.this.scope.equals("SERIES")) {
                    string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesInstanceUID);
                }
                if (string2 == null || string2.length() == 0) {
                    throw new DicomException("\"" + string + "\": cannot get common UID - wrong scope " + RemapFrameOfReferenceUIDs.this.scope + " specified perhaps ?");
                }
                String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.FrameOfReferenceUID);
                String string4 = (String)RemapFrameOfReferenceUIDs.this.frameOfReferenceUIDIndexedByCommonUID.get(string2);
                if (string4 == null) {
                    string4 = string3 == null || string3.length() == 0 ? RemapFrameOfReferenceUIDs.this.u.getAnotherNewUID() : string3;
                    RemapFrameOfReferenceUIDs.this.frameOfReferenceUIDIndexedByCommonUID.put(string2, string4);
                }
                if (!string4.equals(string3)) {
                    slf4jlogger.info("\"{}\": replacing old FoRUID {} with common {} for {} {}", string, string3, string4, RemapFrameOfReferenceUIDs.this.scope, string2);
                    object = new UniqueIdentifierAttribute(TagFromName.FrameOfReferenceUID);
                    ((Attribute)object).addValue(string4);
                    attributeList.put((Attribute)object);
                }
                ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.apps.RemapFrameOfReferenceUIDs", null, "Vers. " + VersionAndConstants.getBuildDate(), "Remapped UIDs");
                attributeList.removeGroupLengthAttributes();
                attributeList.removeMetaInformationHeaderAttributes();
                attributeList.remove(TagFromName.DataSetTrailingPadding);
                FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", RemapFrameOfReferenceUIDs.this.ourAETitle);
                object = FileUtilities.makeSameRelativePathNameInDifferentFolder(RemapFrameOfReferenceUIDs.this.srcFolderName, RemapFrameOfReferenceUIDs.this.dstFolderName, string);
                if (((File)object).exists()) {
                    throw new DicomException("\"" + string + "\": new file \"" + object + "\" already exists - not overwriting");
                }
                File file = ((File)object).getParentFile();
                if (!file.exists() && !file.mkdirs()) {
                    throw new DicomException("\"" + string + "\": parent directory creation failed for \"" + object + "\"");
                }
                attributeList.write((File)object, "1.2.840.10008.1.2.1", true, true);
            }
            catch (Exception exception) {
                slf4jlogger.error("File {}", string, exception);
            }
        }
    }
}

