/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeFactory;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.CodingSchemeIdentification;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.MoveDicomFilesIntoHierarchy;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnknownAttribute;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.MessageLogger;
import com.pixelmed.utils.PrintStreamMessageLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;

public class SetCharacteristicsFromSummary {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/SetCharacteristicsFromSummary.java,v 1.31 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SetCharacteristicsFromSummary.class);
    protected String ourAETitle = "OURAETITLE";
    protected String dstFolderName;
    protected Map<String, Boolean> options = new HashMap<String, Boolean>();
    protected Set<AttributeTag> topLevelRemovalList = new HashSet<AttributeTag>();
    protected Set<AttributeTag> recursiveRemovalList = new HashSet<AttributeTag>();
    protected AttributeList topLevelReplacementsList = new AttributeList();
    protected Map<AttributeTag, AttributeList> functionalGroupsReplacementsList = new HashMap<AttributeTag, AttributeList>();
    protected DicomDictionary dictionary;

    protected AttributeTag getAttributeTagFromKeywordOrGroupAndElement(String string) throws DicomException {
        AttributeTag attributeTag = null;
        if (string.length() == 8) {
            try {
                int n = (int)Long.parseLong(string, 16);
                attributeTag = new AttributeTag(n >>> 16, n & 0xFFFF);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (attributeTag == null) {
            attributeTag = this.dictionary.getTagFromName(string);
        }
        slf4jlogger.debug("getAttributeTagFromKeywordOrGroupAndElement(): {}", attributeTag);
        return attributeTag;
    }

    protected Attribute makeNewAttribute(AttributeTag attributeTag) throws DicomException {
        return AttributeFactory.newAttribute(attributeTag);
    }

    protected Attribute makeNewStringAttribute(AttributeTag attributeTag) throws DicomException {
        Attribute attribute = AttributeFactory.newAttribute(attributeTag);
        if (attribute instanceof UnknownAttribute) {
            attribute = new LongStringAttribute(attributeTag);
        }
        return attribute;
    }

    protected Attribute makeNewSequenceAttribute(AttributeTag attributeTag) throws DicomException {
        Attribute attribute = AttributeFactory.newAttribute(attributeTag);
        if (attribute instanceof UnknownAttribute) {
            attribute = new SequenceAttribute(attributeTag);
        }
        return attribute;
    }

    protected Attribute parseAttributeFromJSON(JsonObject jsonObject, String string) throws DicomException {
        Attribute attribute = null;
        AttributeTag attributeTag = this.getAttributeTagFromKeywordOrGroupAndElement(string);
        if (attributeTag == null) {
            throw new DicomException("Unrecognized data element keyword for attribute: " + string);
        }
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)string);
        JsonValue.ValueType valueType = jsonValue.getValueType();
        if (valueType == JsonValue.ValueType.STRING) {
            String string2 = ((JsonString)jsonValue).getString();
            slf4jlogger.debug("parseAttributeFromJSON(): " + string + " : " + string2);
            if (string2 != null && string2.length() > 0) {
                attribute = this.makeNewStringAttribute(attributeTag);
                attribute.addValue(string2);
            }
        } else if (valueType == JsonValue.ValueType.OBJECT) {
            attribute = this.makeNewSequenceAttribute(attributeTag);
            if (!((JsonObject)jsonValue).isNull("cv")) {
                String string3 = ((JsonObject)jsonValue).getString("cv");
                String string4 = ((JsonObject)jsonValue).getString("csd");
                String string5 = ((JsonObject)jsonValue).getString("cm");
                ((SequenceAttribute)attribute).addItem(new CodedSequenceItem(string3, string4, string5).getAttributeList());
            }
        } else if (valueType == JsonValue.ValueType.ARRAY) {
            JsonArray jsonArray = (JsonArray)jsonValue;
            for (JsonValue jsonValue2 : jsonArray) {
                Object object;
                JsonValue.ValueType valueType2 = jsonValue2.getValueType();
                if (valueType2 == JsonValue.ValueType.STRING) {
                    object = ((JsonString)jsonValue2).getString();
                    if (attribute == null) {
                        attribute = this.makeNewStringAttribute(attributeTag);
                    }
                    attribute.addValue((String)object);
                    continue;
                }
                if (valueType2 != JsonValue.ValueType.OBJECT) continue;
                object = new AttributeList();
                this.parseAttributesFromJSON((JsonObject)jsonValue2, (AttributeList)object);
                this.processAttributeListAfterReplacements((AttributeList)object);
                if (attribute == null) {
                    attribute = this.makeNewSequenceAttribute(attributeTag);
                }
                ((SequenceAttribute)attribute).addItem((AttributeList)object);
            }
        }
        if (attribute == null) {
            attribute = this.makeNewAttribute(attributeTag);
            slf4jlogger.debug("parseAttributeFromJSON(): falling through for empty attribute {}", attribute);
        }
        slf4jlogger.debug("parseAttributeFromJSON(): {}", attribute);
        return attribute;
    }

    protected void parseAttributesFromJSON(JsonObject jsonObject, AttributeList attributeList) throws DicomException {
        for (String string : jsonObject.keySet()) {
            Attribute attribute = this.parseAttributeFromJSON(jsonObject, string);
            attributeList.put(attribute);
        }
    }

    protected void parseAttributeTagsFromJSON(JsonObject jsonObject, Set<AttributeTag> set) throws DicomException {
        for (String string : jsonObject.keySet()) {
            AttributeTag attributeTag = this.getAttributeTagFromKeywordOrGroupAndElement(string);
            set.add(attributeTag);
        }
    }

    protected void parseOptionsFromJSON(JsonObject jsonObject) throws DicomException {
        slf4jlogger.debug("parseOptionsFromJSON():");
        for (String string : jsonObject.keySet()) {
            JsonValue jsonValue = (JsonValue)jsonObject.get((Object)string);
            JsonValue.ValueType valueType = jsonValue.getValueType();
            boolean bl = false;
            if (valueType == JsonValue.ValueType.TRUE) {
                bl = true;
            } else if (valueType == JsonValue.ValueType.FALSE) {
                bl = false;
            } else {
                throw new DicomException("Unexpected valueType " + valueType + " in options for " + string);
            }
            slf4jlogger.debug("parseOptionsFromJSON(): {}} : {}", string, bl);
            this.options.put(string, new Boolean(bl));
        }
    }

    protected void parseSummaryFile(String string) throws DicomException, FileNotFoundException {
        JsonReader jsonReader = Json.createReader((Reader)new FileReader(string));
        JsonObject jsonObject = jsonReader.readObject();
        for (String string2 : jsonObject.keySet()) {
            JsonObject jsonObject2 = (JsonObject)jsonObject.get((Object)string2);
            if (string2.equals("options")) {
                this.parseOptionsFromJSON(jsonObject2);
                continue;
            }
            if (string2.equals("remove")) {
                this.parseAttributeTagsFromJSON(jsonObject2, this.topLevelRemovalList);
                continue;
            }
            if (string2.equals("removeall")) {
                this.parseAttributeTagsFromJSON(jsonObject2, this.recursiveRemovalList);
                continue;
            }
            if (string2.equals("top")) {
                this.parseAttributesFromJSON(jsonObject2, this.topLevelReplacementsList);
                continue;
            }
            AttributeTag attributeTag = this.dictionary.getTagFromName(string2);
            AttributeList attributeList = this.functionalGroupsReplacementsList.get(attributeTag);
            if (attributeList == null) {
                attributeList = new AttributeList();
                this.functionalGroupsReplacementsList.put(attributeTag, attributeList);
            }
            this.parseAttributesFromJSON(jsonObject2, attributeList);
        }
        jsonReader.close();
    }

    protected void processAttributeListAfterReplacements(AttributeList attributeList) throws DicomException {
    }

    protected void performReplacements(AttributeList attributeList) throws DicomException {
        for (AttributeTag object2 : this.topLevelRemovalList) {
            attributeList.remove(object2);
        }
        Object object3 = this.recursiveRemovalList.iterator();
        while (object3.hasNext()) {
            AttributeTag attributeTag = object3.next();
            attributeList.removeRecursively(attributeTag);
        }
        attributeList.putAll(this.topLevelReplacementsList);
        if (this.functionalGroupsReplacementsList.size() > 0) {
            object3 = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(attributeList, TagFromName.SharedFunctionalGroupsSequence);
            if (object3 == null) {
                object3 = new AttributeList();
                SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.SharedFunctionalGroupsSequence);
                sequenceAttribute.addItem((AttributeList)object3);
                attributeList.put(sequenceAttribute);
            }
            for (AttributeTag attributeTag : this.functionalGroupsReplacementsList.keySet()) {
                AttributeList attributeList2;
                SequenceAttribute sequenceAttribute = (SequenceAttribute)((AttributeList)object3).get(attributeTag);
                if (sequenceAttribute == null) {
                    sequenceAttribute = new SequenceAttribute(attributeTag);
                    ((AttributeList)object3).put(sequenceAttribute);
                }
                if ((attributeList2 = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(sequenceAttribute)) == null) {
                    attributeList2 = new AttributeList();
                    sequenceAttribute.addItem(attributeList2);
                }
                attributeList2.putAll(this.functionalGroupsReplacementsList.get(attributeTag));
            }
        }
        if ((object3 = this.options.get("AppendToContributingEquipmentSequence")) == null || ((Boolean)object3).booleanValue()) {
            slf4jlogger.debug("performReplacements(): calling addContributingEquipmentSequence()");
            ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.apps.SetCharacteristicsFromSummary", null, "Vers. " + VersionAndConstants.getBuildDate(), "Set characteristics from summary");
        }
        if ((object3 = this.options.get("ReplaceCodingSchemeIdentificationSequence")) == null || ((Boolean)object3).booleanValue()) {
            slf4jlogger.debug("performReplacements(): calling replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList()");
            CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(attributeList);
        }
    }

    public SetCharacteristicsFromSummary(String string, String string2, String string3, MessageLogger messageLogger) throws IOException, DicomException {
        SetCharacteristicsFromSummary setCharacteristicsFromSummary = this;
        this.dictionary = setCharacteristicsFromSummary.topLevelReplacementsList.getDictionary();
        this.dstFolderName = string3;
        this.parseSummaryFile(string);
        OurMediaImporter ourMediaImporter = new OurMediaImporter(messageLogger);
        ourMediaImporter.importDicomFiles(string2);
    }

    public SetCharacteristicsFromSummary(String string, String[] stringArray, String string2, MessageLogger messageLogger) throws IOException, DicomException {
        SetCharacteristicsFromSummary setCharacteristicsFromSummary = this;
        this.dictionary = setCharacteristicsFromSummary.topLevelReplacementsList.getDictionary();
        this.dstFolderName = string2;
        this.parseSummaryFile(string);
        OurMediaImporter ourMediaImporter = new OurMediaImporter(messageLogger);
        for (String string3 : stringArray) {
            ourMediaImporter.importDicomFiles(string3);
        }
    }

    public SetCharacteristicsFromSummary(String string, AttributeList attributeList) throws IOException, DicomException {
        SetCharacteristicsFromSummary setCharacteristicsFromSummary = this;
        this.dictionary = setCharacteristicsFromSummary.topLevelReplacementsList.getDictionary();
        this.parseSummaryFile(string);
        this.performReplacements(attributeList);
        this.processAttributeListAfterReplacements(attributeList);
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[0];
            String string2 = stringArray[stringArray.length - 1];
            if (stringArray.length == 3) {
                PrintStreamMessageLogger printStreamMessageLogger = new PrintStreamMessageLogger(System.err);
                new SetCharacteristicsFromSummary(string, stringArray[1], string2, (MessageLogger)printStreamMessageLogger);
            } else if (stringArray.length > 3) {
                PrintStreamMessageLogger printStreamMessageLogger = new PrintStreamMessageLogger(System.err);
                int n = stringArray.length - 2;
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 1, stringArray2, 0, n);
                new SetCharacteristicsFromSummary(string, stringArray2, string2, (MessageLogger)printStreamMessageLogger);
            } else {
                System.err.println("Usage: java -cp ./pixelmed.jar com.pixelmed.apps.SetCharacteristicsFromSummary jsonfile srcdir|DICOMDIR [srcdir|DICOMDIR]* dstdir");
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class OurMediaImporter
    extends MediaImporter {
        public OurMediaImporter(MessageLogger messageLogger) {
            super(messageLogger);
        }

        @Override
        protected boolean isOKToImport(String string, String string2) {
            return string2 != null;
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string) {
            try {
                DicomInputStream dicomInputStream = new DicomInputStream(new File(string));
                AttributeList attributeList = new AttributeList();
                attributeList.setDecompressPixelData(false);
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
                SetCharacteristicsFromSummary.this.performReplacements(attributeList);
                SetCharacteristicsFromSummary.this.processAttributeListAfterReplacements(attributeList);
                attributeList.removeGroupLengthAttributes();
                attributeList.removeMetaInformationHeaderAttributes();
                attributeList.remove(TagFromName.DataSetTrailingPadding);
                attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
                FileMetaInformation.addFileMetaInformation(attributeList, string2, SetCharacteristicsFromSummary.this.ourAETitle);
                File file = new File(SetCharacteristicsFromSummary.this.dstFolderName, MoveDicomFilesIntoHierarchy.makeHierarchicalPathFromAttributes(attributeList));
                if (file.exists()) {
                    throw new DicomException("\"" + string + "\": new file \"" + file + "\" already exists - not overwriting");
                }
                File file2 = file.getParentFile();
                if (!file2.exists() && !file2.mkdirs()) {
                    throw new DicomException("\"" + string + "\": parent directory creation failed for \"" + file + "\"");
                }
                slf4jlogger.info("Writing with characteristics set file {}", file);
                attributeList.write(file, string2, true, true);
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }
    }
}

