/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.ColorUtilities;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;

public class TabulateSegmentSequence {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/TabulateSegmentSequence.java,v 1.9 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(TabulateSegmentSequence.class);

    public static void tabulateSegmentSequence(String string, PrintStream printStream) throws IOException, FileNotFoundException, NumberFormatException, DicomException {
        AttributeList attributeList = new AttributeList();
        attributeList.read(string, TagFromName.PixelData);
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SegmentSequence);
        if (sequenceAttribute != null) {
            printStream.println("number\tlabel\talg type\ttrackingID\ttrackingUID\tgray\tCIEL\tCIEa\tCIEb\tR\tG\trB\tanat reg CV\tanat reg CSD\tanat reg CSV\tanat reg CM\tanat reg mod CV\tanat reg mod CSD\tanat reg mod CSV\tanat reg mod CM\tseg ctgry CV\tseg ctgry CSD\tseg ctgry CSV\tseg ctgry CM\tseg type CV\tseg type CSD\tseg type CSV\tseg type CM\tsegtype mod CV\tsegtype mod CSD\tsegtype mod CSV\tsegtype mod CM");
            Iterator<SequenceItem> iterator = sequenceAttribute.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                AttributeList attributeList2;
                SequenceItem sequenceItem = iterator.next();
                if (sequenceItem == null || (attributeList2 = sequenceItem.getAttributeList()) == null) continue;
                String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.SegmentNumber);
                String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.SegmentLabel);
                String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.SegmentAlgorithmType);
                String string5 = "\t\t\t";
                String string6 = "\t\t\t";
                Object object7 = (SequenceAttribute)attributeList2.get(TagFromName.AnatomicRegionSequence);
                if (object7 != null) {
                    object6 = CodedSequenceItem.getSingleCodedSequenceItemOrNull((Attribute)object7);
                    if (object6 != null) {
                        string5 = ((CodedSequenceItem)object6).toTabDelimitedString();
                    }
                    if ((object5 = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem((SequenceAttribute)object7, TagFromName.AnatomicRegionModifierSequence)) != null && (object4 = CodedSequenceItem.getSingleCodedSequenceItemOrNull((Attribute)object5)) != null) {
                        string6 = ((CodedSequenceItem)object4).toTabDelimitedString();
                    }
                }
                object7 = "\t\t\t";
                object6 = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList2, TagFromName.SegmentedPropertyCategoryCodeSequence);
                if (object6 != null) {
                    object7 = ((CodedSequenceItem)object6).toTabDelimitedString();
                }
                object6 = "\t\t\t";
                object5 = "\t\t\t";
                object4 = (SequenceAttribute)attributeList2.get(TagFromName.SegmentedPropertyTypeCodeSequence);
                if (object4 != null) {
                    object3 = CodedSequenceItem.getSingleCodedSequenceItemOrNull((Attribute)object4);
                    if (object3 != null) {
                        object6 = ((CodedSequenceItem)object3).toTabDelimitedString();
                    }
                    if ((object2 = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem((SequenceAttribute)object4, TagFromName.SegmentedPropertyTypeModifierCodeSequence)) != null && (object = CodedSequenceItem.getSingleCodedSequenceItemOrNull((Attribute)object2)) != null) {
                        object5 = ((CodedSequenceItem)object).toTabDelimitedString();
                    }
                }
                object4 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.TrackingID);
                object3 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.TrackingUID);
                object2 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.RecommendedDisplayGrayscaleValue);
                object = "";
                String string7 = "";
                String string8 = "";
                String string9 = "";
                String string10 = "";
                String string11 = "";
                String[] stringArray = Attribute.getStringValues(attributeList2, TagFromName.RecommendedDisplayCIELabValue);
                if (stringArray != null && stringArray.length == 3) {
                    object = stringArray[0];
                    string7 = stringArray[1];
                    string8 = stringArray[2];
                    int[] nArray = new int[]{Integer.parseInt((String)object), Integer.parseInt(string7), Integer.parseInt(string8)};
                    int[] nArray2 = ColorUtilities.getSRGBFromIntegerScaledCIELabPCS(nArray);
                    string9 = Integer.toString(nArray2[0]);
                    string10 = Integer.toString(nArray2[1]);
                    string11 = Integer.toString(nArray2[2]);
                }
                printStream.println(string2 + "\t" + string3 + "\t" + string4 + "\t" + (String)object4 + "\t" + (String)object3 + "\t" + (String)object2 + "\t" + (String)object + "\t" + string7 + "\t" + string8 + "\t" + string9 + "\t" + string10 + "\t" + string11 + "\t" + string5 + "\t" + string6 + "\t" + (String)object7 + "\t" + (String)object6 + "\t" + (String)object5);
            }
        } else {
            throw new DicomException("Missing SegmentSequence");
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length >= 1) {
                TabulateSegmentSequence.tabulateSegmentSequence(stringArray[0], System.out);
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: TabulateSegmentSequence inputFile");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

