/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.AttributeTagAttribute;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FunctionalGroupUtilities;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.OtherDoubleAttribute;
import com.pixelmed.dicom.OtherFloatAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.rmi.dgc.VMID;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class CommonConvertedAttributeGeneration {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/CommonConvertedAttributeGeneration.java,v 1.31 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(CommonConvertedAttributeGeneration.class);

    private static void addParametricMapFrameTypeSharedFunctionalGroup(AttributeList attributeList) throws DicomException {
        CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.FrameType);
        ((Attribute)codeStringAttribute).addValue("DERIVED");
        ((Attribute)codeStringAttribute).addValue("PRIMARY");
        ((Attribute)codeStringAttribute).addValue("");
        ((Attribute)codeStringAttribute).addValue("");
        FunctionalGroupUtilities.generateFrameTypeSharedFunctionalGroup(attributeList, TagFromName.ParametricMapFrameTypeSequence, codeStringAttribute);
    }

    private static void addModalitySpecificFrameTypeSharedFunctionalGroup(AttributeList attributeList, String string) throws DicomException {
        AttributeTag attributeTag = null;
        if (string != null) {
            switch (string) {
                case "CT": {
                    attributeTag = TagFromName.CTImageFrameTypeSequence;
                    break;
                }
                case "MR": {
                    attributeTag = TagFromName.MRImageFrameTypeSequence;
                    break;
                }
                case "PT": {
                    attributeTag = TagFromName.PETFrameTypeSequence;
                    break;
                }
                case "DX": {
                    attributeTag = TagFromName.XRay3DFrameTypeSequence;
                    break;
                }
                case "MG": {
                    attributeTag = TagFromName.XRay3DFrameTypeSequence;
                    break;
                }
                case "XA": {
                    attributeTag = TagFromName.XRay3DFrameTypeSequence;
                }
            }
        }
        if (attributeTag != null) {
            Object object = new CodeStringAttribute(TagFromName.FrameType);
            ((Attribute)object).addValue("DERIVED");
            ((Attribute)object).addValue("PRIMARY");
            ((Attribute)object).addValue("VOLUME");
            ((Attribute)object).addValue("NONE");
            FunctionalGroupUtilities.generateFrameTypeSharedFunctionalGroup(attributeList, attributeTag, (Attribute)object);
            AttributeList attributeList2 = ((SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSelectedItemWithinSequence(attributeList, TagFromName.SharedFunctionalGroupsSequence, 0, attributeTag)).getItem(0).getAttributeList();
            CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.PixelPresentation);
            ((Attribute)codeStringAttribute).addValue("MONOCHROME");
            attributeList2.put(codeStringAttribute);
            codeStringAttribute = new CodeStringAttribute(TagFromName.VolumetricProperties);
            ((Attribute)codeStringAttribute).addValue("VOLUME");
            attributeList2.put(codeStringAttribute);
            codeStringAttribute = new CodeStringAttribute(TagFromName.VolumeBasedCalculationTechnique);
            ((Attribute)codeStringAttribute).addValue("NONE");
            attributeList2.put(codeStringAttribute);
        }
    }

    public static String selectSOPClassForModalityNumberOfFramesAndPixelCharacteristics(String string, int n, int n2, int n3, boolean bl) {
        slf4jlogger.trace("selectSOPClassForModalityNumberOfFramesAndPixelCharacteristics(): modality = {}", string);
        slf4jlogger.trace("selectSOPClassForModalityNumberOfFramesAndPixelCharacteristics(): numberOfFrames = {}", n);
        slf4jlogger.trace("selectSOPClassForModalityNumberOfFramesAndPixelCharacteristics(): samplesPerPixel = {}", n2);
        slf4jlogger.trace("selectSOPClassForModalityNumberOfFramesAndPixelCharacteristics(): bitsAllocated = {}", n3);
        slf4jlogger.trace("selectSOPClassForModalityNumberOfFramesAndPixelCharacteristics(): isFloatPixelData = {}", bl);
        String string2 = null;
        if (bl) {
            string2 = "1.2.840.10008.5.1.4.1.1.30";
        } else if (string != null && string.length() > 0) {
            if (n > 1) {
                switch (string) {
                    case "CT": {
                        string2 = "1.2.840.10008.5.1.4.1.1.2.2";
                        break;
                    }
                    case "MR": {
                        string2 = "1.2.840.10008.5.1.4.1.1.4.4";
                        break;
                    }
                    case "PT": {
                        string2 = "1.2.840.10008.5.1.4.1.1.128.1";
                        break;
                    }
                    case "MG": {
                        string2 = "1.2.840.10008.5.1.4.1.1.13.1.3";
                        break;
                    }
                    case "SM": {
                        string2 = "1.2.840.10008.5.1.4.1.1.77.1.3";
                        break;
                    }
                    case "GM": {
                        string2 = "1.2.840.10008.5.1.4.1.1.77.1.2";
                    }
                }
            } else {
                switch (string) {
                    case "CT": {
                        string2 = "1.2.840.10008.5.1.4.1.1.2";
                        break;
                    }
                    case "MR": {
                        string2 = "1.2.840.10008.5.1.4.1.1.4";
                        break;
                    }
                    case "PT": {
                        string2 = "1.2.840.10008.5.1.4.1.1.128";
                        break;
                    }
                    case "MG": {
                        string2 = "1.2.840.10008.5.1.4.1.1.1.2";
                        break;
                    }
                    case "SM": {
                        string2 = "1.2.840.10008.5.1.4.1.1.77.1.6";
                    }
                }
            }
        }
        if (string2 == null) {
            string2 = "1.2.840.10008.5.1.4.1.1.7";
            if (n > 1) {
                if (n2 == 1) {
                    if (n3 == 8) {
                        string2 = "1.2.840.10008.5.1.4.1.1.7.2";
                    } else if (n3 == 16) {
                        string2 = "1.2.840.10008.5.1.4.1.1.7.3";
                    }
                } else if (n2 == 3) {
                    string2 = "1.2.840.10008.5.1.4.1.1.7.4";
                }
            }
        }
        slf4jlogger.trace("selectSOPClassForModalityNumberOfFramesAndPixelCharacteristics(): SOP Class = {}", string2);
        return string2;
    }

    public static void generateCommonAttributes(AttributeList attributeList, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) throws DicomException {
        UIDGenerator uIDGenerator = new UIDGenerator();
        Object object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(uIDGenerator.getAnotherNewUID());
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object).addValue(uIDGenerator.getAnotherNewUID());
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object).addValue(uIDGenerator.getAnotherNewUID());
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.PatientID);
        ((Attribute)object).addValue(string2);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.PatientBirthDate);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientSex);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object).addValue(string3);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
        ((Attribute)object).addValue("^^^^");
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.AccessionNumber);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue(string4);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object).addValue(string5);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.Manufacturer);
        ((Attribute)object).addValue("PixelMed");
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.DeviceSerialNumber);
        ((Attribute)object).addValue(new VMID().toString());
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.SoftwareVersions);
        ((Attribute)object).addValue(VersionAndConstants.getBuildDate());
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.BurnedInAnnotation);
        ((Attribute)object).addValue("NO");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.RecognizableVisualFeatures);
        ((Attribute)object).addValue("NO");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.ContentQualification);
        ((Attribute)object).addValue("RESEARCH");
        attributeList.put((Attribute)object);
        object = new Date();
        String string8 = new SimpleDateFormat("yyyyMMdd").format((Date)object);
        Object object2 = new SimpleDateFormat("HHmmss.SSS").format((Date)object);
        Attribute attribute = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)attribute).addValue(string8);
        attributeList.put(attribute);
        attribute = new TimeAttribute(TagFromName.StudyTime);
        ((Attribute)attribute).addValue((String)object2);
        attributeList.put(attribute);
        attribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)attribute).addValue(string8);
        attributeList.put(attribute);
        attribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)attribute).addValue((String)object2);
        attributeList.put(attribute);
        attribute = new DateAttribute(TagFromName.ContentDate);
        ((Attribute)attribute).addValue(string8);
        attributeList.put(attribute);
        attribute = new TimeAttribute(TagFromName.ContentTime);
        ((Attribute)attribute).addValue((String)object2);
        attributeList.put(attribute);
        attribute = new DateAttribute(TagFromName.InstanceCreationDate);
        ((Attribute)attribute).addValue(string8);
        attributeList.put(attribute);
        attribute = new TimeAttribute(TagFromName.InstanceCreationTime);
        ((Attribute)attribute).addValue((String)object2);
        attributeList.put(attribute);
        attribute = new ShortStringAttribute(TagFromName.TimezoneOffsetFromUTC);
        ((Attribute)attribute).addValue(DateTimeAttribute.getTimeZone(TimeZone.getDefault(), (Date)object));
        attributeList.put(attribute);
        object = new UniqueIdentifierAttribute(TagFromName.InstanceCreatorUID);
        ((Attribute)object).addValue("1.3.6.1.4.1.5962.99.3");
        attributeList.put((Attribute)object);
        int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 1);
        if (string7 == null) {
            int n3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsAllocated, 1);
            attribute = attributeList.getPixelData();
            boolean bl2 = attribute instanceof OtherFloatAttribute || attribute instanceof OtherDoubleAttribute;
            string7 = CommonConvertedAttributeGeneration.selectSOPClassForModalityNumberOfFramesAndPixelCharacteristics(string6, n, n2, n3, bl2);
        }
        if (SOPClass.isImageWithFrameOfReferenceStorage(string7) || string7.equals("1.2.840.10008.5.1.4.1.1.66") || string7.equals("1.2.840.10008.5.1.4.1.1.104.3")) {
            object2 = new UniqueIdentifierAttribute(TagFromName.FrameOfReferenceUID);
            ((Attribute)object2).addValue(uIDGenerator.getAnotherNewUID());
            attributeList.put((Attribute)object2);
            object2 = new LongStringAttribute(TagFromName.PositionReferenceIndicator);
            attributeList.put((Attribute)object2);
        }
        if (SOPClass.isImageWithSynchronizationStorage(string7) || string7.equals("1.2.840.10008.5.1.4.1.1.66")) {
            object2 = new UniqueIdentifierAttribute(TagFromName.SynchronizationFrameOfReferenceUID);
            ((Attribute)object2).addValue("1.2.840.10008.15.1.1");
            attributeList.put((Attribute)object2);
            object2 = new CodeStringAttribute(TagFromName.SynchronizationTrigger);
            ((Attribute)object2).addValue("NO TRIGGER");
            attributeList.put((Attribute)object2);
            object2 = new CodeStringAttribute(TagFromName.AcquisitionTimeSynchronized);
            ((Attribute)object2).addValue("N");
            attributeList.put((Attribute)object2);
        }
        if (!SOPClass.isEncapsulatedDocument(string7)) {
            if (!SOPClass.isLegacyConvertedEnhancedImageStorage(string7)) {
                object2 = new CodeStringAttribute(TagFromName.PatientOrientation);
                attributeList.put((Attribute)object2);
            }
            object2 = new CodeStringAttribute(TagFromName.LossyImageCompression);
            ((Attribute)object2).addValue("00");
            attributeList.put((Attribute)object2);
        }
        if (string7.equals("1.2.840.10008.5.1.4.1.1.30")) {
            CommonConvertedAttributeGeneration.addParametricMapFrameTypeSharedFunctionalGroup(attributeList);
            object2 = new CodeStringAttribute(TagFromName.ContentLabel);
            ((Attribute)object2).addValue("LABEL1");
            attributeList.put((Attribute)object2);
            object2 = new LongStringAttribute(TagFromName.ContentDescription);
            attributeList.put((Attribute)object2);
            object2 = new PersonNameAttribute(TagFromName.ContentCreatorName);
            attributeList.put((Attribute)object2);
        }
        if (SOPClass.isEnhancedMultiframeImageStorage(string7)) {
            CodeStringAttribute codeStringAttribute;
            double d;
            String string9;
            double d2;
            if (n2 == 1 && (d2 = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.WindowWidth, 0.0)) > 0.0) {
                double d3 = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.WindowCenter, 0.0);
                string9 = Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.VOILUTFunction, "LINEAR");
                FunctionalGroupUtilities.generateVOILUTFunctionalGroup(attributeList, n, d2, d3, string9);
                attributeList.remove(TagFromName.WindowCenter);
                attributeList.remove(TagFromName.WindowWidth);
                attributeList.remove(TagFromName.VOILUTFunction);
            }
            if ((d = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.RescaleSlope, 0.0)) > 0.0) {
                double d4 = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.RescaleIntercept, 0.0);
                string9 = Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.RescaleType, "US");
                FunctionalGroupUtilities.generatePixelValueTransformationFunctionalGroup(attributeList, n, d, d4, string9);
                attributeList.remove(TagFromName.RescaleSlope);
                attributeList.remove(TagFromName.RescaleIntercept);
                attributeList.remove(TagFromName.RescaleType);
            }
            if (bl) {
                FunctionalGroupUtilities.generateUnassignedConvertedAttributesSequenceFunctionalGroups(attributeList, n);
            }
            if (string7.equals("1.2.840.10008.5.1.4.1.1.66.4")) {
                codeStringAttribute = new CodeStringAttribute(TagFromName.ImageType);
                ((Attribute)codeStringAttribute).addValue("DERIVED");
                ((Attribute)codeStringAttribute).addValue("PRIMARY");
                attributeList.put(codeStringAttribute);
            } else {
                codeStringAttribute = new CodeStringAttribute(TagFromName.ImageType);
                ((Attribute)codeStringAttribute).addValue("DERIVED");
                ((Attribute)codeStringAttribute).addValue("PRIMARY");
                ((Attribute)codeStringAttribute).addValue("VOLUME");
                ((Attribute)codeStringAttribute).addValue("NONE");
                attributeList.put(codeStringAttribute);
            }
            if (!string7.equals("1.2.840.10008.5.1.4.1.1.66.4") && !string7.equals("1.2.840.10008.5.1.4.1.1.77.1.6")) {
                codeStringAttribute = new CodeStringAttribute(TagFromName.PixelPresentation);
                ((Attribute)codeStringAttribute).addValue("MONOCHROME");
                attributeList.put(codeStringAttribute);
                codeStringAttribute = new CodeStringAttribute(TagFromName.VolumetricProperties);
                ((Attribute)codeStringAttribute).addValue("VOLUME");
                attributeList.put(codeStringAttribute);
                codeStringAttribute = new CodeStringAttribute(TagFromName.VolumeBasedCalculationTechnique);
                ((Attribute)codeStringAttribute).addValue("NONE");
                attributeList.put(codeStringAttribute);
            }
            CommonConvertedAttributeGeneration.addModalitySpecificFrameTypeSharedFunctionalGroup(attributeList, string6);
        } else if (!SOPClass.isEncapsulatedDocument(string7)) {
            object2 = new CodeStringAttribute(TagFromName.ImageType);
            ((Attribute)object2).addValue("DERIVED");
            ((Attribute)object2).addValue("PRIMARY");
            attributeList.put((Attribute)object2);
        }
        if (SOPClass.isMultiframeImageStorage(string7)) {
            if (SOPClass.isMultiframeSecondaryCaptureImageStorage(string7)) {
                if (attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence) != null) {
                    AttributeTagAttribute attributeTagAttribute = new AttributeTagAttribute(TagFromName.FrameIncrementPointer);
                    attributeTagAttribute.addValue(TagFromName.PerFrameFunctionalGroupsSequence);
                    attributeList.put(attributeTagAttribute);
                } else if (n > 1) {
                    Attribute attribute2 = new AttributeTagAttribute(TagFromName.FrameIncrementPointer);
                    ((AttributeTagAttribute)attribute2).addValue(TagFromName.PageNumberVector);
                    attributeList.put(attribute2);
                    attribute2 = new IntegerStringAttribute(TagFromName.PageNumberVector);
                    for (int i = 1; i <= n; ++i) {
                        attribute2.addValue(i);
                    }
                    attributeList.put(attribute2);
                }
            } else if (!SOPClass.isEnhancedMultiframeImageStorage(string7)) {
                Attribute attribute3 = new AttributeTagAttribute(TagFromName.FrameIncrementPointer);
                ((AttributeTagAttribute)attribute3).addValue(TagFromName.FrameTime);
                attributeList.put(attribute3);
                if (attributeList.get(TagFromName.FrameTime) == null) {
                    attribute3 = new DecimalStringAttribute(TagFromName.FrameTime);
                    attribute3.addValue(0);
                    attributeList.put(attribute3);
                }
            }
        }
        slf4jlogger.debug("CommonConvertedAttributeGeneration.generateCommonAttributes(): SOP Class = {}", string7);
        Attribute attribute4 = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)attribute4).addValue(string7);
        attributeList.put(attribute4);
        if (SOPClass.isSecondaryCaptureImageStorage(string7) || SOPClass.isEncapsulatedDocument(string7) && !string7.equals("1.2.840.10008.5.1.4.1.1.104.3")) {
            attribute4 = new CodeStringAttribute(TagFromName.ConversionType);
            ((Attribute)attribute4).addValue("WSD");
            attributeList.put(attribute4);
        }
        if (!(SOPClass.isSecondaryCaptureImageStorage(string7) || SOPClass.isEncapsulatedDocument(string7) || string7.equals("1.2.840.10008.5.1.4.1.1.66.4"))) {
            attribute4 = new SequenceAttribute(TagFromName.AcquisitionContextSequence);
            attributeList.put(attribute4);
        }
        if (string6 == null || string6.length() == 0) {
            string6 = SOPClass.selectModalityForSOPClass(string7);
            slf4jlogger.debug("CommonConvertedAttributeGeneration.generateCommonAttributes(): selected Modality {} for SOP Class {}", string6, string7);
        }
        attribute4 = new CodeStringAttribute(TagFromName.Modality);
        ((Attribute)attribute4).addValue(string6);
        attributeList.put(attribute4);
    }

    public static void generateCommonAttributes(AttributeList attributeList, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws DicomException {
        CommonConvertedAttributeGeneration.generateCommonAttributes(attributeList, string, string2, string3, string4, string5, string6, string7, true);
    }
}

