/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.convert.NIfTI1Exception;
import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class NIfTI1Header {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/NIfTI1Header.java,v 1.16 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(NIfTI1Header.class);
    public static final int FIXED_HEADER_LENGTH = 348;
    public static final int MAGIC_OFFSET = 344;
    public byte[] bytes;
    public boolean bigEndian;
    public int sizeof_hdr;
    public byte dim_info;
    public short[] dim = new short[8];
    public float intent_p1;
    public float intent_p2;
    public float intent_p3;
    public short intent_code;
    public Intent intent;
    public short datatype_code;
    public DataType datatype;
    public short bitpix;
    public short slice_start;
    public float[] pixdim = new float[8];
    public float vox_offset;
    public float scl_slope;
    public float scl_inter;
    public short slice_end;
    public byte slice_code;
    public SliceOrder slice_order;
    public byte xyzt_units_code;
    public byte xyzt_units_code_spatial;
    public Units xyzt_units_spatial;
    public byte xyzt_units_code_temporal;
    public Units xyzt_units_temporal;
    public float cal_max;
    public float cal_min;
    public float slice_duration;
    public float toffset;
    public byte[] description = new byte[80];
    public byte[] aux_file = new byte[24];
    public short qform_code;
    public CoordinateTransform qform;
    public short sform_code;
    public CoordinateTransform sform;
    public float quatern_b;
    public float quatern_c;
    public float quatern_d;
    public float qoffset_x;
    public float qoffset_y;
    public float qoffset_z;
    public float[] srow_x = new float[4];
    public float[] srow_y = new float[4];
    public float[] srow_z = new float[4];
    public byte[] intent_name = new byte[16];
    public byte[] magic = new byte[4];

    public static boolean isNIfTI1SingleFileMagicNumber(byte[] byArray, int n) {
        return byArray[n] == 110 && byArray[n + 1] == 43 && byArray[n + 2] == 49 && byArray[n + 3] == 0;
    }

    public static boolean isNIfTI1DualFileMagicNumber(byte[] byArray, int n) {
        return byArray[n] == 110 && byArray[n + 1] == 105 && byArray[n + 2] == 49 && byArray[n + 3] == 0;
    }

    public boolean isNIfTI1SingleFileMagicNumber() {
        return NIfTI1Header.isNIfTI1SingleFileMagicNumber(this.bytes, 344);
    }

    public boolean isNIfTI1DualFileMagicNumber() {
        return NIfTI1Header.isNIfTI1DualFileMagicNumber(this.bytes, 344);
    }

    public static File getImageDataFile(File file) {
        return new File(file.getParent(), file.getName().replaceFirst("[.][^.]*$", ".img"));
    }

    public NIfTI1Header(File file) throws IOException, NIfTI1Exception {
        BinaryInputStream binaryInputStream;
        BinaryInputStream binaryInputStream2 = new BinaryInputStream(file, false);
        this.bytes = new byte[348];
        binaryInputStream2.readInsistently(this.bytes, 0, 348);
        binaryInputStream2.close();
        if (this.isNIfTI1SingleFileMagicNumber() || this.isNIfTI1DualFileMagicNumber()) {
            int n;
            binaryInputStream = new BinaryInputStream(new ByteArrayInputStream(this.bytes), false);
            binaryInputStream.mark(4);
            this.sizeof_hdr = (int)binaryInputStream.readUnsigned32();
            if (this.sizeof_hdr != 348) {
                binaryInputStream.setBigEndian();
                binaryInputStream.reset();
                this.sizeof_hdr = (int)binaryInputStream.readUnsigned32();
                if (this.sizeof_hdr != 348) {
                    throw new NIfTI1Exception("Cannot determine NIfTI-1 endianness from sizeof_hdr byte order since does not match required size");
                }
                this.bigEndian = true;
                slf4jlogger.info("Is BigEndian");
            } else {
                this.bigEndian = false;
                slf4jlogger.info("Is LittleEndian");
            }
            slf4jlogger.info("Have NIfTI-1 header");
            binaryInputStream.skip(35L);
            this.dim_info = (byte)binaryInputStream.readUnsigned8();
            slf4jlogger.info("dim_info = {}", this.dim_info & 0xFF);
            for (n = 0; n < this.dim.length; ++n) {
                this.dim[n] = (short)binaryInputStream.readUnsigned16();
                slf4jlogger.info("dim{} = {}", n, this.dim[n]);
            }
            this.intent_p1 = binaryInputStream.readFloat();
            slf4jlogger.info("intent_p1 = {}", Float.valueOf(this.intent_p1));
            this.intent_p2 = binaryInputStream.readFloat();
            slf4jlogger.info("intent_p2 = {}", Float.valueOf(this.intent_p2));
            this.intent_p3 = binaryInputStream.readFloat();
            slf4jlogger.info("intent_p3 = {}", Float.valueOf(this.intent_p3));
            this.intent_code = (short)binaryInputStream.readUnsigned16();
            this.intent = Intent.getIntent(this.intent_code);
            slf4jlogger.info("intent = {} {}", new Object[]{this.intent_code & 0xFFFF, this.intent});
            this.datatype_code = (short)binaryInputStream.readUnsigned16();
            this.datatype = DataType.getDataType(this.datatype_code);
            slf4jlogger.info("datatype = {} {}", new Object[]{this.datatype_code & 0xFFFF, this.datatype});
            this.bitpix = (short)binaryInputStream.readUnsigned16();
            slf4jlogger.info("bitpix = {}", this.bitpix & 0xFFFF);
            this.slice_start = (short)binaryInputStream.readUnsigned16();
            slf4jlogger.info("slice_start = {}", this.slice_start & 0xFFFF);
            for (n = 0; n < this.pixdim.length; ++n) {
                this.pixdim[n] = binaryInputStream.readFloat();
                slf4jlogger.info("pixdim[{}] = {}", n, Float.valueOf(this.pixdim[n]));
            }
            this.vox_offset = binaryInputStream.readFloat();
            slf4jlogger.info("vox_offset = {}", Float.valueOf(this.vox_offset));
            this.scl_slope = binaryInputStream.readFloat();
            slf4jlogger.info("scl_slope = {}", Float.valueOf(this.scl_slope));
            this.scl_inter = binaryInputStream.readFloat();
            slf4jlogger.info("scl_inter = {}", Float.valueOf(this.scl_inter));
            this.slice_end = (short)binaryInputStream.readUnsigned16();
            slf4jlogger.info("slice_end = {}", this.slice_end & 0xFFFF);
            this.slice_code = (byte)binaryInputStream.readUnsigned8();
            this.slice_order = SliceOrder.getSliceOrder(this.slice_code);
            slf4jlogger.info("slice_code = {} {}", new Object[]{this.slice_code & 0xFF, this.slice_order});
            this.xyzt_units_code = (byte)binaryInputStream.readUnsigned8();
            this.xyzt_units_code_spatial = (byte)(this.xyzt_units_code & 3);
            this.xyzt_units_code_temporal = (byte)(this.xyzt_units_code & 0x1C);
            this.xyzt_units_spatial = Units.getUnits(this.xyzt_units_code_spatial);
            this.xyzt_units_temporal = Units.getUnits(this.xyzt_units_code_temporal);
            slf4jlogger.info("xyzt_units_code = {}", this.xyzt_units_code & 0xFF);
            slf4jlogger.info("xyzt_units_spatial = {} {}", new Object[]{this.xyzt_units_code_spatial & 0xFF, this.xyzt_units_spatial});
            slf4jlogger.info("xyzt_units_temporal = {} {}", new Object[]{this.xyzt_units_code_temporal & 0xFF, this.xyzt_units_temporal});
            this.cal_max = binaryInputStream.readFloat();
            slf4jlogger.info("cal_max = {}", Float.valueOf(this.cal_max));
            this.cal_min = binaryInputStream.readFloat();
            slf4jlogger.info("cal_min = {}", Float.valueOf(this.cal_min));
            this.slice_duration = binaryInputStream.readFloat();
            slf4jlogger.info("slice_duration = {}", Float.valueOf(this.slice_duration));
            this.toffset = binaryInputStream.readFloat();
            slf4jlogger.info("toffset = {}", Float.valueOf(this.toffset));
            binaryInputStream.skip(8L);
            binaryInputStream.readInsistently(this.description, 0, this.description.length);
            slf4jlogger.info("description = {}", new String(this.description, Charset.forName("US-ASCII")));
            binaryInputStream.readInsistently(this.aux_file, 0, this.aux_file.length);
            slf4jlogger.info("aux_file = {}", new String(this.aux_file, Charset.forName("US-ASCII")));
            this.qform_code = (short)binaryInputStream.readUnsigned16();
            this.qform = CoordinateTransform.getCoordinateTransform(this.qform_code);
            slf4jlogger.info("qform = {} {}", new Object[]{this.qform_code & 0xFFFF, this.qform});
            this.sform_code = (short)binaryInputStream.readUnsigned16();
            this.sform = CoordinateTransform.getCoordinateTransform(this.sform_code);
            slf4jlogger.info("sform = {} {}", new Object[]{this.sform_code & 0xFFFF, this.sform});
            this.quatern_b = binaryInputStream.readFloat();
            slf4jlogger.info("quatern_b = {}", Float.valueOf(this.quatern_b));
            this.quatern_c = binaryInputStream.readFloat();
            slf4jlogger.info("quatern_c = {}", Float.valueOf(this.quatern_c));
            this.quatern_d = binaryInputStream.readFloat();
            slf4jlogger.info("quatern_d = {}", Float.valueOf(this.quatern_d));
            this.qoffset_x = binaryInputStream.readFloat();
            slf4jlogger.info("qoffset_x = {}", Float.valueOf(this.qoffset_x));
            this.qoffset_y = binaryInputStream.readFloat();
            slf4jlogger.info("qoffset_y = {}", Float.valueOf(this.qoffset_y));
            this.qoffset_z = binaryInputStream.readFloat();
            slf4jlogger.info("qoffset_z = {}", Float.valueOf(this.qoffset_z));
            for (n = 0; n < this.srow_x.length; ++n) {
                this.srow_x[n] = binaryInputStream.readFloat();
                slf4jlogger.info("srow_x[{}] = {}", n, Float.valueOf(this.srow_x[n]));
            }
            for (n = 0; n < this.srow_y.length; ++n) {
                this.srow_y[n] = binaryInputStream.readFloat();
                slf4jlogger.info("srow_y[{}] = {}", n, Float.valueOf(this.srow_y[n]));
            }
            for (n = 0; n < this.srow_z.length; ++n) {
                this.srow_z[n] = binaryInputStream.readFloat();
                slf4jlogger.info("srow_z[{}] = {}", n, Float.valueOf(this.srow_z[n]));
            }
        } else {
            throw new NIfTI1Exception("Not a NIfTI-1 magic number");
        }
        binaryInputStream.readInsistently(this.intent_name, 0, this.intent_name.length);
        slf4jlogger.info("intent_name = {}", new String(this.intent_name, Charset.forName("US-ASCII")));
        binaryInputStream.readInsistently(this.magic, 0, this.magic.length);
        slf4jlogger.info("magic = {}", new String(this.magic, Charset.forName("US-ASCII")));
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 1) {
                new NIfTI1Header(new File(stringArray[0]));
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: NIfTI1Header inputFile");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    static enum CoordinateTransform {
        UNKNOWN(0),
        SCANNER_ANAT(1),
        ALIGNED_ANAT(2),
        TALAIRACH(3),
        MNI_152(4);

        private short xform_code;
        static final Map<Short, CoordinateTransform> map;

        private CoordinateTransform(short s) {
            this.xform_code = s;
        }

        static final CoordinateTransform getCoordinateTransform(short s) {
            return map.get(new Short(s));
        }

        static {
            map = new HashMap<Short, CoordinateTransform>();
            for (CoordinateTransform coordinateTransform : CoordinateTransform.values()) {
                map.put(new Short(coordinateTransform.xform_code), coordinateTransform);
            }
        }
    }

    static enum Units {
        UNKNOWN(0),
        METER(1),
        MM(2),
        MICRON(3),
        SEC(8),
        MSEC(16),
        USEC(24),
        HZ(32),
        PPM(40),
        RADS(48);

        private byte units_code;
        static final Map<Byte, Units> map;

        private Units(byte by) {
            this.units_code = by;
        }

        static final Units getUnits(byte by) {
            return map.get(new Byte(by));
        }

        static {
            map = new HashMap<Byte, Units>();
            for (Units units : Units.values()) {
                map.put(new Byte(units.units_code), units);
            }
        }
    }

    static enum SliceOrder {
        UNKNOWN(0),
        SEQ_INC(1),
        SEQ_DEC(2),
        ALT_INC(3),
        ALT_DEC(4),
        ALT_INC2(5),
        ALT_DEC2(6);

        private byte slice_code;
        static final Map<Byte, SliceOrder> map;

        private SliceOrder(byte by) {
            this.slice_code = by;
        }

        static final SliceOrder getSliceOrder(byte by) {
            return map.get(new Byte(by));
        }

        static {
            map = new HashMap<Byte, SliceOrder>();
            for (SliceOrder sliceOrder : SliceOrder.values()) {
                map.put(new Byte(sliceOrder.slice_code), sliceOrder);
            }
        }
    }

    static enum DataType {
        NONE(0),
        UINT8(2),
        INT16(4),
        INT32(8),
        FLOAT32(16),
        COMPLEX64(32),
        FLOAT64(64),
        RGB24(128),
        INT8(256),
        UINT16(512),
        UINT32(768),
        INT64(1024),
        UINT64(1280),
        FLOAT128(1536),
        COMPLEX128(1792),
        COMPLEX256(2048),
        RGBA32(2304);

        private short datatype;
        static final Map<Short, DataType> map;

        private DataType(short s) {
            this.datatype = s;
        }

        static final DataType getDataType(short s) {
            return map.get(new Short(s));
        }

        static {
            map = new HashMap<Short, DataType>();
            for (DataType dataType : DataType.values()) {
                map.put(new Short(dataType.datatype), dataType);
            }
        }
    }

    static enum Intent {
        NONE(0),
        CORREL(2),
        TTEST(3),
        FTEST(4),
        ZSCORE(5),
        CHISQ(6),
        BETA(7),
        BINOM(8),
        GAMMA(9),
        POISSON(10),
        NORMAL(11),
        FTEST_NONC(12),
        CHISQ_NONC(13),
        LOGISTIC(14),
        LAPLACE(15),
        UNIFORM(16),
        TTEST_NONC(17),
        WEIBULL(18),
        CHI(19),
        INVGAUSS(20),
        EXTVAL(21),
        PVAL(22),
        LOGPVAL(23),
        LOG10PVAL(24),
        ESTIMATE(1001),
        LABEL(1002),
        NEURONAME(1003),
        GENMATRIX(1004),
        SYMMATRIX(1005),
        DISPVECT(1006),
        VECTOR(1007),
        POINTSET(1008),
        TRIANGLE(1009),
        QUATERNION(1010),
        DIMLESS(1011),
        TIME_SERIES(2001),
        NODE_INDEX(2002),
        RGB_VECTOR(2003),
        RGBA_VECTOR(2004),
        SHAPE(2005);

        private short intent;
        static final Map<Short, Intent> map;

        private Intent(short s) {
            this.intent = s;
        }

        boolean isStatistic() {
            return this.intent >= Intent.CORREL.intent && this.intent <= Intent.LOG10PVAL.intent;
        }

        static final Intent getIntent(short s) {
            return map.get(new Short(s));
        }

        static {
            map = new HashMap<Short, Intent>();
            for (Intent intent : Intent.values()) {
                map.put(new Short(intent.intent), intent);
            }
        }
    }
}

