/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.convert.NRRDException;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class NRRDHeader {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/NRRDHeader.java,v 1.14 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(NRRDHeader.class);
    public String magic;
    public int byte_offset_of_binary;
    public Map<String, String> fields = new TreeMap<String, String>();
    public Map<String, String> keys = new TreeMap<String, String>();

    public static String[] getSpaceDelimitedValues(String string) {
        return string.split(" ");
    }

    public Type getType() {
        Type type = null;
        String string = this.fields.get("type");
        if (string != null) {
            type = Type.getType(string);
        }
        return type;
    }

    public int getSingleIntegerValueOrThrowException(String string) throws NRRDException, NumberFormatException {
        String string2 = this.fields.get(string);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        throw new NRRDException("Missing value of " + string);
    }

    public int[] getArrayOfIntegerValueOrThrowException(String string) throws NRRDException, NumberFormatException {
        String string2 = this.fields.get(string);
        if (string2 != null) {
            String[] stringArray = NRRDHeader.getSpaceDelimitedValues(string2);
            if (stringArray != null && stringArray.length > 0) {
                int[] nArray = new int[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    nArray[i] = Integer.parseInt(stringArray[i]);
                }
                return nArray;
            }
            throw new NRRDException("Missing value of " + string);
        }
        throw new NRRDException("Missing value of " + string);
    }

    public static String[] getVectorTripleValuesFromString(String string, String string2) throws NRRDException {
        String[] stringArray = null;
        if ((string2 = string2.trim()).startsWith("(") && string2.endsWith(")")) {
            string2 = string2.replace("(", "");
            stringArray = (string2 = string2.replace(")", "")).split(",");
            if (stringArray.length != 3) {
                throw new NRRDException("vector value of " + string + " does not contain three values': " + string2);
            }
        } else {
            throw new NRRDException("vector value of " + string + " not enclosed in '(' and ')': " + string2);
        }
        return stringArray;
    }

    public int getDimension() throws NRRDException, NumberFormatException {
        return this.getSingleIntegerValueOrThrowException("dimension");
    }

    public int[] getSizes() throws NRRDException, NumberFormatException {
        return this.getArrayOfIntegerValueOrThrowException("sizes");
    }

    public String getSpace() {
        return this.fields.get("space");
    }

    public String[] getSpaceDirections() {
        String[] stringArray = null;
        String string = this.fields.get("space directions");
        if (string != null) {
            stringArray = NRRDHeader.getSpaceDelimitedValues(string);
        }
        return stringArray;
    }

    public String[] getSpaceOrigin() throws NRRDException {
        String[] stringArray = null;
        String string = this.fields.get("space origin");
        if (string != null) {
            stringArray = NRRDHeader.getVectorTripleValuesFromString("space origin", string);
        }
        return stringArray;
    }

    public boolean isDataBigEndian() {
        String string = this.fields.get("endian");
        return string != null && string.equals("big");
    }

    public boolean isDataGZIPEncoded() {
        String string = this.fields.get("encoding");
        return string != null && string.equals("gzip");
    }

    public String getDataFile() {
        return this.fields.get("data file");
    }

    public NRRDHeader(File file) throws IOException, NRRDException {
        Object object;
        String[] stringArray;
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
        this.magic = lineNumberReader.readLine();
        if (this.magic == null || !this.magic.startsWith("NRRD")) {
            throw new NRRDException("Not an NRRD magic number");
        }
        while ((string = lineNumberReader.readLine()) != null && string.length() > 0) {
            String string2;
            if (string.startsWith("#")) {
                stringArray = string;
                slf4jlogger.info("Comment: \"{}\"", new Object[]{stringArray});
                continue;
            }
            stringArray = string.split(": ", 2);
            if (stringArray.length == 2) {
                object = stringArray[0];
                string2 = stringArray[1];
                this.fields.put((String)object, string2);
                slf4jlogger.info("Field: \"{}\" Description: \"{}\"", object, string2);
                continue;
            }
            stringArray = string.split(":=", 2);
            if (stringArray.length == 2) {
                object = stringArray[0];
                string2 = stringArray[1];
                this.keys.put((String)object, string2);
                slf4jlogger.info("Key: \"{}\" Value: \"{}\"", object, string2);
                continue;
            }
            slf4jlogger.info("Unrecognized pattern of NRRD header line # {}: \"{}\"", lineNumberReader.getLineNumber(), string);
        }
        lineNumberReader.close();
        stringArray = this.fields.get("data file");
        if (stringArray == null || stringArray.trim().length() == 0) {
            int n;
            this.byte_offset_of_binary = 0;
            object = new FileInputStream(file);
            boolean bl = true;
            while ((n = ((InputStream)object).read()) != -1) {
                ++this.byte_offset_of_binary;
                if (n == 10) {
                    if (bl) break;
                    bl = true;
                    continue;
                }
                if (n == 13) continue;
                bl = false;
            }
            ((InputStream)object).close();
            slf4jlogger.info("byte_offset_of_binary = {}", this.byte_offset_of_binary);
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 1) {
                new NRRDHeader(new File(stringArray[0]));
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: NRRDHeader inputFile");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    static enum Type {
        NONE,
        INT8,
        UINT8,
        INT16,
        UINT16,
        INT32,
        UINT32,
        INT64,
        UINT64,
        FLOAT32,
        FLOAT64,
        BLOCK;

        static final Map<String, Type> map;

        static final Type getType(String string) {
            return map.get(string);
        }

        static {
            map = new HashMap<String, Type>();
            map.put("signed char", INT8);
            map.put("int8", INT8);
            map.put("int8_t", INT8);
            map.put("uchar", UINT8);
            map.put("unsigned char", UINT8);
            map.put("uint8", UINT8);
            map.put("uint8_t", UINT8);
            map.put("short", INT16);
            map.put("short int", INT16);
            map.put("signed short", INT16);
            map.put("signed short int", INT16);
            map.put("int16", INT16);
            map.put("int16_t", INT16);
            map.put("ushort", UINT16);
            map.put("unsigned short", UINT16);
            map.put("unsigned short int", UINT16);
            map.put("uint16", UINT16);
            map.put("uint16_t", UINT16);
            map.put("int", INT32);
            map.put("signed int", INT32);
            map.put("int32", INT32);
            map.put("int32_t", INT32);
            map.put("uint", UINT32);
            map.put("unsigned int", UINT32);
            map.put("uint32", UINT32);
            map.put("uint32_t", UINT32);
            map.put("longlong", INT64);
            map.put("long long", INT64);
            map.put("long long int", INT64);
            map.put("signed long long", INT64);
            map.put("signed long long int", INT64);
            map.put("int64", INT64);
            map.put("int64_t", INT64);
            map.put("ulonglong", UINT64);
            map.put("unsigned long long", UINT64);
            map.put("unsigned long long int", UINT64);
            map.put("uint64", UINT64);
            map.put("uint64_t", UINT64);
            map.put("float", FLOAT32);
            map.put("double", FLOAT64);
            map.put("block", BLOCK);
        }
    }
}

