/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.convert.CommonConvertedAttributeGeneration;
import com.pixelmed.convert.NRRDException;
import com.pixelmed.convert.NRRDHeader;
import com.pixelmed.dicom.ArrayCopyUtilities;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTagAttribute;
import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodingSchemeIdentification;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.FunctionalGroupUtilities;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherDoubleAttribute;
import com.pixelmed.dicom.OtherFloatAttribute;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedLongAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.CopyStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;

public class NRRDToDicom {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/NRRDToDicom.java,v 1.27 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(NRRDToDicom.class);
    private static boolean preSpatialDimensionsLeastRapidlyVaryingInOutput = false;

    public static AttributeList generateGeometryFunctionalGroupsFromNRRDHeader(NRRDHeader nRRDHeader, AttributeList attributeList) throws DicomException, NRRDException, NumberFormatException {
        Object[] objectArray;
        String string = nRRDHeader.getSpace();
        double[] dArray = new double[]{1.0, 1.0, 1.0};
        if (string != null) {
            if (string.equals("right-anterior-superior") || string.equals("RAS") || string.equals("right-anterior-superior-time") || string.equals("RAST")) {
                dArray[0] = -1.0;
                dArray[1] = -1.0;
                dArray[2] = 1.0;
            } else if (string.equals("left-anterior-superior") || string.equals("LAS") || string.equals("left-anterior-superior-time") || string.equals("LAST")) {
                dArray[0] = 1.0;
                dArray[1] = -1.0;
                dArray[2] = 1.0;
            } else if (string.equals("left-posterior-superior") || string.equals("LPS") || string.equals("left-posterior-superior-time") || string.equals("LPST")) {
                dArray[0] = 1.0;
                dArray[1] = 1.0;
                dArray[2] = 1.0;
            } else {
                slf4jlogger.info("Warning: non-patient-relative coordinate space {} so position and coordinates in DICOM images may be incorrect", string);
            }
        }
        Object[] objectArray2 = nRRDHeader.getSpaceOrigin();
        slf4jlogger.info("spaceOrigin array = {}", Arrays.toString(objectArray2));
        double[] dArray2 = new double[]{Double.parseDouble((String)objectArray2[0]), Double.parseDouble((String)objectArray2[1]), Double.parseDouble((String)objectArray2[2])};
        double[] dArray3 = new double[3];
        double[][] dArrayArray = new double[3][];
        double[][] dArrayArray2 = new double[3][];
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        int n4 = 0;
        int[] nArray = nRRDHeader.getSizes();
        String[] stringArray = nRRDHeader.getSpaceDirections();
        if (stringArray != null) {
            int n5 = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                double d;
                if (stringArray[i].equals("none")) {
                    if (n5 == -1) {
                        n2 *= nArray[i];
                        continue;
                    }
                    n3 *= nArray[i];
                    continue;
                }
                if (++n5 == 2) {
                    n = nArray[i];
                }
                objectArray = NRRDHeader.getVectorTripleValuesFromString("space directions[" + i + "]", stringArray[i]);
                slf4jlogger.info("space directions[{}] vector array = {}", i, Arrays.toString(objectArray));
                dArrayArray[n5] = new double[3];
                double d2 = Double.parseDouble((String)objectArray[0]);
                double d3 = Double.parseDouble((String)objectArray[1]);
                double d4 = Double.parseDouble((String)objectArray[2]);
                dArrayArray[n5][0] = d2;
                dArrayArray[n5][1] = d3;
                dArrayArray[n5][2] = d4;
                slf4jlogger.info("rowColumnAndSliceDirectionVectors[{}][0] = {}", n5, dArrayArray[n5][0]);
                slf4jlogger.info("rowColumnAndSliceDirectionVectors[{}][1] = {}", n5, dArrayArray[n5][1]);
                slf4jlogger.info("rowColumnAndSliceDirectionVectors[{}][2] = {}", n5, dArrayArray[n5][2]);
                dArray3[n5] = d = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
                slf4jlogger.info("spacing[{}] = {}", n5, dArray3[n5]);
                dArrayArray2[n5] = new double[3];
                dArrayArray2[n5][0] = d2 / d;
                dArrayArray2[n5][1] = d3 / d;
                dArrayArray2[n5][2] = d4 / d;
                slf4jlogger.info("rowColumnAndSliceDirectionUnitVectors[{}][0] = {}", n5, dArrayArray2[n5][0]);
                slf4jlogger.info("rowColumnAndSliceDirectionUnitVectors[{}][1] = {}", n5, dArrayArray2[n5][1]);
                slf4jlogger.info("rowColumnAndSliceDirectionUnitVectors[{}][2] = {}", n5, dArrayArray2[n5][2]);
            }
            n4 = n2 * n * n3;
        }
        attributeList = FunctionalGroupUtilities.createFunctionalGroupsIfNotPresent(attributeList, n4);
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
        SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        objectArray = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(sequenceAttribute);
        SequenceAttribute sequenceAttribute3 = new SequenceAttribute(TagFromName.PixelMeasuresSequence);
        objectArray.put(sequenceAttribute3);
        AttributeList attributeList2 = new AttributeList();
        sequenceAttribute3.addItem(attributeList2);
        DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(TagFromName.PixelSpacing);
        ((Attribute)decimalStringAttribute).addValue(dArray3[1]);
        ((Attribute)decimalStringAttribute).addValue(dArray3[0]);
        attributeList2.put(decimalStringAttribute);
        decimalStringAttribute = new DecimalStringAttribute(TagFromName.SliceThickness);
        ((Attribute)decimalStringAttribute).addValue(dArray3[2]);
        attributeList2.put(decimalStringAttribute);
        decimalStringAttribute = new DecimalStringAttribute(TagFromName.SpacingBetweenSlices);
        ((Attribute)decimalStringAttribute).addValue(dArray3[2]);
        attributeList2.put(decimalStringAttribute);
        sequenceAttribute3 = new SequenceAttribute(TagFromName.PlaneOrientationSequence);
        objectArray.put(sequenceAttribute3);
        attributeList2 = new AttributeList();
        sequenceAttribute3.addItem(attributeList2);
        decimalStringAttribute = new DecimalStringAttribute(TagFromName.ImageOrientationPatient);
        ((Attribute)decimalStringAttribute).addValue(dArray[0] * dArrayArray2[0][0]);
        ((Attribute)decimalStringAttribute).addValue(dArray[1] * dArrayArray2[0][1]);
        ((Attribute)decimalStringAttribute).addValue(dArray[2] * dArrayArray2[0][2]);
        ((Attribute)decimalStringAttribute).addValue(dArray[0] * dArrayArray2[1][0]);
        ((Attribute)decimalStringAttribute).addValue(dArray[1] * dArrayArray2[1][1]);
        ((Attribute)decimalStringAttribute).addValue(dArray[2] * dArrayArray2[1][2]);
        attributeList2.put(decimalStringAttribute);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n2; ++k) {
                    int n6 = preSpatialDimensionsLeastRapidlyVaryingInOutput ? (i * n2 + k) * n + j : (i * n + j) * n2 + k;
                    SequenceAttribute sequenceAttribute4 = new SequenceAttribute(TagFromName.PlanePositionSequence);
                    SequenceAttribute.getAttributeListFromSelectedItemWithinSequence(sequenceAttribute2, n6).put(sequenceAttribute4);
                    AttributeList attributeList3 = new AttributeList();
                    sequenceAttribute4.addItem(attributeList3);
                    Attribute attribute = new DecimalStringAttribute(TagFromName.ImagePositionPatient);
                    attribute.addValue(dArray[0] * (dArrayArray[2][0] * (double)j + dArray2[0]));
                    attribute.addValue(dArray[1] * (dArrayArray[2][1] * (double)j + dArray2[1]));
                    attribute.addValue(dArray[2] * (dArrayArray[2][2] * (double)j + dArray2[2]));
                    attributeList3.put(attribute);
                    sequenceAttribute4 = new SequenceAttribute(TagFromName.FrameContentSequence);
                    SequenceAttribute.getAttributeListFromSelectedItemWithinSequence(sequenceAttribute2, n6).put(sequenceAttribute4);
                    attributeList3 = new AttributeList();
                    sequenceAttribute4.addItem(attributeList3);
                    attribute = new ShortStringAttribute(TagFromName.StackID);
                    attribute.addValue(i + 1);
                    attributeList3.put(attribute);
                    attribute = new UnsignedLongAttribute(TagFromName.InStackPositionNumber);
                    attribute.addValue(j + 1);
                    attributeList3.put(attribute);
                    attribute = new UnsignedLongAttribute(TagFromName.DimensionIndexValues);
                    attribute.addValue(i + 1);
                    attribute.addValue(j + 1);
                    attributeList3.put(attribute);
                }
            }
        }
        return attributeList;
    }

    public static AttributeList generateDimensions(AttributeList attributeList) throws DicomException {
        UIDGenerator uIDGenerator = new UIDGenerator();
        String string = uIDGenerator.getAnotherNewUID();
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.DimensionOrganizationSequence);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList2 = new AttributeList();
        sequenceAttribute.addItem(attributeList2);
        Attribute attribute = new UniqueIdentifierAttribute(TagFromName.DimensionOrganizationUID);
        attribute.addValue(string);
        attributeList2.put(attribute);
        sequenceAttribute = new SequenceAttribute(TagFromName.DimensionIndexSequence);
        attributeList.put(sequenceAttribute);
        attributeList2 = new AttributeList();
        sequenceAttribute.addItem(attributeList2);
        attribute = new AttributeTagAttribute(TagFromName.DimensionIndexPointer);
        ((AttributeTagAttribute)attribute).addValue(TagFromName.StackID);
        attributeList2.put(attribute);
        attribute = new AttributeTagAttribute(TagFromName.FunctionalGroupPointer);
        ((AttributeTagAttribute)attribute).addValue(TagFromName.FrameContentSequence);
        attributeList2.put(attribute);
        attribute = new UniqueIdentifierAttribute(TagFromName.DimensionOrganizationUID);
        attribute.addValue(string);
        attributeList2.put(attribute);
        attribute = new LongStringAttribute(TagFromName.DimensionDescriptionLabel);
        attribute.addValue("StackID");
        attributeList2.put(attribute);
        attributeList2 = new AttributeList();
        sequenceAttribute.addItem(attributeList2);
        attribute = new AttributeTagAttribute(TagFromName.DimensionIndexPointer);
        ((AttributeTagAttribute)attribute).addValue(TagFromName.InStackPositionNumber);
        attributeList2.put(attribute);
        attribute = new AttributeTagAttribute(TagFromName.FunctionalGroupPointer);
        ((AttributeTagAttribute)attribute).addValue(TagFromName.FrameContentSequence);
        attributeList2.put(attribute);
        attribute = new UniqueIdentifierAttribute(TagFromName.DimensionOrganizationUID);
        attribute.addValue(string);
        attributeList2.put(attribute);
        attribute = new LongStringAttribute(TagFromName.DimensionDescriptionLabel);
        attribute.addValue("InStackPositionNumber");
        attributeList2.put(attribute);
        return attributeList;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AttributeList generateDICOMPixelDataModuleAttributesFromNRRDFile(File file, NRRDHeader nRRDHeader, AttributeList attributeList) throws IOException, DicomException, NRRDException, NumberFormatException {
        Object object;
        Object object2;
        int n;
        int n2;
        if (attributeList == null) {
            attributeList = new AttributeList();
        }
        if ((n2 = nRRDHeader.getDimension()) < 2) {
            throw new DicomException("Cannot convert if less than two dimensions");
        }
        int[] nArray = nRRDHeader.getSizes();
        if (n2 != nArray.length) {
            throw new DicomException("Inconsistent number of dimensions = " + n2 + " and length of size array = " + nArray.length);
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        int n7 = 1;
        int n8 = 1;
        String[] stringArray = nRRDHeader.getSpaceDirections();
        if (stringArray == null) {
            if (n2 > 3) throw new DicomException("Number of dimensions is greater than 3 (" + n2 + ") and no information about which dimensions are space");
            n3 = nArray[0];
            n4 = nArray[1];
            n5 = n2 == 3 ? nArray[2] : 1;
        } else {
            if (n2 != stringArray.length) throw new DicomException("Inconsistent number of dimensions = " + n2 + " and length of space directions array = " + stringArray.length);
            int n9 = -1;
            for (n = 0; n < n2; ++n) {
                if (stringArray[n].equals("none")) {
                    if (n9 == -1) {
                        n7 *= nArray[n];
                        continue;
                    }
                    n8 *= nArray[n];
                    continue;
                }
                if (++n9 == 0) {
                    n3 = nArray[n];
                    continue;
                }
                if (n9 == 1) {
                    n4 = nArray[n];
                    continue;
                }
                if (n9 != 2) throw new DicomException("More than three spatial dimensions in space directions");
                n6 = nArray[n];
            }
            n5 = n7 * n6 * n8;
        }
        slf4jlogger.info("numberOfScalarsPerVoxel = {}", n7);
        slf4jlogger.info("columns = {}", n3);
        slf4jlogger.info("rows = {}", n4);
        slf4jlogger.info("numberOfSlicesInVolume = {}", n6);
        slf4jlogger.info("numberOfSpatialVolumes = {}", n8);
        slf4jlogger.info("numberOfFrames = {}", n5);
        String string = null;
        n = 0;
        int n10 = 0;
        int n11 = 0;
        Attribute attribute = null;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        NRRDHeader.Type type = nRRDHeader.getType();
        switch (type) {
            case INT8: {
                attribute = new OtherByteAttribute(TagFromName.PixelData);
                n11 = 1;
                n10 = 8;
                n = 1;
                string = "MONOCHROME2";
                break;
            }
            case UINT8: {
                attribute = new OtherByteAttribute(TagFromName.PixelData);
                n11 = 0;
                n10 = 8;
                n = 1;
                string = "MONOCHROME2";
                break;
            }
            case INT16: {
                attribute = new OtherWordAttribute(TagFromName.PixelData);
                n11 = 1;
                n10 = 16;
                n = 1;
                string = "MONOCHROME2";
                break;
            }
            case UINT16: {
                attribute = new OtherWordAttribute(TagFromName.PixelData);
                n11 = 0;
                n10 = 16;
                n = 1;
                string = "MONOCHROME2";
                break;
            }
            case INT32: {
                throw new DicomException("Conversion of " + (Object)((Object)type) + " not supported");
            }
            case UINT32: {
                throw new DicomException("Conversion of " + (Object)((Object)type) + " not supported");
            }
            case INT64: {
                throw new DicomException("Conversion of " + (Object)((Object)type) + " not supported");
            }
            case UINT64: {
                throw new DicomException("Conversion of " + (Object)((Object)type) + " not supported");
            }
            case FLOAT32: {
                attribute = new OtherFloatAttribute(TagFromName.FloatPixelData);
                bl3 = false;
                n11 = 0;
                n10 = 32;
                bl = false;
                bl2 = false;
                n = 1;
                string = "MONOCHROME2";
                break;
            }
            case FLOAT64: {
                attribute = new OtherDoubleAttribute(TagFromName.DoubleFloatPixelData);
                bl3 = false;
                n11 = 0;
                n10 = 64;
                bl = false;
                bl2 = false;
                n = 1;
                string = "MONOCHROME2";
                break;
            }
            case BLOCK: {
                throw new DicomException("Conversion of " + (Object)((Object)type) + " not supported");
            }
            default: {
                throw new DicomException("Conversion of " + (Object)((Object)type) + " not supported");
            }
        }
        long l = 0L;
        String string2 = nRRDHeader.getDataFile();
        File file2 = null;
        if (string2 != null) {
            file2 = new File(file.getParentFile(), string2);
        } else if (nRRDHeader.byte_offset_of_binary > 0) {
            file2 = file;
            l = nRRDHeader.byte_offset_of_binary;
        }
        double d = 0.0;
        double d2 = 0.0;
        boolean bl4 = false;
        if (file2 != null) {
            int n12;
            int n13;
            object2 = new BufferedInputStream(new FileInputStream(file2));
            if (l > 0L) {
                CopyStream.skipInsistently((InputStream)object2, l);
            }
            if (nRRDHeader.isDataGZIPEncoded()) {
                object2 = new GZIPInputStream((InputStream)object2);
            }
            BinaryInputStream binaryInputStream = new BinaryInputStream((InputStream)object2, nRRDHeader.isDataBigEndian());
            int n14 = n4 * n3 * n5 * n;
            if (attribute instanceof OtherByteAttribute) {
                void var33_35;
                byte[] byArray = new byte[n14];
                binaryInputStream.readInsistently(byArray, 0, n14);
                if (n7 > 1) {
                    object = new byte[n14];
                    int n15 = 0;
                    for (n13 = 0; n13 < n8; ++n13) {
                        for (int i = 0; i < n6; ++i) {
                            for (n12 = 0; n12 < n4; ++n12) {
                                for (int j = 0; j < n3; ++j) {
                                    for (int k = 0; k < n7; ++k) {
                                        int n16 = preSpatialDimensionsLeastRapidlyVaryingInOutput ? (n13 * n7 + k) * n6 + i : (n13 * n6 + i) * n7 + k;
                                        int n17 = (n16 * n4 + n12) * n3 + j;
                                        object[n17] = byArray[n15++];
                                    }
                                }
                            }
                        }
                    }
                    Object[] objectArray = object;
                }
                attribute.setValues((byte[])var33_35);
            } else if (attribute instanceof OtherWordAttribute) {
                void var33_38;
                short[] sArray = new short[n14];
                binaryInputStream.readUnsigned16(sArray, 0, n14);
                if (n7 > 1) {
                    object = new short[n14];
                    int n18 = 0;
                    for (n13 = 0; n13 < n8; ++n13) {
                        for (int i = 0; i < n6; ++i) {
                            for (n12 = 0; n12 < n4; ++n12) {
                                for (int j = 0; j < n3; ++j) {
                                    for (int k = 0; k < n7; ++k) {
                                        int n19 = preSpatialDimensionsLeastRapidlyVaryingInOutput ? (n13 * n7 + k) * n6 + i : (n13 * n6 + i) * n7 + k;
                                        int n20 = (n19 * n4 + n12) * n3 + j;
                                        object[n20] = sArray[n18++];
                                    }
                                }
                            }
                        }
                    }
                    Object[] objectArray = object;
                }
                attribute.setValues((short[])var33_38);
            } else if (attribute instanceof OtherFloatAttribute) {
                void var33_41;
                float[] fArray = new float[n14];
                binaryInputStream.readFloat(fArray, n14);
                if (n7 > 1) {
                    object = new float[n14];
                    int n21 = 0;
                    for (n13 = 0; n13 < n8; ++n13) {
                        for (int i = 0; i < n6; ++i) {
                            for (n12 = 0; n12 < n4; ++n12) {
                                for (int j = 0; j < n3; ++j) {
                                    for (int k = 0; k < n7; ++k) {
                                        int n22 = preSpatialDimensionsLeastRapidlyVaryingInOutput ? (n13 * n7 + k) * n6 + i : (n13 * n6 + i) * n7 + k;
                                        int n23 = (n22 * n4 + n12) * n3 + j;
                                        object[n23] = fArray[n21++];
                                    }
                                }
                            }
                        }
                    }
                    Object[] objectArray = object;
                }
                attribute.setValues((float[])var33_41);
                object = ArrayCopyUtilities.minMax((float[])var33_41);
                d = object[0];
                d2 = object[1];
                bl4 = true;
            } else if (attribute instanceof OtherDoubleAttribute) {
                void var33_44;
                double[] dArray = new double[n14];
                binaryInputStream.readDouble(dArray, n14);
                if (n7 > 1) {
                    object = new double[n14];
                    int n24 = 0;
                    for (n13 = 0; n13 < n8; ++n13) {
                        for (int i = 0; i < n6; ++i) {
                            for (n12 = 0; n12 < n4; ++n12) {
                                for (int j = 0; j < n3; ++j) {
                                    for (int k = 0; k < n7; ++k) {
                                        int n25 = preSpatialDimensionsLeastRapidlyVaryingInOutput ? (n13 * n7 + k) * n6 + i : (n13 * n6 + i) * n7 + k;
                                        int n26 = (n25 * n4 + n12) * n3 + j;
                                        object[n26] = dArray[n24++];
                                    }
                                }
                            }
                        }
                    }
                    Object[] objectArray = object;
                }
                attribute.setValues((double[])var33_44);
                object = ArrayCopyUtilities.minMax((double[])var33_44);
                d = object[0];
                d2 = object[1];
                bl4 = true;
            }
            binaryInputStream.close();
            ((InputStream)object2).close();
        }
        attributeList.put(attribute);
        object2 = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
        ((Attribute)object2).addValue(string);
        attributeList.put((Attribute)object2);
        object2 = new UnsignedShortAttribute(TagFromName.BitsAllocated);
        ((Attribute)object2).addValue(n10);
        attributeList.put((Attribute)object2);
        if (bl) {
            object2 = new UnsignedShortAttribute(TagFromName.BitsStored);
            ((Attribute)object2).addValue(n10);
            attributeList.put((Attribute)object2);
        }
        if (bl2) {
            object2 = new UnsignedShortAttribute(TagFromName.HighBit);
            ((Attribute)object2).addValue(n10 - 1);
            attributeList.put((Attribute)object2);
        }
        object2 = new UnsignedShortAttribute(TagFromName.Rows);
        ((Attribute)object2).addValue(n4);
        attributeList.put((Attribute)object2);
        object2 = new UnsignedShortAttribute(TagFromName.Columns);
        ((Attribute)object2).addValue(n3);
        attributeList.put((Attribute)object2);
        if (bl3) {
            object2 = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
            ((Attribute)object2).addValue(n11);
            attributeList.put((Attribute)object2);
        }
        attributeList.remove(TagFromName.NumberOfFrames);
        if (n5 > 1) {
            object2 = new IntegerStringAttribute(TagFromName.NumberOfFrames);
            ((Attribute)object2).addValue(n5);
            attributeList.put((Attribute)object2);
        }
        object2 = new UnsignedShortAttribute(TagFromName.SamplesPerPixel);
        ((Attribute)object2).addValue(n);
        attributeList.put((Attribute)object2);
        attributeList.remove(TagFromName.PlanarConfiguration);
        if (n > 1) {
            object2 = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
            ((Attribute)object2).addValue(0);
            attributeList.put((Attribute)object2);
        }
        if (n != 1) return attributeList;
        double d3 = 1.0;
        double d4 = 0.0;
        object = new CodeStringAttribute(TagFromName.PresentationLUTShape);
        ((Attribute)object).addValue("IDENTITY");
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.RescaleSlope);
        ((Attribute)object).addValue(d3);
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.RescaleIntercept);
        ((Attribute)object).addValue(d4);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.RescaleType);
        ((Attribute)object).addValue("US");
        attributeList.put((Attribute)object);
        if (!bl4) return attributeList;
        double d5 = d2 - d;
        double d6 = (d2 + d) / 2.0;
        StringAttribute stringAttribute = new DecimalStringAttribute(TagFromName.WindowWidth);
        ((Attribute)stringAttribute).addValue(d5);
        attributeList.put(stringAttribute);
        stringAttribute = new DecimalStringAttribute(TagFromName.WindowCenter);
        ((Attribute)stringAttribute).addValue(d6);
        attributeList.put(stringAttribute);
        stringAttribute = new CodeStringAttribute(TagFromName.VOILUTFunction);
        ((Attribute)stringAttribute).addValue(attribute instanceof OtherFloatAttribute || attribute instanceof OtherDoubleAttribute ? "LINEAR_EXACT" : "LINEAR");
        attributeList.put(stringAttribute);
        return attributeList;
    }

    public NRRDToDicom(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws IOException, DicomException, NRRDException {
        this(string, string2, string3, string4, string5, string6, string7, null, null);
    }

    public NRRDToDicom(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws IOException, DicomException, NRRDException, NumberFormatException {
        File file = new File(string);
        NRRDHeader nRRDHeader = new NRRDHeader(file);
        AttributeList attributeList = NRRDToDicom.generateDICOMPixelDataModuleAttributesFromNRRDFile(file, nRRDHeader, null);
        CommonConvertedAttributeGeneration.generateCommonAttributes(attributeList, string3, string4, string5, string6, string7, string8, string9, true);
        string9 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
        if (SOPClass.isEnhancedMultiframeImageStorage(string9)) {
            NRRDToDicom.generateGeometryFunctionalGroupsFromNRRDHeader(nRRDHeader, attributeList);
            NRRDToDicom.generateDimensions(attributeList);
        }
        LongStringAttribute longStringAttribute = new LongStringAttribute(TagFromName.ManufacturerModelName);
        ((Attribute)longStringAttribute).addValue(this.getClass().getName());
        attributeList.put(longStringAttribute);
        CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(attributeList);
        attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(string2, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        try {
            if (stringArray.length != 7) {
                if (stringArray.length == 8) {
                    string = stringArray[7];
                } else if (stringArray.length == 9) {
                    string = stringArray[7];
                    string2 = stringArray[8];
                } else {
                    System.err.println("Error: Incorrect number of arguments");
                    System.err.println("Usage: NRRDToDicom inputFile outputFile patientName patientID studyID seriesNumber instanceNumber [modality [SOPClass]]");
                    System.exit(1);
                }
            }
            new NRRDToDicom(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6], string, string2);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

