/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;

public class RawImageDescription {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/RawImageDescription.java,v 1.9 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(RawImageDescription.class);
    protected Type type;
    protected int rows;
    protected int columns;
    protected int frames;
    protected boolean isDataBigEndian;

    public Type getType() {
        return this.type;
    }

    public RawImageDescription(File file) throws IOException, NumberFormatException {
        JsonReader jsonReader = Json.createReader((Reader)new FileReader(file));
        JsonObject jsonObject = jsonReader.readObject();
        for (String string : jsonObject.keySet()) {
            JsonValue jsonValue = (JsonValue)jsonObject.get((Object)string);
            switch (string) {
                case "type": {
                    this.type = Type.getType(((JsonString)jsonValue).getString());
                    break;
                }
                case "rows": {
                    this.rows = Integer.parseInt(((JsonString)jsonValue).getString());
                    break;
                }
                case "columns": {
                    this.columns = Integer.parseInt(((JsonString)jsonValue).getString());
                    break;
                }
                case "frames": {
                    this.frames = Integer.parseInt(((JsonString)jsonValue).getString());
                    break;
                }
                case "endian": {
                    this.isDataBigEndian = ((JsonString)jsonValue).getString().toLowerCase().equals("big");
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("type = " + Type.toString(this.type) + "\n");
        stringBuffer.append("rows = " + this.rows + "\n");
        stringBuffer.append("columns = " + this.columns + "\n");
        stringBuffer.append("frames = " + this.frames + "\n");
        stringBuffer.append("endian = " + (this.isDataBigEndian ? "big" : "little") + "\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 1) {
                RawImageDescription rawImageDescription = new RawImageDescription(new File(stringArray[0]));
                System.err.println(rawImageDescription.toString());
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: RawImageDescription formatFile");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    static enum Type {
        NONE,
        INT8,
        UINT8,
        INT16,
        UINT16,
        INT32,
        UINT32,
        INT64,
        UINT64,
        FLOAT32,
        FLOAT64;

        static final Map<String, Type> map;

        static final Type getType(String string) {
            return map.get(string.toLowerCase());
        }

        public static String toString(Type type) {
            String string = "none";
            switch (type) {
                case INT8: {
                    string = "int8";
                    break;
                }
                case UINT8: {
                    string = "uint8";
                    break;
                }
                case INT16: {
                    string = "int16";
                    break;
                }
                case UINT16: {
                    string = "uint16";
                    break;
                }
                case INT32: {
                    string = "int32";
                    break;
                }
                case UINT32: {
                    string = "uint32";
                    break;
                }
                case INT64: {
                    string = "int64";
                    break;
                }
                case UINT64: {
                    string = "uint64";
                    break;
                }
                case FLOAT32: {
                    string = "float";
                    break;
                }
                case FLOAT64: {
                    string = "double";
                }
            }
            return string;
        }

        static {
            map = new HashMap<String, Type>();
            map.put("signed char", INT8);
            map.put("int8", INT8);
            map.put("int8_t", INT8);
            map.put("uchar", UINT8);
            map.put("unsigned char", UINT8);
            map.put("uint8", UINT8);
            map.put("uint8_t", UINT8);
            map.put("short", INT16);
            map.put("short int", INT16);
            map.put("signed short", INT16);
            map.put("signed short int", INT16);
            map.put("int16", INT16);
            map.put("int16_t", INT16);
            map.put("ushort", UINT16);
            map.put("unsigned short", UINT16);
            map.put("unsigned short int", UINT16);
            map.put("uint16", UINT16);
            map.put("uint16_t", UINT16);
            map.put("int", INT32);
            map.put("signed int", INT32);
            map.put("int32", INT32);
            map.put("int32_t", INT32);
            map.put("uint", UINT32);
            map.put("unsigned int", UINT32);
            map.put("uint32", UINT32);
            map.put("uint32_t", UINT32);
            map.put("longlong", INT64);
            map.put("long long", INT64);
            map.put("long long int", INT64);
            map.put("signed long long", INT64);
            map.put("signed long long int", INT64);
            map.put("int64", INT64);
            map.put("int64_t", INT64);
            map.put("ulonglong", UINT64);
            map.put("unsigned long long", UINT64);
            map.put("unsigned long long int", UINT64);
            map.put("uint64", UINT64);
            map.put("uint64_t", UINT64);
            map.put("float", FLOAT32);
            map.put("double", FLOAT64);
        }
    }
}

