/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class TIFFValues {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/TIFFValues.java,v 1.2 2021/06/17 17:12:43 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(TIFFValues.class);

    public static TIFFValues extractValues(int n, byte[] byArray, ByteOrder byteOrder, int n2) {
        TIFFValues tIFFValues = null;
        switch (n) {
            case 1: {
                tIFFValues = TIFFByteValues.extractValues(byArray, n2);
                break;
            }
            case 2: {
                tIFFValues = TIFFAsciiValues.extractValues(byArray, n2);
                break;
            }
            case 3: {
                tIFFValues = TIFFShortValues.extractValues(byArray, byteOrder, n2);
                break;
            }
            case 4: {
                tIFFValues = TIFFLongValues.extractValues(byArray, byteOrder, n2);
                break;
            }
            case 5: {
                tIFFValues = TIFFRationalValues.extractValues(byArray, byteOrder, n2);
                break;
            }
            case 6: {
                tIFFValues = TIFFSByteValues.extractValues(byArray, n2);
                break;
            }
            case 7: {
                tIFFValues = TIFFUndefinedValues.extractValues(byArray, n2);
                break;
            }
            case 8: {
                tIFFValues = TIFFSShortValues.extractValues(byArray, byteOrder, n2);
                break;
            }
            case 9: {
                tIFFValues = TIFFSLongValues.extractValues(byArray, byteOrder, n2);
                break;
            }
            case 10: {
                tIFFValues = TIFFSRationalValues.extractValues(byArray, byteOrder, n2);
                break;
            }
            case 13: {
                tIFFValues = TIFFIfdValues.extractValues(byArray, byteOrder, n2);
                break;
            }
            case 16: {
                tIFFValues = TIFFLong8Values.extractValues(byArray, byteOrder, n2);
                break;
            }
            case 17: {
                tIFFValues = TIFFSlong8Values.extractValues(byArray, byteOrder, n2);
                break;
            }
            case 18: {
                tIFFValues = TIFFIfd8Values.extractValues(byArray, byteOrder, n2);
            }
        }
        return tIFFValues;
    }

    public long getSingleNumericValue(int n, long l) {
        return l;
    }

    public static long getSingleNumericValue(TIFFValues tIFFValues, int n, long l) {
        return tIFFValues.getSingleNumericValue(n, l);
    }

    public long[] getNumericValues() {
        return null;
    }

    public byte[] getByteValues() {
        return null;
    }

    public String[] getStringValues() {
        return null;
    }

    public static class TIFFIfd8Values
    extends TIFFValues {
        long[] values;

        TIFFIfd8Values(long[] lArray) {
            this.values = lArray;
        }

        public static TIFFIfd8Values extractValues(byte[] byArray, ByteOrder byteOrder, int n) {
            long[] lArray = new long[n];
            int n2 = 8;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                lArray[i] = ByteBuffer.wrap(byArray, n3, n2).order(byteOrder).getLong();
                n3 += n2;
            }
            return new TIFFIfd8Values(lArray);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = "";
            for (long l : this.values) {
                stringBuffer.append(string);
                stringBuffer.append(l);
                string = " ";
            }
            return stringBuffer.toString();
        }

        @Override
        public long getSingleNumericValue(int n, long l) {
            long l2 = l;
            if (n < this.values.length) {
                l2 = this.values[n];
            }
            return l2;
        }

        @Override
        public long[] getNumericValues() {
            return this.values;
        }
    }

    public static class TIFFSlong8Values
    extends TIFFValues {
        long[] values;

        TIFFSlong8Values(long[] lArray) {
            this.values = lArray;
        }

        public static TIFFSlong8Values extractValues(byte[] byArray, ByteOrder byteOrder, int n) {
            long[] lArray = new long[n];
            int n2 = 8;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                lArray[i] = ByteBuffer.wrap(byArray, n3, n2).order(byteOrder).getLong();
                n3 += n2;
            }
            return new TIFFSlong8Values(lArray);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = "";
            for (long l : this.values) {
                stringBuffer.append(string);
                stringBuffer.append(l);
                string = " ";
            }
            return stringBuffer.toString();
        }

        @Override
        public long getSingleNumericValue(int n, long l) {
            long l2 = l;
            if (n < this.values.length) {
                l2 = this.values[n];
            }
            return l2;
        }

        @Override
        public long[] getNumericValues() {
            return this.values;
        }
    }

    public static class TIFFLong8Values
    extends TIFFValues {
        long[] values;

        TIFFLong8Values(long[] lArray) {
            this.values = lArray;
        }

        public static TIFFLong8Values extractValues(byte[] byArray, ByteOrder byteOrder, int n) {
            long[] lArray = new long[n];
            int n2 = 8;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                lArray[i] = ByteBuffer.wrap(byArray, n3, n2).order(byteOrder).getLong();
                n3 += n2;
            }
            return new TIFFLong8Values(lArray);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = "";
            for (long l : this.values) {
                stringBuffer.append(string);
                stringBuffer.append(l);
                string = " ";
            }
            return stringBuffer.toString();
        }

        @Override
        public long getSingleNumericValue(int n, long l) {
            long l2 = l;
            if (n < this.values.length) {
                l2 = this.values[n];
            }
            return l2;
        }

        @Override
        public long[] getNumericValues() {
            return this.values;
        }
    }

    public static class TIFFIfdValues
    extends TIFFValues {
        long[] values;

        TIFFIfdValues(long[] lArray) {
            this.values = lArray;
        }

        public static TIFFIfdValues extractValues(byte[] byArray, ByteOrder byteOrder, int n) {
            long[] lArray = new long[n];
            int n2 = 4;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                lArray[i] = (long)ByteBuffer.wrap(byArray, n3, n2).order(byteOrder).getInt() & 0xFFFFFFFFL;
                n3 += n2;
            }
            return new TIFFIfdValues(lArray);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = "";
            for (long l : this.values) {
                stringBuffer.append(string);
                stringBuffer.append(l);
                string = " ";
            }
            return stringBuffer.toString();
        }

        @Override
        public long getSingleNumericValue(int n, long l) {
            long l2 = l;
            if (n < this.values.length) {
                l2 = this.values[n];
            }
            return l2;
        }

        @Override
        public long[] getNumericValues() {
            return this.values;
        }
    }

    public static class TIFFSRationalValues
    extends TIFFValues {
        long[] numeratorValues;
        long[] denominatorValues;

        TIFFSRationalValues(long[] lArray, long[] lArray2) {
            this.numeratorValues = lArray;
            this.denominatorValues = lArray2;
        }

        public static TIFFSRationalValues extractValues(byte[] byArray, ByteOrder byteOrder, int n) {
            long[] lArray = new long[n];
            long[] lArray2 = new long[n];
            int n2 = 4;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                long l = (long)ByteBuffer.wrap(byArray, n3, n2).order(byteOrder).getInt() & 0xFFFFFFFFL;
                if ((l & 0x80000000L) == 0x80000000L) {
                    l |= Integer.MIN_VALUE;
                }
                lArray[i] = l;
                long l2 = (long)ByteBuffer.wrap(byArray, n3 += n2, n2).order(byteOrder).getInt() & 0xFFFFFFFFL;
                if ((l2 & 0x80000000L) == 0x80000000L) {
                    l2 |= Integer.MIN_VALUE;
                }
                lArray2[i] = l2;
                n3 += n2;
            }
            return new TIFFSRationalValues(lArray, lArray2);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = "";
            for (int i = 0; i < this.numeratorValues.length; ++i) {
                stringBuffer.append(string);
                stringBuffer.append(this.numeratorValues[i]);
                stringBuffer.append("/");
                stringBuffer.append(this.denominatorValues[i]);
                string = " ";
            }
            return stringBuffer.toString();
        }

        @Override
        public long getSingleNumericValue(int n, long l) {
            long l2 = l;
            if (n < this.denominatorValues.length && this.denominatorValues[n] != 0L) {
                l2 = (long)((double)this.numeratorValues[n] / (double)this.denominatorValues[n]);
            }
            return l2;
        }
    }

    public static class TIFFRationalValues
    extends TIFFValues {
        long[] numeratorValues;
        long[] denominatorValues;

        TIFFRationalValues(long[] lArray, long[] lArray2) {
            this.numeratorValues = lArray;
            this.denominatorValues = lArray2;
        }

        public static TIFFRationalValues extractValues(byte[] byArray, ByteOrder byteOrder, int n) {
            long[] lArray = new long[n];
            long[] lArray2 = new long[n];
            int n2 = 4;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                lArray[i] = (long)ByteBuffer.wrap(byArray, n3, n2).order(byteOrder).getInt() & 0xFFFFFFFFL;
                lArray2[i] = (long)ByteBuffer.wrap(byArray, n3 += n2, n2).order(byteOrder).getInt() & 0xFFFFFFFFL;
                n3 += n2;
            }
            return new TIFFRationalValues(lArray, lArray2);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = "";
            for (int i = 0; i < this.numeratorValues.length; ++i) {
                stringBuffer.append(string);
                stringBuffer.append(this.numeratorValues[i]);
                stringBuffer.append("/");
                stringBuffer.append(this.denominatorValues[i]);
                string = " ";
            }
            return stringBuffer.toString();
        }

        @Override
        public long getSingleNumericValue(int n, long l) {
            long l2 = l;
            if (n < this.denominatorValues.length && this.denominatorValues[n] != 0L) {
                l2 = (long)((double)this.numeratorValues[n] / (double)this.denominatorValues[n]);
            }
            return l2;
        }
    }

    public static class TIFFSLongValues
    extends TIFFValues {
        long[] values;

        TIFFSLongValues(long[] lArray) {
            this.values = lArray;
        }

        public static TIFFSLongValues extractValues(byte[] byArray, ByteOrder byteOrder, int n) {
            long[] lArray = new long[n];
            int n2 = 4;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                long l = (long)ByteBuffer.wrap(byArray, n3, n2).order(byteOrder).getInt() & 0xFFFFFFFFL;
                if ((l & 0x80000000L) == 0x80000000L) {
                    l |= Integer.MIN_VALUE;
                }
                lArray[i] = l;
                n3 += n2;
            }
            return new TIFFSLongValues(lArray);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = "";
            for (long l : this.values) {
                stringBuffer.append(string);
                stringBuffer.append(l);
                string = " ";
            }
            return stringBuffer.toString();
        }

        @Override
        public long getSingleNumericValue(int n, long l) {
            long l2 = l;
            if (n < this.values.length) {
                l2 = this.values[n];
            }
            return l2;
        }

        @Override
        public long[] getNumericValues() {
            return this.values;
        }
    }

    public static class TIFFLongValues
    extends TIFFValues {
        long[] values;

        TIFFLongValues(long[] lArray) {
            this.values = lArray;
        }

        public static TIFFLongValues extractValues(byte[] byArray, ByteOrder byteOrder, int n) {
            long[] lArray = new long[n];
            int n2 = 4;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                lArray[i] = (long)ByteBuffer.wrap(byArray, n3, n2).order(byteOrder).getInt() & 0xFFFFFFFFL;
                n3 += n2;
            }
            return new TIFFLongValues(lArray);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = "";
            for (long l : this.values) {
                stringBuffer.append(string);
                stringBuffer.append(l);
                string = " ";
            }
            return stringBuffer.toString();
        }

        @Override
        public long getSingleNumericValue(int n, long l) {
            long l2 = l;
            if (n < this.values.length) {
                l2 = this.values[n];
            }
            return l2;
        }

        @Override
        public long[] getNumericValues() {
            return this.values;
        }
    }

    public static class TIFFSShortValues
    extends TIFFValues {
        int[] values;

        TIFFSShortValues(int[] nArray) {
            this.values = nArray;
        }

        public static TIFFSShortValues extractValues(byte[] byArray, ByteOrder byteOrder, int n) {
            int[] nArray = new int[n];
            int n2 = 2;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                int n4 = ByteBuffer.wrap(byArray, n3, n2).order(byteOrder).getShort();
                if ((n4 & 0x8000) == 32768) {
                    n4 |= Short.MIN_VALUE;
                }
                nArray[i] = n4;
                n3 += n2;
            }
            return new TIFFSShortValues(nArray);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = "";
            for (int n : this.values) {
                stringBuffer.append(string);
                stringBuffer.append(n);
                string = " ";
            }
            return stringBuffer.toString();
        }

        @Override
        public long getSingleNumericValue(int n, long l) {
            long l2 = l;
            if (n < this.values.length) {
                l2 = this.values[n];
            }
            return l2;
        }

        @Override
        public long[] getNumericValues() {
            long[] lArray = null;
            if (this.values.length > 0) {
                lArray = new long[this.values.length];
                for (int i = 0; i < this.values.length; ++i) {
                    lArray[i] = this.values[i];
                }
            }
            return lArray;
        }
    }

    public static class TIFFShortValues
    extends TIFFValues {
        int[] values;

        TIFFShortValues(int[] nArray) {
            this.values = nArray;
        }

        public static TIFFShortValues extractValues(byte[] byArray, ByteOrder byteOrder, int n) {
            int[] nArray = new int[n];
            int n2 = 2;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                nArray[i] = ByteBuffer.wrap(byArray, n3, n2).order(byteOrder).getShort() & 0xFFFF;
                n3 += n2;
            }
            return new TIFFShortValues(nArray);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = "";
            for (int n : this.values) {
                stringBuffer.append(string);
                stringBuffer.append(n);
                string = " ";
            }
            return stringBuffer.toString();
        }

        @Override
        public long getSingleNumericValue(int n, long l) {
            long l2 = l;
            if (n < this.values.length) {
                l2 = this.values[n];
            }
            return l2;
        }

        @Override
        public long[] getNumericValues() {
            long[] lArray = null;
            if (this.values.length > 0) {
                lArray = new long[this.values.length];
                for (int i = 0; i < this.values.length; ++i) {
                    lArray[i] = this.values[i];
                }
            }
            return lArray;
        }
    }

    public static class TIFFAsciiValues
    extends TIFFValues {
        String[] values;

        TIFFAsciiValues(String[] stringArray) {
            this.values = stringArray;
        }

        public static TIFFAsciiValues extractValues(byte[] byArray, int n) {
            String[] stringArray = null;
            try {
                int n2;
                ArrayList<String> arrayList = new ArrayList<String>();
                if (byArray != null && (n2 = byArray.length) > 0) {
                    slf4jlogger.debug("TIFFAsciiValues.extractValues(): have buffer content");
                    int n3 = 0;
                    int n4 = 0;
                    while (n4 < n2) {
                        if (byArray[n4] == 0) {
                            String string = new String(byArray, n3, n4 - n3, "UTF-8");
                            arrayList.add(string);
                            n3 = ++n4;
                            continue;
                        }
                        ++n4;
                    }
                    stringArray = arrayList.toArray(new String[arrayList.size()]);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace(System.err);
            }
            return new TIFFAsciiValues(stringArray);
        }

        @Override
        public String[] getStringValues() {
            return this.values;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : this.values) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
    }

    public static class TIFFSByteValues
    extends TIFFValues {
        byte[] values;

        TIFFSByteValues(byte[] byArray) {
            this.values = byArray;
        }

        public static TIFFSByteValues extractValues(byte[] byArray, int n) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            return new TIFFSByteValues(byArray2);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = "";
            for (byte by : this.values) {
                stringBuffer.append(string);
                int n = by & 0xFF;
                if ((n & 0x80) == 128) {
                    n |= 0xFFFFFF80;
                }
                stringBuffer.append(n);
                string = " ";
            }
            return stringBuffer.toString();
        }

        @Override
        public long getSingleNumericValue(int n, long l) {
            long l2 = l;
            if (n < this.values.length && ((l2 = (long)this.values[n] & 0xFFL) & 0x80L) == 128L) {
                l2 |= 0xFFFFFFFFFFFFFF80L;
            }
            return l2;
        }

        @Override
        public long[] getNumericValues() {
            long[] lArray = null;
            if (this.values.length > 0) {
                lArray = new long[this.values.length];
                for (int i = 0; i < this.values.length; ++i) {
                    long l = (long)this.values[i] & 0xFFL;
                    if ((l & 0x80L) == 128L) {
                        l |= 0xFFFFFFFFFFFFFF80L;
                    }
                    lArray[i] = l;
                }
            }
            return lArray;
        }

        @Override
        public byte[] getByteValues() {
            return this.values;
        }
    }

    public static class TIFFByteValues
    extends TIFFValues {
        byte[] values;

        TIFFByteValues(byte[] byArray) {
            this.values = byArray;
        }

        public static TIFFByteValues extractValues(byte[] byArray, int n) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            return new TIFFByteValues(byArray2);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = "";
            for (byte by : this.values) {
                stringBuffer.append(string);
                stringBuffer.append(by & 0xFF);
                string = " ";
            }
            return stringBuffer.toString();
        }

        @Override
        public long getSingleNumericValue(int n, long l) {
            long l2 = l;
            if (n < this.values.length) {
                l2 = (long)this.values[n] & 0xFFL;
            }
            return l2;
        }

        @Override
        public long[] getNumericValues() {
            long[] lArray = null;
            if (this.values.length > 0) {
                lArray = new long[this.values.length];
                for (int i = 0; i < this.values.length; ++i) {
                    lArray[i] = (long)this.values[i] & 0xFFL;
                }
            }
            return lArray;
        }

        @Override
        public byte[] getByteValues() {
            return this.values;
        }
    }

    public static class TIFFUndefinedValues
    extends TIFFValues {
        byte[] values;

        TIFFUndefinedValues(byte[] byArray) {
            this.values = byArray;
        }

        public static TIFFUndefinedValues extractValues(byte[] byArray, int n) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            return new TIFFUndefinedValues(byArray2);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = "";
            for (byte by : this.values) {
                stringBuffer.append(string);
                stringBuffer.append(by & 0xFF);
                string = " ";
            }
            return stringBuffer.toString();
        }

        @Override
        public long getSingleNumericValue(int n, long l) {
            long l2 = l;
            if (n < this.values.length) {
                l2 = (long)this.values[n] & 0xFFL;
            }
            return l2;
        }

        @Override
        public long[] getNumericValues() {
            long[] lArray = null;
            if (this.values.length > 0) {
                lArray = new long[this.values.length];
                for (int i = 0; i < this.values.length; ++i) {
                    lArray[i] = (long)this.values[i] & 0xFFL;
                }
            }
            return lArray;
        }

        @Override
        public byte[] getByteValues() {
            return this.values;
        }
    }
}

