/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.database;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.CopyStream;
import com.pixelmed.utils.MessageLogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;

public class DatabaseMediaImporter
extends MediaImporter {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/database/DatabaseMediaImporter.java,v 1.16 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DatabaseMediaImporter.class);
    protected File savedInstancesFolder;
    protected DatabaseInformationModel databaseInformationModel;
    protected StoredFilePathStrategy storedFilePathStrategy;

    public DatabaseMediaImporter(String string, File file, DatabaseInformationModel databaseInformationModel, MessageLogger messageLogger) {
        super(string, messageLogger);
        this.savedInstancesFolder = file;
        this.databaseInformationModel = databaseInformationModel;
        this.storedFilePathStrategy = StoredFilePathStrategy.getDefaultStrategy();
    }

    public DatabaseMediaImporter(String string, File file, StoredFilePathStrategy storedFilePathStrategy, DatabaseInformationModel databaseInformationModel, MessageLogger messageLogger) {
        super(string, messageLogger);
        this.savedInstancesFolder = file;
        this.databaseInformationModel = databaseInformationModel;
        this.storedFilePathStrategy = storedFilePathStrategy;
    }

    @Override
    protected void doSomethingWithDicomFileOnMedia(String string) {
        slf4jlogger.debug("doSomethingWithDicomFileOnMedia(): {}", string);
        try {
            DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
            AttributeList attributeList = new AttributeList();
            attributeList.read(dicomInputStream, TagFromName.PixelData);
            dicomInputStream.close();
            String string2 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPInstanceUID);
            if (string2 == null) {
                throw new DicomException("Cannot get SOP Instance UID to make file name for local copy when inserting into database");
            }
            String string3 = this.storedFilePathStrategy.makeReliableStoredFilePathWithFoldersCreated(this.savedInstancesFolder, string2).getPath();
            slf4jlogger.debug("doSomethingWithDicomFileOnMedia(): uid = {}  path = {}", string2, string3);
            CopyStream.copy(string, string3);
            this.databaseInformationModel.insertObject(attributeList, string3, "C");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

