/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.database;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;

public class MapTableModel
extends AbstractTableModel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/database/MapTableModel.java,v 1.18 2025/01/29 10:58:06 dclunie Exp $";
    protected int columnCount;
    protected int rowCount;
    protected String[] columnNames;
    protected Object[][] data;
    protected HashSet includeList;
    protected HashSet excludeList;

    protected boolean isAcceptable(HashSet hashSet, HashSet hashSet2, String string) {
        return string != null && (hashSet2 == null || !hashSet2.contains(string.toUpperCase(Locale.US)));
    }

    public MapTableModel() {
        this.includeList = null;
        this.excludeList = null;
        this.initializeModelFromMap(null, null);
    }

    public MapTableModel(Map map, Map map2) {
        this.includeList = null;
        this.excludeList = null;
        this.initializeModelFromMap(map, map2);
    }

    public MapTableModel(Map map, Map map2, HashSet hashSet, HashSet hashSet2) {
        this.includeList = hashSet;
        this.excludeList = hashSet2;
        this.initializeModelFromMap(map, map2);
    }

    public void initializeModelFromMap(Map map, Map map2) {
        this.rowCount = 1;
        this.columnCount = 0;
        if (map == null) {
            this.columnNames = null;
            this.data = null;
        } else {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (String string : map.keySet()) {
                if (!this.isAcceptable(this.includeList, this.excludeList, string) || map.get(string) == null) continue;
                treeSet.add(string);
            }
            this.columnCount = treeSet.size();
            this.columnNames = new String[this.columnCount];
            this.data = new Object[1][];
            this.data[0] = new String[this.columnCount];
            int n = 0;
            Iterator<Object> iterator = treeSet.iterator();
            while (iterator.hasNext() && n < this.columnCount) {
                String string;
                String string2 = (String)iterator.next();
                if (!this.isAcceptable(this.includeList, this.excludeList, string2)) continue;
                String string3 = map2 == null ? null : (String)map2.get(string2);
                String string4 = string = string3 == null ? string2 : string3;
                String string5 = (String)map.get(string2);
                if (string5 == null) continue;
                this.columnNames[n] = string;
                this.data[0][n] = string5;
                ++n;
            }
        }
        this.fireTableChanged(null);
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.data[n][n2];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }
}

