/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.database;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.util.Locale;

public class RebuildDatabaseFromInstanceFiles {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/database/RebuildDatabaseFromInstanceFiles.java,v 1.21 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(RebuildDatabaseFromInstanceFiles.class);
    private static long filesProcessed;

    private static void processFileOrDirectory(DatabaseInformationModel databaseInformationModel, File file) {
        String string = file.getName().toUpperCase(Locale.US);
        if (!(!file.isDirectory() || string.equals("CDVIEWER") || string.equals("CVS") || string.equals("ICONS") || string.equals("JRE") || string.equals("LOCALE") || string.equals("RESOURCES") || string.equals("THUMBNAILS") || string.endsWith(".APP"))) {
            slf4jlogger.info("Recursing into directory {}", file);
            try {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    RebuildDatabaseFromInstanceFiles.processFileOrDirectory(databaseInformationModel, fileArray[i]);
                }
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        } else if (file.isFile()) {
            if (!(file.isHidden() || string.endsWith(".APP") || string.endsWith(".BAK") || string.endsWith(".BAT") || string.endsWith(".BDT") || string.endsWith(".BIN") || string.endsWith(".BMP") || string.endsWith(".BZ2") || string.endsWith(".CAB") || string.endsWith(".CFG") || string.endsWith(".CHM") || string.endsWith(".CM") || string.endsWith(".CNF") || string.endsWith(".CNT") || string.endsWith(".COL") || string.endsWith(".CONFIG") || string.endsWith(".CRT.MANIFEST") || string.endsWith(".CSS") || string.endsWith(".CUR") || string.endsWith(".DAT") || string.endsWith(".DB") || string.endsWith(".DCT") || string.endsWith(".DLL") || string.endsWith(".DOC") || string.endsWith(".DTD") || string.endsWith(".EXE") || string.endsWith(".EXE.MANIFEST") || string.endsWith(".GIF") || string.endsWith(".HDR") || string.endsWith(".HLP") || string.endsWith(".HQX") || string.endsWith(".HTC") || string.endsWith(".HTF") || string.endsWith(".HTM") || string.endsWith(".HTML") || string.endsWith(".IBT") || string.endsWith(".ICO") || string.endsWith(".IDX") || string.endsWith(".INF") || string.endsWith(".INI") || string.endsWith(".INX") || string.endsWith(".ISO") || string.endsWith(".JAR") || string.endsWith(".JPEG") || string.endsWith(".JPG") || string.endsWith(".JS") || string.endsWith(".JSE") || string.endsWith(".LNK") || string.endsWith(".LOG") || string.endsWith(".LST") || string.endsWith(".MDB") || string.endsWith(".MFC.MANIFEST") || string.endsWith(".MO") || string.endsWith(".MSG") || string.endsWith(".MSI") || string.endsWith(".MSO") || string.endsWith(".NIB") || string.endsWith(".OCX") || string.endsWith(".ORG") || string.endsWith(".PAL") || string.endsWith(".PDF") || string.endsWith(".PFL") || string.endsWith(".PNG") || string.endsWith(".PRO") || string.endsWith(".PROPERTIES") || string.endsWith(".RAR") || string.endsWith(".RES") || string.endsWith(".RTC") || string.endsWith(".RTF") || string.endsWith(".SIT") || string.endsWith(".SRV") || string.endsWith(".SWF") || string.endsWith(".TB2") || string.endsWith(".TIF") || string.endsWith(".TPL") || string.endsWith(".TXT") || string.endsWith(".XML") || string.endsWith(".XSL") || string.endsWith(".ZIP") || string.endsWith("ABOUT.HTA") || string.endsWith("ACRCODES.ACR") || string.endsWith("ACRCODES-EN.ACR") || string.endsWith("CDINFO") || string.endsWith("DATABASE.BACKUP") || string.endsWith("DATABASE.DATA") || string.endsWith("DATABASE.SCRIPT") || string.endsWith("DICOMDIR") || string.endsWith("JAR.OLD") || string.endsWith("LOGGER") || string.endsWith("NAVIGATOR.HTA") || string.endsWith("NOTES") || string.endsWith("README") || string.endsWith("TOOLBARCONFIGURATION.OLD"))) {
                slf4jlogger.info("Doing file {}", file);
                try {
                    DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(file)));
                    AttributeList attributeList = new AttributeList();
                    attributeList.read(dicomInputStream, TagFromName.PixelData);
                    dicomInputStream.close();
                    databaseInformationModel.insertObject(attributeList, file.getAbsolutePath(), "C");
                    ++filesProcessed;
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
            } else {
                slf4jlogger.info("Skipping hidden or unwanted {}", file);
            }
        } else {
            slf4jlogger.info("Not a directory (that we want) or file {}", file);
        }
    }

    public static void main(String[] stringArray) {
        RebuildDatabaseFromInstanceFiles rebuildDatabaseFromInstanceFiles = new RebuildDatabaseFromInstanceFiles();
        if (stringArray.length >= 3) {
            Object[] objectArray;
            String string = stringArray[0];
            String string2 = stringArray[1];
            if (string.indexOf(46) == -1) {
                string = "com.pixelmed.database." + string;
            }
            DatabaseInformationModel databaseInformationModel = null;
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                Class[] classArray = new Class[]{string2.getClass()};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                objectArray = new Object[]{string2};
                databaseInformationModel = (DatabaseInformationModel)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
                System.exit(0);
            }
            long l = System.currentTimeMillis();
            filesProcessed = 0L;
            int n = 2;
            while (n < stringArray.length) {
                objectArray = stringArray[n++];
                File file = new File((String)objectArray);
                RebuildDatabaseFromInstanceFiles.processFileOrDirectory(databaseInformationModel, file);
            }
            long l2 = System.currentTimeMillis() - l;
            double d = (double)filesProcessed / ((double)l2 / 1000.0);
            slf4jlogger.info("Processed {} files in {} ms, {} files/s", filesProcessed, l2, d);
            databaseInformationModel.close();
        } else {
            System.err.println("Usage: java com.pixelmed.database.RebuildDatabaseFromInstanceFiles databaseModelClassName databaseFileName path(s)");
        }
    }
}

