/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.ApplicationEntityAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.AttributeTagAttribute;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FloatDoubleAttribute;
import com.pixelmed.dicom.FloatSingleAttribute;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.LongTextAttribute;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherByteAttributeOnDisk;
import com.pixelmed.dicom.OtherDoubleAttribute;
import com.pixelmed.dicom.OtherFloatAttribute;
import com.pixelmed.dicom.OtherLongAttribute;
import com.pixelmed.dicom.OtherVeryLongAttribute;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.OtherWordAttributeOnDisk;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.ShortTextAttribute;
import com.pixelmed.dicom.SignedLongAttribute;
import com.pixelmed.dicom.SignedShortAttribute;
import com.pixelmed.dicom.SignedVeryLongAttribute;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UniversalResourceAttribute;
import com.pixelmed.dicom.UnknownAttribute;
import com.pixelmed.dicom.UnlimitedCharactersAttribute;
import com.pixelmed.dicom.UnlimitedTextAttribute;
import com.pixelmed.dicom.UnsignedLongAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.dicom.UnsignedVeryLongAttribute;
import com.pixelmed.dicom.ValueRepresentation;

public class AttributeFactory {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/AttributeFactory.java,v 1.46 2025/01/29 10:58:06 dclunie Exp $";
    private static final long maximumInMemoryOtherDataValueLength = 0x2000000L;

    private AttributeFactory() {
    }

    public static Class getClassOfAttributeFromValueRepresentation(AttributeTag attributeTag, byte[] byArray, boolean bl, int n, boolean bl2, boolean bl3) {
        Class clazz;
        Class clazz2 = bl2 ? OtherByteAttributeOnDisk.class : OtherByteAttribute.class;
        Class clazz3 = clazz = bl2 ? OtherWordAttributeOnDisk.class : OtherWordAttribute.class;
        Class clazz4 = ValueRepresentation.isApplicationEntityVR(byArray) ? ApplicationEntityAttribute.class : (ValueRepresentation.isAgeStringVR(byArray) ? AgeStringAttribute.class : (ValueRepresentation.isAttributeTagVR(byArray) ? AttributeTagAttribute.class : (ValueRepresentation.isCodeStringVR(byArray) ? CodeStringAttribute.class : (ValueRepresentation.isDateVR(byArray) ? DateAttribute.class : (ValueRepresentation.isDateTimeVR(byArray) ? DateTimeAttribute.class : (ValueRepresentation.isDecimalStringVR(byArray) ? DecimalStringAttribute.class : (ValueRepresentation.isFloatDoubleVR(byArray) ? FloatDoubleAttribute.class : (ValueRepresentation.isFloatSingleVR(byArray) ? FloatSingleAttribute.class : (ValueRepresentation.isIntegerStringVR(byArray) ? IntegerStringAttribute.class : (ValueRepresentation.isLongStringVR(byArray) ? LongStringAttribute.class : (ValueRepresentation.isLongTextVR(byArray) ? LongTextAttribute.class : (ValueRepresentation.isOtherByteVR(byArray) ? (n > 1 && attributeTag.equals(TagFromName.PixelData) ? clazz : clazz2) : (ValueRepresentation.isOtherDoubleVR(byArray) ? OtherDoubleAttribute.class : (ValueRepresentation.isOtherFloatVR(byArray) ? OtherFloatAttribute.class : (ValueRepresentation.isOtherLongVR(byArray) ? OtherLongAttribute.class : (ValueRepresentation.isOtherVeryLongVR(byArray) ? OtherVeryLongAttribute.class : (ValueRepresentation.isOtherWordVR(byArray) ? (bl || n > 1 || !attributeTag.equals(TagFromName.PixelData) ? clazz : clazz2) : (ValueRepresentation.isOtherUnspecifiedVR(byArray) ? (n > 1 || !attributeTag.equals(TagFromName.PixelData) ? clazz : clazz2) : (ValueRepresentation.isPersonNameVR(byArray) ? PersonNameAttribute.class : (ValueRepresentation.isSequenceVR(byArray) ? SequenceAttribute.class : (ValueRepresentation.isShortStringVR(byArray) ? ShortStringAttribute.class : (ValueRepresentation.isSignedLongVR(byArray) ? SignedLongAttribute.class : (ValueRepresentation.isSignedVeryLongVR(byArray) ? SignedVeryLongAttribute.class : (ValueRepresentation.isSignedShortVR(byArray) ? SignedShortAttribute.class : (ValueRepresentation.isShortTextVR(byArray) ? ShortTextAttribute.class : (ValueRepresentation.isTimeVR(byArray) ? TimeAttribute.class : (ValueRepresentation.isUniqueIdentifierVR(byArray) ? UniqueIdentifierAttribute.class : (ValueRepresentation.isUnsignedLongVR(byArray) ? UnsignedLongAttribute.class : (ValueRepresentation.isUnsignedVeryLongVR(byArray) ? UnsignedVeryLongAttribute.class : (ValueRepresentation.isUnknownVR(byArray) ? UnknownAttribute.class : (ValueRepresentation.isUnsignedShortVR(byArray) ? UnsignedShortAttribute.class : (ValueRepresentation.isUnspecifiedShortVR(byArray) ? (bl3 ? SignedShortAttribute.class : UnsignedShortAttribute.class) : (ValueRepresentation.isUnspecifiedShortOrOtherWordVR(byArray) ? (bl3 ? SignedShortAttribute.class : UnsignedShortAttribute.class) : (ValueRepresentation.isUniversalResourceVR(byArray) ? UniversalResourceAttribute.class : (ValueRepresentation.isUnlimitedCharactersVR(byArray) ? UnlimitedCharactersAttribute.class : (ValueRepresentation.isUnlimitedTextVR(byArray) ? UnlimitedTextAttribute.class : UnknownAttribute.class))))))))))))))))))))))))))))))))))));
        return clazz4;
    }

    public static Class getClassOfAttributeFromValueRepresentation(AttributeTag attributeTag, byte[] byArray, boolean bl, int n, long l, boolean bl2, boolean bl3) {
        boolean bl4 = l > 0x2000000L && bl2;
        return AttributeFactory.getClassOfAttributeFromValueRepresentation(attributeTag, byArray, bl, n, bl4, bl3);
    }

    public static Attribute newAttribute(AttributeTag attributeTag) throws DicomException {
        if (attributeTag == null) {
            throw new DicomException("Cannot create a new attribute without supplying an AttributeTag");
        }
        byte[] byArray = DicomDictionary.StandardDictionary.getValueRepresentationFromTag(attributeTag);
        if (byArray == null) {
            byArray = attributeTag.isPrivateCreator() ? new byte[]{76, 79} : new byte[]{85, 78};
        }
        return AttributeFactory.newAttribute(attributeTag, byArray);
    }

    public static Attribute newAttribute(AttributeTag attributeTag, byte[] byArray) throws DicomException {
        return AttributeFactory.newAttribute(attributeTag, byArray, true, 0);
    }

    public static Attribute newAttribute(AttributeTag attributeTag, byte[] byArray, SpecificCharacterSet specificCharacterSet) throws DicomException {
        return AttributeFactory.newAttribute(attributeTag, byArray, specificCharacterSet, true, 0, false);
    }

    public static Attribute newAttribute(AttributeTag attributeTag, byte[] byArray, boolean bl, int n) throws DicomException {
        return AttributeFactory.newAttribute(attributeTag, byArray, null, bl, n, false);
    }

    public static Attribute newAttribute(AttributeTag attributeTag, byte[] byArray, SpecificCharacterSet specificCharacterSet, boolean bl, int n, boolean bl2) throws DicomException {
        if (attributeTag == null) {
            throw new DicomException("Cannot create a new attribute without supplying an AttributeTag");
        }
        Attribute attribute = null;
        try {
            Class clazz = AttributeFactory.getClassOfAttributeFromValueRepresentation(attributeTag, byArray, bl, n, false, bl2);
            Class[] classArray = null;
            Object[] objectArray = null;
            if (ValueRepresentation.isAffectedBySpecificCharacterSet(byArray)) {
                Class[] classArray2 = new Class[]{AttributeTag.class, SpecificCharacterSet.class};
                Object[] objectArray2 = new Object[]{attributeTag, specificCharacterSet};
                classArray = classArray2;
                objectArray = objectArray2;
            } else {
                Class[] classArray3 = new Class[]{AttributeTag.class};
                Object[] objectArray3 = new Object[]{attributeTag};
                classArray = classArray3;
                objectArray = objectArray3;
            }
            attribute = (Attribute)clazz.getConstructor(classArray).newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new DicomException("Could not instantiate an attribute for " + attributeTag + ": " + exception.getCause());
        }
        return attribute;
    }

    public static Attribute newAttribute(AttributeTag attributeTag, byte[] byArray, SpecificCharacterSet specificCharacterSet, boolean bl, int n) throws DicomException {
        return AttributeFactory.newAttribute(attributeTag, byArray, specificCharacterSet, bl, n, false);
    }

    public static Attribute newAttribute(AttributeTag attributeTag, byte[] byArray, long l, DicomInputStream dicomInputStream, SpecificCharacterSet specificCharacterSet, boolean bl, int n, long l2, boolean bl2) throws DicomException {
        if (attributeTag == null) {
            throw new DicomException("Cannot create a new attribute without supplying an AttributeTag");
        }
        Attribute attribute = null;
        try {
            Class clazz = AttributeFactory.getClassOfAttributeFromValueRepresentation(attributeTag, byArray, bl, n, l, dicomInputStream.getFile() != null, bl2);
            Class[] classArray = null;
            Object[] objectArray = null;
            Long l3 = new Long(l);
            Long l4 = new Long(l2);
            if (ValueRepresentation.isAffectedBySpecificCharacterSet(byArray)) {
                Class[] classArray2 = new Class[]{AttributeTag.class, Long.class, DicomInputStream.class, SpecificCharacterSet.class};
                Object[] objectArray2 = new Object[]{attributeTag, l3, dicomInputStream, specificCharacterSet};
                classArray = classArray2;
                objectArray = objectArray2;
            } else if (clazz == OtherByteAttributeOnDisk.class || clazz == OtherWordAttributeOnDisk.class) {
                Class[] classArray3 = new Class[]{AttributeTag.class, Long.class, DicomInputStream.class, Long.class};
                Object[] objectArray3 = new Object[]{attributeTag, l3, dicomInputStream, l4};
                classArray = classArray3;
                objectArray = objectArray3;
            } else {
                Class[] classArray4 = new Class[]{AttributeTag.class, Long.TYPE, DicomInputStream.class};
                Object[] objectArray4 = new Object[]{attributeTag, l3, dicomInputStream};
                classArray = classArray4;
                objectArray = objectArray4;
            }
            attribute = (Attribute)clazz.getConstructor(classArray).newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new DicomException("Could not instantiate an attribute for " + attributeTag + ": " + exception.getCause());
        }
        return attribute;
    }

    public static Attribute newAttribute(AttributeTag attributeTag, byte[] byArray, long l, DicomInputStream dicomInputStream, SpecificCharacterSet specificCharacterSet, boolean bl, int n, long l2) throws DicomException {
        return AttributeFactory.newAttribute(attributeTag, byArray, l, dicomInputStream, specificCharacterSet, bl, n, l2, false);
    }
}

