/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.ValueRepresentation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;

public class AttributeListTableModel
extends AbstractTableModel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/AttributeListTableModel.java,v 1.24 2025/01/29 10:58:06 dclunie Exp $";
    protected int columnCount;
    protected int rowCount;
    protected String[] columnNames;
    protected Object[][] data;
    protected HashSet includeList;
    protected HashSet excludeList;

    protected boolean isAcceptable(HashSet hashSet, HashSet hashSet2, AttributeTag attributeTag, byte[] byArray) {
        return !(hashSet2 != null && hashSet2.contains(attributeTag) || hashSet != null && !hashSet.contains(attributeTag) || ValueRepresentation.isSequenceVR(byArray) || ValueRepresentation.isOtherByteOrWordVR(byArray) || ValueRepresentation.isOtherUnspecifiedVR(byArray) || attributeTag.getGroup() % 2 != 0 || attributeTag.getElement() == 0);
    }

    public AttributeListTableModel() {
        this.includeList = null;
        this.excludeList = null;
        this.initializeModelFromAttributeList(null);
    }

    public AttributeListTableModel(AttributeList attributeList) {
        this.includeList = null;
        this.excludeList = null;
        this.initializeModelFromAttributeList(attributeList);
    }

    public AttributeListTableModel(AttributeList attributeList, HashSet hashSet, HashSet hashSet2) {
        this.includeList = hashSet;
        this.excludeList = hashSet2;
        this.initializeModelFromAttributeList(attributeList);
    }

    public void initializeModelFromAttributeList(AttributeList attributeList) {
        this.rowCount = 1;
        this.columnCount = 0;
        if (attributeList == null) {
            this.columnNames = null;
            this.data = null;
        } else {
            String string;
            DicomDictionary dicomDictionary = attributeList.getDictionary();
            TreeSet<String> treeSet = new TreeSet<String>();
            for (Attribute attribute : attributeList.values()) {
                if (!this.isAcceptable(this.includeList, this.excludeList, attribute.getTag(), attribute.getVR()) || (string = dicomDictionary.getNameFromTag(attribute.getTag())) == null) continue;
                treeSet.add(dicomDictionary.getNameFromTag(attribute.getTag()));
            }
            this.columnCount = treeSet.size();
            this.columnNames = new String[this.columnCount];
            this.data = new Object[1][];
            this.data[0] = new String[this.columnCount];
            int n = 0;
            Iterator<Object> iterator = treeSet.iterator();
            while (iterator.hasNext() && n < this.columnCount) {
                string = (String)iterator.next();
                AttributeTag attributeTag = dicomDictionary.getTagFromName(string);
                if (!this.isAcceptable(this.includeList, this.excludeList, attributeTag, dicomDictionary.getValueRepresentationFromTag(attributeTag))) continue;
                this.columnNames[n] = string;
                this.data[0][n] = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, attributeTag);
                ++n;
            }
        }
        this.fireTableChanged(null);
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.data[n][n2];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }
}

