/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodingSchemeIdentificationItem;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class CodingSchemeIdentification {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/CodingSchemeIdentification.java,v 1.19 2025/01/29 10:58:06 dclunie Exp $";
    protected List<CodingSchemeIdentificationItem> listOfItems;
    public static final String REGISTRY_HL7 = "HL7";
    public static final CodingSchemeIdentificationItem ACR = new CodingSchemeIdentificationItem("ACR", "HL7", "2.16.840.1.113883.6.76", "ACR Index for Radiological Diagnosis");
    public static final CodingSchemeIdentificationItem ASTM_SIG = new CodingSchemeIdentificationItem("ASTM-sigpurpose", null, "1.2.840.10065.1.12", "ASTM E 2084 Signature Purpose codes");
    public static final CodingSchemeIdentificationItem C4 = new CodingSchemeIdentificationItem("C4", "HL7", "2.16.840.1.113883.6.12", "CPT-4");
    public static final CodingSchemeIdentificationItem C5 = new CodingSchemeIdentificationItem("C5", "HL7", "2.16.840.1.113883.6.82", "CPT-5");
    public static final CodingSchemeIdentificationItem caDSR = new CodingSchemeIdentificationItem("caDSR", null, "2.16.840.1.113883.3.26.2", "Cancer Data Standard Repository");
    public static final CodingSchemeIdentificationItem CD2 = new CodingSchemeIdentificationItem("CD2", "HL7", "2.16.840.1.113883.6.13", "American Dental Association Current Dental Terminology 2");
    public static final CodingSchemeIdentificationItem CTV3 = new CodingSchemeIdentificationItem("CTV3", "HL7", "2.16.840.1.113883.6.6", "Clinical Terms Version 3");
    public static final CodingSchemeIdentificationItem DC = new CodingSchemeIdentificationItem("DC", null, "1.2.840.10008.2.16.10", "Dublin Core");
    public static final CodingSchemeIdentificationItem DCM = new CodingSchemeIdentificationItem("DCM", "HL7", "1.2.840.10008.2.16.4", "DICOM Controlled Terminology");
    public static final CodingSchemeIdentificationItem DCMUID = new CodingSchemeIdentificationItem("DCMUID", null, "1.2.840.10008.2.6.1", "DICOM UID Registry");
    public static final CodingSchemeIdentificationItem FMA = new CodingSchemeIdentificationItem("FMA", "HL7", "2.16.840.1.113883.6.119", "FMA");
    public static final CodingSchemeIdentificationItem HPC = new CodingSchemeIdentificationItem("HPC", "HL7", "2.16.840.1.113883.6.14", "Healthcare Financing Administration (HCFA) Common Procedure CodingSystem (HCPCS)");
    public static final CodingSchemeIdentificationItem I10 = new CodingSchemeIdentificationItem("I10", "HL7", "2.16.840.1.113883.6.3", "ICD10");
    public static final CodingSchemeIdentificationItem I10C = new CodingSchemeIdentificationItem("I10C", "HL7", "2.16.840.1.113883.6.90", "ICD-10-CM");
    public static final CodingSchemeIdentificationItem I10P = new CodingSchemeIdentificationItem("I10P", "HL7", "2.16.840.1.113883.6.4", "ICD-10-PCS");
    public static final CodingSchemeIdentificationItem I11 = new CodingSchemeIdentificationItem("I11", null, "1.2.840.10008.2.16.16", "ICD11");
    public static final CodingSchemeIdentificationItem I9 = new CodingSchemeIdentificationItem("I9", "HL7", "2.16.840.1.113883.6.42", "ICD9");
    public static final CodingSchemeIdentificationItem I9C = new CodingSchemeIdentificationItem("I9C", "HL7", "2.16.840.1.113883.6.2", "ICD9-CM");
    public static final CodingSchemeIdentificationItem IBSI = new CodingSchemeIdentificationItem("IBSI", null, "1.2.840.10008.2.16.13", "Image Biomarker Standardisation Initiative");
    public static final CodingSchemeIdentificationItem ICDO3 = new CodingSchemeIdentificationItem("ICDO3", "HL7", "2.16.840.1.113883.6.43.1", "ICD-O-3");
    public static final CodingSchemeIdentificationItem ISO3166_1 = new CodingSchemeIdentificationItem("ISO3166_1", "HL7", "2.16.1", "ISO 2 letter country codes");
    public static final CodingSchemeIdentificationItem ISO639_1 = new CodingSchemeIdentificationItem("ISO639_1", "HL7", "2.16.840.1.113883.6.99", "ISO 3 letter language codes");
    public static final CodingSchemeIdentificationItem ISO639_2 = new CodingSchemeIdentificationItem("ISO639_2", "HL7", "2.16.840.1.113883.6.100", "ISO 3 letter language codes");
    public static final CodingSchemeIdentificationItem ITIS_TSN = new CodingSchemeIdentificationItem("ITIS_TSN", null, "1.2.840.10008.2.16.7", "ITIS TSN");
    public static final CodingSchemeIdentificationItem LN = new CodingSchemeIdentificationItem("LN", "HL7", "2.16.840.1.113883.6.1", "LOINC");
    public static final CodingSchemeIdentificationItem MA = new CodingSchemeIdentificationItem("MA", null, "1.2.840.10008.2.16.5", "Adult Mouse Anatomy Ontology");
    public static final CodingSchemeIdentificationItem MAYOASRG = new CodingSchemeIdentificationItem("MAYOASRG", null, "1.2.840.10008.2.16.12", "Mayo Clinic Non-radiological Images Specific Body Structure Anatomical Surface Region Guide");
    public static final CodingSchemeIdentificationItem MDC = new CodingSchemeIdentificationItem("MDC", "HL7", "2.16.840.1.113883.6.24", "ISO/IEEE 11073 Medical Device Nomenclature");
    public static final CodingSchemeIdentificationItem MGI = new CodingSchemeIdentificationItem("MGI", null, "1.2.840.10008.2.16.8", "MGI");
    public static final CodingSchemeIdentificationItem MSH = new CodingSchemeIdentificationItem("MSH", "HL7", "2.16.840.1.113883.6.177", "MeSH");
    public static final CodingSchemeIdentificationItem NBD = new CodingSchemeIdentificationItem("NBD", null, "2.16.840.1.113883.15.2", "NASPE/BPEG Defibrillator Code");
    public static final CodingSchemeIdentificationItem NBG = new CodingSchemeIdentificationItem("NBG", null, "2.16.840.1.113883.15.3", "NASPE/BPEG Generic Pacemaker Code");
    public static final CodingSchemeIdentificationItem NCIt = new CodingSchemeIdentificationItem("NCIt", "HL7", "2.16.840.1.113883.3.26.1.1", "NCI Thesaurus");
    public static final CodingSchemeIdentificationItem NDC = new CodingSchemeIdentificationItem("NDC", "HL7", "2.16.840.1.113883.6.69", "National Drug Code Directory");
    public static final CodingSchemeIdentificationItem NEU = new CodingSchemeIdentificationItem("NEU", "HL7", "2.16.840.1.113883.6.210", "NeuroNames");
    public static final CodingSchemeIdentificationItem NICIP = new CodingSchemeIdentificationItem("NICIP", null, "2.16.840.1.113883.2.1.3.2.4.21", "NICIP");
    public static final CodingSchemeIdentificationItem NYUMCCG = new CodingSchemeIdentificationItem("NYUMCCG", null, "1.2.840.10008.2.16.11", "New York University Melanoma Clinical Cooperative Group");
    public static final CodingSchemeIdentificationItem PATHLEX = new CodingSchemeIdentificationItem("PATHLEX", null, "1.3.6.1.4.1.19376.1.8.2.1", "PathLex");
    public static final CodingSchemeIdentificationItem POS = new CodingSchemeIdentificationItem("POS", "HL7", "2.16.840.1.113883.6.50", "HCFA Place of Service (POS) Codes for Professional Claims");
    public static final CodingSchemeIdentificationItem PUBCHEM_CID = new CodingSchemeIdentificationItem("PUBCHEM_CID", null, "1.2.840.10008.2.16.9", "PubChem");
    public static final CodingSchemeIdentificationItem RADELEMENT = new CodingSchemeIdentificationItem("RADELEMENT", null, "1.2.840.10008.2.16.15", "RadElement");
    public static final CodingSchemeIdentificationItem RADLEX = new CodingSchemeIdentificationItem("RADLEX", "HL7", "2.16.840.1.113883.6.256", "RadLex");
    public static final CodingSchemeIdentificationItem RFC3066 = new CodingSchemeIdentificationItem("RFC3066", "HL7", "2.16.840.1.113883.6.121", "RFC 3066");
    public static final CodingSchemeIdentificationItem RFC5646 = new CodingSchemeIdentificationItem("RFC5646", "HL7", "2.16.840.1.113883.6.316", "RFC 5646");
    public static final CodingSchemeIdentificationItem RO = new CodingSchemeIdentificationItem("RO", null, "1.2.840.10008.2.16.14", "Radiomics Ontology");
    public static final CodingSchemeIdentificationItem RXNORM = new CodingSchemeIdentificationItem("RXNORM", "HL7", "2.16.840.1.113883.6.88", "RXNORM");
    public static final CodingSchemeIdentificationItem SCT = new CodingSchemeIdentificationItem("SCT", "HL7", "2.16.840.1.113883.6.96", "SNOMED CT using SNOMED-CT style values");
    public static final CodingSchemeIdentificationItem SDM = new CodingSchemeIdentificationItem("99SDM", "HL7", "2.16.840.1.113883.6.53", "SDM");
    public static final CodingSchemeIdentificationItem SNM3 = new CodingSchemeIdentificationItem("SNM3", "HL7", "2.16.840.1.113883.6.51", "SNOMED V3");
    public static final CodingSchemeIdentificationItem SRT = new CodingSchemeIdentificationItem("SRT", "HL7", "2.16.840.1.113883.6.96", "SNOMED CT using SNOMED-RT style values");
    public static final CodingSchemeIdentificationItem UBERON = new CodingSchemeIdentificationItem("UBERON", null, "1.2.840.10008.2.16.6", "UBERON");
    public static final CodingSchemeIdentificationItem UCUM = new CodingSchemeIdentificationItem("UCUM", "HL7", "2.16.840.1.113883.6.8", "Unified Code for Units of Measure");
    public static final CodingSchemeIdentificationItem UMLS = new CodingSchemeIdentificationItem("UMLS", "HL7", "2.16.840.1.113883.6.86", "UMLS codes as CUIs making up the values in a coding system");
    public static final CodingSchemeIdentificationItem UPC = new CodingSchemeIdentificationItem("UPC", "HL7", "2.16.840.1.113883.6.55", "Universal Product Code - Universal Code Council");
    public static final CodingSchemeIdentificationItem Private_99_OFFIS_DCMTK = new CodingSchemeIdentificationItem("99_OFFIS_DCMTK", null, "1.2.276.0.7230010.3.0.0.1", "OFFIS DCMTK");
    public static final CodingSchemeIdentificationItem Private_99PMP = new CodingSchemeIdentificationItem("99PMP", null, "1.3.6.1.4.1.5962.98.1", "PixelMed Publishing");
    public static final CodingSchemeIdentificationItem Private_99IPCMR = new CodingSchemeIdentificationItem("99IPCMR", null, "1.3.6.1.4.1.5962.98.2", "Imaging Procedure Code Mapping Resource");
    public static final CodingSchemeIdentificationItem Private_99QIICR = new CodingSchemeIdentificationItem("99QIICR", null, "1.3.6.1.4.1.43046.3.0.0", "NCI QIICR Project 3DSlicer BWH");
    protected static CodingSchemeIdentificationItem[] knownCodingSchemes = new CodingSchemeIdentificationItem[]{ACR, ASTM_SIG, C4, C5, caDSR, CD2, CTV3, DC, DCM, DCMUID, FMA, HPC, I10, I10C, I10P, I11, I9, I9C, IBSI, ICDO3, ISO3166_1, ISO639_1, ISO639_2, ITIS_TSN, LN, MA, MAYOASRG, MDC, MGI, MSH, NBD, NBG, NCIt, NDC, NEU, NICIP, NYUMCCG, PATHLEX, POS, PUBCHEM_CID, RADELEMENT, RADLEX, RFC3066, RFC5646, RO, RXNORM, SCT, SDM, SNM3, SRT, UBERON, UCUM, UMLS, UPC, Private_99_OFFIS_DCMTK, Private_99PMP, Private_99IPCMR, Private_99QIICR};

    protected static CodingSchemeIdentificationItem lookupByCodingSchemeDesignator(String string) {
        CodingSchemeIdentificationItem codingSchemeIdentificationItem = null;
        if (string != null && string.length() > 0) {
            for (CodingSchemeIdentificationItem codingSchemeIdentificationItem2 : knownCodingSchemes) {
                if (!codingSchemeIdentificationItem2.getCodingSchemeDesignator().equals(string)) continue;
                codingSchemeIdentificationItem = codingSchemeIdentificationItem2;
                break;
            }
        }
        return codingSchemeIdentificationItem;
    }

    public CodingSchemeIdentification(AttributeList attributeList) {
        SequenceAttribute sequenceAttribute;
        int n;
        Attribute attribute;
        if (attributeList != null && (attribute = attributeList.get(TagFromName.CodingSchemeIdentificationSequence)) != null && attribute instanceof SequenceAttribute && (n = (sequenceAttribute = (SequenceAttribute)attribute).getNumberOfItems()) > 0) {
            this.listOfItems = new ArrayList<CodingSchemeIdentificationItem>();
            for (int i = 0; i < n; ++i) {
                SequenceItem sequenceItem = sequenceAttribute.getItem(i);
                CodingSchemeIdentificationItem codingSchemeIdentificationItem = new CodingSchemeIdentificationItem(sequenceItem);
                this.listOfItems.add(codingSchemeIdentificationItem);
            }
        }
    }

    public CodingSchemeIdentification(List<CodingSchemeIdentificationItem> list) {
        this.listOfItems = list;
    }

    public SequenceAttribute getAsSequenceAttribute() {
        SequenceAttribute sequenceAttribute = null;
        if (this.listOfItems != null) {
            sequenceAttribute = new SequenceAttribute(TagFromName.CodingSchemeIdentificationSequence);
            for (CodingSchemeIdentificationItem codingSchemeIdentificationItem : this.listOfItems) {
                SequenceItem sequenceItem = codingSchemeIdentificationItem.getAsSequenceItem();
                sequenceAttribute.addItem(sequenceItem);
            }
        }
        return sequenceAttribute;
    }

    public CodingSchemeIdentificationItem getByCodingSchemeDesignator(String string) {
        CodingSchemeIdentificationItem codingSchemeIdentificationItem = null;
        if (this.listOfItems != null && string != null && string.length() > 0) {
            for (CodingSchemeIdentificationItem codingSchemeIdentificationItem2 : this.listOfItems) {
                if (!codingSchemeIdentificationItem2.getCodingSchemeDesignator().equals(string)) continue;
                codingSchemeIdentificationItem = codingSchemeIdentificationItem2;
            }
        }
        return codingSchemeIdentificationItem;
    }

    protected static void recursivelyCollectCodingSchemeDesignators(AttributeList attributeList, Set<String> set) {
        for (Object v : attributeList.values()) {
            Object object;
            Object object2;
            Attribute attribute;
            if (v instanceof SequenceAttribute) {
                attribute = (SequenceAttribute)v;
                object2 = ((SequenceAttribute)attribute).iterator();
                if (object2 == null) continue;
                while (object2.hasNext()) {
                    AttributeList attributeList2;
                    object = (SequenceItem)object2.next();
                    if (object == null || (attributeList2 = ((SequenceItem)object).getAttributeList()) == null) continue;
                    CodingSchemeIdentification.recursivelyCollectCodingSchemeDesignators(attributeList2, set);
                }
                continue;
            }
            attribute = (Attribute)v;
            object2 = attribute.getTag();
            if (!((AttributeTag)object2).equals(TagFromName.CodingSchemeDesignator) || ((String)(object = attribute.getSingleStringValueOrEmptyString())).length() <= 0) continue;
            set.add((String)object);
        }
    }

    public static CodingSchemeIdentification getCodingSchemesFromExistingAttributeList(AttributeList attributeList) {
        TreeSet<String> treeSet = new TreeSet<String>();
        CodingSchemeIdentification.recursivelyCollectCodingSchemeDesignators(attributeList, treeSet);
        ArrayList<CodingSchemeIdentificationItem> arrayList = null;
        for (String string : treeSet) {
            CodingSchemeIdentificationItem codingSchemeIdentificationItem = CodingSchemeIdentification.lookupByCodingSchemeDesignator(string);
            if (codingSchemeIdentificationItem == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<CodingSchemeIdentificationItem>();
            }
            arrayList.add(codingSchemeIdentificationItem);
        }
        return new CodingSchemeIdentification(arrayList);
    }

    public static void replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(AttributeList attributeList) {
        CodingSchemeIdentification codingSchemeIdentification = CodingSchemeIdentification.getCodingSchemesFromExistingAttributeList(attributeList);
        SequenceAttribute sequenceAttribute = codingSchemeIdentification.getAsSequenceAttribute();
        if (sequenceAttribute != null) {
            attributeList.put(sequenceAttribute);
        }
    }
}

