/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.util.ArrayList;

public class CompositeInstanceContext {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/CompositeInstanceContext.java,v 1.37 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(CompositeInstanceContext.class);
    protected AttributeList list = new AttributeList();
    protected static AttributeTag[] patientModuleAttributeTags = new AttributeTag[]{TagFromName.PatientName, TagFromName.PatientID, TagFromName.IssuerOfPatientID, TagFromName.IssuerOfPatientIDQualifiersSequence, TagFromName.TypeOfPatientID, TagFromName.PatientBirthDate, TagFromName.PatientBirthDateInAlternativeCalendar, TagFromName.PatientDeathDateInAlternativeCalendar, TagFromName.PatientAlternativeCalendar, TagFromName.PatientSex, TagFromName.ReferencedPatientPhotoSequence, TagFromName.QualityControlSubject, TagFromName.ReferencedPatientSequence, TagFromName.PatientBirthTime, TagFromName.OtherPatientIDs, TagFromName.OtherPatientIDsSequence, TagFromName.OtherPatientNames, TagFromName.EthnicGroup, TagFromName.PatientComments, TagFromName.PatientSpeciesDescription, TagFromName.PatientSpeciesCodeSequence, TagFromName.PatientBreedDescription, TagFromName.PatientBreedCodeSequence, TagFromName.BreedRegistrationSequence, TagFromName.StrainDescription, TagFromName.StrainNomenclature, TagFromName.StrainCodeSequence, TagFromName.StrainAdditionalInformation, TagFromName.StrainStockSequence, TagFromName.GeneticModificationsSequence, TagFromName.ResponsiblePerson, TagFromName.ResponsiblePersonRole, TagFromName.ResponsibleOrganization, TagFromName.PatientIdentityRemoved, TagFromName.DeidentificationMethod, TagFromName.DeidentificationMethodCodeSequence, TagFromName.SourcePatientGroupIdentificationSequence, TagFromName.GroupOfPatientsIdentificationSequence};
    protected static AttributeTag[] clinicalTrialSubjectModuleAttributeTags = new AttributeTag[]{TagFromName.ClinicalTrialSubjectID, TagFromName.ClinicalTrialSponsorName, TagFromName.ClinicalTrialProtocolID, TagFromName.ClinicalTrialProtocolName, TagFromName.ClinicalTrialSiteID, TagFromName.ClinicalTrialSiteName, TagFromName.ClinicalTrialSubjectID, TagFromName.ClinicalTrialSubjectReadingID, TagFromName.ClinicalTrialProtocolEthicsCommitteeName, TagFromName.ClinicalTrialProtocolEthicsCommitteeApprovalNumber};
    protected static AttributeTag[] generalStudyModuleAttributeTags = new AttributeTag[]{TagFromName.StudyInstanceUID, TagFromName.StudyDate, TagFromName.StudyTime, TagFromName.ReferringPhysicianName, TagFromName.ReferringPhysicianIdentificationSequence, TagFromName.ConsultingPhysicianName, TagFromName.ConsultingPhysicianIdentificationSequence, TagFromName.StudyID, TagFromName.AccessionNumber, TagFromName.IssuerOfAccessionNumberSequence, TagFromName.StudyDescription, TagFromName.PhysiciansOfRecord, TagFromName.PhysiciansOfRecordIdentificationSequence, TagFromName.NameOfPhysiciansReadingStudy, TagFromName.PhysiciansReadingStudyIdentificationSequence, TagFromName.RequestingServiceCodeSequence, TagFromName.ReferencedStudySequence, TagFromName.ProcedureCodeSequence, TagFromName.ReasonForPerformedProcedureCodeSequence};
    protected static AttributeTag[] patientStudyModuleAttributeTags = new AttributeTag[]{TagFromName.AdmittingDiagnosesDescription, TagFromName.AdmittingDiagnosesCodeSequence, TagFromName.PatientAge, TagFromName.PatientSize, TagFromName.PatientWeight, TagFromName.PatientBodyMassIndex, TagFromName.MeasuredAPDimension, TagFromName.MeasuredLateralDimension, TagFromName.PatientSizeCodeSequence, TagFromName.MedicalAlerts, TagFromName.Allergies, TagFromName.SmokingStatus, TagFromName.PregnancyStatus, TagFromName.LastMenstrualDate, TagFromName.PatientState, TagFromName.Occupation, TagFromName.AdditionalPatientHistory, TagFromName.AdmissionID, TagFromName.IssuerOfAdmissionID, TagFromName.IssuerOfAdmissionIDSequence, TagFromName.ServiceEpisodeID, TagFromName.IssuerOfServiceEpisodeIDSequence, TagFromName.ServiceEpisodeDescription, TagFromName.PatientSexNeutered};
    protected static AttributeTag[] clinicalTrialStudyModuleAttributeTags = new AttributeTag[]{TagFromName.ClinicalTrialTimePointID, TagFromName.ClinicalTrialTimePointDescription, TagFromName.LongitudinalTemporalOffsetFromEvent, TagFromName.LongitudinalTemporalEventType, TagFromName.ConsentForClinicalTrialUseSequence};
    protected static AttributeTag[] generalSeriesModuleAttributeTags = new AttributeTag[]{TagFromName.Modality, TagFromName.SeriesInstanceUID, TagFromName.SeriesNumber, TagFromName.Laterality, TagFromName.SeriesDate, TagFromName.SeriesTime, TagFromName.PerformingPhysicianName, TagFromName.PerformingPhysicianIdentificationSequence, TagFromName.ProtocolName, TagFromName.ReferencedDefinedProtocolSequence, TagFromName.ReferencedPerformedProtocolSequence, TagFromName.SeriesDescription, TagFromName.SeriesDescriptionCodeSequence, TagFromName.OperatorsName, TagFromName.OperatorIdentificationSequence, TagFromName.ReferencedPerformedProcedureStepSequence, TagFromName.RelatedSeriesSequence, TagFromName.BodyPartExamined, TagFromName.PatientPosition, TagFromName.RequestAttributesSequence, TagFromName.PerformedProcedureStepID, TagFromName.PerformedProcedureStepStartDate, TagFromName.PerformedProcedureStepStartTime, TagFromName.PerformedProcedureStepDescription, TagFromName.PerformedProtocolCodeSequence, TagFromName.CommentsOnThePerformedProcedureStep, TagFromName.AnatomicalOrientationType};
    protected static AttributeTag[] clinicalTrialSeriesModuleAttributeTags = new AttributeTag[]{TagFromName.ClinicalTrialCoordinatingCenterName, TagFromName.ClinicalTrialSeriesID, TagFromName.ClinicalTrialSeriesDescription};
    protected static AttributeTag[] generalEquipmentModuleAttributeTags = new AttributeTag[]{TagFromName.Manufacturer, TagFromName.InstitutionName, TagFromName.InstitutionAddress, TagFromName.StationName, TagFromName.InstitutionalDepartmentName, TagFromName.ManufacturerModelName, TagFromName.ManufacturerDeviceClassUID, TagFromName.DeviceSerialNumber, TagFromName.SoftwareVersions, TagFromName.GantryID, TagFromName.UDISequence, TagFromName.DeviceUID, TagFromName.SpatialResolution, TagFromName.DateOfLastCalibration, TagFromName.TimeOfLastCalibration, TagFromName.PixelPaddingValue};
    protected static AttributeTag[] frameOfReferenceModuleAttributeTags = new AttributeTag[]{TagFromName.FrameOfReferenceUID, TagFromName.PositionReferenceIndicator};
    protected static AttributeTag[] sopCommonModuleAttributeTags = new AttributeTag[]{TagFromName.SOPClassUID, TagFromName.SOPInstanceUID, TagFromName.InstanceCreationDate, TagFromName.InstanceCreationTime, TagFromName.InstanceCoercionDateTime, TagFromName.InstanceCreatorUID, TagFromName.RelatedGeneralSOPClassUID, TagFromName.OriginalSpecializedSOPClassUID, TagFromName.CodingSchemeIdentificationSequence, TagFromName.ContextGroupIdentificationSequence, TagFromName.MappingResourceIdentificationSequence, TagFromName.TimezoneOffsetFromUTC, TagFromName.ContributingEquipmentSequence, TagFromName.InstanceNumber, TagFromName.SOPInstanceStatus, TagFromName.SOPAuthorizationDateTime, TagFromName.SOPAuthorizationComment, TagFromName.AuthorizationEquipmentCertificationNumber, TagFromName.OriginalAttributesSequence, TagFromName.HL7StructuredDocumentReferenceSequence, TagFromName.LongitudinalTemporalInformationModified, TagFromName.QueryRetrieveView, TagFromName.ConversionSourceAttributesSequence, TagFromName.ContentQualification, TagFromName.PrivateDataElementCharacteristicsSequence, TagFromName.InstanceOriginStatus, TagFromName.BarcodeValue};
    protected static AttributeTag[] generalImageModuleAttributeTags = new AttributeTag[]{TagFromName.ContentDate, TagFromName.ContentTime};
    protected static AttributeTag[] srDocumentGeneralModuleAttributeTags = new AttributeTag[]{TagFromName.ReferencedRequestSequence, TagFromName.PerformedProcedureCodeSequence};

    public AttributeList getAttributeList() {
        return this.list;
    }

    public boolean equals(Object object) {
        if (object instanceof CompositeInstanceContext) {
            return this.list.equals(((CompositeInstanceContext)object).getAttributeList());
        }
        return false;
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    protected void addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(AttributeList attributeList, AttributeTag attributeTag) {
        Attribute attribute = attributeList.get(attributeTag);
        if (attribute != null) {
            if (attribute.getVM() > 0 || attribute instanceof SequenceAttribute && ((SequenceAttribute)attribute).getNumberOfItems() > 0) {
                if (this.list.get(attributeTag) == null) {
                    this.list.put(attributeTag, attribute);
                }
            } else {
                this.list.put(attributeTag, attribute);
            }
        }
    }

    public CompositeInstanceContext() {
    }

    public CompositeInstanceContext(AttributeList attributeList, boolean bl) {
        this.updateFromSource(attributeList, bl);
    }

    public CompositeInstanceContext(AttributeList attributeList) {
        this(attributeList, true);
    }

    protected void createReferencedRequestSequenceIfAbsent(AttributeList attributeList) {
        try {
            SequenceAttribute sequenceAttribute;
            int n;
            Attribute attribute = this.list.get(TagFromName.ReferencedRequestSequence);
            Attribute attribute2 = this.list.get(TagFromName.RequestAttributesSequence);
            if ((attribute == null || !(attribute instanceof SequenceAttribute) || ((SequenceAttribute)attribute).getNumberOfItems() == 0) && attribute2 != null && attribute2 instanceof SequenceAttribute && (n = (sequenceAttribute = (SequenceAttribute)attribute2).getNumberOfItems()) > 0) {
                SequenceAttribute sequenceAttribute2 = new SequenceAttribute(TagFromName.ReferencedRequestSequence);
                for (int i = 0; i < n; ++i) {
                    SequenceItem sequenceItem = sequenceAttribute.getItem(i);
                    AttributeList attributeList2 = sequenceItem.getAttributeList();
                    AttributeList attributeList3 = new AttributeList();
                    AttributeTag attributeTag = TagFromName.StudyInstanceUID;
                    Object object = Attribute.getSingleStringValueOrEmptyString(attributeList2, attributeTag);
                    StringAttribute stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                    ((Attribute)stringAttribute).addValue((String)object);
                    attributeList3.put(stringAttribute);
                    attributeTag = TagFromName.ReferencedStudySequence;
                    object = attributeList2.get(attributeTag);
                    if (object == null) {
                        object = new SequenceAttribute(TagFromName.ReferencedStudySequence);
                    }
                    attributeList3.put((Attribute)object);
                    attributeTag = TagFromName.AccessionNumber;
                    object = Attribute.getSingleStringValueOrEmptyString(attributeList2, attributeTag);
                    stringAttribute = new ShortStringAttribute(attributeTag);
                    ((Attribute)stringAttribute).addValue((String)object);
                    attributeList3.put(stringAttribute);
                    attributeTag = TagFromName.IssuerOfAccessionNumberSequence;
                    object = attributeList2.get(attributeTag);
                    if (object != null) {
                        attributeList3.put((Attribute)object);
                    }
                    attributeTag = TagFromName.PlacerOrderNumberImagingServiceRequest;
                    object = Attribute.getSingleStringValueOrEmptyString(attributeList2, attributeTag);
                    stringAttribute = new LongStringAttribute(attributeTag);
                    ((Attribute)stringAttribute).addValue((String)object);
                    attributeList3.put(stringAttribute);
                    attributeTag = TagFromName.OrderPlacerIdentifierSequence;
                    object = attributeList2.get(attributeTag);
                    if (object != null) {
                        attributeList3.put((Attribute)object);
                    }
                    attributeTag = TagFromName.FillerOrderNumberImagingServiceRequest;
                    object = Attribute.getSingleStringValueOrEmptyString(attributeList2, attributeTag);
                    stringAttribute = new LongStringAttribute(attributeTag);
                    ((Attribute)stringAttribute).addValue((String)object);
                    attributeList3.put(stringAttribute);
                    attributeTag = TagFromName.OrderFillerIdentifierSequence;
                    object = attributeList2.get(attributeTag);
                    if (object != null) {
                        attributeList3.put((Attribute)object);
                    }
                    attributeTag = TagFromName.RequestedProcedureID;
                    object = Attribute.getSingleStringValueOrEmptyString(attributeList2, attributeTag);
                    stringAttribute = new ShortStringAttribute(attributeTag);
                    ((Attribute)stringAttribute).addValue((String)object);
                    attributeList3.put(stringAttribute);
                    attributeTag = TagFromName.RequestedProcedureDescription;
                    object = Attribute.getSingleStringValueOrEmptyString(attributeList2, attributeTag);
                    stringAttribute = new LongStringAttribute(attributeTag);
                    ((Attribute)stringAttribute).addValue((String)object);
                    attributeList3.put(stringAttribute);
                    attributeTag = TagFromName.RequestedProcedureCodeSequence;
                    object = attributeList2.get(attributeTag);
                    if (object == null) {
                        object = new SequenceAttribute(TagFromName.ReferencedStudySequence);
                    }
                    attributeList3.put((Attribute)object);
                    attributeTag = TagFromName.ReasonForTheRequestedProcedure;
                    object = Attribute.getSingleStringValueOrEmptyString(attributeList2, attributeTag);
                    if (((String)object).length() > 0) {
                        stringAttribute = new LongStringAttribute(attributeTag);
                        ((Attribute)stringAttribute).addValue((String)object);
                        attributeList3.put(stringAttribute);
                    }
                    if ((object = attributeList2.get(attributeTag = TagFromName.ReasonForRequestedProcedureCodeSequence)) != null) {
                        attributeList3.put((Attribute)object);
                    }
                    sequenceAttribute2.addItem(attributeList3);
                }
                this.list.put(sequenceAttribute2);
            }
        }
        catch (DicomException dicomException) {
            slf4jlogger.error("Ignoring exception", dicomException);
        }
    }

    protected void createPerformedProcedureCodeSequenceIfAbsent(AttributeList attributeList) {
        SequenceAttribute sequenceAttribute;
        int n;
        Attribute attribute = this.list.get(TagFromName.PerformedProcedureCodeSequence);
        Attribute attribute2 = this.list.get(TagFromName.ProcedureCodeSequence);
        if ((attribute == null || !(attribute instanceof SequenceAttribute) || ((SequenceAttribute)attribute).getNumberOfItems() == 0) && attribute2 != null && attribute2 instanceof SequenceAttribute && (n = (sequenceAttribute = (SequenceAttribute)attribute2).getNumberOfItems()) > 0) {
            SequenceAttribute sequenceAttribute2 = new SequenceAttribute(TagFromName.PerformedProcedureCodeSequence);
            for (int i = 0; i < n; ++i) {
                SequenceItem sequenceItem = sequenceAttribute.getItem(i);
                sequenceAttribute2.addItem(sequenceItem);
            }
            this.list.put(sequenceAttribute2);
        }
    }

    public void updateFromSource(AttributeList attributeList, boolean bl) {
        for (AttributeTag attributeTag : patientModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        for (AttributeTag attributeTag : clinicalTrialSubjectModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        for (AttributeTag attributeTag : generalStudyModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        for (AttributeTag attributeTag : patientStudyModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        for (AttributeTag attributeTag : clinicalTrialStudyModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        for (AttributeTag attributeTag : generalSeriesModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        for (AttributeTag attributeTag : clinicalTrialSeriesModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        for (AttributeTag attributeTag : generalEquipmentModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        for (AttributeTag attributeTag : frameOfReferenceModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        for (AttributeTag attributeTag : sopCommonModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        for (AttributeTag attributeTag : generalImageModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        for (AttributeTag attributeTag : srDocumentGeneralModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        if (bl) {
            this.createReferencedRequestSequenceIfAbsent(attributeList);
            this.createPerformedProcedureCodeSequenceIfAbsent(attributeList);
        }
        this.list.removeGroupLengthAttributes();
    }

    public void updateFromSource(AttributeList attributeList) {
        this.updateFromSource(attributeList, true);
    }

    public static void removePatient(AttributeList attributeList) {
        for (AttributeTag attributeTag : patientModuleAttributeTags) {
            attributeList.remove(attributeTag);
        }
        for (AttributeTag attributeTag : clinicalTrialSubjectModuleAttributeTags) {
            attributeList.remove(attributeTag);
        }
    }

    public static void removeAllButPatient(AttributeList attributeList) {
        CompositeInstanceContext.removeStudy(attributeList);
        CompositeInstanceContext.removeSeries(attributeList);
        CompositeInstanceContext.removeEquipment(attributeList);
        CompositeInstanceContext.removeFrameOfReference(attributeList);
        CompositeInstanceContext.removeInstance(attributeList);
        CompositeInstanceContext.removeSRDocumentGeneral(attributeList);
    }

    public static void removeAllButStudy(AttributeList attributeList) {
        CompositeInstanceContext.removePatient(attributeList);
        CompositeInstanceContext.removeSeries(attributeList);
        CompositeInstanceContext.removeEquipment(attributeList);
        CompositeInstanceContext.removeFrameOfReference(attributeList);
        CompositeInstanceContext.removeInstance(attributeList);
        CompositeInstanceContext.removeSRDocumentGeneral(attributeList);
    }

    public static void removeAllButSeries(AttributeList attributeList) {
        CompositeInstanceContext.removePatient(attributeList);
        CompositeInstanceContext.removeStudy(attributeList);
        CompositeInstanceContext.removeEquipment(attributeList);
        CompositeInstanceContext.removeFrameOfReference(attributeList);
        CompositeInstanceContext.removeInstance(attributeList);
        CompositeInstanceContext.removeSRDocumentGeneral(attributeList);
    }

    public static void removeAllButPatientAndStudy(AttributeList attributeList) {
        CompositeInstanceContext.removeSeries(attributeList);
        CompositeInstanceContext.removeEquipment(attributeList);
        CompositeInstanceContext.removeFrameOfReference(attributeList);
        CompositeInstanceContext.removeInstance(attributeList);
        CompositeInstanceContext.removeSRDocumentGeneral(attributeList);
    }

    public static void removeStudy(AttributeList attributeList) {
        for (AttributeTag attributeTag : generalStudyModuleAttributeTags) {
            attributeList.remove(attributeTag);
        }
        for (AttributeTag attributeTag : patientStudyModuleAttributeTags) {
            attributeList.remove(attributeTag);
        }
        for (AttributeTag attributeTag : clinicalTrialStudyModuleAttributeTags) {
            attributeList.remove(attributeTag);
        }
    }

    public static void removeSeries(AttributeList attributeList) {
        for (AttributeTag attributeTag : generalSeriesModuleAttributeTags) {
            attributeList.remove(attributeTag);
        }
        for (AttributeTag attributeTag : clinicalTrialSeriesModuleAttributeTags) {
            attributeList.remove(attributeTag);
        }
    }

    public static void removeEquipment(AttributeList attributeList) {
        for (AttributeTag attributeTag : generalEquipmentModuleAttributeTags) {
            attributeList.remove(attributeTag);
        }
    }

    public static void removeFrameOfReference(AttributeList attributeList) {
        for (AttributeTag attributeTag : frameOfReferenceModuleAttributeTags) {
            attributeList.remove(attributeTag);
        }
    }

    public static void removeInstance(AttributeList attributeList) {
        for (AttributeTag attributeTag : sopCommonModuleAttributeTags) {
            attributeList.remove(attributeTag);
        }
        for (AttributeTag attributeTag : generalImageModuleAttributeTags) {
            attributeList.remove(attributeTag);
        }
    }

    public static void removeSRDocumentGeneral(AttributeList attributeList) {
        for (AttributeTag attributeTag : srDocumentGeneralModuleAttributeTags) {
            attributeList.remove(attributeTag);
        }
    }

    public static void removeAllButSelected(AttributeList attributeList, Selector selector) {
        if (!selector.patient) {
            CompositeInstanceContext.removePatient(attributeList);
        }
        if (!selector.study) {
            CompositeInstanceContext.removeStudy(attributeList);
        }
        if (!selector.equipment) {
            CompositeInstanceContext.removeEquipment(attributeList);
        }
        if (!selector.frameOfReference) {
            CompositeInstanceContext.removeFrameOfReference(attributeList);
        }
        if (!selector.series) {
            CompositeInstanceContext.removeSeries(attributeList);
        }
        if (!selector.instance) {
            CompositeInstanceContext.removeInstance(attributeList);
        }
        if (!selector.srDocumentGeneral) {
            CompositeInstanceContext.removeSRDocumentGeneral(attributeList);
        }
    }

    public static void removeAllSelected(AttributeList attributeList, Selector selector) {
        if (selector.patient) {
            CompositeInstanceContext.removePatient(attributeList);
        }
        if (selector.study) {
            CompositeInstanceContext.removeStudy(attributeList);
        }
        if (selector.equipment) {
            CompositeInstanceContext.removeEquipment(attributeList);
        }
        if (selector.frameOfReference) {
            CompositeInstanceContext.removeFrameOfReference(attributeList);
        }
        if (selector.series) {
            CompositeInstanceContext.removeSeries(attributeList);
        }
        if (selector.instance) {
            CompositeInstanceContext.removeInstance(attributeList);
        }
        if (selector.srDocumentGeneral) {
            CompositeInstanceContext.removeSRDocumentGeneral(attributeList);
        }
    }

    public void removePatient() {
        CompositeInstanceContext.removePatient(this.list);
    }

    public void removeAllButPatient() {
        CompositeInstanceContext.removeAllButPatient(this.list);
    }

    public void removeAllButStudy() {
        CompositeInstanceContext.removeAllButStudy(this.list);
    }

    public void removeAllButSeries() {
        CompositeInstanceContext.removeAllButSeries(this.list);
    }

    public void removeAllButPatientAndStudy() {
        CompositeInstanceContext.removeAllButPatientAndStudy(this.list);
    }

    public void removeStudy() {
        CompositeInstanceContext.removeStudy(this.list);
    }

    public void removeSeries() {
        CompositeInstanceContext.removeSeries(this.list);
    }

    public void removeEquipment() {
        CompositeInstanceContext.removeEquipment(this.list);
    }

    public void removeFrameOfReference() {
        CompositeInstanceContext.removeFrameOfReference(this.list);
    }

    public void removeInstance() {
        CompositeInstanceContext.removeInstance(this.list);
    }

    public void removeSRDocumentGeneral() {
        CompositeInstanceContext.removeSRDocumentGeneral(this.list);
    }

    public void removeAllButSelected(Selector selector) {
        if (!selector.patient) {
            CompositeInstanceContext.removePatient(this.list);
        }
        if (!selector.study) {
            CompositeInstanceContext.removeStudy(this.list);
        }
        if (!selector.equipment) {
            CompositeInstanceContext.removeEquipment(this.list);
        }
        if (!selector.frameOfReference) {
            CompositeInstanceContext.removeFrameOfReference(this.list);
        }
        if (!selector.series) {
            CompositeInstanceContext.removeSeries(this.list);
        }
        if (!selector.instance) {
            CompositeInstanceContext.removeInstance(this.list);
        }
        if (!selector.srDocumentGeneral) {
            CompositeInstanceContext.removeSRDocumentGeneral(this.list);
        }
    }

    public void removeAllSelected(Selector selector) {
        if (selector.patient) {
            CompositeInstanceContext.removePatient(this.list);
        }
        if (selector.study) {
            CompositeInstanceContext.removeStudy(this.list);
        }
        if (selector.equipment) {
            CompositeInstanceContext.removeEquipment(this.list);
        }
        if (selector.frameOfReference) {
            CompositeInstanceContext.removeFrameOfReference(this.list);
        }
        if (selector.series) {
            CompositeInstanceContext.removeSeries(this.list);
        }
        if (selector.instance) {
            CompositeInstanceContext.removeInstance(this.list);
        }
        if (selector.srDocumentGeneral) {
            CompositeInstanceContext.removeSRDocumentGeneral(this.list);
        }
    }

    public void put(Attribute attribute) {
        this.list.put(attribute);
    }

    public void putAll(AttributeList attributeList) {
        this.list.putAll(attributeList);
    }

    public String toString() {
        return this.list.toString();
    }

    public static class Selector {
        public boolean patient;
        public boolean study;
        public boolean equipment;
        public boolean frameOfReference;
        public boolean series;
        public boolean instance;
        public boolean srDocumentGeneral;

        public Selector(boolean bl) {
            if (bl) {
                this.patient = true;
                this.study = true;
                this.equipment = true;
                this.frameOfReference = true;
                this.series = true;
                this.instance = true;
                this.srDocumentGeneral = true;
            }
        }

        public Selector(String[] stringArray, ArrayList<String> arrayList) {
            for (String string : stringArray) {
                String string2 = string.toLowerCase().trim();
                if (string2.equals("-patient")) {
                    this.patient = true;
                    continue;
                }
                if (string2.equals("-study")) {
                    this.study = true;
                    continue;
                }
                if (string2.equals("-equipment")) {
                    this.equipment = true;
                    continue;
                }
                if (string2.equals("-frameofreference")) {
                    this.frameOfReference = true;
                    continue;
                }
                if (string2.equals("-series")) {
                    this.series = true;
                    continue;
                }
                if (string2.equals("-instance")) {
                    this.instance = true;
                    continue;
                }
                if (string2.equals("-srdocumentgeneral")) {
                    this.srDocumentGeneral = true;
                    continue;
                }
                arrayList.add(string);
            }
        }
    }
}

