/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.BinaryOutputStream;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

public class CompressedFrameEncoder {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/CompressedFrameEncoder.java,v 1.18 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(CompressedFrameEncoder.class);

    public static String chooseOutputFormatForTransferSyntax(String string) {
        String string2 = null;
        if (string.equals("1.2.840.10008.1.2.4.91") || string.equals("1.2.840.10008.1.2.4.90")) {
            string2 = "jpeg2000";
        } else if (string.equals("1.2.840.10008.1.2.4.57") || string.equals("1.2.840.10008.1.2.4.70")) {
            string2 = "jpeg-lossless";
        } else if (string.equals("1.2.840.10008.1.2.4.80") || string.equals("1.2.840.10008.1.2.4.81")) {
            string2 = "jpeg-ls";
        } else if (string.equals("1.2.840.10008.1.2.4.50") || string.equals("1.2.840.10008.1.2.4.51")) {
            string2 = "jpeg";
        } else if (string.equals("1.2.840.10008.1.2.5")) {
            string2 = "rle";
        }
        return string2;
    }

    public static String chooseTransferSyntaxForOutputFormat(String string) {
        String string2 = null;
        if (string.equals("jpeg2000")) {
            string2 = "1.2.840.10008.1.2.4.90";
        } else if (string.equals("jpeg-lossless")) {
            string2 = "1.2.840.10008.1.2.4.70";
        } else if (string.equals("jpeg-ls")) {
            string2 = "1.2.840.10008.1.2.4.80";
        } else if (string.equals("jpeg")) {
            string2 = "1.2.840.10008.1.2.4.50";
        } else if (string.equals("rle")) {
            string2 = "1.2.840.10008.1.2.5";
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getCompressedFrameAsFile(AttributeList attributeList, BufferedImage bufferedImage, String string, File file) throws IOException, FileNotFoundException, DicomException {
        File file2 = null;
        if (string.equals("rle")) {
            int n;
            int n2;
            int n3;
            int n4 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsStored, 0);
            if (n4 == 1) {
                throw new DicomException("Cannot compress single bit images using RLE");
            }
            int n5 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 0);
            int n6 = n5 * (n3 = (n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsAllocated, 0)) / 8);
            if (n6 > 15) {
                throw new DicomException("Cannot compress image with " + n2 + " Bits Allocated and " + n5 + " Samples per Pixel using RLE since would require " + n6 + " segments");
            }
            byte[][] byArrayArray = new byte[n6][];
            SampleModel sampleModel = bufferedImage.getSampleModel();
            WritableRaster writableRaster = bufferedImage.getRaster();
            int n7 = writableRaster.getNumBands();
            if (n7 != n5) {
                throw new DicomException("Cannot compress image with " + n7 + " bands but " + n5 + " Samples per Pixel using RLE");
            }
            int n8 = sampleModel.getDataType();
            DataBuffer dataBuffer = writableRaster.getDataBuffer();
            int n9 = bufferedImage.getWidth();
            int n10 = bufferedImage.getHeight();
            slf4jlogger.debug("w*h*samplesPerPixel*bytesPerSample={}", n9 * n10 * n5 * n3);
            byte[] byArray = new byte[128];
            int n11 = 0;
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n3; ++j) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    n = (n3 - j - 1) * 8;
                    for (int k = 0; k < n10; ++k) {
                        int n12 = 0;
                        int n13 = 0;
                        byte by = 0;
                        boolean bl = false;
                        for (int i2 = 0; i2 < n9; ++i2) {
                            int n14 = sampleModel.getSample(i2, k, i, dataBuffer);
                            byte by2 = (byte)(n14 >> n);
                            if (n13 > 0) {
                                if (by2 == by) {
                                    if (++n13 < 128) continue;
                                    if (slf4jlogger.isTraceEnabled()) {
                                        slf4jlogger.trace("[{},{}] writing run of length {} of byte {} dec", k, i2, n13, by & 0xFF);
                                    }
                                    byteArrayOutputStream.write(1 - n13);
                                    byteArrayOutputStream.write(by);
                                    n13 = 0;
                                    n12 = 0;
                                    continue;
                                }
                                if (slf4jlogger.isTraceEnabled()) {
                                    slf4jlogger.trace("[{},{}] end of run of length {} of byte {} dec caused by new byte {} dec", k, i2, n13, by & 0xFF, by2 & 0xFF);
                                }
                                byteArrayOutputStream.write(1 - n13);
                                byteArrayOutputStream.write(by);
                                n13 = 0;
                                byArray[0] = by2;
                                n12 = 1;
                                continue;
                            }
                            if (n12 >= 128) {
                                if (slf4jlogger.isTraceEnabled()) {
                                    slf4jlogger.trace("[{},{}] writing full buffer length {}", k, i2, n12);
                                }
                                byteArrayOutputStream.write(n12 - 1);
                                byteArrayOutputStream.write(byArray, 0, n12);
                                byArray[0] = by2;
                                n12 = 1;
                                continue;
                            }
                            if (n12 == 1 && by2 == byArray[0]) {
                                if (slf4jlogger.isTraceEnabled()) {
                                    slf4jlogger.trace("[{},{}] detected start of run of {} dec so using single byte in existing buffer length {}", k, i2, by2 & 0xFF, n12 - 1);
                                }
                                by = by2;
                                n13 = 2;
                                n12 = 0;
                                continue;
                            }
                            if (n12 > 1 && by2 == byArray[n12 - 1]) {
                                if (slf4jlogger.isTraceEnabled()) {
                                    slf4jlogger.trace("[{},{}] detected start of run of {} dec so writing existing buffer length {}", k, i2, by2 & 0xFF, n12 - 1);
                                }
                                byteArrayOutputStream.write(n12 - 1 - 1);
                                byteArrayOutputStream.write(byArray, 0, n12 - 1);
                                by = by2;
                                n13 = 2;
                                n12 = 0;
                                continue;
                            }
                            byArray[n12++] = by2;
                        }
                        if (n13 > 0) {
                            if (slf4jlogger.isTraceEnabled()) {
                                slf4jlogger.trace("[{},] end of row flushing run of length {} of byte {} dec", k, n13, by & 0xFF);
                            }
                            byteArrayOutputStream.write(1 - n13);
                            byteArrayOutputStream.write(by);
                            continue;
                        }
                        if (n12 <= 0) continue;
                        if (slf4jlogger.isTraceEnabled()) {
                            slf4jlogger.trace("[{},] end of row flushing buffer length {}", k, n12);
                        }
                        byteArrayOutputStream.write(n12 - 1);
                        byteArrayOutputStream.write(byArray, 0, n12);
                    }
                    if (byteArrayOutputStream.size() % 2 != 0) {
                        byteArrayOutputStream.write(0);
                    }
                    byArrayArray[n11] = byteArrayOutputStream.toByteArray();
                    if (slf4jlogger.isDebugEnabled()) {
                        slf4jlogger.debug("segments[{}].length={} sample={} doingByte={}", n11, byArrayArray[n11].length, i, j);
                    }
                    ++n11;
                }
            }
            slf4jlogger.debug("Have {} segments", n11);
            BinaryOutputStream binaryOutputStream = new BinaryOutputStream(new FileOutputStream(file), false);
            binaryOutputStream.writeUnsigned32(n11);
            long l = 64L;
            for (n = 0; n < 15; ++n) {
                if (n < n11) {
                    slf4jlogger.debug("segments[{}] offset {}", n, l);
                    binaryOutputStream.writeUnsigned32(l);
                    l += (long)byArrayArray[n].length;
                    continue;
                }
                slf4jlogger.debug("segments[{}] offset 0", n);
                binaryOutputStream.writeUnsigned32(0L);
            }
            for (n = 0; n < n11; ++n) {
                binaryOutputStream.write(byArrayArray[n]);
            }
            binaryOutputStream.flush();
            binaryOutputStream.close();
            return file;
        }
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        if (iterator == null) throw new DicomException("Cannot find writer for format " + string);
        if (!iterator.hasNext()) throw new DicomException("Cannot find writer for format " + string);
        ImageWriter imageWriter = iterator.next();
        if (imageWriter == null) throw new DicomException("Cannot find writer for format " + string);
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("getCompressedFrameAsFile(): Using writer {} {} {}", imageWriter.getOriginatingProvider().getDescription(Locale.US), imageWriter.getOriginatingProvider().getVendorName(), imageWriter.getOriginatingProvider().getVersion());
        }
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file);
        imageWriter.setOutput(imageOutputStream);
        try {
            Class<?> clazz;
            boolean bl = false;
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            boolean bl2 = imageWriteParam.canWriteCompressed();
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("doSomethingWithDicomFileOnMedia(): ImageWriteParam.canWriteCompressed() = {}", bl2);
            }
            if (bl2) {
                if (string.equals("jpeg2000")) {
                    clazz = Class.forName("com.sun.media.imageio.plugins.jpeg2000.J2KImageWriteParam");
                    if (imageWriteParam != null && clazz.isInstance(imageWriteParam)) {
                        Method method = clazz.getMethod("canWriteCompressed", new Class[0]);
                        if (method == null) {
                            throw new DicomException("Could not get J2KImageWriteParam.canWriteCompressed() method");
                        }
                        Method method2 = clazz.getMethod("setLossless", Boolean.TYPE);
                        if (method2 == null) {
                            throw new DicomException("Could not get J2KImageWriteParam.setLossless() method");
                        }
                        method2.invoke((Object)imageWriteParam, Boolean.TRUE);
                        Method method3 = clazz.getMethod("setComponentTransformation", Boolean.TYPE);
                        if (method3 == null) {
                            throw new DicomException("Could not get J2KImageWriteParam.setComponentTransformation() method");
                        }
                        method3.invoke((Object)imageWriteParam, Boolean.TRUE);
                        Method method4 = clazz.getMethod("setWriteCodeStreamOnly", Boolean.TYPE);
                        if (method4 == null) {
                            throw new DicomException("Could not get setWriteCodeStreamOnly() method");
                        }
                        method4.invoke((Object)imageWriteParam, Boolean.TRUE);
                        bl = true;
                    }
                } else if (string.equals("jpeg-lossless")) {
                    imageWriteParam.setCompressionType("JPEG-LOSSLESS");
                    bl = true;
                } else if (string.equals("jpeg-ls")) {
                    imageWriteParam.setCompressionType("JPEG-LS");
                    bl = true;
                } else if (string.equals("jpeg")) {
                    imageWriteParam.setCompressionMode(2);
                    imageWriteParam.setCompressionQuality(1.0f);
                    bl = true;
                }
            }
            if (bl) {
                clazz = null;
                imageWriter.write((IIOMetadata)((Object)clazz), new IIOImage(bufferedImage, null, (IIOMetadata)((Object)clazz)), imageWriteParam);
                imageOutputStream.flush();
                imageOutputStream.close();
                file2 = file;
                try {
                    slf4jlogger.trace("doSomethingWithDicomFileOnMedia(): Calling dispose() on writer");
                    imageWriter.dispose();
                    return file2;
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
                return file2;
            }
            slf4jlogger.error("Could not setup writer with compression and necessary parameters");
            return file2;
        }
        catch (Exception exception) {
            slf4jlogger.error("Exception while setting parameters for writer", exception);
        }
        return file2;
    }
}

