/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;

public class DateAttribute
extends StringAttribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DateAttribute.java,v 1.23 2025/01/29 10:58:06 dclunie Exp $";
    protected static final int MAX_LENGTH_SINGLE_VALUE = 8;

    @Override
    public final int getMaximumLengthOfSingleValue() {
        return 8;
    }

    public DateAttribute(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public DateAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream);
    }

    public DateAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream);
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.DA;
    }

    @Override
    protected final boolean allowRepairOfIncorrectLength() {
        return false;
    }

    @Override
    protected final boolean allowRepairOfInvalidCharacterReplacement() {
        return true;
    }

    @Override
    protected char getInvalidCharacterReplacement() {
        return '\u0000';
    }

    @Override
    public final boolean isCharacterInValueValid(int n) throws DicomException {
        return n < 127 && Character.isDigit(n);
    }

    @Override
    public boolean areValuesWellFormed() throws DicomException {
        boolean bl = true;
        if (this.originalValues != null && this.originalValues.length > 0) {
            for (int i = 0; i < this.originalValues.length; ++i) {
                String string = this.originalValues[i];
                if (string == null || string.length() <= 0 || string.length() == 8) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }
}

