/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeAttribute
extends StringAttribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DateTimeAttribute.java,v 1.30 2025/01/29 10:58:06 dclunie Exp $";
    protected static final int MAX_LENGTH_SINGLE_VALUE = 26;

    @Override
    public final int getMaximumLengthOfSingleValue() {
        return 26;
    }

    public DateTimeAttribute(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public DateTimeAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream);
    }

    public DateTimeAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream);
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.DT;
    }

    @Override
    protected final boolean allowRepairOfIncorrectLength() {
        return false;
    }

    @Override
    protected final boolean allowRepairOfInvalidCharacterReplacement() {
        return false;
    }

    @Override
    public final boolean isCharacterInValueValid(int n) throws DicomException {
        return n < 127 && (Character.isDigit(n) || n == 32 || n == 43 || n == 45 || n == 46);
    }

    public static String getFormattedString(Date date, TimeZone timeZone, boolean bl) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(bl ? "yyyyMMddHHmmss.SSSZ" : "yyyyMMddHHmmss.SSS");
        simpleDateFormat.setTimeZone(timeZone);
        return simpleDateFormat.format(date);
    }

    public static String getFormattedString(Date date, TimeZone timeZone) {
        return DateTimeAttribute.getFormattedString(date, timeZone, true);
    }

    public static String getFormattedStringUTC(Date date) {
        return DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT"));
    }

    public static String getFormattedStringDefaultTimeZone(Date date) {
        return DateTimeAttribute.getFormattedString(date, TimeZone.getDefault());
    }

    public static String getFormattedString(Date date) {
        return DateTimeAttribute.getFormattedStringDefaultTimeZone(date);
    }

    public static Date getDateFromFormattedString(String string) throws ParseException {
        char c;
        int n = string.length();
        Date date = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (n >= 4) {
            stringBuffer.append("yyyy");
            n2 = 4;
            if (n >= 6 && Character.isDigit(string.charAt(n2))) {
                stringBuffer.append("MM");
                n2 = 6;
                if (n >= 8 && Character.isDigit(string.charAt(n2))) {
                    stringBuffer.append("dd");
                    n2 = 8;
                    if (n >= 10 && Character.isDigit(string.charAt(n2))) {
                        stringBuffer.append("HH");
                        n2 = 10;
                        if (n >= 12 && Character.isDigit(string.charAt(n2))) {
                            stringBuffer.append("mm");
                            n2 = 12;
                            if (n >= 14 && Character.isDigit(string.charAt(n2))) {
                                stringBuffer.append("ss");
                                n2 = 14;
                                if (n > 14 && string.charAt(n2) == '.') {
                                    stringBuffer.append(".");
                                    while (++n2 < n && Character.isDigit(string.charAt(n2))) {
                                        ++n4;
                                        if (n3 != 0) continue;
                                        n3 = n2;
                                    }
                                    if (n4 > 0) {
                                        stringBuffer.append("SSS");
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (n2 < n && ((c = string.charAt(n2)) == '+' || c == '-')) {
            stringBuffer.append("Z");
            bl = true;
        }
        if (n4 > 0) {
            if (n4 < 3) {
                StringBuffer stringBuffer2 = new StringBuffer();
                for (int i = n4; i < 3; ++i) {
                    stringBuffer2.append("0");
                }
                string = string.substring(0, n3 + n4) + stringBuffer2.toString() + string.substring(n3 + n4);
            } else if (n4 > 3) {
                string = string.substring(0, n3 + 3) + string.substring(n3 + n4);
            }
        }
        if (!bl) {
            stringBuffer.append("Z");
            string = string + "+0000";
        }
        String string2 = stringBuffer.toString();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        date = simpleDateFormat.parse(string);
        return date;
    }

    public static Date getDateFromFormattedString(AttributeList attributeList, AttributeTag attributeTag, AttributeTag attributeTag2) throws ParseException, DicomException {
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, attributeTag);
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, attributeTag2);
        if (string.length() == 0) {
            throw new DicomException("Missing date attribute or value for " + attributeTag);
        }
        return DateTimeAttribute.getDateFromFormattedString(string + string2 + Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.TimezoneOffsetFromUTC, "+0000"));
    }

    public static TimeZone getTimeZone(String string) {
        String string2 = "";
        if (string.length() == 5 && (string.startsWith("+") || string.startsWith("-"))) {
            string2 = "GMT" + string.substring(0, 3) + ":" + string.substring(3);
        }
        return TimeZone.getTimeZone(string2);
    }

    public static String getTimeZone(TimeZone timeZone, Date date) {
        int n = timeZone.getOffset(date.getTime());
        boolean bl = false;
        if (n < 0) {
            bl = true;
            n = -n;
        }
        int n2 = n / 1000 / 60;
        int n3 = n2 / 60;
        int n4 = n2 % 60;
        String string = (bl ? "-" : "+") + (n3 > 9 ? "" : "0") + n3 + (n4 > 9 ? "" : "0") + n4;
        return string;
    }

    public static String getCurrentTimeZone() {
        return DateTimeAttribute.getTimeZone(TimeZone.getDefault(), new Date());
    }

    public static long getTimeInMilliSecondsSinceEpoch(String string) throws ParseException {
        Date date = DateTimeAttribute.getDateFromFormattedString(string);
        long l = date.getTime();
        return l;
    }

    public static long getTimeInMilliSecondsSinceEpoch(AttributeList attributeList, AttributeTag attributeTag, AttributeTag attributeTag2) throws ParseException, DicomException {
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, attributeTag);
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, attributeTag2);
        if (string.length() == 0) {
            throw new DicomException("Missing date attribute or value for " + attributeTag);
        }
        return DateTimeAttribute.getTimeInMilliSecondsSinceEpoch(string + string2 + Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.TimezoneOffsetFromUTC, "+0000"));
    }
}

