/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTagAttribute;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodingSchemeIdentification;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherByteAttributeMultipleCompressedFrames;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.TransferSyntax;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.StringUtilities;
import com.pixelmed.utils.XPathQuery;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.FileImageInputStream;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EncapsulateImageInDicom {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/EncapsulateImageInDicom.java,v 1.10 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(EncapsulateImageInDicom.class);

    private static String dumpTree(Node node, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = node.getNodeName();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("    ");
        }
        stringBuffer.append("<");
        stringBuffer.append(string);
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                if (node2 == null) continue;
                stringBuffer.append(" ");
                stringBuffer.append(node2.getNodeName());
                stringBuffer.append("=\"");
                stringBuffer.append(node2.getNodeValue());
                stringBuffer.append("\"");
            }
        }
        stringBuffer.append(">");
        String string2 = node.getNodeValue();
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append("\n");
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            stringBuffer.append(EncapsulateImageInDicom.dumpTree(node3, n + 1));
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("    ");
        }
        stringBuffer.append("</");
        stringBuffer.append(string);
        stringBuffer.append(">\n");
        return stringBuffer.toString();
    }

    private static String dumpTree(Node node) {
        return EncapsulateImageInDicom.dumpTree(node, 0);
    }

    protected static String getCompressionType(Node node) {
        String string = null;
        try {
            string = XPathQuery.getNamedAttributeValueOfElementNode((Node)XPathFactory.newInstance().newXPath().evaluate("//CompressionTypeName", node, XPathConstants.NODE), "value");
        }
        catch (XPathExpressionException xPathExpressionException) {
            slf4jlogger.error("", xPathExpressionException);
        }
        return string;
    }

    protected static short getBitsPerSample(Node node) {
        short s = 0;
        try {
            String string = XPathQuery.getNamedAttributeValueOfElementNode((Node)XPathFactory.newInstance().newXPath().evaluate("//BitsPerSample", node, XPathConstants.NODE), "value");
            if (string != null && string.length() > 0) {
                s = (short)Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            slf4jlogger.error("", numberFormatException);
        }
        catch (XPathExpressionException xPathExpressionException) {
            slf4jlogger.error("", xPathExpressionException);
        }
        return s;
    }

    protected static String getPhotometricInterpretation(Node node) {
        String string = null;
        try {
            String string2 = XPathQuery.getNamedAttributeValueOfElementNode((Node)XPathFactory.newInstance().newXPath().evaluate("//ColorSpaceType", node, XPathConstants.NODE), "name");
            slf4jlogger.debug("getPhotometricInterpretation(): colorSpaceType = {}", string2);
            if (string2 != null && string2.length() > 0 && string2.equals("YCbCr")) {
                string = "YBR_FULL_422";
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            slf4jlogger.error("", xPathExpressionException);
        }
        return string;
    }

    protected static short getElementAttributeFromMetadata(Node node, String string, String string2) {
        short s = 0;
        try {
            String string3 = XPathQuery.getNamedAttributeValueOfElementNode((Node)XPathFactory.newInstance().newXPath().evaluate("//" + string, node, XPathConstants.NODE), string2);
            if (string3 != null && string3.length() > 0) {
                s = (short)Integer.parseInt(string3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            slf4jlogger.error("", numberFormatException);
        }
        catch (XPathExpressionException xPathExpressionException) {
            slf4jlogger.error("", xPathExpressionException);
        }
        return s;
    }

    public static short getColumns(Node node) {
        return EncapsulateImageInDicom.getElementAttributeFromMetadata(node, "sof", "samplesPerLine");
    }

    public static short getRows(Node node) {
        return EncapsulateImageInDicom.getElementAttributeFromMetadata(node, "sof", "numLines");
    }

    protected static short getSamplesPerPixel(Node node) {
        return EncapsulateImageInDicom.getElementAttributeFromMetadata(node, "sof", "numFrameComponents");
    }

    protected static short getSamplePrecision(Node node) {
        return EncapsulateImageInDicom.getElementAttributeFromMetadata(node, "sof", "samplePrecision");
    }

    protected static short getJPEGProcess(Node node) {
        return EncapsulateImageInDicom.getElementAttributeFromMetadata(node, "sof", "process");
    }

    protected static String getTransferSyntaxUIDFromJPEGProcess(short s) {
        String string = null;
        if (s == 0 || s == 2) {
            string = "1.2.840.10008.1.2.4.50";
        }
        return string;
    }

    public static AttributeList generateDICOMPixelModuleFromConsumerImageFile(String string, AttributeList attributeList) throws IOException, DicomException {
        return EncapsulateImageInDicom.generateDICOMPixelModuleFromConsumerImageFile(new File(string), attributeList);
    }

    public static AttributeList generateDICOMPixelModuleFromConsumerImageFile(File file, AttributeList attributeList) throws IOException, DicomException {
        File[] n4;
        Object object;
        Object object2;
        String[] stringArray;
        int n = 0;
        Node node = null;
        Node node2 = null;
        ImageReader imageReader = null;
        FileImageInputStream fileImageInputStream = new FileImageInputStream(file);
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(fileImageInputStream);
        if (iterator.hasNext()) {
            imageReader = iterator.next();
        }
        if (imageReader == null) {
            slf4jlogger.debug("generateDICOMPixelModuleFromConsumerImageFile(): Failed to find reader to get Metadata based on FileImageInputStream");
            stringArray = file.getName();
            int s = stringArray.lastIndexOf(46);
            if (s != -1 && s < stringArray.length()) {
                object2 = stringArray.substring(s + 1);
                slf4jlogger.debug("generateDICOMPixelModuleFromConsumerImageFile(): fileSuffix {}", object2);
                iterator = ImageIO.getImageReadersBySuffix((String)object2);
                if (iterator.hasNext()) {
                    imageReader = (ImageReader)iterator.next();
                }
                if (imageReader == null) {
                    slf4jlogger.debug("generateDICOMPixelModuleFromConsumerImageFile(): Failed to find reader to get Metadata based on fileSuffix {}", object2);
                }
            }
        }
        if (imageReader == null) {
            throw new DicomException("Cannot obtain reader to get Metadata so will not convert " + file);
        }
        slf4jlogger.debug("generateDICOMPixelModuleFromConsumerImageFile(): Using reader {} {} {}", imageReader.getOriginatingProvider().getDescription(Locale.US), imageReader.getOriginatingProvider().getVendorName(), imageReader.getOriginatingProvider().getVersion());
        imageReader.setInput(fileImageInputStream);
        n = 1;
        iterator = imageReader.getImageMetadata(0);
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("generateDICOMPixelModuleFromConsumerImageFile(): metadata = {}", iterator);
        }
        if (iterator != null) {
            stringArray = ((IIOMetadata)((Object)iterator)).getMetadataFormatNames();
            if (slf4jlogger.isDebugEnabled()) {
                slf4jlogger.debug("generateDICOMPixelModuleFromConsumerImageFile(): formatNames = {}", StringUtilities.toString(stringArray));
            }
            if (stringArray != null) {
                for (String s3 : stringArray) {
                    if (s3 == null) continue;
                    if (s3.equals("javax_imageio_1.0")) {
                        node = ((IIOMetadata)((Object)iterator)).getAsTree(s3);
                        if (!slf4jlogger.isDebugEnabled()) continue;
                        slf4jlogger.debug("generateDICOMPixelModuleFromConsumerImageFile(): {} JIIO tree = {}", s3, EncapsulateImageInDicom.dumpTree(node));
                        continue;
                    }
                    if (s3.equals("javax_imageio_jpeg_image_1.0")) {
                        node2 = ((IIOMetadata)((Object)iterator)).getAsTree(s3);
                        if (!slf4jlogger.isDebugEnabled()) continue;
                        slf4jlogger.debug("generateDICOMPixelModuleFromConsumerImageFile(): {} JPEG tree = {}", s3, EncapsulateImageInDicom.dumpTree(node2));
                        continue;
                    }
                    Node s4 = ((IIOMetadata)((Object)iterator)).getAsTree(s3);
                    if (!slf4jlogger.isDebugEnabled()) continue;
                    slf4jlogger.debug("generateDICOMPixelModuleFromConsumerImageFile(): {} unrecognized tree = {}", s3, EncapsulateImageInDicom.dumpTree(s4));
                }
            }
        }
        try {
            slf4jlogger.trace("generateDICOMPixelModuleFromConsumerImageFile(): Calling dispose() on reader");
            imageReader.dispose();
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
        fileImageInputStream.close();
        iterator = null;
        if (node2 == null) {
            throw new DicomException("Cannot obtain JPEG Metadata");
        }
        short s2 = EncapsulateImageInDicom.getRows(node2);
        slf4jlogger.debug("generateDICOMPixelModuleFromConsumerImageFile(): rows = {}", s2);
        short s = EncapsulateImageInDicom.getColumns(node2);
        slf4jlogger.debug("generateDICOMPixelModuleFromConsumerImageFile(): columns = {}", s);
        object2 = null;
        int n2 = EncapsulateImageInDicom.getSamplePrecision(node2);
        short s3 = (short)(n2 <= 8 ? 8 : 16);
        short s4 = (short)(n2 - 1);
        short s5 = EncapsulateImageInDicom.getSamplesPerPixel(node2);
        slf4jlogger.debug("generateDICOMPixelModuleFromConsumerImageFile(): samplesPerPixel = {}", s5);
        short s6 = 0;
        String string = s5 == 3 ? EncapsulateImageInDicom.getPhotometricInterpretation(node) : (s5 == 1 ? "MONOCHROME2" : "");
        slf4jlogger.debug("generateDICOMPixelModuleFromConsumerImageFile(): photometricInterpretation = {}", string);
        short s7 = 0;
        if (attributeList == null) {
            attributeList = new AttributeList();
        }
        short fileArray = EncapsulateImageInDicom.getJPEGProcess(node2);
        slf4jlogger.debug("generateDICOMPixelModuleFromConsumerImageFile(): jpegProcess = {}", fileArray);
        Object n3 = EncapsulateImageInDicom.getTransferSyntaxUIDFromJPEGProcess(fileArray);
        slf4jlogger.debug("generateDICOMPixelModuleFromConsumerImageFile(): outputTransferSyntax = {}", n3);
        if (n3 != null && ((String)n3).length() > 0) {
            object = new UniqueIdentifierAttribute(TagFromName.TransferSyntaxUID);
            ((Attribute)object).addValue((String)n3);
            attributeList.put((Attribute)object);
            object = new TransferSyntax((String)n3);
            if (object != null) {
                String string2 = ((TransferSyntax)object).isLossy() ? "01" : "";
                CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.LossyImageCompression);
                ((Attribute)codeStringAttribute).addValue(string2);
                attributeList.put(codeStringAttribute);
            }
        }
        if ((object2 = new OtherByteAttributeMultipleCompressedFrames(TagFromName.PixelData, n4 = new File[]{file})) != null) {
            Object object3;
            int unsignedShortAttribute;
            attributeList.put((Attribute)object2);
            int object4 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsStored, -1);
            if (object4 == -1) {
                n3 = new UnsignedShortAttribute(TagFromName.BitsStored);
                ((Attribute)n3).addValue((short)n2);
                attributeList.put((Attribute)n3);
            }
            if ((unsignedShortAttribute = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.HighBit, -1)) == -1) {
                if (object4 != -1) {
                    s4 = (short)(object4 - 1);
                }
                object = new UnsignedShortAttribute(TagFromName.HighBit);
                ((Attribute)object).addValue(s4);
                attributeList.put((Attribute)object);
            }
            if ((object4 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PixelRepresentation, -1)) == -1) {
                UnsignedShortAttribute codeStringAttribute = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
                ((Attribute)codeStringAttribute).addValue(s6);
                attributeList.put(codeStringAttribute);
            }
            if ((object3 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PhotometricInterpretation)) == null) {
                CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
                ((Attribute)codeStringAttribute).addValue(string);
                attributeList.put(codeStringAttribute);
            }
            attributeList.remove(TagFromName.BitsAllocated);
            object3 = new UnsignedShortAttribute(TagFromName.BitsAllocated);
            ((Attribute)object3).addValue(s3);
            attributeList.put((Attribute)object3);
            attributeList.remove(TagFromName.Rows);
            object3 = new UnsignedShortAttribute(TagFromName.Rows);
            ((Attribute)object3).addValue(s2);
            attributeList.put((Attribute)object3);
            attributeList.remove(TagFromName.Columns);
            object3 = new UnsignedShortAttribute(TagFromName.Columns);
            ((Attribute)object3).addValue(s);
            attributeList.put((Attribute)object3);
            attributeList.remove(TagFromName.NumberOfFrames);
            if (n > 1) {
                object3 = new IntegerStringAttribute(TagFromName.NumberOfFrames);
                ((Attribute)object3).addValue(n);
                attributeList.put((Attribute)object3);
            }
            attributeList.remove(TagFromName.SamplesPerPixel);
            object3 = new UnsignedShortAttribute(TagFromName.SamplesPerPixel);
            ((Attribute)object3).addValue(s5);
            attributeList.put((Attribute)object3);
            attributeList.remove(TagFromName.PlanarConfiguration);
            if (s5 > 1) {
                object3 = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
                ((Attribute)object3).addValue(s7);
                attributeList.put((Attribute)object3);
            }
            if (iterator != null) {
                object3 = new OtherByteAttribute(TagFromName.ICCProfile);
                ((Attribute)object3).setValues((byte[])iterator);
                attributeList.put((Attribute)object3);
            }
        }
        return attributeList;
    }

    public static AttributeList generateDICOMPixelModuleFromConsumerImageFile(String string) throws IOException, DicomException {
        return EncapsulateImageInDicom.generateDICOMPixelModuleFromConsumerImageFile(string, null);
    }

    public EncapsulateImageInDicom(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, AttributeList attributeList) throws IOException, DicomException {
        AttributeList attributeList2 = EncapsulateImageInDicom.generateDICOMPixelModuleFromConsumerImageFile(string);
        String string10 = Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.TransferSyntaxUID);
        UIDGenerator uIDGenerator = new UIDGenerator();
        Object object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(uIDGenerator.getNewSOPInstanceUID(string5, string6, string7));
        attributeList2.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object).addValue(uIDGenerator.getNewSeriesInstanceUID(string5, string6));
        attributeList2.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object).addValue(uIDGenerator.getNewStudyInstanceUID(string5));
        attributeList2.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)object).addValue(string3);
        attributeList2.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.PatientID);
        ((Attribute)object).addValue(string4);
        attributeList2.put((Attribute)object);
        object = new DateAttribute(TagFromName.PatientBirthDate);
        attributeList2.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientSex);
        attributeList2.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object).addValue(string5);
        attributeList2.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
        ((Attribute)object).addValue("^^^^");
        attributeList2.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.AccessionNumber);
        attributeList2.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue(string6);
        attributeList2.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object).addValue(string7);
        attributeList2.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList2.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientOrientation);
        attributeList2.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Laterality);
        attributeList2.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.BurnedInAnnotation);
        ((Attribute)object).addValue("YES");
        attributeList2.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.ImageType);
        ((Attribute)object).addValue("DERIVED");
        ((Attribute)object).addValue("SECONDARY");
        attributeList2.put((Attribute)object);
        object = new Date();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)stringAttribute).addValue(new SimpleDateFormat("yyyyMMdd").format((Date)object));
        attributeList2.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.StudyTime);
        ((Attribute)stringAttribute).addValue(new SimpleDateFormat("HHmmss.SSS").format((Date)object));
        attributeList2.put(stringAttribute);
        object = new UniqueIdentifierAttribute(TagFromName.InstanceCreatorUID);
        ((Attribute)object).addValue("1.3.6.1.4.1.5962.99.3");
        attributeList2.put((Attribute)object);
        int n = Attribute.getSingleIntegerValueOrDefault(attributeList2, TagFromName.NumberOfFrames, 1);
        int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList2, TagFromName.SamplesPerPixel, 1);
        if (string9 == null) {
            string9 = "1.2.840.10008.5.1.4.1.1.7";
            if (n > 1) {
                if (n2 == 1) {
                    int n3 = Attribute.getSingleIntegerValueOrDefault(attributeList2, TagFromName.BitsAllocated, 1);
                    if (n3 == 8) {
                        string9 = "1.2.840.10008.5.1.4.1.1.7.2";
                    } else if (n3 == 16) {
                        string9 = "1.2.840.10008.5.1.4.1.1.7.3";
                    }
                } else if (n2 == 3) {
                    string9 = "1.2.840.10008.5.1.4.1.1.7.4";
                }
            }
        }
        if (n > 1) {
            Attribute attribute = new AttributeTagAttribute(TagFromName.FrameIncrementPointer);
            ((AttributeTagAttribute)attribute).addValue(TagFromName.PageNumberVector);
            attributeList2.put(attribute);
            attribute = new IntegerStringAttribute(TagFromName.PageNumberVector);
            for (int i = 1; i <= n; ++i) {
                attribute.addValue(i);
            }
            attributeList2.put(attribute);
        }
        if (SOPClass.isMultiframeSecondaryCaptureImageStorage(string9) && n2 == 1) {
            StringAttribute stringAttribute2 = new CodeStringAttribute(TagFromName.PresentationLUTShape);
            ((Attribute)stringAttribute2).addValue("IDENTITY");
            attributeList2.put(stringAttribute2);
            stringAttribute2 = new DecimalStringAttribute(TagFromName.RescaleSlope);
            ((Attribute)stringAttribute2).addValue("1");
            attributeList2.put(stringAttribute2);
            stringAttribute2 = new DecimalStringAttribute(TagFromName.RescaleIntercept);
            ((Attribute)stringAttribute2).addValue("0");
            attributeList2.put(stringAttribute2);
            stringAttribute2 = new LongStringAttribute(TagFromName.RescaleType);
            ((Attribute)stringAttribute2).addValue("US");
            attributeList2.put(stringAttribute2);
        }
        slf4jlogger.debug("SOP Class = {}", string9);
        Attribute attribute = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        attribute.addValue(string9);
        attributeList2.put(attribute);
        if (SOPClass.isSecondaryCaptureImageStorage(string9)) {
            attribute = new CodeStringAttribute(TagFromName.ConversionType);
            attribute.addValue("WSD");
            attributeList2.put(attribute);
        } else {
            attribute = new SequenceAttribute(TagFromName.AcquisitionContextSequence);
            attributeList2.put(attribute);
        }
        if (string8 == null) {
            string8 = "OT";
        }
        attribute = new CodeStringAttribute(TagFromName.Modality);
        attribute.addValue(string8);
        attributeList2.put(attribute);
        if (attributeList != null) {
            attributeList2.putAll(attributeList);
        }
        CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(attributeList2);
        attributeList2.insertSuitableSpecificCharacterSetForAllStringValues();
        FileMetaInformation.addFileMetaInformation(attributeList2, string10, "OURAETITLE");
        attributeList2.write(string2, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        try {
            if (stringArray.length != 7) {
                if (stringArray.length == 8) {
                    string = stringArray[7];
                } else if (stringArray.length == 9) {
                    string = stringArray[7];
                    string2 = stringArray[8];
                } else {
                    System.err.println("Error: Incorrect number of arguments");
                    System.err.println("Usage: EncapsulateImageInDicom inputFile outputFile patientName patientID studyID seriesNumber instanceNumber [modality [SOPClass]]");
                    System.exit(1);
                }
            }
            new EncapsulateImageInDicom(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6], string, string2, null);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

