/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import java.util.ArrayList;
import java.util.Iterator;

public class FunctionalGroupUtilities {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/FunctionalGroupUtilities.java,v 1.17 2025/01/29 10:58:06 dclunie Exp $";

    public static AttributeList createSharedFunctionalGroupsIfNotPresent(AttributeList attributeList) {
        SequenceAttribute sequenceAttribute;
        if (attributeList == null) {
            attributeList = new AttributeList();
        }
        if ((sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence)) == null) {
            sequenceAttribute = new SequenceAttribute(TagFromName.SharedFunctionalGroupsSequence);
            attributeList.put(sequenceAttribute);
            sequenceAttribute.addItem(new AttributeList());
        }
        return attributeList;
    }

    public static AttributeList createFunctionalGroupsIfNotPresent(AttributeList attributeList, int n) {
        SequenceAttribute sequenceAttribute = (SequenceAttribute)(attributeList = FunctionalGroupUtilities.createSharedFunctionalGroupsIfNotPresent(attributeList)).get(TagFromName.PerFrameFunctionalGroupsSequence);
        if (sequenceAttribute == null) {
            sequenceAttribute = new SequenceAttribute(TagFromName.PerFrameFunctionalGroupsSequence);
            attributeList.put(sequenceAttribute);
            for (int i = 0; i < n; ++i) {
                sequenceAttribute.addItem(new AttributeList());
            }
        }
        return attributeList;
    }

    public static AttributeList generateUnassignedConvertedAttributesSequenceFunctionalGroups(AttributeList attributeList, int n) {
        SequenceAttribute sequenceAttribute = (SequenceAttribute)(attributeList = FunctionalGroupUtilities.createFunctionalGroupsIfNotPresent(attributeList, n)).get(TagFromName.SharedFunctionalGroupsSequence);
        AttributeList attributeList2 = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(sequenceAttribute);
        SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attributeList2.get(TagFromName.UnassignedSharedConvertedAttributesSequence);
        if (sequenceAttribute2 == null) {
            sequenceAttribute2 = new SequenceAttribute(TagFromName.UnassignedSharedConvertedAttributesSequence);
            sequenceAttribute2.addItem(new AttributeList());
            attributeList2.put(sequenceAttribute2);
        }
        SequenceAttribute sequenceAttribute3 = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        Iterator<SequenceItem> iterator = sequenceAttribute3.iterator();
        while (iterator.hasNext()) {
            SequenceItem sequenceItem = iterator.next();
            AttributeList attributeList3 = sequenceItem.getAttributeList();
            SequenceAttribute sequenceAttribute4 = (SequenceAttribute)attributeList3.get(TagFromName.UnassignedPerFrameConvertedAttributesSequence);
            if (sequenceAttribute4 != null) continue;
            sequenceAttribute4 = new SequenceAttribute(TagFromName.UnassignedPerFrameConvertedAttributesSequence);
            sequenceAttribute4.addItem(new AttributeList());
            attributeList3.put(sequenceAttribute4);
        }
        return attributeList;
    }

    public static AttributeList generatePixelValueTransformationFunctionalGroup(AttributeList attributeList, int n, double d, double d2, String string) throws DicomException {
        attributeList = FunctionalGroupUtilities.createFunctionalGroupsIfNotPresent(attributeList, n);
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
        AttributeList attributeList2 = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(sequenceAttribute);
        SequenceAttribute sequenceAttribute2 = new SequenceAttribute(TagFromName.PixelValueTransformationSequence);
        attributeList2.put(sequenceAttribute2);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute2.addItem(attributeList3);
        StringAttribute stringAttribute = new DecimalStringAttribute(TagFromName.RescaleSlope);
        ((Attribute)stringAttribute).addValue(d);
        attributeList3.put(stringAttribute);
        stringAttribute = new DecimalStringAttribute(TagFromName.RescaleIntercept);
        ((Attribute)stringAttribute).addValue(d2);
        attributeList3.put(stringAttribute);
        stringAttribute = new LongStringAttribute(TagFromName.RescaleType);
        ((Attribute)stringAttribute).addValue(string);
        attributeList3.put(stringAttribute);
        return attributeList;
    }

    public static AttributeList generateVOILUTFunctionalGroup(AttributeList attributeList, int n, double d, double d2, String string) throws DicomException {
        attributeList = FunctionalGroupUtilities.createFunctionalGroupsIfNotPresent(attributeList, n);
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
        AttributeList attributeList2 = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(sequenceAttribute);
        SequenceAttribute sequenceAttribute2 = new SequenceAttribute(TagFromName.FrameVOILUTSequence);
        attributeList2.put(sequenceAttribute2);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute2.addItem(attributeList3);
        StringAttribute stringAttribute = new DecimalStringAttribute(TagFromName.WindowWidth);
        ((Attribute)stringAttribute).addValue(d);
        attributeList3.put(stringAttribute);
        stringAttribute = new DecimalStringAttribute(TagFromName.WindowCenter);
        ((Attribute)stringAttribute).addValue(d2);
        attributeList3.put(stringAttribute);
        stringAttribute = new CodeStringAttribute(TagFromName.VOILUTFunction);
        ((Attribute)stringAttribute).addValue(string);
        attributeList3.put(stringAttribute);
        return attributeList;
    }

    public static AttributeList generateFrameTypeSharedFunctionalGroup(AttributeList attributeList, AttributeTag attributeTag, Attribute attribute) throws DicomException {
        attributeList = FunctionalGroupUtilities.createSharedFunctionalGroupsIfNotPresent(attributeList);
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
        AttributeList attributeList2 = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(sequenceAttribute);
        SequenceAttribute sequenceAttribute2 = new SequenceAttribute(attributeTag);
        attributeList2.put(sequenceAttribute2);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute2.addItem(attributeList3);
        attributeList3.put(attribute);
        return attributeList;
    }

    public static void removeFunctionalGroup(AttributeList attributeList, AttributeTag attributeTag) {
        Iterator<SequenceItem> iterator;
        SequenceAttribute sequenceAttribute;
        Object object;
        Object object2;
        SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        if (sequenceAttribute2 != null) {
            int n = sequenceAttribute2.getNumberOfItems();
            int n2 = 0;
            object2 = sequenceAttribute2.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                AttributeList attributeList2 = ((SequenceItem)object).getAttributeList();
                if (attributeList2 != null) {
                    attributeList2.remove(attributeTag);
                }
                ++n2;
            }
        }
        if ((sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence)) != null && (iterator = sequenceAttribute.iterator()).hasNext() && (object = ((SequenceItem)(object2 = iterator.next())).getAttributeList()) != null) {
            ((AttributeList)object).remove(attributeTag);
        }
    }

    public static void removeAllButSelected(SequenceAttribute sequenceAttribute, Selector selector) {
        AttributeList attributeList = sequenceAttribute.getItem(0).getAttributeList();
        for (int i = 0; i < sequenceAttribute.getNumberOfItems(); ++i) {
            Iterator iterator = sequenceAttribute.getItem(i).getAttributeList().values().iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                AttributeTag attributeTag = attribute.getTag();
                boolean bl = selector.spatial && FunctionalGroupUtilities.isSpatial(attributeTag) || selector.framecontent && FunctionalGroupUtilities.isFrameContent(attributeTag) || selector.unclassified && FunctionalGroupUtilities.isUnclassified(attributeTag);
                if (bl) continue;
                iterator.remove();
            }
        }
    }

    public static void removeAllButSelected(AttributeList attributeList, Selector selector) {
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
        if (sequenceAttribute != null && sequenceAttribute.getNumberOfItems() >= 1) {
            FunctionalGroupUtilities.removeAllButSelected(sequenceAttribute, selector);
        }
        if ((sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence)) != null && sequenceAttribute.getNumberOfItems() >= 1) {
            FunctionalGroupUtilities.removeAllButSelected(sequenceAttribute, selector);
        }
    }

    public static boolean isSpatial(AttributeTag attributeTag) {
        return attributeTag.equals(TagFromName.PixelMeasuresSequence) || attributeTag.equals(TagFromName.PlanePositionSequence) || attributeTag.equals(TagFromName.PlaneOrientationSequence);
    }

    public static boolean isFrameContent(AttributeTag attributeTag) {
        return attributeTag.equals(TagFromName.FrameContentSequence);
    }

    public static boolean isUnclassified(AttributeTag attributeTag) {
        return !FunctionalGroupUtilities.isSpatial(attributeTag) && !FunctionalGroupUtilities.isFrameContent(attributeTag);
    }

    public static class Selector {
        public boolean spatial;
        public boolean framecontent;
        public boolean unclassified;

        public Selector(boolean bl) {
            if (bl) {
                this.setAll(true);
            }
        }

        public void setAll(boolean bl) {
            this.spatial = bl;
            this.framecontent = bl;
            this.unclassified = bl;
        }

        public Selector(String[] stringArray, ArrayList<String> arrayList) {
            for (String string : stringArray) {
                String string2 = string.toLowerCase().trim();
                if (string2.equals("-all")) {
                    this.spatial = true;
                    this.framecontent = true;
                    this.unclassified = true;
                    continue;
                }
                if (string2.equals("-spatial")) {
                    this.spatial = true;
                    continue;
                }
                if (string2.equals("-framecontent")) {
                    this.framecontent = true;
                    continue;
                }
                if (string2.equals("-unclassified")) {
                    this.unclassified = true;
                    continue;
                }
                arrayList.add(string);
            }
        }
    }
}

