/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.GeometryOfSliceFromAttributeList;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.geometry.GeometryOfSlice;
import com.pixelmed.geometry.GeometryOfVolume;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;

public class GeometryOfVolumeFromAttributeList
extends GeometryOfVolume {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/GeometryOfVolumeFromAttributeList.java,v 1.27 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(GeometryOfVolumeFromAttributeList.class);

    public GeometryOfVolumeFromAttributeList(AttributeList attributeList, int[] nArray) throws DicomException {
        int n;
        slf4jlogger.debug("GeometryOfVolumeFromAttributeList():");
        this.frames = null;
        this.isVolume = false;
        int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0);
        int n3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0);
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
        SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        int n4 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        int n5 = n = nArray == null ? n4 : nArray.length;
        if (n4 == 1 && sequenceAttribute == null && sequenceAttribute2 == null && attributeList.containsKey(TagFromName.ImagePositionPatient)) {
            slf4jlogger.debug("GeometryOfVolumeFromAttributeList(): single frame with no functional groups and ImagePositionPatient");
            GeometryOfSliceFromAttributeList geometryOfSliceFromAttributeList = null;
            try {
                geometryOfSliceFromAttributeList = new GeometryOfSliceFromAttributeList(attributeList);
            }
            catch (Exception exception) {
                slf4jlogger.debug("", exception);
                geometryOfSliceFromAttributeList = null;
            }
            if (geometryOfSliceFromAttributeList != null) {
                this.frames = new GeometryOfSlice[1];
                this.frames[0] = geometryOfSliceFromAttributeList;
            }
        } else if (n > 0 && sequenceAttribute != null && sequenceAttribute2 != null) {
            slf4jlogger.debug("GeometryOfVolumeFromAttributeList(): multi frame with functional groups");
            SequenceAttribute sequenceAttribute3 = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, TagFromName.PlaneOrientationSequence);
            SequenceAttribute sequenceAttribute4 = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, TagFromName.PlanePositionSequence);
            SequenceAttribute sequenceAttribute5 = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, TagFromName.PixelMeasuresSequence);
            this.frames = new GeometryOfSlice[n];
            for (int i = 0; i < n; ++i) {
                int n6 = nArray == null ? i : nArray[i];
                Attribute attribute = null;
                SequenceAttribute sequenceAttribute6 = sequenceAttribute3;
                if (sequenceAttribute6 == null) {
                    sequenceAttribute6 = (SequenceAttribute)sequenceAttribute2.getItem(n6).getAttributeList().get(TagFromName.PlaneOrientationSequence);
                }
                if (sequenceAttribute6 != null) {
                    attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute6, TagFromName.ImageOrientationPatient);
                    slf4jlogger.debug("GeometryOfVolumeFromAttributeList(): aImageOrientationPatient = {}", attribute);
                }
                Attribute attribute2 = null;
                SequenceAttribute sequenceAttribute7 = sequenceAttribute4;
                if (sequenceAttribute7 == null) {
                    sequenceAttribute7 = (SequenceAttribute)sequenceAttribute2.getItem(n6).getAttributeList().get(TagFromName.PlanePositionSequence);
                }
                if (sequenceAttribute7 != null) {
                    attribute2 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute7, TagFromName.ImagePositionPatient);
                    slf4jlogger.debug("GeometryOfVolumeFromAttributeList(): aImagePositionPatient = {}", attribute2);
                }
                Attribute attribute3 = null;
                Attribute attribute4 = null;
                SequenceAttribute sequenceAttribute8 = sequenceAttribute5;
                if (sequenceAttribute8 == null) {
                    sequenceAttribute8 = (SequenceAttribute)sequenceAttribute2.getItem(n6).getAttributeList().get(TagFromName.PixelMeasuresSequence);
                }
                if (sequenceAttribute8 != null) {
                    attribute3 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute8, TagFromName.PixelSpacing);
                    attribute4 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute8, TagFromName.SliceThickness);
                    slf4jlogger.debug("GeometryOfVolumeFromAttributeList(): aPixelSpacing = {}", attribute3);
                    slf4jlogger.debug("GeometryOfVolumeFromAttributeList(): aSliceThickness = {}", attribute4);
                }
                if (attribute2 == null || attribute3 == null || attribute == null) {
                    this.frames = null;
                    break;
                }
                double[] dArray = attribute2.getDoubleValues();
                double[] dArray2 = attribute3.getDoubleValues();
                double[] dArray3 = new double[]{dArray2[0], dArray2[1], 0.0};
                double d = attribute4 == null ? 0.0 : attribute4.getSingleDoubleValueOrDefault(0.0);
                double[] dArray4 = attribute.getDoubleValues();
                double[] dArray5 = new double[]{dArray4[0], dArray4[1], dArray4[2]};
                double[] dArray6 = new double[]{dArray4[3], dArray4[4], dArray4[5]};
                double[] dArray7 = new double[]{n2, n3, 1.0};
                this.frames[i] = new GeometryOfSlice(dArray5, dArray6, dArray, dArray3, d, dArray7);
            }
        } else {
            slf4jlogger.debug("GeometryOfVolumeFromAttributeList(): no information");
        }
        this.checkAndSetVolumeSampledRegularlyAlongFrameDimension();
    }

    public GeometryOfVolumeFromAttributeList(AttributeList attributeList) throws DicomException {
        this(attributeList, null);
    }

    public static double[] getImageOrientationPatientFromAttributeList(AttributeList attributeList) {
        slf4jlogger.debug("GeometryOfVolumeFromAttributeList.getImageOrientationPatientFromAttributeList():");
        double[] dArray = null;
        try {
            SequenceAttribute sequenceAttribute;
            Attribute attribute = null;
            SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
            int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 0);
            if (n == 1 && sequenceAttribute2 == null) {
                attribute = attributeList.get(TagFromName.ImageOrientationPatient);
            } else if (n > 0 && sequenceAttribute2 != null && (sequenceAttribute = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute2, TagFromName.PlaneOrientationSequence)) != null) {
                attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, TagFromName.ImageOrientationPatient);
            }
            slf4jlogger.debug("GeometryOfVolumeFromAttributeList.getImageOrientationPatientFromAttributeList(): aImageOrientationPatient = {}", attribute);
            if (attribute != null) {
                dArray = attribute.getDoubleValues();
            }
        }
        catch (DicomException dicomException) {
            slf4jlogger.error("", dicomException);
        }
        return dArray;
    }
}

