/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.ValueRepresentation;

public class MultiFramePixelData {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/MultiFramePixelData.java,v 1.13 2025/01/29 10:58:06 dclunie Exp $";
    private byte[] bytePixelsForAllFrames;
    private short[] wordPixelsForAllFrames;
    private int currentFrameOffset;
    private int numberOfPixelValuesPerFrame;
    private int numberOfPixelValuesTotal;

    private byte[] getBytePixelsForAllFrames() {
        return this.bytePixelsForAllFrames;
    }

    private short[] getWordPixelsForAllFrames() {
        return this.wordPixelsForAllFrames;
    }

    public boolean hasBytePixels() {
        return this.bytePixelsForAllFrames != null;
    }

    public boolean hasWordPixels() {
        return this.wordPixelsForAllFrames != null;
    }

    public Attribute getPixelDataAttribute() throws DicomException {
        Attribute attribute = null;
        if (this.hasBytePixels()) {
            OtherByteAttribute otherByteAttribute = new OtherByteAttribute(TagFromName.PixelData);
            otherByteAttribute.setValues(this.getBytePixelsForAllFrames());
            attribute = otherByteAttribute;
        } else if (this.hasWordPixels()) {
            OtherWordAttribute otherWordAttribute = new OtherWordAttribute(TagFromName.PixelData);
            otherWordAttribute.setValues(this.getWordPixelsForAllFrames());
            attribute = otherWordAttribute;
        }
        return attribute;
    }

    public MultiFramePixelData(int n, int n2, int n3, int n4) {
        this.numberOfPixelValuesPerFrame = n3 * n * n2;
        this.numberOfPixelValuesTotal = this.numberOfPixelValuesPerFrame * n4;
        this.currentFrameOffset = 0;
        this.bytePixelsForAllFrames = null;
        this.wordPixelsForAllFrames = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addFrame(Attribute attribute) throws DicomException {
        if (attribute == null) throw new DicomException("Missing Pixel Data");
        byte[] byArray = attribute.getVR();
        if (ValueRepresentation.isOtherByteVR(byArray)) {
            if (this.wordPixelsForAllFrames != null) {
                throw new DicomException("Cannot mix OB and OW Pixel Data VR from different frames" + attribute.getVRAsString());
            }
            if (this.bytePixelsForAllFrames == null) {
                this.bytePixelsForAllFrames = new byte[this.numberOfPixelValuesTotal];
            }
            byte[] byArray2 = attribute.getByteValues();
            System.arraycopy(byArray2, 0, this.bytePixelsForAllFrames, this.currentFrameOffset, byArray2.length);
            this.currentFrameOffset += this.numberOfPixelValuesPerFrame;
            return;
        } else {
            if (!ValueRepresentation.isOtherWordVR(byArray)) throw new DicomException("Incorrect Pixel Data VR " + attribute.getVRAsString());
            if (this.bytePixelsForAllFrames != null) {
                throw new DicomException("Cannot mix OB and OW Pixel Data VR from different frames" + attribute.getVRAsString());
            }
            if (this.wordPixelsForAllFrames == null) {
                this.wordPixelsForAllFrames = new short[this.numberOfPixelValuesTotal];
            }
            short[] sArray = attribute.getShortValues();
            System.arraycopy(sArray, 0, this.wordPixelsForAllFrames, this.currentFrameOffset, sArray.length);
            this.currentFrameOffset += this.numberOfPixelValuesPerFrame;
        }
    }
}

