/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.ShortTextAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TextAttribute;

public class PersonIdentification {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/PersonIdentification.java,v 1.12 2025/01/29 10:58:07 dclunie Exp $";
    protected AttributeList list;
    protected CodedSequenceItem[] personIdentificationCodeSequence;
    protected String personAddress;
    protected String[] personTelephoneNumbers;
    protected String institutionName;
    protected String institutionAddress;
    protected CodedSequenceItem institutionCodeSequence;

    public PersonIdentification(AttributeList attributeList) throws DicomException {
        this.personIdentificationCodeSequence = CodedSequenceItem.getArrayOfCodedSequenceItemsOrNull(attributeList, TagFromName.PersonIdentificationCodeSequence);
        this.personAddress = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PersonAddress);
        this.personTelephoneNumbers = Attribute.getStringValues(attributeList, TagFromName.PersonTelephoneNumbers);
        this.institutionName = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.InstitutionName);
        this.institutionAddress = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.InstitutionAddress);
        this.institutionCodeSequence = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList, TagFromName.InstitutionCodeSequence);
        this.getAttributeList();
    }

    public PersonIdentification(CodedSequenceItem[] codedSequenceItemArray, String string, String[] stringArray, String string2, String string3, CodedSequenceItem codedSequenceItem) throws DicomException {
        this.personIdentificationCodeSequence = codedSequenceItemArray;
        this.personAddress = string;
        this.personTelephoneNumbers = stringArray;
        this.institutionName = string2;
        this.institutionAddress = string3;
        this.institutionCodeSequence = codedSequenceItem;
        if (codedSequenceItemArray == null || codedSequenceItemArray.length < 1) {
            throw new DicomException("Person Identification Code Sequence is Type 1 but information not supplied");
        }
        if ((string2 == null || string2.length() == 0) && codedSequenceItem == null) {
            throw new DicomException("One of either InstitutionName or institutionCodeSequence are required");
        }
    }

    public AttributeList getAttributeList() throws DicomException {
        if (this.list == null) {
            Object object;
            int n;
            this.list = new AttributeList();
            if (this.personIdentificationCodeSequence == null || this.personIdentificationCodeSequence.length < 1) {
                throw new DicomException("Person Identification Code Sequence is Type 1 but information not supplied");
            }
            Attribute attribute = new SequenceAttribute(TagFromName.PersonIdentificationCodeSequence);
            for (n = 0; n < this.personIdentificationCodeSequence.length; ++n) {
                object = this.personIdentificationCodeSequence[n];
                if (object == null) continue;
                ((SequenceAttribute)attribute).addItem(((CodedSequenceItem)object).getAttributeList());
            }
            this.list.put(attribute);
            if (this.personAddress != null && this.personAddress.length() > 0) {
                attribute = new ShortTextAttribute(TagFromName.PersonAddress);
                ((TextAttribute)attribute).addValue(this.personAddress);
                this.list.put(attribute);
            }
            if (this.personTelephoneNumbers != null && this.personTelephoneNumbers.length > 0) {
                attribute = new LongStringAttribute(TagFromName.PersonTelephoneNumbers);
                for (n = 0; n < this.personTelephoneNumbers.length; ++n) {
                    object = this.personTelephoneNumbers[n];
                    if (object == null) continue;
                    ((StringAttribute)attribute).addValue((String)object);
                }
                this.list.put(attribute);
            }
            if (this.institutionName != null && this.institutionName.length() > 0) {
                attribute = new LongStringAttribute(TagFromName.InstitutionName);
                ((StringAttribute)attribute).addValue(this.institutionName);
                this.list.put(attribute);
            } else if (this.institutionCodeSequence == null) {
                throw new DicomException("One of either InstitutionName or institutionCodeSequence are required");
            }
            if (this.institutionAddress != null && this.institutionAddress.length() > 0) {
                attribute = new ShortTextAttribute(TagFromName.InstitutionAddress);
                ((TextAttribute)attribute).addValue(this.institutionAddress);
                this.list.put(attribute);
            }
            if (this.institutionCodeSequence != null) {
                attribute = new SequenceAttribute(TagFromName.InstitutionCodeSequence);
                ((SequenceAttribute)attribute).addItem(this.institutionCodeSequence.getAttributeList());
                this.list.put(attribute);
            }
        }
        return this.list;
    }
}

